/* TeXme.cmd
Copyright (C) Z. Wagner -- Ice Bear Soft, 28 Dec 1995 

This batch TeX'es the specified file. It looks for the Subject EA to find the main file 
and format. If the format is not resolved, the same algorithm as in "texit.cmd" is used. 
If the format is not yet resolved, TEXFORMATDEFAULT environment variable is searched. If 
it is not defined, the batch displays an error, otherwise TeXbatch.cmd is called.

Usage:
TeXme <file_name> [option]

The option is silently passed to "TeXbatch.cmd". The file name is parsed and its directory
is selected as current before "TeXbatch.cmd" is called.
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
'@echo off'

parse arg filename opt
if filename == '' then do
  say 'File name is missing'
  'pause'
  exit 1
end

main = ''
format = ''

texfile = splitfile(filename)

do until rv \= 'MAIN'
  rv = GetSubject(texfile)
  if rv == 'MAIN' then do
    texfile = splitfile(main)
  end
end

if format == '' then do
  /* Commands from texit.cmd */
  input = texfile
  fname = filespec( 'name', input)
  parse var fname base '.' ext
  if ext = '' then
    input = input'.tex'
  fname = stream( input, 'C', 'QUERY EXISTS')
  if fname = '' then
    fname = SysSearchPath( 'TEXINPUT', input)
  if \ (fname = '') then
  do
    line = linein( fname)
    call stream fname, 'C', 'CLOSE'
    /* say 'First line =' line */
    parse var line '%' 'Format:' format .
    if (format = '') then
      parse var line '%' 'format:' format .
    if (format = '') then
      parse var line '%' 'Format' format .
    if (format = '') then
      parse var line '%' 'format' format .
  end
  /* End of commands from texit.cmd */
end

if format == '' then do
  format = value('TEXFORMATDEFAULT',, 'OS2ENVIRONMENT')
end

if format == '' then do
  say 'Error: cannot resolve format'
  'pause'
  exit 1
end

rc = 0
call TeXbatch format texfile opt
exit rc

/* Procedure for getting subject */

GetSubject: procedure expose main format 
parse arg fn
rc = SysGetEA(fn, '.subject', 'subj')
if rc == 0 then do
  sub = substr(subj, 5)
  parse var sub kw '=' val
  if translate(kw) == 'MAIN' then do
    main = val
    rv = 'MAIN'
  end
  else
  if translate(kw) == 'FORMAT' then do
    format = val
    rv = 'FMT'
  end
  else rv = 'BAD'
end
else rv = 'NO'
return rv

/* Splits the file, handles extension and changes directory; stops if file not found */

splitfile: procedure 
parse arg fn
name = filespec('name', fn)
if name == '' then do
  say 'Error: invalid file name' fn
  'pause'
  exit 1
end

ext = ''
dotpos = pos('.', name)
if dotpos > 0 then ext = substr(name, dotpos)

/* Remove .log */

if translate(ext) == '.LOG' then do
  base = substr(name, 1, dotpos-1)
  fn = filespec('drive', fn) || filespec('path', fn) || base
  dotpos = 0
  ext = ''
end

xfn = exist(fn)
if (xfn == '') & (dotpos == 0) then xfn = exist(fn || '.tex')
if xfn == '' then do
  say 'Error: cannot find file' fn
  'pause'
  exit 1
end

drive = filespec('drive', xfn)
dir = filespec('path', xfn)
name = filespec('name', xfn)

cd = ''
if drive \= '' then drive
if dir \= '' then do
  if substr(dir, length(dir)) == '\' then cd = substr(dir, 1, length(dir)-1)
  else cd = dir
end
if cd \= '' then 'cd' cd
return name

/* This procedure checks whether the file exists by returning fully qualified name */

exist: procedure
parse arg fn
ex = stream(fn, 'C', 'QUERY EXISTS')
if ex \= '' then call stream ex, 'C', 'CLOSE'
return ex
