/*-----------------------------------------------------*/
/*  Font Dialog Java class                             */
/*-----------------------------------------------------*/

import java.awt.*;
import java.applet.*;
import java.util.*;


/*--------------------------------------------------------------*/
/* The class is an extension of Dialog                          */
/*  It provides font options                                    */
/*  Several sets of options are handled using a cardlayout      */
/*   panel                                                      */
/*--------------------------------------------------------------*/
public class FontDlg extends Dialog {

  private String myTitle;

  private Panel mainPanel = new Panel();
  private Panel fontPanel = new Panel();
  private Panel colorPanel = new Panel();
  private CardLayout cl = new CardLayout();

  private Panel bPanel = new Panel();
  private Button bApply = new Button("Apply");
  private Button bDone = new Button("Done");
  private Button bCancel = new Button("Cancel");

  private Checkbox cbPlain = new Checkbox("Plain");
  private Checkbox cbBold = new Checkbox("Bold");
  private Checkbox cbItalic= new Checkbox("Italicized");
  private CheckboxGroup cbgStyle = new CheckboxGroup();

  private Label lFont = new Label("Font: ", Label.RIGHT);
  private Choice cSize = new Choice();
  private Choice cFont = new Choice();

  private Label lRed = new Label("Red ", Label.RIGHT);
  private Label lGreen = new Label("Green", Label.RIGHT);
  private Label lBlue = new Label("Blue", Label.RIGHT);
  private Label lRedval = new Label("0", Label.CENTER);
  private Label lGreenval = new Label("0", Label.CENTER);
  private Label lBlueval = new Label("0", Label.CENTER);
  private Scrollbar sbRed = new Scrollbar(Scrollbar.HORIZONTAL, 0, 64, 0, 255);
  private Scrollbar sbGreen = new Scrollbar(Scrollbar.HORIZONTAL, 0, 64, 0, 255);
  private Scrollbar sbBlue = new Scrollbar(Scrollbar.HORIZONTAL, 0, 64, 0, 255);
  private TextField tfTest = new TextField("", 16);

  public  String curFontName;
  public  int    curFontStyle;
  public  int    curFontSize;
  public  Color  curColor;
  public  Font   curFont;
  public  boolean fontApply=false;

  int iFontsize;

  int iSizes[] = {8, 10, 12, 14, 16, 18, 20, 22, 24};
  String sFonts[] = {"Courier", "Helv", "TimesNewRoman"};


  int     ix=0, iy=0;

/*---------------------------------------------------------------*/
/* Constructor for dialog                                        */
/*  args are: parent frame, title                                */
/*---------------------------------------------------------------*/

  public FontDlg(Frame fr, String sTitle) {

    super(fr, sTitle, true);          //construct the dialog as modal

    myTitle = sTitle;

//  Identify card layout for central options panel(s)
    mainPanel.setLayout(cl);        //use card layout for master panel

// Create center panel with option info (font options)

    GridBagConstraints gbc = new GridBagConstraints();
    GridBagLayout gbl = new GridBagLayout();
    gbc.anchor = GridBagConstraints.WEST;

    fontPanel.setLayout(gbl);

// Add the fontsize choicelist and its label to the panel
// Add the fontsizes from the static array to the choice and
//  set the default size to the fourth entry

    gbc.gridx=0; gbc.gridy=0;
    gbc.gridwidth=1;
    addElement(fontPanel, lFont, gbl, gbc);

    gbc.gridx=GridBagConstraints.RELATIVE;
    gbc.gridwidth=2;
    addElement(fontPanel, cFont, gbl, gbc);
    for (int i=0; i<sFonts.length; i++ ) {
       cFont.addItem(sFonts[i]);
    }
    cFont.select(0);

    gbc.gridx = 1; gbc.gridy = 1;
    gbc.gridwidth=1;
    addElement(fontPanel, cSize, gbl, gbc);
    for (int i=0;i<iSizes.length ;i++ ) {
       cSize.addItem( (new Integer(iSizes[i])).toString() );
    }
    cSize.select(3);

// Add the fontstyle buttons to the panel and then define them
//  as a group.  Set the initial style to BOLD

    gbc.gridx=0; gbc.gridy=2;
    gbc.gridwidth=1;

    addElement(fontPanel, cbPlain, gbl, gbc);
    gbc.gridx = GridBagConstraints.RELATIVE;
    addElement(fontPanel, cbItalic, gbl, gbc);
    addElement(fontPanel, cbBold, gbl, gbc);
    cbPlain.setCheckboxGroup(cbgStyle);
    cbBold.setCheckboxGroup(cbgStyle);
    cbItalic.setCheckboxGroup(cbgStyle);
    cbgStyle.setCurrent(cbBold);

    mainPanel.add("font", fontPanel);

// Create center panel with option info (color options)

    GridBagConstraints gbc2 = new GridBagConstraints();
    GridBagLayout gbl2 = new GridBagLayout();
    gbc2.anchor = GridBagConstraints.WEST;

    colorPanel.setLayout(gbl2);


// Add color vector scrollbars

    gbc2.gridx=0; gbc2.gridy=1;
    
    lRed.setForeground(Color.red);
    addElement(colorPanel, lRed, gbl2, gbc2);
    gbc2.gridx = GridBagConstraints.RELATIVE;
    gbc2.gridwidth = 2; gbc2.fill=GridBagConstraints.HORIZONTAL;
    addElement(colorPanel, sbRed, gbl2, gbc2);
    gbc2.gridwidth = 1;
    addElement(colorPanel, lRedval, gbl2, gbc2);

    gbc2.gridx=0; gbc2.gridy=2;
    lGreen.setForeground(Color.green);
    addElement(colorPanel, lGreen, gbl2, gbc2);
    gbc2.gridx = GridBagConstraints.RELATIVE;
    gbc2.gridwidth = 2;
    addElement(colorPanel, sbGreen, gbl2, gbc2);
    gbc2.gridwidth = 1;
    addElement(colorPanel, lGreenval, gbl2, gbc2);

    gbc2.gridx=0; gbc2.gridy=3;
    lBlue.setForeground(Color.blue);
    addElement(colorPanel, lBlue, gbl2, gbc2);
    gbc2.gridx = GridBagConstraints.RELATIVE;
    gbc2.gridwidth = 2;
    addElement(colorPanel, sbBlue, gbl2, gbc2);
    gbc2.gridwidth = 1;
    addElement(colorPanel, lBlueval, gbl2, gbc2);
    gbc2.gridx = 1; gbc2.gridy = 4;
    gbc2.gridwidth = 2;
    addElement(colorPanel, tfTest, gbl2, gbc2);
    
    mainPanel.add("color", colorPanel);

// add the entire cardlayout panel onto the frame

    add("Center", mainPanel);

// Create button panel
    bPanel.setLayout(new FlowLayout());
    bPanel.add(bApply);
    bPanel.add(bDone);
    bPanel.add(bCancel);
    add("South", bPanel);

// Show and then resize the frame
//    show();
    resize(300,250);

  }

/*--------------------------------------------------------------*/
/* show overload                                                */
/*    show specified card layout panel                          */
/*--------------------------------------------------------------*/

   public void show(String cPanel) {
//      fontApply=false;
      cl.show(mainPanel, cPanel);
      super.show();
   }

/* get stuff methods -------------------------------------------*/

   public boolean getFontApply() {
      return fontApply;
   }

   public Font getCurFont() {
      return curFont;
   }

   public Color getCurColor() {
      return curColor;
   }

/*--------------------------------------------------------------*/
/* ACTION method override                                       */
/*    process menu item and button selections                   */
/*--------------------------------------------------------------*/

    public boolean action(Event e, Object o) {

      if (e.target == bApply) {
          curColor = tfTest.getBackground();

          Checkbox cbTemp = cbgStyle.getCurrent();
          if (cbTemp == cbBold) {
             curFontStyle = Font.BOLD;
          } else {
              if (cbTemp == cbItalic) {
                  curFontStyle = Font.ITALIC;
              } else {
                curFontStyle = Font.PLAIN;
                } 
          } 

          curFontSize = iSizes[cSize.getSelectedIndex()];
          curFontName = cFont.getSelectedItem();
          curFont = new Font(curFontName, curFontStyle, curFontSize);
          fontApply = true;
          return true;
      }

      if (e.target == bDone) {
          hide();
          return true;
      }

      if (e.target == bCancel) {
          fontApply = false;
          hide();
          return true;
      }

      return false;
    }


/*------------------------------------------------------*/
/* Add Element method                                   */
/*------------------------------------------------------*/
  public void addElement(Panel p,
                         Component o,
                         GridBagLayout g,
                         GridBagConstraints c) {
    g.setConstraints(o, c);
    p.add(o);
  }

/*--------------------------------------------------------*/
/* handleEvent method                                     */
/*  invoked when an event action occurs. It processes     */
/*  events from the scollbar controls.                    */
/*--------------------------------------------------------*/

  public boolean handleEvent(Event e) {
    int sbVal;

    if (e.target == sbRed) {
       sbVal = sbRed.getValue();
       lRedval.setText( (new Integer(sbVal)).toString() );
       Color c = tfTest.getBackground();
       tfTest.setBackground(new Color(sbVal, c.getGreen(), c.getBlue()));
    }

    if (e.target == sbGreen) {
       sbVal = sbGreen.getValue();
       lGreenval.setText( (new Integer(sbVal)).toString() );
       Color c = tfTest.getBackground();
       tfTest.setBackground(new Color(c.getRed(), sbVal, c.getBlue()));
    }

    if (e.target == sbBlue) {
       sbVal = sbBlue.getValue();
       lBlueval.setText( (new Integer(sbVal)).toString() );
       Color c = tfTest.getBackground();
       tfTest.setBackground(new Color(c.getRed(), c.getGreen(), sbVal));
    }

     
    return super.handleEvent(e);
  }

}
