/********************************************************************/
/*                                                                  */
/* (C) Copyright IBM UK Ltd. 1996                                   */
/*                                                                  */
/* SETPROC - Example of DosSetProcessorStatus usage.                */
/*                                                                  */
/* Set one or more processors online or offline.                    */
/* Setting a proessor offline makes it temporarily unavailable for  */
/* dispatching work. Setting it online makes it available.          */
/*                                                                  */
/* Note: it is not possible to set offline the processor on which   */
/*       the DosSetProcessorStatus API is executed.                 */
/*                                                                  */
/* Richard Moore 4th January 99                                     */
/* Version 1.0                                                      */
/*                                                                  */
/* Syntax SETPROC <procid> ON|OFF                                   */
/*                                                                  */
/*                                                                  */
/********************************************************************/


#define INCL_DOSSPINLOCK

#include <os2.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "apis.h"          /* include this if not using the toolkit for Warp E-Server */

/*************************************************************************************/
/*                                                                                   */
/* Purpose:                                                                          */
/*                                                                                   */
/* DosSetProcessorStatus set the ONLINE or OFFLINE status of a processor on an SMP   */
/* SMP system. The processor status may be querier using DosGetProcessorStatus.      */
/* ONLINE status imples the processor is available for running work.                 */
/* OFFLINE status implies the processor is not available for running work.           */
/* At least on processor must remain ONLINE (the one that called                     */
/* DosSetProcessorStatus).                                                           */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/*                      Prototype definition for DosSetProcessorStatus               */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/*       APIRET APIENTRY DosSetProcessorStatus(ULONG procid, ULONG status);          */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/* Use either the SMP version of OS2386.LIB or the following ordinals in the .DEF    */
/* file at link edit time.                                                           */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/*  #define ORD_DOS32SETPROCESSORSTATUS     448                                      */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/* procid is the processor ID numbered from 1 through n, where there are n           */
/* processors in total.                                                              */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/* status is one of the following:                                                   */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/*  #define PROC_OFFLINE    0x00000000         processor is offline                  */
/*  #define PROC_ONLINE     0x00000001         processor is online                   */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/* DosSetProcessorStatus returns the following:                                      */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/*  0      NO_ERROR                                                                  */
/*  87     ERROR_INVALID_PARAMETER                                                   */
/*                                                                                   */
/*************************************************************************************/

int main(int argc, char *argv[], char *envp[])
{
   APIRET rc;
   ULONG procid;     
   ULONG status;     
   int i;

   if (argc < 3) {
      printf("Syntax: SETPROC <procid> ON|OFF\n");
      return 0;
   } /* endif */

   if (strcmpi(argv[argc-1],"OFF")==0) status = 0;
   else if (strcmpi(argv[argc-1],"ON")==0) status = 1;
   else {
      printf("Syntax: SETPROC <procid1 procid2 ..... > ON|OFF\n");
      return 0;
   } /* endif */

   for (i=1; i<argc-1; ++i ) {
      procid = atol(argv[i]);
      rc = DosSetProcessorStatus(procid, status);
      if (rc) printf("DosSetProcesorStatus returned %u\n",rc); 
   } /* endfor */

   return rc;
   
}

