typedef struct _IHDRS {
  NPVOID	npInstanceData;
  USHORT	(FAR *IRQHandler)();
  UCHAR 	IRQLevel;
  UCHAR 	IRQShared;
} IHDRS, NEAR *NPIHDRS;

NPIHDRS FAR HookIRQ (PTRTYPE_INSTANCEDATA npInst) {
  UCHAR   i;
  NPIHDRS p;
  USHORT  rc;

  /* scan list of interrupt header structures */

  for (i = 0, p = IHdr; i < MAX_IRQS; i++, p++) {

    /* found free list entry */

    if (p->IRQLevel == 0) {

      /* attach to interrupt in given sharing mode */

      p->IRQLevel  = npInst->IRQLevel;
      p->IRQShared = (npInst->Flags & IRQSHARED) ? 1 : 0;
      rc = DevHelp_SetIRQ ((NPFN)p->IRQHandler, p->IRQLevel, p->IRQShared);

      /* if attach failed and sharing mode was "shared" try "unshared" */

      if (rc && p->IRQShared) {
	p->IRQShared = 0;
	rc = DevHelp_SetIRQ ((NPFN)p->IRQHandler, p->IRQLevel, p->IRQShared);

	/* if attach failed another time give up */

	if (rc) {
	  p->IRQLevel = 0;
	  return (NULL);
	}
      }
    }

    /* attach to interrupt succeeded, initialize link structures */

    if (p->IRQLevel == npInst->IRQLevel) {
      npInst->npIHdr = p;
      p->npInst      = npInst;
      return (p);
    }
  }
  return (NULL);
}

VOID FAR UnhookIRQ (PTRTYPE_INSTANCEDATA npInst) {
  NPIHDRS p = npInst->npIHdr;

  if (p) {
    DevHelp_UnSetIRQ (p->IRQLevel);
    p->IRQLevel = 0;
  }
}

VOID FAR RehookIRQ (PTRTYPE_INSTANCEDATA npInst) {
  NPIHDRS p = npInst->npIHdr;

  if (p) {
    DISABLE
    DevHelp_UnSetIRQ (p->IRQLevel);
    DevHelp_SetIRQ ((NPFN)p->IRQHandler, p->IRQLevel, p->IRQShared);
    ENABLE
  }
}

/* each IRQ entry point handles a list of instances hooked to this IRQ level */

USHORT FAR _loadds IRQEntry0() { return (HandleIRQ (IHdr[0].npInst) >> 1); }
USHORT FAR _loadds IRQEntry1() { return (HandleIRQ (IHdr[1].npInst) >> 1); }
USHORT FAR _loadds IRQEntry2() { return (HandleIRQ (IHdr[2].npInst) >> 1); }
USHORT FAR _loadds IRQEntry3() { return (HandleIRQ (IHdr[3].npInst) >> 1); }

USHORT NEAR HandleIRQ (PTRTYPE_INSTANCEDATA npInst) {
  USHORT Claimed = 0;

  /* walk list of instances attached to this IRQ */

  for ; npInst != NULL; npInst = npInst->npIntNext)
    Claimed |= npInst->IntHandler (npInst);

  return (~Claimed);
}

USHORT NEAR Interrupt (PTRTYPE_INSTANCEDATA npInst)
{
  USHORT Claimed = 0;
  int	 rcCheck;

  /* is the interrupt generated by hardware associated with this instance ? */
  /* if not, bail out early						    */

  if (!(rcCheck = CheckIRQ (npInst))) {
    return (Claimed);
  }

  /* interrupt is *possibly* from us					 */
  /* if we expect an interrupt or the interrupt is *definitely* from us, */
  /* handle it								 */

  /* up to this point, interrupts are still enabled in case of a shared IRQ */

  DISABLE
  if ((npInst->Flags & WAIT_INTERRUPT) || (rcCheck == 1)) {
    npInst->Flags &= ~WAIT_INTERRUPT;

    /* there should be am IRQ timeout timer running */

    if (npInst->IRQTimerHandle) {

      /* cancel the timer, because we got the real thing */

      ADD_CancelTimer (npInst->IRQTimerHandle);
      npInst->IRQTimerHandle = 0;
      Claimed = 1;

    } else {
      /* spurious */
    }

    /* reenable IRQ handling both globally and for this particular IRQ */

    ENABLE
    DevHelp_EOI (npInst->IRQLevel);

    if (Claimed) {
      /* enter the actual handler code with interrupts disabled, */
      /* it might need that					 */
      /* the handler must return with interrupts enabled	 */

      DISABLE
      HandleInterruptForInstance (npInst);
    }

    /* this is a *requirement* !					 */
    /* if we fail to do so, the OS/2 IRQ dispatcher will shut down this  */
    /* IRQ line 							 */
    Claimed = 1;

  } else {
    ENABLE
    /* spurious */
  }
  return (Claimed);
}

/* As long as the driver isn't prepared to handle interrupts          */
/* from a particular hardware we have to catch them anyway to prevent */
/* the OS/2 IRQ dispatcher from going mad!			      */

USHORT NEAR CatchInterrupt (PTRTYPE_INSTANCEDATA npInst)
{
  if (npInst->CheckIRQ (npInst)) {
    DevHelp_EOI (npInst->IRQLevel);
    return (1);
  }
  return (0);
}

