/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* Let's make a window containing 5 different Groups. There will be a
    TEXT group containing a few lines of text. There will be a SLIDER
    group containing 2 sliders. There will be a DROP group containing
    one dropbox. Finally there will be a RESULTBUTTON group
    containing OK and CANCEL buttons. Let's say that we want a
    groupbox around the whole thing. Normally, each group of controls
    has its own groupbox, but by not specifying those, and instead using
    a GROUP control, you can contain different group types inside of a
    single groupbox. Note that the GROUP must precede the other groups
    that it contains, or it will draw over them.
*/

/* ====================== 'Main Window' ======================= */
/* First Group is GROUP */
RXTYPE.1 = 'GROUP'

/* Default */
RXFLAGS.1 = ''

/* Label */
RXLABEL.1 = 'Everything'

/* Width, Height */
RXINFO.1 = '240 220'

/* Position */
RXX.1 = 6
RXY.1 = 6





/* Second group = SLIDER */
RXTYPE.2 = 'SLIDER'

/* Print out value of slider knob as it moves */
RXFLAGS.2 = 'VALUE'

/* Range/Detent/Label for each slider. No Groupbox */
RXLABEL.2 = '128 128 Range 1:| 64 0 Range 2:'

/* Initial values for slider knobs */
RXVAL.2 = '64 32'

/* TotalControls, ControlsPerLine, SizeOfControl */
RXINFO.2 = '2 1 142'

/* Position */
RXX.2 = 74
RXY.2 = 18





/* Third Group is DROP */
RXTYPE.3 = 'DROP'

/* Give me index rather than the text for the selected item. If I typed
    in something, not in the droplist, then that text is returned. Also,
    cause RXDLG to return when a control in this Group is used */
RXFLAGS.3 = 'INDEX'

/* Labels for each dropbox, and Groupbox. No Groupbox */
RXLABEL.3 = 'Type Here:'

/* Stem variable names to fetch the strings for each dropbox in the group */
RXVAL.3 = 'BLORT'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.3 = '1 1 100'

/* First List items */
BLORT.1 = 'This is 1'
BLORT.2 = 'This is 2'
BLORT.3 = 'This is 3'
BLORT.4 = 'This is 4'
BLORT.5 = 'This is 5'
BLORT.6 = 'This is 6'
BLORT.7 = 'This is 7'
BLORT.8 = ' '  /* Marks the end of the list */

/* Position */
RXX.3 = 85
RXY.3 = 78





/* Fourth Group is TEXT */
RXTYPE.4 = 'TEXT'

/* Center the text */
RXFLAGS.4 = 'CENTER'

/* 3 lines of text, no group box */
RXLABEL.4 = 'PLEASE READ!|This is a REXX example of|centered text.'

/* TotalPhrases, PhrasesPerLine, WidthOfPhrase, BetweenPhrases */
RXINFO.4 = '3 1 0 0'

/* Position */
RXX.4 = 40
RXY.4 = 110




/* Fifth group is RESULT */
RXTYPE.5 = 'RESULT'

/* Return a 1 for OK, YES, RETRY, ENTER, etc. Return a 1 for
    CANCEL, NO, IGNORE, etc. No need to set 'END' since
    RESULTBUTTON group always causes RXDLG to return */
RXFLAGS.5 = 'BOOL'

/* No groupbox */
RXLABEL.5 = ' '

/* Give me "Ok" and "Cancel" */
RXINFO.5 = '1 2'

/* RXVAL is Irrelevant for RESULTBUTTON */

/* Position */
RXX.5 = 60
RXY.5 = 178




/* Default size and position (also gives us sizing and max button) */
RXWINMAIN = ' '
/* Present the window. RESULT Flag so that ESC or ENTER causes
  RXDLG to return */
RXDLG 5 '"Main Window"' 'RXWINMAIN' 'RESULT'




/* Do user interaction. We sleep until RXDLG returns (ie, when user
    presses ENTER or ESC. We didn't specify 'END' for any
    of the groups, so those won't cause RXDLG to return) */
RXDLG




/* We could go through all 5 groups RXVAL strings. For example, here's the
    SLIDER code. Note RXVAL.2 because it's the second group. You get the idea */
/*
DO i = 1 TO 2
   PARSE VAR RXVAL.2 knob RXVAL.2
   RXSAY 'Slider #'i' = 'knob
END
*/



/* ========================== Done ========================== */
EXIT

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
