/* This creates a Main Window with a Group of 1 SPIN with the
   END flag set.  Whenever the user changes the SPIN's value, RXDLG
   returns, and we force the value of the SPIN to 129.
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* =============== Create "Main Window" ================= */
/* First Group is SPIN */
RXTYPE.1 = 'SPIN'

/* Use of a control in this group causes RXDLG to return */
RXFLAGS.1 = 'END|VALUE'

/* Label for control. No Groupbox */
RXLABEL.1 = '200 40 Move:'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '1 1 70'

/* initial value of spin */
RXVAL.1 = '64'

/* Position */
RXX.1 = 70
RXY.1 = 10

/* Default size and position (also gives us sizing and max button) */
RXWIN1 = ''

/* NOCLOSE since we want to close the window ourselves.
    No RESULT Flag, so the ESC and ENTER keys do nothing, and we don't
    have to bother checking for those */
RXDLG 1 '"Main Window"' 'RXWIN1'  'NOCLOSE'

more:

/* Do user interaction */
RXDLG

/* Did user click upon the CLOSE ICON? If so, then exit */
IF RXID < 0 THEN EXIT

/* Since there is only 1 group and 1 control, we know that it caused RXDLG
    to return. Force spin value to 129
*/

RXSET '""' 1 1 'VAL' 129
SIGNAL more

/* ==================================================== */
FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
