/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* This demos using TEXT Groups */

/* ====================== 'Main Window' ======================= */
/* First Group will be 3 lines of centered text with a groupbox */
RXTYPE.1 = 'TEXT'

/* Center the text */
RXFLAGS.1 = 'CENTER'

/* Text lines */
RXLABEL.1 = 'PLEASE READ!|This is a REXX example of|centered text.|Text Stuff'

/* TotalPhrases, PhrasesPerLine, WidthOfPhrase, BetweenPhrases */
RXINFO.1 = '3 1 0 0'

/* Position */
RXX.1 = 10
RXY.1 = 10


/* Second Group will show how to setup 3 columns with headings of "First",
    Second", and "Third", and then put the values 0 and 1 under First, 2 and
    3 under Second, and 4 and 5 under Third. We set BetweenPhrases to
    the desired space between columns. Since we want 3 columns, PhrasesPerLine
    is 3. Then, the order of label string goes by rows (ie, the 3 headings, and the
    first values for the 3 headings, then the second values for the 3 headings).
    Finally, we put a group box labelled "Chart" */
RXTYPE.2 = 'TEXT'

/* Center the text */
RXFLAGS.2 = 'CENTER'

/* Text lines */
RXLABEL.2 = 'First|Second|Third|0|2|4|1|3|5|Chart'

/* TotalPhrases, PhrasesPerLine, WidthOfPhrase, BetweenPhrases */
RXINFO.2 = '9 3 0 10'

/* Position */
RXX.2 = 10
RXY.2 = 100

/* Default size and position (also gives us sizing and max button) */
RXWINMAIN = ' '
RXDLG 2 '"Main Window"' 'RXWINMAIN' 'RESULT'

/* Do user interaction */
RXDLG

/* ========================== Done ========================== */
EXIT

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
