//
//                     TxWin, Textmode Windowing Library
//
//   Original code Copyright (c) 1995-2021 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   TxLib, released under MIT License
//
//   Copyright (c) 1995-2021  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on TxWin licensing can be directed to: info@dfsee.com
//
// ==========================================================================
//
// Binary value SWAP low/high parts
//
// Author: J. van Wijk
//
// JvW  28-02-2021 LICENSING: Changed from LGPL to the more liberal MIT license
// JvW  24-07-2005 Initial version, split off from TXUTIL

#include <txlib.h>


/*****************************************************************************/
// Convert USHORT value from big to little endian or vice-versa
/*****************************************************************************/
USHORT txSwapUS                                 // RET   converted value
(
   USHORT              val                      // IN    value
)
{
   USHORT              rc;

   rc  = (val & 0x00ff) << 8;
   rc += (val & 0xff00) >> 8;

   return (rc);
}                                               // end 'txSwapUS'
/*---------------------------------------------------------------------------*/


/*****************************************************************************/
// Convert ULONG value from big to little endian or vice-versa
/*****************************************************************************/
ULONG txSwapUL                                  // RET   converted value
(
   ULONG               val                      // IN    value
)
{
   ULONG               rc;

   rc  = (val & 0x000000ff) << 24;
   rc += (val & 0x0000ff00) <<  8;
   rc += (val & 0x00ff0000) >>  8;
   rc += (val & 0xff000000) >> 24;

   return (rc);
}                                               // end 'txSwapUL'
/*---------------------------------------------------------------------------*/

