
// First include all needed standard header files
#include <stdlib.h>
#include <stdio.h>
#include <process.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include <time.h>

#ifndef M_PI
#define M_PI 3.14159
#endif

// Then the needed OS/2 API stuffs
#define INCL_TYPES
#define INCL_WIN
#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_GPI
#include <os2.h>

#include <cairo.h>
#include <cairo-os2.h>

#define DEBUG_BUILD

// --------------- Functions: -----------------------------------------------

#ifdef DEBUG_BUILD
void MorphToPM()
{
  PPIB pib;
  PTIB tib;

  DosGetInfoBlocks(&tib, &pib);

  // Change flag from VIO to PM:
  if (pib->pib_ultype==2) pib->pib_ultype = 3;
}
#endif

void ErrorMsg(char *Msg)
{
#ifdef DEBUG_BUILD
  printf("ErrorMsg: %s\n",Msg); fflush(stdout);
#endif
  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
                Msg, "TestApp Error", 0, MB_OK | MB_MOVEABLE | MB_ICONEXCLAMATION);
}

static void inline DisableFPUException()
{
  unsigned short usCW;

  // Some OS/2 PM API calls modify the FPU Control Word,
  // but forget to restore it.

  // This can result in XCPT_FLOAT_INVALID_OPCODE exceptions,
  // so to be sure, we always disable Invalid Opcode FPU exception
  // before using FPU stuffs with Cairo or from this application.

  usCW = _control87(0, 0);
  usCW = usCW | EM_INVALID | 0x80;
  _control87(usCW, MCW_EM | 0x80);
}


#define TITLE TEXT("Cairo Snippets")
#define BORDER_WIDTH 75.
#define FONT_SIZE 24

cairo_surface_t *surface = NULL;
cairo_t *cr = NULL;
double line_width;
cairo_font_extents_t font_extents;
int SNIPPET_WIDTH, SNIPPET_HEIGHT;
static HPS hpsClient;


void snippet_normalize (cairo_t *cr, double width, double height)
{
  /*
  if (width>=height)
    height=width;
  else
  width=height;
  */
  cairo_scale (cr, width, height);
  cairo_set_line_width (cr, 0.04);
}

int pos=0;

void draw_cairo_surface()
{
    cairo_text_extents_t CairoTextExtents;

#ifdef DEBUG_BUILD
  time_t firsttic, toc;
  printf("[MainWindowProc] : Drawing Surface: %p\n", surface);
  firsttic = clock();
#endif
  /* Now draw the snippet, clipped to the box */

  DisableFPUException();

  cairo_save (cr);
  snippet_normalize (cr, SNIPPET_WIDTH, SNIPPET_HEIGHT);


  cairo_set_source_rgb (cr, 0.3, 0.3 ,0.3);
  cairo_rectangle (cr,
                   0, 0,
                   1, 1);
  cairo_fill(cr);

  cairo_select_font_face (cr, "Sans", CAIRO_FONT_SLANT_NORMAL,
                          CAIRO_FONT_WEIGHT_BOLD);
  cairo_set_font_size (cr, 0.20);

                          cairo_text_extents(cr,
                                             "00:00:00",
                                             &CairoTextExtents);

                          
  cairo_set_source_rgba (cr, 0.3,1,0.2, 0.6);
  cairo_move_to (cr, 0.02, 0.53);
  cairo_show_text (cr, "Cairo on");

  cairo_move_to (cr, 0.17, 0.65);
  cairo_set_font_size (cr, 0.25);
  cairo_text_path (cr, "OS/2");
  cairo_set_source_rgba (cr, 0.5,0.5, 1, 0.69);
  cairo_fill_preserve (cr);
  cairo_set_source_rgba (cr, 0,0,0, 0.6);
  cairo_set_line_width (cr, 0.01);
  cairo_close_path (cr);
  cairo_stroke (cr);

  cairo_set_source_rgba (cr, 1,0.2,0.2, 0.6);
  cairo_arc (cr, 0.05, 0.53, 0.02, 0, 2*M_PI);
  cairo_close_path (cr);
  cairo_arc (cr, 0.27, 0.65, 0.02, 0, 2*M_PI);
  cairo_fill (cr);
  cairo_close_path (cr);

  cairo_set_source_rgba (cr, 1, 0.2, 0.2, 0.5);
  cairo_move_to(cr,
                (sin(pos*M_PI/180.0)+1)/2,
                (cos(pos*M_PI/180.0)+1)/2);
  cairo_line_to(cr,
                (cos((pos+180)*M_PI/180.0)+1)/2,
                (sin((pos+180)*M_PI/180.0)+1)/2);
  cairo_close_path (cr);
  cairo_stroke (cr);

  cairo_set_source_rgba (cr, 0.2, 1,0.2, 0.5);
  cairo_move_to(cr,
                (sin(pos*M_PI/180.0)+1)/2,
                (cos(pos*M_PI/180.0)+1)/2);
  cairo_line_to(cr,
                (sin((pos+180)*M_PI/180.0)+1)/2,
                (cos((pos+180)*M_PI/180.0)+1)/2);
  cairo_close_path (cr);
  cairo_stroke (cr);

  cairo_set_source_rgba (cr, 0.2, 0.2, 1, 0.5);
  cairo_move_to(cr,
                (cos(pos*M_PI/180.0)+1)/2,
                (sin(pos*M_PI/180.0)+1)/2);
  cairo_line_to(cr,
                (cos((pos+180)*M_PI/180.0)+1)/2,
                (sin((pos+180)*M_PI/180.0)+1)/2);
  cairo_close_path (cr);
  cairo_stroke (cr);

  /*
  cairo_move_to (cr, 0.12, 0.22);
  cairo_set_font_size (cr, 0.1);
  cairo_rotate(cr, pos*M_PI/180);
  cairo_scale(cr, 2, 2);
  cairo_text_path (cr, "Doodle");
  cairo_set_source_rgba (cr, 0.8,0.5, 1, 0.889);
  cairo_fill_preserve (cr);
  cairo_set_source_rgba (cr, 0.2,0.1,0.3, 0.86);
  cairo_set_line_width (cr, 0.007);
  cairo_stroke (cr);
  */

  cairo_restore (cr);

#ifdef DEBUG_BUILD
  printf("[MainWindowProc] : Surface is ready: %p\n", surface);
  toc = clock();
  printf("[MainWindowProc] : Time spent: %d (%f sec)\n",
         (toc-firsttic), (toc-firsttic) * 1.0 / CLOCKS_PER_SEC);
#endif

}

MRESULT EXPENTRY MainWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  SWP swpTemp;

  switch (msg)
  {
    case WM_CREATE:
        WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 1000, 500);
        break;
    case WM_TIMER:
        if (SHORT1FROMMP(mp1)==1000)
        {
          if (surface)
          {
            draw_cairo_surface();
            pos = (pos+1) % 360;
            WinInvalidateRect(hwnd, NULL, FALSE);
          }
        }
        break;
    case WM_DESTROY:
#ifdef DEBUG_BUILD
      printf("[MainWindowProc] : In WM_DESTROY\n");
#endif
      if (cr)
        cairo_destroy (cr);
      if (surface)
        cairo_surface_destroy (surface);
      WinReleasePS(hpsClient);
      break;

    case WM_PAINT:
      if ((!cr) && (!surface))
      {
        // First time paint, create surface and all those stuffs
  #ifdef DEBUG_BUILD
        printf("[MainWindowProc] : In first WM_PAINT\n");
  #endif
  
        WinQueryWindowPos(hwnd, &swpTemp);
        SNIPPET_WIDTH = swpTemp.cx;
        SNIPPET_HEIGHT = swpTemp.cy;
  
  #ifdef DEBUG_BUILD
        printf("[MainWindowProc] : Window size: %d x %d\n", SNIPPET_WIDTH, SNIPPET_HEIGHT);
  #endif
  
        surface = cairo_os2_surface_create(hpsClient=WinGetPS(hwnd),
                                           swpTemp.cx, swpTemp.cy);

#ifdef DEBUG_BUILD
        printf("[MainWindowProc] : @1\n");
#endif

        cr = cairo_create (surface);

#ifdef DEBUG_BUILD
        printf("[MainWindowProc] : @2\n");
#endif


        cairo_os2_surface_set_manual_window_refresh(surface, TRUE);

#ifdef DEBUG_BUILD
        printf("[MainWindowProc] : @3\n");
#endif

        draw_cairo_surface();
#ifdef DEBUG_BUILD
        printf("[MainWindowProc] : @4\n");
#endif

      }

      {
	HPS hpsBeginPaint;
        RECTL rclRect;
      
        hpsBeginPaint = WinBeginPaint(hwnd, NULL, &rclRect);

        // Repaint the stuffs
	cairo_os2_surface_refresh_window(surface, hpsBeginPaint, &rclRect);

        // All done!
	WinEndPaint(hpsBeginPaint);
	return (MRESULT) FALSE;
      }
      break;
    case WM_SIZE:
  #ifdef DEBUG_BUILD
        printf("[MainWindowProc] : In WM_SIZE\n");
  #endif
        if (surface)
        {
          SWP swpTemp;
          SNIPPET_WIDTH = SHORT1FROMMP(mp2);
          SNIPPET_HEIGHT = SHORT2FROMMP(mp2);

#ifdef DEBUG_BUILD
          printf("[MainWindowProc] : Window size: %d x %d\n", SNIPPET_WIDTH, SNIPPET_HEIGHT);
#endif

          WinQueryWindowPos(hwnd, &swpTemp);
#ifdef DEBUG_BUILD
          printf("[MainWindowProc] : Window size2: %d x %d\n", swpTemp.cx, swpTemp.cy);
#endif
          cairo_os2_surface_set_size(surface,
                                     SHORT1FROMMP(mp2),
                                     SHORT2FROMMP(mp2),
                                     6000);
          draw_cairo_surface();
          WinInvalidateRect(hwnd, NULL, TRUE);
        }
        break;
  }
  return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY NewFrameProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  PFNWP pOldFrameProc;
  MRESULT result;
  PTRACKINFO ti;

  pOldFrameProc = (PFNWP) WinQueryWindowULong(hwnd, QWL_USER);

  result = (*pOldFrameProc)(hwnd, msg, mp1, mp2);

  if (msg == WM_QUERYTRACKINFO)
  {
    ti = (PTRACKINFO) mp2;
    ti->ptlMinTrackSize.x = 300;
    ti->ptlMinTrackSize.y = 200;
  }
  return result;
}

void PMTest()
{
  HAB hab;
  HMQ hmq;
  QMSG msg;
  ULONG flCreaFlags, flFrameStyle, flClientStyle;
  SWP swap;
  PFNWP pOldFrameProc;
  HWND hwndFrame;
  HWND hwndClient;


#ifdef DEBUG_BUILD
  printf("[PMThread] : Starting\n");
#endif
  // Setup this thread for using PM (sending messages etc...)
  hab = WinInitialize(0);
  hmq = WinCreateMsgQueue(hab, 0);

  // Create main window
  WinRegisterClass(hab, "PrivateClassName",  // Register a private class, so
		   MainWindowProc,           // we can use our own window procedure for frame
		   0, 0);

  // Set defaults for main window:
  flCreaFlags = 
    FCF_TASKLIST | FCF_SYSMENU | FCF_TITLEBAR | FCF_SIZEBORDER |
    FCF_DLGBORDER | FCF_MINMAX |
    FCF_SHELLPOSITION | FCF_NOBYTEALIGN | FCF_AUTOICON;
  flFrameStyle =
    FS_NOBYTEALIGN | FS_BORDER;
  flClientStyle =
      WS_CLIPCHILDREN;

  hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
				 flFrameStyle,       // Frame window style
				 &flCreaFlags,
                                 "PrivateClassName",
                                 "TestApp for CAIRO.DLL",
				 flClientStyle,//0,   // Client window style
				 NULLHANDLE,
				 0L,
                                 &hwndClient);

  pOldFrameProc = WinSubclassWindow(hwndFrame, NewFrameProc); // Subclass window to be able
                                                              // to handle resize events
  // Store old window proc in frame window's ULONG
  WinSetWindowULong(hwndFrame, QWL_USER, (ULONG) pOldFrameProc);

  // Move the window more down if it would be out of the screen
  WinQueryWindowPos(hwndFrame, &swap);
  if (swap.y+swap.cy > WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN))
  {
    WinSetWindowPos(hwndFrame, HWND_TOP, swap.x,
		    WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) - swap.cy, 0, 0, SWP_MOVE);
    WinQueryWindowPos(hwndFrame, &swap);
  }
  if (swap.x+swap.cx > WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN))
  {
    if (WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) - swap.cx >= 0)
      WinSetWindowPos(hwndFrame, HWND_TOP, 
		      WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) - swap.cx, swap.y,  0, 0, SWP_MOVE);
  }

  WinSetWindowPos(hwndFrame, HWND_TOP, 0, 0, 0, 0, SWP_ZORDER | SWP_SHOW | SWP_ACTIVATE);

#ifdef DEBUG_BUILD
  printf("[PMThread] : Reached WinProcessDlg\n");
#endif
  while (WinGetMsg(hab, &msg, 0, 0, 0))
    WinDispatchMsg(hab, &msg);
#ifdef DEBUG_BUILD
  printf("[PMThread] : Shutting down!\n");
#endif

  WinDestroyWindow(hwndFrame); // Destroy windows

  // Uninitialize PM
  WinDestroyMsgQueue(hmq);
  WinTerminate(hab);

#ifdef DEBUG_BUILD
  printf("[PMThread] : Stopped\n");
#endif
}



// ---------- Main function -------------------------------------------------

int main(int argc, char *argv[])
{
#ifdef DEBUG_BUILD
  MorphToPM();
  setbuf(stdout, NULL);
  setbuf(stderr, NULL);
#ifdef __WATCOMC__
#if __WATCOMC__<1200
  printf("Compiled with WatcomC v%d.%02d\n", (__WATCOMC__)/100, (__WATCOMC__)%100);
#else
  printf("Compiled with OpenWatcom v%d.%02d\n", (__WATCOMC__-1100)/100, (__WATCOMC__-1100)%100);
#endif
#endif
  fflush(stdout);
#endif

  PMTest();

#ifdef DEBUG_BUILD
  printf("Everything done! Bye!\n");
#endif

  return 0;
}
