/* */
SIGNAL ON SYNTAX
CALL RXFUNCADD "HALKbdLoadFuncs","HALKBD","HALKbdLoadFuncs"
CALL HALKbdLoadFuncs
ROW=1; COL=1
ROWS=40; COLS=80
"@MODE "COLS ROWS
DO FOREVER
	CALL SYSCURPOS ROW-1,COL-1
	PARSE VALUE HALKbdCharIn() WITH SHIFTSTATE"~"SCANCODE"~"ASCIICODE
	SELECT
		WHEN SCANCODE=1 THEN LEAVE
		WHEN (SCANCODE>=2)&(SCANCODE<=10) THEN CALL SET SCANCODE-1 /* Numeric */
		WHEN SCANCODE=11 THEN CALL SET "0" /* 0 = 0 not 10 */
		WHEN SCANCODE=41 THEN CALL SET "0" /* ` or ~ = 0 */
		WHEN (SCANCODE>=16)&(SCANCODE<=21) THEN CALL SET D2X(SCANCODE-6) /* QWERTY = ABCDEF */
		WHEN SCANCODE=22 THEN IF ROW=1 THEN ROW=ROWS; ELSE ROW=ROW-1 /* U = up */
		WHEN SCANCODE=23 THEN IF ROW=ROWS THEN ROW=1; ELSE ROW=ROW+1 /* I = down */
		WHEN SCANCODE=24 THEN IF COL=1 THEN COL=COLS; ELSE COL=COL-1 /* O = left */
		WHEN SCANCODE=25 THEN IF COL=COLS THEN COL=1; ELSE COL=COL+1 /* P = right */
		OTHERWISE NOP
	END
END
EXIT

SYNTAX:
CALL TRACE O
SAY RC ERRORTEXT(RC)
SAY SOURCELINE(SIGL)
TRACE ?I
NOP
EXIT

BITSET: PROCEDURE /* Check if bit BIT is set in number NUM */
PARSE ARG NUM,BIT
BIN=X2B(D2X(NUM))
IF LENGTH(BIN)<BIT THEN RETURN 0
RETURN SUBSTR(BIN,LENGTH(BIN)-BIT,1)

SET:
CALL CHAROUT ,ARG(1)
COL=COL+LENGTH(ARG(1))
IF COL>COLS THEN DO; COL=COL-COLS; ROW=ROW+1; END
RETURN
