/* Find Daylight Savings change dates */

dateFormat = '%A %B %d'

if RxFuncQuery('RxDate')
    then call RxFuncAdd 'RxDate', 'RexxDate', 'RxDate'

parse arg Year 

if Year = '' then do
    say 'Calculate the beginning and ending of Daylight Savings Time'
    say 'in the United States'
    say '  (First Sunday in April and last Sunday in October)'
    say 'Usage: Daylight <year>'
    return
end

DaylightStart = rxDate(year'-4-1')  
DayOfWeek =  rxDate(DaylightStart, '%w')
if DayOfWeek > 0 /* If April 1st isn't a Sunday, jump ahead to the next one */
    then DaylightStart = DaylightStart + (7 - DayOfWeek)

DaylightEnd = rxDate(year'-10-31') - rxDate(year'-10-31', '%w')

Today = rxDate()

say 'For the year' rxDate(DaylightStart, '%Y')
say 'Daylight Savings starts on:' rxDate(DaylightStart, dateFormat) 
say '                           ' DaylightStart - Today 'days from now'
say '               and ends on:' rxDate(DaylightEnd, dateFormat)
say '                           ' DaylightEnd - Today 'days from now'
