/* Test Dutch WOY functions */

parse arg testdate

say 'The Dutch Week number for' testdate 'is' DutchWeekOfYear(testdate)
return

/* 
    Find the Monday based day of the week, 
    where Monday = 0, Tuesday = 1, .....Sunday = 6 
*/
MDoW:
    procedure
    result = RxDate(arg(1), '%w') - 1
    if result < 0
        then result = 6
    return result

/* Find the week of the year, based on the Dutch rules */
DutchWeekOfYear:
    procedure
    dateval = arg(1)
    year = RxDate(dateval, '%Y')
        
    JanFirst = RxDate(year'-1-1')
           MondayBeforeJanFirst = JanFirst - MDow(JanFirst)

    week = (RxDate(dateval) - RxDate(MondayBeforeJanFirst)) % 7

    /* Is this a leap year? */
    If RxDate(year'-2-29', '%M') = 2
        then cutoff = 2
        else cutoff = 3

    /* At least 4 days of the new year in the first week, */
        /* 5 days in a leapYear (rules 2 and 3)               */
    if MDoW(janFirst) <= cutoff
        then week = week + 1

    /* Leftover days are week 53 (rule 4) */
    if week = 0
        then week = 53

    return week
