/* 
    Convert Gregorian dates to Mayan dates 

    Based on info from "A Forest of Kings: The Untold Story of the Ancient Maya"
    by Linda Schele and David Freidel

    The dates seem to agree with those in the book close to current times, 
    older dates disagree with the book by 4 days for some reason, but the
    dates at the creation seem to agree..perhaps the book is in error? or
    the mayans slipped up once or twice?  Anyhow, this utility probably
    shouldn't be taken too seriously
*/

mayaOffset = 1137141

/* 
  According to Schele & Freidel (p. 507), this offset is believed to be 
  correct but "is two days out of agreement with the calanders that are 
  still maintained by the Maya of the Guatamala highlands" 

  An offset of 1137139 would cause the dates to agree
*/

/* Mayan Days */
day.0  = 'Imix'
day.1  = 'Ik'
day.2  = 'Akbal'
day.3  = 'Kan'
day.4  = 'Chicchan'
day.5  = 'Cimi'
day.6  = 'Manik'
day.7  = 'Lamat'
day.8  = 'Muluc'
day.9  = 'Oc'
day.10 = 'Chuen'
day.11 = 'Eb'
day.12 = 'Ben'
day.13 = 'Ix'
day.14 = 'Men'
day.15 = 'Cib'
day.16 = 'Caban'
day.17 = "Etz'nab"
day.18 = 'Cauac'
day.19 = 'Ahau'

/* Mayan Months */
month.0  = 'Pop'
month.1  = 'Uo'
month.2  = 'Zip'
month.3  = "Zotz'"
month.4  = 'Zec'
month.5  = 'Xul'
month.6  = 'Yaxkin'
month.7  = 'Mol'
month.8  = "Ch'en"
month.9  = 'Yax'
month.10 = 'Zac'
month.11 = 'Ceh'
month.12 = 'Mac'
month.13 = 'Kankin'
month.14 = 'Muan'
month.15 = 'Pax'
month.16 = 'Kayab'
month.17 = 'Chumku'
month.18 = 'Uayeb'


if RxFuncQuery('RxDate')
    then call RxFuncAdd 'RxDate', 'RexxDate', 'RxDate'

parse arg d

if d = '' then do
    say 'Convert between Gregorian and Mayan dates'
    say 'Usage: Mayan <gregorian-date | mayan-long-count>'
    say ''
    say 'Today is....'
    d = rxdate()
end

if pos('.', d) > 0 then do
   mayaBase = calcLong(d)
   gregBase = mayaBase - mayaOffset
end
else do
   gregBase = rxDate(d)
   mayaBase = gregBase + mayaOffset
end

/* Figure the Maya Long Count */
baktun =    mayaBase %144000
katun  =   (mayaBase//144000) %7200
tun    =  ((mayaBase//144000)//7200) %360
uinal  = (((mayaBase//144000)//7200)//360) %20
kin    = (((mayaBase//144000)//7200)//360)//20

tzolkinNum = ((mayaBase+3)//13)+1
tzolkinDay = (mayaBase+19)//20

haabBase  = (mayaBase+348)//365
haabMonth = haabBase % 20
haabDay   = haabBase // 20
if haabDay = 0
    then haabDay = 'chum' /* 'seating' of the upcoming month */

say '       Gregorian:' rxDate(gregBase, '%A, %b %d %Y')
say 'Mayan Long Count:' baktun'.'katun'.'tun'.'uinal'.'kin
say '  Calendar Round:' tzolkinNum day.tzolkinDay haabDay month.haabMonth
return



/* Convert the Mayan long count to Mayan Base days */
calcLong:
    procedure
    parse value arg(1) with baktun '.' katun '.' tun '.' uinal '.' kin
    return (baktun*144000)+(katun*7200)+(tun*360)+(uinal*20)+kin
