{Esstu Utilities - various handy functions for REXX}

LIBRARY S2UTIL;

{$CDecl+,OrgName+,I-,S-,Delphi+,Use32+}

USES DOS,OS2DEF,REXX,STRINGS,OS2BASE;

{$LINKER
  DESCRIPTION      "Esstu Utilities - handy functions for REXX"
  DATA MULTIPLE NONSHARED

  EXPORTS
    S2PARSEARGS=S2PARSEARGS
    S2WORDSPLIT=S2WORDSPLIT
    S2LOADFUNCS=S2LOADFUNCS
}

CONST FUNCTIONTABLE : ARRAY[ 0..1 ] OF PCHAR =
(
    'S2PARSEARGS',
    'S2WORDSPLIT'
);

FUNCTION S2LOADFUNCS(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    I:INTEGER;
BEGIN
    RET.STRLENGTH:=0;
    IF ARGC>0 THEN RESULT:=40
    ELSE BEGIN
        FOR I:=LOW(FUNCTIONTABLE) TO HIGH(FUNCTIONTABLE) DO
            REXXREGISTERFUNCTIONDLL(FUNCTIONTABLE[I],'S2UTIL',FUNCTIONTABLE[I]);
        RESULT:=0;
    END;
END;

FUNCTION STR2INT(S:STRING):INTEGER;
VAR
    INT,I:INTEGER;
BEGIN
    INT:=0;
    FOR I:=1 TO LENGTH(S) DO INT:=INT*10+ORD(S[I])-ORD('0');
    RESULT:=INT;
END;

PROCEDURE INT2RXSTR(VAR RX:RXSTRING;NUM:INTEGER);
VAR
    S:STRING;
BEGIN
    STR(NUM,S);
    RX.STRLENGTH:=LENGTH(S);
    STRPCOPY(RX.STRPTR,S);
END;

{Variable Pool codes: (from C header file)
#define RXSHV_SET          0x00       /* Set var from given value    */
#define RXSHV_FETCH        0x01       /* Copy value of var to buffer */
#define RXSHV_DROPV        0x02       /* Drop variable               */
#define RXSHV_SYSET        0x03       /* Symbolic name Set variable  */
#define RXSHV_SYFET        0x04       /* Symbolic name Fetch variable*/
#define RXSHV_SYDRO        0x05       /* Symbolic name Drop variable */
#define RXSHV_NEXTV        0x06       /* Fetch "next" variable       */
#define RXSHV_PRIV         0x07       /* Fetch private information   */
#define RXSHV_EXIT         0x08       /* Set function exit value     */
}

FUNCTION S2PARSEARGS(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    RETN:INTEGER;
    VARS:SHVBLOCK;
    ARGSTRING:STRING;
    STEM:STRING;
    I,J:INTEGER;
    VARNAME:STRING;
    N:INTEGER;
    VALUE:STRING;
    OPTION:STRING;
    OPTVAL:STRING;
    START:INTEGER;
    QUOTED,Q:BOOLEAN;
BEGIN
    IF ARGC<>2 THEN EXIT;
    ARGSTRING:=STRPAS(ARGS^.STRPTR)+' -'; {Add space and dash at end to trigger end-of-arg code}
    INC(ARGS);
    STEM:=STRPAS(ARGS^.STRPTR);
    N:=0;
    VALUE:='';
    QUOTED:=FALSE;
    FOR I:=1 TO LENGTH(ARGSTRING) DO BEGIN
        IF ARGSTRING[I]='"' THEN QUOTED:=NOT QUOTED;
        IF QUOTED THEN VALUE:=VALUE+ARGSTRING[I]
        ELSE BEGIN
            IF (ARGSTRING[I]=' ') AND (VALUE<>'') AND ((ARGSTRING[I+1]='-') OR (ARGSTRING[I+1]='/')) THEN BEGIN
                N:=N+1;
                STR(N,VARNAME);
                VARNAME:=STEM+VARNAME;
                VARS.SHVNEXT:=NIL;
                VARS.SHVCODE:=0;
                VARS.SHVNAME.STRPTR:=@VARNAME[1];
                VARS.SHVNAME.STRLENGTH:=LENGTH(VARNAME);
                VARS.SHVVALUE.STRPTR:=@VALUE[1];
                VARS.SHVVALUE.STRLENGTH:=LENGTH(VALUE);
                RETN:=REXXVARIABLEPOOL(VARS);
                Q:=FALSE;
                START:=1;
                IF (VALUE[1]='-') OR (VALUE[1]='/') THEN START:=2;
                OPTION:='';
                OPTVAL:='';
                VALUE:=VALUE+#0;
                FOR J:=START TO LENGTH(VALUE) DO BEGIN
                    IF VALUE[J]='"' THEN Q:=NOT Q;
                    IF Q THEN OPTION:=OPTION+VALUE[J]
                    ELSE BEGIN
                        IF VALUE[J]=#0 THEN BREAK
                        ELSE IF VALUE[J] IN [' ',':','='] THEN BEGIN OPTVAL:=STRPAS(@VALUE[J+1]); BREAK; END
                        ELSE OPTION:=OPTION+VALUE[J];
                    END;
                END;
                VARNAME:=STEM+OPTION;
                VARS.SHVNEXT:=NIL;
                VARS.SHVCODE:=0;
                VARS.SHVNAME.STRPTR:=@VARNAME[1];
                VARS.SHVNAME.STRLENGTH:=LENGTH(VARNAME);
                VARS.SHVVALUE.STRPTR:=@OPTVAL[1];
                VARS.SHVVALUE.STRLENGTH:=LENGTH(OPTVAL);
                RETN:=REXXVARIABLEPOOL(VARS);
                VALUE:='';
            END ELSE VALUE:=VALUE+ARGSTRING[I];
        END
    END;
    VARNAME:=STEM+'0';
    STR(N,VALUE);
    VARS.SHVNEXT:=NIL;
    VARS.SHVCODE:=0;
    VARS.SHVNAME.STRPTR:=@VARNAME[1];
    VARS.SHVNAME.STRLENGTH:=LENGTH(VARNAME);
    VARS.SHVVALUE.STRPTR:=@VALUE[1];
    VARS.SHVVALUE.STRLENGTH:=LENGTH(VALUE);
    RETN:=REXXVARIABLEPOOL(VARS);
    RESULT:=0;
    RET.STRLENGTH:=0;
END;

FUNCTION S2WORDSPLIT(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    RETN:INTEGER;
    VARS:SHVBLOCK;
    ARGSTRING:STRING;
    STEM:STRING;
    I:INTEGER;
    VARNAME:STRING;
    N:INTEGER;
    VALUE:STRING;
    QUOTED:BOOLEAN;
BEGIN
    IF ARGC<>2 THEN EXIT;
    ARGSTRING:=STRPAS(ARGS^.STRPTR)+' '; {Add space at end to trigger end-of-word code}
    INC(ARGS);
    STEM:=STRPAS(ARGS^.STRPTR);
    N:=0;
    VALUE:='';
    QUOTED:=FALSE;
    FOR I:=1 TO LENGTH(ARGSTRING) DO BEGIN
        IF ARGSTRING[I]='"' THEN QUOTED:=NOT QUOTED;
        IF QUOTED THEN VALUE:=VALUE+ARGSTRING[I]
        ELSE BEGIN
            IF ARGSTRING[I]=' ' THEN BEGIN IF VALUE<>'' THEN BEGIN
                N:=N+1;
                STR(N,VARNAME);
                VARNAME:=STEM+VARNAME;
                VARS.SHVNEXT:=NIL;
                VARS.SHVCODE:=0;
                VARS.SHVNAME.STRPTR:=@VARNAME[1];
                VARS.SHVNAME.STRLENGTH:=LENGTH(VARNAME);
                VARS.SHVVALUE.STRPTR:=@VALUE[1];
                VARS.SHVVALUE.STRLENGTH:=LENGTH(VALUE);
                RETN:=REXXVARIABLEPOOL(VARS);
                VALUE:='';
            END END ELSE VALUE:=VALUE+ARGSTRING[I];
        END
    END;
    VARNAME:=STEM+'0';
    STR(N,VALUE);
    VARS.SHVNEXT:=NIL;
    VARS.SHVCODE:=0;
    VARS.SHVNAME.STRPTR:=@VARNAME[1];
    VARS.SHVNAME.STRLENGTH:=LENGTH(VARNAME);
    VARS.SHVVALUE.STRPTR:=@VALUE[1];
    VARS.SHVVALUE.STRLENGTH:=LENGTH(VALUE);
    RETN:=REXXVARIABLEPOOL(VARS);
    RESULT:=0;
    RET.STRLENGTH:=0;
END;

INITIALIZATION
END.

