/*
 *
 * Module   :LXLIST.C
 * Abstract :LX Executable import module list
 * 
 * Copyright (C) Sergey I. Yevtushenko
 * Last Update :Wed  14-08-96
 * Created     :Sat  20-04-96
 */

#define INCL_DOSFILEMGR
#define INCL_DOSMODULEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <lxlist.h>


typedef struct st__module_info
{
    UCHAR Name[CCHMAXPATHCOMP];
    ULONG Type;
} MODULE, *PMODULE;

APIRET GetModuleInfo(PMODULE Module)
{
	UCHAR LoadError[256] = "";	/* Area for Load failure information */
	HMODULE ModuleHandle = NULLHANDLE;	/* Module handle                     */
	APIRET rc = NO_ERROR;	/* Return code                       */

    Module->Type = -1;

    rc = DosLoadModule(LoadError, sizeof(LoadError), Module->Name, &ModuleHandle);
    Module->Name[0] = 0;
    if (rc != NO_ERROR)
    {
        return rc;
    }

    rc = DosQueryModuleName(ModuleHandle, sizeof(Module->Name), Module->Name);
    if (rc != NO_ERROR)
    {
        Module->Name[0] = 0;
        return rc;
    }

    rc = DosQueryProcType(ModuleHandle, 1L, NULL, &Module->Type);
    if (rc != NO_ERROR)
    {
        Module->Type = -1;
        return rc;
    }

    rc = DosFreeModule(ModuleHandle);
    return rc;
}

void list_LX(char *file)
{
	FILE *in;
	long beg = 0;
	LXheader hdr;
	int i;
	word sign;

	in = fopen(file, "rb");
	if (!in)
		return;
	fread(&sign, sizeof(sign), 1, in);
	if (sign != 0x4D5A && sign != 0x5A4D)	/* MZ or ZM !!! Yes this is also valid */
	{
		/* printf("not an executable file"); */
		fclose(in);
		return;
	}
	fseek(in, OffsetToLX, SEEK_SET);
	fread(&beg, sizeof(beg), 1, in);
	fseek(in, beg, SEEK_SET);
	fread(&hdr, sizeof(hdr), 1, in);
	if (hdr._L != 'L' || hdr._X != 'X')
	{
		/* printf("Unknow format '%c%c'", hdr._L, hdr._X); */
		fclose(in);
		return;
	}
    printf("%s :\n", file);
	fseek(in, beg + hdr.ImportModuleTblOff, SEEK_SET);
	for (i = 0; i < (hdr.ImportProcTblOff - hdr.ImportModuleTblOff); i++)
	{
		int j;
		char *name;
		j = getc(in);
		if (j > 0)
		{
			char *ptr;
			name = (char *) malloc(j + 1);
			if (name)
			{
                APIRET rc;
                MODULE module;
				ptr = name;
				for (; j > 0; j--, i++)
					*ptr++ = getc(in);
				*ptr = 0;
                strcpy(module.Name, name);
                rc = GetModuleInfo(&module);
                printf("\t %s (%s) : %s\n", name,
                        (module.Type == -1) ? "(unknow)" :
                        (module.Type == 1 ? "32-bit":"16-bit"), module.Name);
			}
			free(name);
		}
	}
	if (!i)
		printf("\n");
	fclose(in);
}

main(int argc, char **argv)
{
	int i;
    char path[CCHMAXPATHCOMP];
    if(argc == 1)
    {
        printf(
            "LX executable import module(s) lister V0.02\n"
            "Copyright (c) 1996  Sergey I. Yevtushenko\n"
            "  Usage: LXLIST <filespec>\n"
        );
        return 0;
    }
	for (i = 1; i < argc; i++)
	{
		HDIR hdirFindHandle = HDIR_SYSTEM;
		FILEFINDBUF3 FindBuffer = {0};
		ULONG ulResultBufLen = sizeof(FILEFINDBUF3);
		ULONG ulFindCount = 1;
		APIRET rc = NO_ERROR;
		char *slash = 0;

		strcpy(path, argv[i]);
		slash = strrchr(path, '\\');
		if (slash)
			slash++;

		rc = DosFindFirst(argv[i],
				  &hdirFindHandle,
				  FILE_NORMAL | FILE_ARCHIVED |
				  FILE_SYSTEM | FILE_HIDDEN | FILE_READONLY,
				  &FindBuffer,
				  ulResultBufLen,
				  &ulFindCount,
				  FIL_STANDARD);

		if (rc != NO_ERROR)
			return 1;

		do
		{
			ulFindCount = 1;
			if (slash)
			{
				strcpy(slash, FindBuffer.achName);
				list_LX(path);
			}
			else
				list_LX(FindBuffer.achName);

			rc = DosFindNext(hdirFindHandle,
					 &FindBuffer,
					 ulResultBufLen,
					 &ulFindCount);
			if (rc != NO_ERROR && rc != ERROR_NO_MORE_FILES)
			{
				printf("DosFindNext error: return code = %u\n", rc);
				return 1;
			}
		}
		while (rc != ERROR_NO_MORE_FILES);
		rc = DosFindClose(hdirFindHandle);
	}
	return 0;
}


