/*REXX exec to invoke the Debugger under APPC */
Parse Arg Parms '(' Debug;
If Parms="?" Then Signal Help;

If Parms="" Then Do;
  Parse Source . . SPath .;
  SPath=Left(SPath,LastPos("\",SPath)-1);
End;
Else SPath=Parms;
If SubStr(SPath,2,2)\=":\" Then Do;
  Say "Path specification must include a drive:\";
  Say "Push Enter to continue";
  Parse Pull .;
  Exit 16;
End;

If Right(SPath,1)="\" Then SPath=Left(SPath,Length(SPath)-1);
SPath=Translate(SPath);
If Translate(Directory(SPath))\=SPath Then Do;
  Say "Specified path ("SPath") does not exist";
  Say "Push Enter to continue";
  Parse Pull .;
  Exit 16;
End;

If Debug\="" Then Do;
  RC=Value("ICLUI_TRACE","ON","OS2ENVIRONMENT");
  RC=Value("ICLUI_TRACETO","STDERR","OS2ENVIRONMENT");
  RC=Value("ICLUI TRACE","ON","OS2ENVIRONMENT");
  RC=Value("ICLUI TRACETO","STDERR","OS2ENVIRONMENT");
  ToDevice="2>TRC.OUT";
End;
Else ToDevice="";

/* The following must be a string of 8 characters so that   */
/* it can be replaced with up to an 8 character string  */
debugCmd = "idbug   "
 
debugCmd " -r -Qconnect=wait -Qprotocol=appc a123" ToDevice;
Exit;

Help:
  Parse Source . . SPath .;
  I=LastPos("\",SPath);
  J=LastPos(".",SPath);
  Parse Value SubStr(SPath,I+1) With Cmd "." .;
  Say Cmd "- invoke the MVS debugger under APPC.  This exec MUST be executed under APPC";
  Say " ";
  Say "    Syntax:" Cmd "<drive:path>";
  Say " ";
  Say "    Where:  drive:path - is an optional path specification (including drive) which";
  Say "                         indicates the directory containing the debugger files";
  Say " ";
  Say "     Defaults: The default <drive:path> is the directory containing this command";
  Exit;
