/* ***************************************************************** */
/*                                                                   */
/* Licensed Materials - Property of IBM                              */
/* 5639-B92 (C) Copyright IBM Corp., 1996, 1997                      */
/* All rights reserved                                               */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                   */
/* ***************************************************************** */
/*--< Start of Specifications >--------------------------------------*/
/*                                                                   */
/* Program Name: ECFPARCC                                            */
/*                                                                   */
/* Descriptive Name:                                                 */
/*                                                                   */
/* Function:                                                         */
/*   REXX exec called by convert to parse the CCCA log files         */
/*                                                                   */
/* Input:                                                            */
/*                                                                   */
/*   Description: none                                               */
/*                                                                   */
/* Output:                                                           */
/*                                                                   */
/*   Description: none                                               */
/*                                                                   */
/* Normal Exit Conditions:                                           */
/*                                                                   */
/* Error Exit Conditions:                                            */
/*                                                                   */
/* Messages:                                                         */
/*                                                                   */
/* External References:                                              */
/*                                                                   */
/* Environment Variables:                                            */
/*                                                                   */
/*--< End of Specifications >----------------------------------------*/
/*                                                                   */
/* Change Activity                                                   */
/*                                                                   */
/*   03/14/97 jph  Copyright statement for release 4/97.             */
/*   11/15/97 jph  Add full path, (replace GetEnv).                  */
/*                                                                   */
/*--< End of specifications >----------------------------------------*/
/*trace ?i*/
  echo off
  rc = 0
  wpath=value("ECFWORK",,"OS2ENVIRONMENT")
  /* GetEnv by calling C DLL                    */
  /* envvar = "ECFWORK"
     call ECFGTENV envvar
     wpath = result        */	
  /* End GetEnv            */
  /* Set up file variables */
  cccatmp = wpath || "\ECFCCCA.TMP"
  cccaab1 = wpath || "\ECFCCCA.AB1"
  cccatm1 = wpath || "\ECFCCCA.TM1"
  cccaab2 = wpath || "\ECFCCCA.AB2"
  cccatm2 = wpath || "\ECFCCCA.TM2"
  cccaab3 = wpath || "\ECFCCCA.AB3"
  cccatm3 = wpath || "\ECFCCCA.TM3"
  cccaab4 = wpath || "\ECFCCCA.AB4"
  cccatm4 = wpath || "\ECFCCCA.TM4"
  cccaab5 = wpath || "\ECFCCCA.AB5"
  cccatm5 = wpath || "\ECFCCCA.TM5"
  cccaab6 = wpath || "\ECFCCCA.AB6"
  cccatm6 = wpath || "\ECFCCCA.TM6"

/***********************************************************************/
/* PARSE ECFCCCA.AB1 giving ECFCCCA.TM1                                */
/***********************************************************************/
  rc = stream(cccatmp, "c", "query exists")
  if rc \== "" then "erase " cccatmp
  /* Copy CCCAAB1 to CCCATMP, deleting blank lines */
  /* Make sure CCCAAB1 exists before entering the do-forever loop */
  rc = stream(cccaab1, "c", "query exists")
  if rc \== "" then do
    do forever
      aline = linein(cccaab1)
      if aline \== "" then call lineout cccatmp, aline
      if substr(aline,26,27) == "E N D    O F    R E P O R T" then leave
    end /* do forever */
  end /* end if */
  rc = stream(cccaab1,"c","close")
  rc = stream(cccatmp,"c","close")

  /* Parse CCCATMP, */
  /* inserting correct host character as character 1 */
  /* and writing result to CCCATM1 */
  /* Case #1 substr(aline, 26,27) == "E N D    O F    R E P O R T"   -> char = "-" */
  /* Case #2 substr(aline, 2, 8) == "5785-ABJ" and first line        -> char = " "
     Case #3 substr(aline, 2, 8) == "5785-ABJ" and not first line    -> char = "1"
     Case #4 substr(aline, 16,10) == ".........."                    -> char = "0"
     Case #5 line after case #4                                      -> char = "0"
     Case #6 substr(aline, 1, 1) == " " and not any of above         -> char = " "
     Case #7 substr(aline, 1, 1) == "-" and not any of above         -> char = " "
     Case #8 substr(aline, 1, 1) \== " " and not \=="-"              -> char = "0" */
  first = "true"
  rc = stream(cccatm1, "c", "query exists")
  if rc \== "" then "erase " cccatm1
  /* Make sure CCCATMP exists before entering the do-forever loop */
  rc = stream(cccatmp, "c", "query exists")
  if rc \== "" then do
      do forever
         aline = linein(cccatmp)
         /* say aline */
         if substr(aline,26,27) == "E N D    O F    R E P O R T" then /* Case #1 */
            do
               /* say "case 1" */
               char = "-"
               outline = char || aline
               call lineout cccatm1, outline
               leave
            end /* do */
         else
            do
               if substr(aline, 2, 8) == "5785-ABJ" then
                  do
                     if first = "true" then                           /* Case #2 */
                        do
                           /* say "case 2" */
                           char = " "
                           outline = char || aline
                           call lineout cccatm1, outline
                        end /* do */
                     else                                             /* Case #3 */
                        do
                           /* say "case 3" */
                           first = "false"
                           char = "1"
                           outline = char || aline
                           call lineout cccatm1, outline
                        end /* do */
                     /* end if */
                  end /* do */
               else
                  do
                     if substr(aline, 16, 10) == ".........." then    /* Case #4 */
                        do
                          /* say "case 4" */
                          char = "0"
                          outline = char || aline
                          call lineout cccatm1, outline
                          aline = linein(cccatmp)                     /* Case #5 */
                          /* say "case 5" */
                          char = "0"
                          outline = char || aline
                          call lineout cccatm1, outline
                        end /* do */
                     else
                        do
                           if substr(aline, 1, 1) == " " then         /* Case #6 */
                              do
                                 /* say "case 6" */
                                 char = " "
                                 outline = char || aline
                                 call lineout cccatm1, outline
                              end /* do */
                           else
                              do
                                 if substr(aline, 1, 1) == "-" then   /* Case #7 */
                                    do
                                       /* say "case 7" */
                                       char = " "
                                       outline = char || aline
                                       call lineout cccatm1, outline
                                    end /* do */
                                 else
                                    do
                                       /* say "case 8" */
                                       char = "0"                     /* Case #8 */
                                       outline = char || aline
                                       call lineout cccatm1, outline
                                    end /* do */
                                 /* end if */
                              end /* do */
                           /* end if */
                        end /* do */
                     /* end if */
                  end /* do */
               /* end if */
            end /* do */
         /* end if */
      end /* do forever */
  end /* end if */
  rc = stream(cccatmp,"c","close")
  rc = stream(cccatm1,"c","close")

/***********************************************************************/
/* PARSE ECFCCCA.AB2 giving ECFCCCA.TM2                                */
/***********************************************************************/
  rc = stream(cccatmp, "c", "query exists")
  if rc \== "" then "erase " cccatmp
  /* Copy CCCAAB2 to CCCATMP, deleting blank lines */
  /* Make sure CCCAAB2 exists before entering the do-forever loop */
  rc = stream(cccaab2, "c", "query exists")
  if rc \== "" then do
    do forever
      aline = linein(cccaab2)
      if aline \== "" then call lineout cccatmp, aline
      if substr(aline,26,27) == "E N D    O F    R E P O R T" then leave
    end /* do forever */
  end /* end if */
  rc = stream(cccaab2,"c","close")
  rc = stream(cccatmp,"c","close")

  /* Parse CCCATMP, */
  /* inserting correct host character as character 1 */
  /* and writing result to CCCATM2 */
  /* Case #1 substr(aline, 26,27) == "E N D    O F    R E P O R T"   -> char = "-" */
  /* Case #2 substr(aline, 2, 8) == "5785-ABJ" and first line        -> char = " "
     Case #3 substr(aline, 2, 8) == "5785-ABJ" and not first line    -> char = "1"
     Case #4 substr(aline, 7,10) == ".........."                     -> char = "0"
     Case #5 line after case #4                                      -> char = "0"
     Case #6 line after case #5                                      -> char = " "
d    Case #7 substr(aline, 8, 8) == "        "                       -> char = " "
d    Case #8 substr(aline, 8, 8) \== "        "                      -> char = "0" */
  first = "true"
  rc = stream(cccatm2, "c", "query exists")
  if rc \== "" then "erase " cccatm2
  /* Make sure CCCATMP exists before entering the do-forever loop */
  rc = stream(cccatmp, "c", "query exists")
  if rc \== "" then do
      do forever
         aline = linein(cccatmp)
         /* say aline */
         if substr(aline,26,27) == "E N D    O F    R E P O R T" then /* Case #1 */
            do
               /* say "case 1" */
               char = "-"
               outline = char || aline
               call lineout cccatm2, outline
               leave
            end /* do */
         else
            do
               if substr(aline, 2, 8) == "5785-ABJ" then
                  do
                     if first = "true" then                           /* Case #2 */
                        do
                           /* say "case 2" */
                           char = " "
                           outline = char || aline
                           call lineout cccatm2, outline
                        end /* do */
                     else                                             /* Case #3 */
                        do
                           /* say "case 3" */
                           first = "false"
                           char = "1"
                           outline = char || aline
                           call lineout cccatm2, outline
                        end /* do */
                     /* end if */
                  end /* do */
               else
                  do
                     if substr(aline, 7,10) == ".........."   then    /* Case #4 */
                        do
                          /*  say "case 4" */
                          char = "0"
                          outline = char || aline
                          call lineout cccatm2, outline
                          aline = linein(cccatmp)                     /* Case #5 */
                          /* say "case 5" */
                          char = "0"
                          outline = char || aline
                          call lineout cccatm2, outline
                          aline = linein(cccatmp)                     /* Case #6 */
                          /* say "case 6" */
                          char = " "
                          outline = char || aline
                          call lineout cccatm2, outline
                        end /* do */
                     else
                        do
                           if substr(aline, 8, 8) == "        " then  /* Case #7 */
                              do
                                 /* say "case 7" */
                                 char = " "
                                 outline = char || aline
                                 call lineout cccatm2, outline
                              end /* do */
                           else
                              do
                                 /* say "case 8" */
                                 char = "0"                     /* Case #8 */
                                 outline = char || aline
                                 call lineout cccatm2, outline
                              end /* do */
                           /* end if */
                        end /* do */
                     /* end if */
                  end /* do */
               /* end if */
            end /* do */
         /* end if */
      end /* do forever */
  end /* end if */
  rc = stream(cccatmp,"c","close")
  rc = stream(cccatm2,"c","close")

/***********************************************************************/
/* PARSE ECFCCCA.AB3 giving ECFCCCA.TM3                                */
/***********************************************************************/
  rc = stream(cccatmp, "c", "query exists")
  if rc \== "" then "erase " cccatmp
  /* Copy CCCAAB3 to CCCATMP, deleting blank lines */
  /* Make sure CCCAAB3 exists before entering the do-forever loop */
  rc = stream(cccaab3, "c", "query exists")
  if rc \== "" then do
    do forever
      aline = linein(cccaab3)
      if aline \== "" then call lineout cccatmp, aline
      if substr(aline,26,27) == "E N D    O F    R E P O R T" then leave
    end /* do forever */
  end /* end if */
  rc = stream(cccaab3,"c","close")
  rc = stream(cccatmp,"c","close")

  /* Parse CCCATMP, */
  /* inserting correct host character as character 1 */
  /* and writing result to CCCATM3 */
  /* Case #1 substr(aline, 26,27) == "E N D    O F    R E P O R T"   -> char = "-" */
  /* Case #2 substr(aline, 2, 8) == "5785-ABJ" and first line        -> char = " "
     Case #3 substr(aline, 2, 8) == "5785-ABJ" and not first line    -> char = "1"
     Case #4 substr(aline, 7,10) == ".........."                     -> char = "0"
     Case #5 line after case #4                                      -> char = "0"
     Case #6 line after case #5                                      -> char = " "
     Case #7 substr(aline, 8, 8) == "        "                       -> char = " "
     Case #8 substr(aline, 8, 8) \== "        "                      -> char = "0" */
  first = "true"
  rc = stream(cccatm3, "c", "query exists")
  if rc \== "" then "erase " cccatm3
  /* Make sure CCCATMP exists before entering the do-forever loop */
  rc = stream(cccatmp, "c", "query exists")
  if rc \== "" then do
      do forever
         aline = linein(cccatmp)
         /* say aline */
         if substr(aline,26,27) == "E N D    O F    R E P O R T" then /* Case #1 */
            do
               /* say "case 1" */
               char = "-"
               outline = char || aline
               call lineout cccatm3, outline
               leave
            end /* do */
         else
            do
               if substr(aline, 2, 8) == "5785-ABJ" then
                  do
                     if first = "true" then                           /* Case #2 */
                        do
                           /* say "case 2" */
                           char = " "
                           outline = char || aline
                           call lineout cccatm3, outline
                        end /* do */
                     else                                             /* Case #3 */
                        do
                           /* say "case 3" */
                           first = "false"
                           char = "1"
                           outline = char || aline
                           call lineout cccatm3, outline
                        end /* do */
                     /* end if */
                  end /* do */
               else
                  do
                     if substr(aline, 7,10) == ".........."   then    /* Case #4 */
                        do
                          /*  say "case 4" */
                          char = "0"
                          outline = char || aline
                          call lineout cccatm3, outline
                          aline = linein(cccatmp)                     /* Case #5 */
                          /* say "case 5" */
                          char = "0"
                          outline = char || aline
                          call lineout cccatm3, outline
                          aline = linein(cccatmp)                     /* Case #6 */
                          /* say "case 6" */
                          char = " "
                          outline = char || aline
                          call lineout cccatm3, outline
                        end /* do */
                     else
                        do
                           if substr(aline, 8, 8) == "        " then  /* Case #7 */
                              do
                                 /* say "case 7" */
                                 char = " "
                                 outline = char || aline
                                 call lineout cccatm3, outline
                              end /* do */
                           else
                              do
                                 /* say "case 8" */
                                 char = "0"                     /* Case #8 */
                                 outline = char || aline
                                 call lineout cccatm3, outline
                              end /* do */
                           /* end if */
                        end /* do */
                     /* end if */
                  end /* do */
               /* end if */
            end /* do */
         /* end if */
      end /* do forever */
  end /* end if */
  rc = stream(cccatmp,"c","close")
  rc = stream(cccatm3,"c","close")

/***********************************************************************/
/* PARSE ECFCCCA.AB4 giving ECFCCCA.TM4                                */
/***********************************************************************/
  rc = stream(cccatmp, "c", "query exists")
  if rc \== "" then "erase " cccatmp
  /* Copy CCCAAB4 to CCCATMP, deleting blank lines */
  /* Make sure CCCAAB4 exists before entering the do-forever loop */
  rc = stream(cccaab4, "c", "query exists")
  if rc \== "" then do
    do forever
      aline = linein(cccaab4)
      if aline \== "" then call lineout cccatmp, aline
      if substr(aline,26,27) == "E N D    O F    R E P O R T" then leave
    end /* do forever */
  end /* end if */
  rc = stream(cccaab4,"c","close")
  rc = stream(cccatmp,"c","close")

  /* Parse CCCATMP, */
  /* inserting correct host character as character 1 */
  /* and writing result to CCCATM4 */
  /* Case #1 substr(aline, 26,27) == "E N D    O F    R E P O R T"   -> char = "-" */
  /* Case #2 substr(aline, 2, 8) == "5785-ABJ" and first line        -> char = " "
     Case #3 substr(aline, 2, 8) == "5785-ABJ" and not first line    -> char = "1"
     Case #4 substr(aline, 7,10) == ".........."                     -> char = "0"
     Case #5 line after case #4                                      -> char = "0"
     Case #6 line after case #5                                      -> char = " "
     Case #7 substr(aline, 8, 8) == "        "                       -> char = " "
     Case #8 substr(aline, 8, 8) \== "        "                      -> char = "0" */
  first = "true"
  rc = stream(cccatm4, "c", "query exists")
  if rc \== "" then "erase " cccatm4
  /* Make sure CCCATMP exists before entering the do-forever loop */
  rc = stream(cccatmp, "c", "query exists")
  if rc \== "" then do
      do forever
         aline = linein(cccatmp)
         /* say aline */
         if substr(aline,26,27) == "E N D    O F    R E P O R T" then /* Case #1 */
            do
               /* say "case 1" */
               char = "-"
               outline = char || aline
               call lineout cccatm4, outline
               leave
            end /* do */
         else
            do
               if substr(aline, 2, 8) == "5785-ABJ" then
                  do
                     if first = "true" then                           /* Case #2 */
                        do
                           /* say "case 2" */
                           char = " "
                           outline = char || aline
                           call lineout cccatm4, outline
                        end /* do */
                     else                                             /* Case #3 */
                        do
                           /* say "case 3" */
                           first = "false"
                           char = "1"
                           outline = char || aline
                           call lineout cccatm4, outline
                        end /* do */
                     /* end if */
                  end /* do */
               else
                  do
                     if substr(aline, 7,10) == ".........."   then    /* Case #4 */
                        do
                          /*  say "case 4" */
                          char = "0"
                          outline = char || aline
                          call lineout cccatm4, outline
                          aline = linein(cccatmp)                     /* Case #5 */
                          /* say "case 5" */
                          char = "0"
                          outline = char || aline
                          call lineout cccatm4, outline
                          aline = linein(cccatmp)                     /* Case #6 */
                          /* say "case 6" */
                          char = " "
                          outline = char || aline
                          call lineout cccatm4, outline
                        end /* do */
                     else
                        do
                           if substr(aline, 8, 8) == "        " then  /* Case #7 */
                              do
                                 /* say "case 7" */
                                 char = " "
                                 outline = char || aline
                                 call lineout cccatm4, outline
                              end /* do */
                           else
                              do
                                 /* say "case 8" */
                                 char = "0"                     /* Case #8 */
                                 outline = char || aline
                                 call lineout cccatm4, outline
                              end /* do */
                           /* end if */
                        end /* do */
                     /* end if */
                  end /* do */
               /* end if */
            end /* do */
         /* end if */
      end /* do forever */
  end /* end if */
  rc = stream(cccatmp,"c","close")
  rc = stream(cccatm4,"c","close")

/***********************************************************************/
/* PARSE ECFCCCA.AB5 giving ECFCCCA.TM5                                */
/***********************************************************************/
  rc = stream(cccatmp, "c", "query exists")
  if rc \== "" then "erase " cccatmp
  /* Copy CCCAAB5 to CCCATMP, deleting blank lines */
  /* Make sure CCCAAB5 exists before entering the do-forever loop */
  rc = stream(cccaab5, "c", "query exists")
  if rc \== "" then do
    do forever
      aline = linein(cccaab5)
      if aline \== "" then call lineout cccatmp, aline
      if substr(aline,26,27) == "E N D    O F    R E P O R T" then leave
    end /* do forever */
  end /* end if */
  rc = stream(cccaab5,"c","close")
  rc = stream(cccatmp,"c","close")

  /* Parse CCCATMP, */
  /* inserting correct host character as character 1 */
  /* and writing result to CCCATM5 */
  /* Case #1 substr(aline, 26,27) == "E N D    O F    R E P O R T"   -> char = "-" */
  /* Case #2 substr(aline, 2, 8) == "5785-ABJ" and first line        -> char = " "
     Case #3 substr(aline, 2, 8) == "5785-ABJ" and not first line    -> char = "1"
     Case #4 substr(aline, 7,10) == ".........."                     -> char = "0"
     Case #5 line after case #4                                      -> char = "0"
     Case #6 line after case #5                                      -> char = " "
     Case #7 substr(aline, 8, 8) == "        "                       -> char = " "
     Case #8 substr(aline, 8, 8) \== "        "                      -> char = "0" */
  first = "true"
  rc = stream(cccatm5, "c", "query exists")
  if rc \== "" then "erase " cccatm5
  /* Make sure CCCATMP exists before entering the do-forever loop */
  rc = stream(cccatmp, "c", "query exists")
  if rc \== "" then do
       do forever
          aline = linein(cccatmp)
          /* say aline */
          if substr(aline,26,27) == "E N D    O F    R E P O R T" then /* Case #1 */
             do
                /* say "case 1" */
                char = "-"
                outline = char || aline
                call lineout cccatm5, outline
                leave
             end /* do */
          else
             do
                if substr(aline, 2, 8) == "5785-ABJ" then
                   do
                      if first = "true" then                           /* Case #2 */
                         do
                            /* say "case 2" */
                            char = " "
                            outline = char || aline
                            call lineout cccatm5, outline
                         end /* do */
                      else                                             /* Case #3 */
                         do
                            /* say "case 3" */
                            first = "false"
                            char = "1"
                            outline = char || aline
                            call lineout cccatm5, outline
                         end /* do */
                      /* end if */
                   end /* do */
                else
                   do
                      if substr(aline, 7,10) == ".........."   then    /* Case #4 */
                         do
                           /*  say "case 4" */
                           char = "0"
                           outline = char || aline
                           call lineout cccatm5, outline
                           aline = linein(cccatmp)                     /* Case #5 */
                           /* say "case 5" */
                           char = "0"
                           outline = char || aline
                           call lineout cccatm5, outline
                           aline = linein(cccatmp)                     /* Case #6 */
                           /* say "case 6" */
                           char = " "
                           outline = char || aline
                           call lineout cccatm5, outline
                         end /* do */
                      else
                         do
                            if substr(aline, 8, 8) == "        " then  /* Case #7 */
                               do
                                  /* say "case 7" */
                                  char = " "
                                  outline = char || aline
                                  call lineout cccatm5, outline
                               end /* do */
                            else
                               do
                                  /* say "case 8" */
                                  char = "0"                     /* Case #8 */
                                  outline = char || aline
                                  call lineout cccatm5, outline
                               end /* do */
                            /* end if */
                         end /* do */
                      /* end if */
                   end /* do */
                /* end if */
             end /* do */
          /* end if */
       end /* do forever */
  end /* end if */
  rc = stream(cccatmp,"c","close")
  rc = stream(cccatm5,"c","close")

/***********************************************************************/
/* PARSE ECFCCCA.AB6 giving ECFCCCA.TM6                                */
/***********************************************************************/
  rc = stream(cccatmp, "c", "query exists")
  if rc \== "" then "erase " cccatmp
  /* Copy CCCAAB6 to CCCATMP, deleting blank lines */
  /* Make sure CCCAAB6 exists before entering the do-forever loop */
  rc = stream(cccaab6, "c", "query exists")
  if rc \== "" then do
    do forever
      aline = linein(cccaab6)
      if aline \== "" then call lineout cccatmp, aline
      if substr(aline,26,27) == "E N D    O F    R E P O R T" then leave
    end /* do forever */
  end /* end if */
  rc = stream(cccaab6,"c","close")
  rc = stream(cccatmp,"c","close")

  /* Parse CCCATMP, */
  /* inserting correct host character as character 1 */
  /* and writing result to CCCATM6 */
  /* Case #1 substr(aline, 26,27) == "E N D    O F    R E P O R T"   -> char = "-" */
  /* Case #2 substr(aline, 2, 8) == "5785-ABJ" and first line        -> char = " "
     Case #3 substr(aline, 2, 8) == "5785-ABJ" and not first line    -> char = "1"
     Case #4 substr(aline, 7,10) == ".........."                     -> char = "0"
     Case #5 line after case #4                                      -> char = "0"
     Case #6 line after case #5                                      -> char = " "
     Case #7 substr(aline, 8, 8) == "        "                       -> char = " "
     Case #8 substr(aline, 8, 8) \== "        "                      -> char = "0" */
  first = "true"
  rc = stream(cccatm6, "c", "query exists")
  if rc \== "" then "erase " cccatm6
  /* Make sure CCCATMP exists before entering the do-forever loop */
  rc = stream(cccatmp, "c", "query exists")
  if rc \== "" then do
      do forever
         aline = linein(cccatmp)
         /* say aline */
         if substr(aline,26,27) == "E N D    O F    R E P O R T" then /* Case #1 */
            do
               /* say "case 1" */
               char = "-"
               outline = char || aline
               call lineout cccatm6, outline
               leave
            end /* do */
         else
            do
               if substr(aline, 2, 8) == "5785-ABJ" then
                  do
                     if first = "true" then                           /* Case #2 */
                        do
                           /* say "case 2" */
                           char = " "
                           outline = char || aline
                           call lineout cccatm6, outline
                        end /* do */
                     else                                             /* Case #3 */
                        do
                           /* say "case 3" */
                           first = "false"
                           char = "1"
                           outline = char || aline
                           call lineout cccatm6, outline
                        end /* do */
                     /* end if */
                  end /* do */
               else
                  do
                     if substr(aline, 7,10) == ".........."   then    /* Case #4 */
                        do
                          /*  say "case 4" */
                          char = "0"
                          outline = char || aline
                          call lineout cccatm6, outline
                          aline = linein(cccatmp)                     /* Case #5 */
                          /* say "case 5" */
                          char = "0"
                          outline = char || aline
                          call lineout cccatm6, outline
                          aline = linein(cccatmp)                     /* Case #6 */
                          /* say "case 6" */
                          char = " "
                          outline = char || aline
                          call lineout cccatm6, outline
                        end /* do */
                     else
                        do
                           if substr(aline, 8, 8) == "        " then  /* Case #7 */
                              do
                                 /* say "case 7" */
                                 char = " "
                                 outline = char || aline
                                 call lineout cccatm6, outline
                              end /* do */
                           else
                              do
                                 /* say "case 8" */
                                 char = "0"                     /* Case #8 */
                                 outline = char || aline
                                 call lineout cccatm6, outline
                              end /* do */
                           /* end if */
                        end /* do */
                     /* end if */
                  end /* do */
               /* end if */
            end /* do */
         /* end if */
      end /* do forever */
  end /* end if */
  rc = stream(cccatmp,"c","close")
  rc = stream(cccatm6,"c","close")
return "OK"
