/* Reinvoking as "REXX %0 %1 %2 %3 %4 %5 %6 %7 %8 %9"  2>nul
@goto runit */
/*********************************************************************/
/* Licensed Material - Property of IBM                               */
/* 5639-B92 , 5639-D65 (C) Copyright IBM Corp., 1997, 1998           */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*********************************************************************/
trace off;
signal on novalue;
parse source opsys . whoami rest;
/* cobolroot is now set by iwzmIR.CMD */
if opsys = 'OS/2' then
  do;
  env = 'OS2ENVIRONMENT';
  callit = '@Call';
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
  call SysLoadFuncs;
  end;
else
  do;
  env = 'ENVIRONMENT';
  callit = '@Rexx';
  end;
tempdir = value('TMP',,env);
tempout = SysTempFileName(tempdir'\TM?????.OUT');
tempout2 = SysTempFileName(tempdir'\T2?????.OUT');
xx = Get_MVSINFO();
if xx <> 0 then
  exit 16;
call Set_MVSINFO_Vars;
if tracemod = '*' |,
  wordpos(translate(substr(whoami,lastpos('\',whoami)+1)),tracemod) > 0 then
  do;
  if trace > 3 then trace results;
  if trace > 4 then trace ?;
  end;
parse arg the_input_args;
call traceit 1 'Entry' '!'the_input_args'!';
usedrive = '';
if tempdata <> '' then
  do;
  if numdrive > 0 then
    do;
    do ii = 1 to numdrive;
      if tempdata = drive.ii & trans.ii = 'text,crlf' then
        do;
        usedrive = drive.ii;
        temphqual = highqual.ii;
        leave;
        end;
      end;
    end;
  if usedrive = '' then
    do;
    call message 01;
    call traceit 1 'Error exit';
    exit 16;
    end;
  if pos('.',temphqual) > 0 then
    copydsn = "'"temphqual".@@TMPC@@.CLIST'";
  else
    copydsn = "'"temphqual".IWZ.@@TMPC@@.CLIST'";
  end;
else
  copydsn = "'"userid".IWZ.@@TMPC@@.CLIST'";
parse arg the_args;
if substr(the_args,1,1) = '-' then
  do;
  quiet = 'yes';
  the_args = substr(the_args,2);
  end;
else
  quiet = 'no';
parse upper var the_args fname disp typ clist parms;
if substr(fname,2,1) <> ':' | substr(fname,3,1) <> '\' then
  do;
  call message 02 fname;
  if disp = 'WIN' then
    '@pause';
  call traceit 1 'Error exit';
  exit 16;
  end;
blanks = '                         ';
blanks = blanks||blanks;
blanks = blanks||blanks;
fname2 = fname;
curdrive = substr(fname,1,2);
curdrive = translate(curdrive);
fname = substr(fname,4);
parse var fname lowquals '\' member;
lastdot = lastpos('.',lowquals);
lowqual = substr(lowquals,lastdot+1);
lowqual = translate(lowqual);
highqm = '';
if numdrive > 0 then
  do;
  do ii = 1 to numdrive;
    if curdrive = drive.ii & trans.ii = 'text,crlf' then
      do;
      highqm = highqual.ii
      mapping = mapping.ii;
      leave;
      end;
    end;
  end;
if highqm = '' then
  do;
  call message 03 fname2;
  call errexit;
  end;
if mapping = 'FILESYS' then
  do;
  parse upper var member fnm '.' fext;
  if fext <> '' then
    useext = fext;
  else
    useext = '?';
  end;
else
  do;
  useext = '?';
  if numtype > 0 then
    do;
    do ii = 1 to numtype;
      if lowqual = type.ii then
        useext = ext.ii;
      end;
    end;
  end;
if typ <> '*' then
  do;
  if useext <> typ then
    do;
    call message 04 fname2;
    if disp = 'WIN' then
      '@pause';
    call traceit 1 'Error exit';
    exit 16;
    end;
  end;
parse var member member '.' dummy;
dsn = '!'highqm'.'lowquals'('member')!';
dsn2 = translate(dsn,"'",'!');
if mvscomm <> 'YES' | (rexeccmd <> '' & rexeccmd <> '*') then
  do;
  if substr(clist,1,4) = 'IGYF' then
    clist = substr(clist,5);
  end;
if quiet = 'no' then
  do;
  call message 05 clist dsn2 parms;
  if mvscomm <> 'YES' | (rexeccmd <> '' & rexeccmd <> '*') then
    do;
    if header = 'YES' then
      thecmd = "EX '"sigyclst"(IGYFCMH)' '"clist dsn parms"'";
    else
      thecmd = "EX '"sigyclst"(IGYFCMD)' '"clist dsn parms"'";
    end;
  else
    do;
    if header = 'YES' then
      thecmd = "EX '"sigyclst"(IGYFTSOC)' '"clist dsn parms"'";
    else
      do;
      thecmd = clist dsn parms;
      thecmd = translate(thecmd,"'",'!');
      end;
    end;
  end;
else
  do;
  if mvscomm <> 'YES' | (rexeccmd <> '' & rexeccmd <> '*') then
    do;
    if header = 'YES' then
      thecmd = "EX '"sigyclst"(IGYFCMH)' '/"clist dsn parms"'";
    else
      thecmd = "EX '"sigyclst"(IGYFCMD)' '/"clist dsn parms"'";
    end;
  else
    do;
    if header = 'YES' then
      thecmd = "EX '"sigyclst"(IGYFTSOC)' '"clist dsn parms"'";
    else
      do;
      thecmd = clist dsn parms;
      thecmd = translate(thecmd,"'",'!');
      end;
    end;
  end;
if rexeccmd = '' | rexeccmd = '*' then
  do;
  if opsys = 'OS/2' then
    do;
    if mvscomm <> 'YES' then
      do;
      if filesys = 'NFS' then
        call iwzmsnd.cmd "@rexec -k -l"userid "-p"pwd system ,
          thecmd "}"tempout;
      else
        '@call iwzmsdu.cmd' thecmd ">"tempout;
      end;
    else
      do;
      if length(thecmd) > maxcmd then
        do;
        call iwzmccm.cmd thecmd;
        iwzmccm_rc = result;
        if iwzmccm_rc <> 0 then
          do;
          call traceit 1 'Error exit';
          exit iwzmccm_rc;
          end;
        thecmd = "EXEC" copydsn;
        end;
      call iwzmvws.cmd thecmd ">"tempout;
      end;
    end;
  else
    do;
    if mvscomm <> 'YES' then
      do;
      call iwzmsnd.cmd "@rsh" system "-l"userid"/"pwd ,
          thecmd "}"tempout;
      end;
    else
      do;
      if length(thecmd) > maxcmd then
        do;
        call iwzmccm.cmd thecmd;
        iwzmccm_rc = result;
        if iwzmccm_rc <> 0 then
          do;
          call traceit 1 'Error exit';
          exit iwzmccm_rc;
          end;
        thecmd = "EXEC" copydsn;
        end;
      call iwzmvws.cmd thecmd ">"tempout;
      end;
    end;
  end;
else
  do;
  if length(thecmd) > maxcmd then
    do;
    call iwzmccm.cmd thecmd;
    iwzmccm_rc = result;
    if iwzmccm_rc <> 0 then
      do;
      call traceit 1 'Error exit';
      exit iwzmccm_rc;
      end;
    thecmd = "EXEC" copydsn;
    end;
  call iwzmfsr.cmd 'REXECCMD' thecmd " }"tempout;
  end;
hex00 = '00'x;
hex05 = '05'x;
hex0c = '0c'x;
read_stem.0 = 0;
if header = 'YES' then
  foundhead = 'no';
else
  foundhead = 'yes';
xx = linein(tempout,1,0);
do forever;
  if lines(tempout) = 0 then
    leave;
  inline = linein(tempout);
  if foundhead = 'yes' then
    do;
    read_stem.0 = read_stem.0 + 1;
    nn = read_stem.0;
    read_stem.nn = inline;
    read_stem.nn = translate(read_stem.nn,'  ',hex00||hex05);
    end;
  else
    do;
    if inline =  '---------- Remote Edit/Compile/Debug ----------' then
      foundhead = 'yes';
    end;
  end;
xx = stream(tempout,'C','CLOSE');
'@erase' tempout;
if read_stem.0 > 0 then
  do;
  nn = read_stem.0;
  inline = read_stem.nn;
  if length(read_stem.nn) = 0 then
    read_stem.0 = read_stem.0 - 1;
  end;
firstout = 'yes';
if read_stem.0 > 0 then
  do;
  do oo = 1 to read_stem.0;
    output = read_stem.oo;
    if substr(output,1,length(blanks)) = blanks then
      output = strip(output,'B');
    else
      output = strip(output,'T');
    if substr(output,1,1) = hex0c then
      output = substr(output,2);
    outok = 'yes';
    if firstout = 'yes' & length(thecmd) > 128 & output <> '' then
      do;
      testout = strip(output,'L');
        testcmd = strip(thecmd,'T');
      lenout = length(testout);
      lenout = length(testcmd) - lenout + 1;
      teststr = substr(testcmd,lenout);
      if testout = teststr then
        outok = 'no'; /* extraneous output line */
      end;
    firstout = 'no';
    if outok = 'yes' then
      call sayit output;
    end;
  end;
if disp = 'WIN' then
  '@pause';
call traceit 1 'Normal exit';
exit 0;
/* */
errexit:
'@pause';
exit 16;
/* */
message:
parse arg iwz_message_num,
          iwz_message_arg1 '\\',
          iwz_message_arg2 '\\',
          iwz_message_arg3 '\\',
          iwz_message_arg4 '\\',
          iwz_message_arg5 '\\',
          iwz_message_arg6 '\\',
          iwz_message_arg7 '\\',
          iwz_message_arg8;
select;
  when language = 'ENG' then
    call message_eng;
  when language = 'JPN' then
    call message_jpn;
  otherwise
    call message_eng;
  end;
return;
/* */
message_eng:
select;
 
when iwz_message_num = 1 then do;
call sayit 'Cannot find drive for temporary data sets';
end;
 
when iwz_message_num = 2 then do;
call sayit 'Unknown filename format:' iwz_message_arg1;
end;
 
when iwz_message_num = 3 then do;
call sayit 'Cannot determine MVS high level qualifier for' iwz_message_arg1;
call sayit 'You may have specified a file on a non-MVS drive.';
end;
 
when iwz_message_num = 4 then do;
call sayit;
call sayit '***** Action not valid for this part:' iwz_message_arg1;
call sayit;
end;
 
when iwz_message_num = 5 then do;
call sayit "Will send to execute on" system":" iwz_message_arg1;
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
/* */
message_jpn:
call sayit 'Japanese message';
select;
 
when iwz_message_num = 1 then do;
call sayit 'Cannot find drive for temporary data sets';
end;
 
when iwz_message_num = 2 then do;
call sayit 'Unknown filename format:' iwz_message_arg1;
end;
 
when iwz_message_num = 3 then do;
call sayit 'Cannot determine MVS high level qualifier for' iwz_message_arg1;
call sayit 'You may have specified a file on a non-MVS drive.';
end;
 
when iwz_message_num = 4 then do;
call sayit;
call sayit '***** Action not valid for this part:' iwz_message_arg1;
call sayit;
end;
 
when iwz_message_num = 5 then do;
call sayit "Will send to execute on" system":" iwz_message_arg1;
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
Get_MVSINFO:
Procedure expose env cobolroot mvsinfo. whoami tempdir trace
 
rtn = 0
null = '0000'x
crlf = '0D0A'x
mvsinfo. = ''
mvsinfoQ = translate('iwzm_MVSINFO.DAT_YALE');
 
oldq = rxqueue('Set',mvsinfoQ)   /* switch to mvsinfo queue */
if queued() = 0 then do                   /* if Q is missing we'll */
  qname = rxqueue('Create',mvsinfoQ)      /* create it and put a bad */
  if qname = mvsinfoQ then push 'Sven'    /* timestamp on it, else */
  else x=rxqueue('Delete',qname)          /* it was in use (we hope) */
  end                                     /* so we'll assume we can */
parse pull mvsstuff; push mvsstuff        /* get/replace Q contents */
parse value mvsstuff with ts (null) . cobolroot (null) mvsstuff /* get */
                                        /* timestamp and cobolroot */
if ts <> 'Sven' then do;
  mvsinfo = cobolroot'\MACROS\MVSINFO.DAT'
  bad_mvsinfo = '    **' whoami '****'crlf'    **error*' mvsinfo,
                'is unavailable, missing or empty **'
 
  x=SysFileTree(mvsinfo,'ts','F')       /* get MVSINFO.DAT's timestamp */
  if ts.0 <> 1 then do
    say bad_mvsinfo
    return 12;
    end
  parse var ts.1 v0 v1 v2 .
  timestamp ='mvsinfo.dat.timestamp' v0 v1 v2
  end;
else
  timestamp = 'Yale'
if timestamp <> ts then do              /* timestamps match? */
  pull mvsstuff                         /* no, remove bad contents */
  rtn = "iwzmIR.CMD"()                /* ask for new stuff */
  if rtn = 0 then do
    parse pull mvsstuff; push mvsstuff    /* get/replace Q contents */
                                        /* remove timestamp and     */
                                        /* cobolroot                */
    parse value mvsstuff with . (null) . cobolroot ( null) mvsstuff
    end
  end
qname = rxqueue('Set',oldq)      /* restore normal queue */
 
do while (mvsstuff<>'') & (rtn=0)   /* mvsinfo. structure */
  parse value mvsstuff with key val (null) mvsstuff
  if mvsinfo.key = '' then do       /* e.g. mvsinfo.TYPE='' */
    mvsinfo.KEYS = mvsinfo.KEYS key /* no substitution for KEYS */
    mvsinfo.key.1 = val             /* e.g. mvsinfo.TYPE.1=val  */
    mvsinfo.key = 1                 /* e.g. mvsinfo.TYPE=1      */
    end
  else do
    x = mvsinfo.key + 1             /* e.g. mvsinfo.TYPE+1     */
    mvsinfo.key.x = val             /* e.g. mvsinfo.TYPE.2=val */
    mvsinfo.key = x                 /* e.g. mvsinfo.TYPE=2     */
    end
  end
 
return rtn
 
Set_MVSINFO_Vars:
 
 parse var mvsinfo.CLOSECMD.1 closecmd;
 parse var mvsinfo.CLOSEFILE.1 closefile;
 parse var mvsinfo.FILESYS.1 filesys accessmon testaccess;
 parse var mvsinfo.FSSTARTCMD.1 fsstartcmd;
 parse var mvsinfo.FSSTOPCMD.1 fsstopcmd;
 parse var mvsinfo.HEADER.1 header;
 parse var mvsinfo.JOBLOG.1 joblog;
 parse var mvsinfo.MAXCMD.1 maxcmd;
 parse var mvsinfo.LANGUAGE.1 language;
 parse var mvsinfo.MOUNTCMD.1 mountcmd;
 parse var mvsinfo.MVSCOMM.1 mvscomm;
 parse var mvsinfo.iwzmEDT.1 iwzmedt;
 parse var mvsinfo.NFS.1 nfs;
 parse var mvsinfo.NULLSTDIN.1 nullstdin;
 parse var mvsinfo.OUTSHOW.1 outshow;
 parse var mvsinfo.PROTSAVE.1 protsave tempmult;
 parse var mvsinfo.PWD.1 pwd pwdasis pwdt pwde;
 parse var mvsinfo.READTIMEOUT.1 readtimeout;
 parse var mvsinfo.REXECCMD.1 rexeccmd;
 parse var mvsinfo.SDU.1 sdu;
 parse var mvsinfo.SIGYCLST.1 sigyclst;
 parse var mvsinfo.SYSPROC.1 sysproc;
 parse var mvsinfo.SYSTEM.1 system;
 parse var mvsinfo.TEMPDRIVE.1 tempdrive;
 parse var mvsinfo.TEMPDATA.1 tempdata;
 parse var mvsinfo.TESTFILE.1 testfile;
 parse var mvsinfo.TRACE.1 trace tracekeep;
 parse var mvsinfo.TRACECMD.1 tracecmd;
 parse var mvsinfo.TRACEMOD.1 tracemod;
 parse var mvsinfo.UMOUNTCMD.1 umountcmd;
 parse var mvsinfo.USERID.1 userid;
 parse var mvsinfo.WORKSYS.1 worksys;
 parse var mvsinfo.WRITETIMEOUT.1 writetimeout;
 
 parse var mvsinfo.DRIVE numdrive;
 if numdrive = '' then
   numdrive = 0;
 do ii = 1 to numdrive;
   parse var mvsinfo.DRIVE.ii,
             drive.ii highqual.ii trans.ii mapping.ii sidefile.ii;
   end;
 
 parse var mvsinfo.TYPE numtype;
 if numtype = '' then
   numtype = 0;
 do ii = 1 to numtype;
   parse var mvsinfo.TYPE.ii type.ii ext.ii;
   end;
 
return
 
/* */
Traceit:
 parse arg iwz_trc_level iwz_trc_message;
 if iwz_trc_level > trace then
   return;
 if pwd <> '********' & pwd <> '++++++++' & pwd <> '========' then
   do;
   do forever;
     if pos(pwd,iwz_trc_message) = 0 then
       leave;
     parse var iwz_trc_message iwz_trc_message1 (pwd) iwz_trc_message2;
     iwz_trc_message = iwz_trc_message1||'********'||iwz_trc_message2
     end;
   end
 iwz_trc_message = date('O') time('L') whoami':' iwz_trc_message;
 xx = lineout(tempdir'\iwzmTRC.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
 if tracecmd <> '' then
   interpret tracecmd;
return;
 
/* */
sayit:
 parse arg iwz_sayit_arg;
 if trace > 2 then
   call traceit 3 '--->' iwz_sayit_arg;
 say iwz_sayit_arg;
return;
/*
:runit
@rexx %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
@rem */
