/* Reinvoking as "REXX %0 %1 %2 %3 %4 %5 %6 %7 %8 %9"  2>nul
@goto runit */
/*********************************************************************/
/* Licensed Material - Property of IBM                               */
/* 5639-B92 , 5639-D65 (C) Copyright IBM Corp., 1997, 1998           */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*********************************************************************/
trace off;
signal on novalue;
parse source opsys . whoami rest;
/* cobolroot is now set by iwzmIR.CMD */
if opsys = 'OS/2' then
  do;
  env = 'OS2ENVIRONMENT';
  callit = '@Call';
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
  call SysLoadFuncs;
  end;
else
  do;
  env = 'ENVIRONMENT';
  callit = '@Rexx';
  end;
tempdir = value('TMP',,env);
tempout = SysTempFileName(tempdir'\TM?????.OUT');
tempout2 = SysTempFileName(tempdir'\T2?????.OUT');
xx = Get_MVSINFO();
if xx <> 0 then
  exit 16;
call Set_MVSINFO_Vars;
if tracemod = '*' |,
  wordpos(translate(substr(whoami,lastpos('\',whoami)+1)),tracemod) > 0 then
  do;
  if trace > 3 then trace results;
  if trace > 4 then trace ?;
  end;
parse arg the_input_args;
call traceit 1 'Entry' '!'the_input_args'!';
pass = 1;
parse arg fparm ronly emsgmac '((' lpexmore; /*bp*/
if tempdata <> '' then
  do;
  tmpdrv = '';
  if numdrive > 0 then
    do;
    do ii = 1 to numdrive;
      if tempdata = drive.ii & trans.ii = 'text,crlf' then
        do;
        tmpdrv = drive.ii;
        temphqual = highqual.ii;
        temphlqo = '((temphlq='temphqual;
        leave;
        end;
      end;
    end;
  if tmpdrv = '' then
    do;
    call message 01;
    call errexit;
    end;
  end;
else
  temphlqo = '';
restart:
select;
  when substr(fparm,2,1) = ':' | pos('\',fparm) > 0 then
    nop;
  when substr(fparm,1,1) = "'" | pos('(',fparm) > 0 then
    do;
    if substr(fparm,1,1) = "'" then
      fparm = strip(fparm,'B',"'");
    else
      fparm = userid"."fparm;
    fparm = strip(fparm,'T',')');
    fparm = translate(fparm,'\','(');
    if tempdata <> '' then
      do;
      testqual = temphqual'.'
      testfparm = translate(fparm);
      if testqual = substr(testfparm,1,length(testqual)) then
        posh = length(testqual);
      else
        posh = pos('.',fparm);
      end;
    else
      posh = pos('.',fparm);
    if posh < 2 then
      do;
      call message 02;
      call errexit;
      end;
    posh = posh - 1;
    highq = substr(fparm,1,posh);
    highq = translate(highq);
    posh = posh + 2;
    fparmrest = substr(fparm,posh);
    fparmrest = translate(fparmrest);
    found = '';
    if numdrive > 0 then
      do;
      do ii = 1 to numdrive;
        if highq = highqual.ii & trans.ii = 'text,crlf' then
          do;
          if (pass = 1 & mapping.ii = 'LOCAL') | pass = 2 then
            do;
            found = drive.ii;
            foundmap = mapping.ii;
            leave;
            end;
          end;
        end;
      end;
    if found = '' then
      do;
      call message 03 translate(highq);
      call errexit;
      end;
    fparm = found'\'fparmrest;
    if pass = 2 & foundmap = 'FILESYS' then
      fparm = fparm||'*';
    end;
  otherwise
    nop;
  end;
if pass = 2 then
  signal lpex;
if substr(fparm,2,1) = ':' then
  curdrive = substr(fparm,1,2);
else
  do;
  curdrive = directory();
  curdrive = substr(curdrive,1,2);
  end;
  curdrive = translate(curdrive);
highqm = '';
if numdrive > 0 then
  do;
  do ii = 1 to numdrive;
    if curdrive = drive.ii & trans.ii = 'text,crlf' then
      do;
      highqm = highqual.ii
      mapping = mapping.ii;
      leave;
      end;
    end;
  end;
if highqm = '' then
  do;
  call message 04 fparm;
  call errexit;
  end;
curdirect = directory();
select;
  when substr(fparm,2,1) = ':' & substr(fparm,3,1) = '\' then
    fparmuse = fparm;
  when substr(fparm,2,1) = ':' & substr(fparm,3,1) <> '\' then
    do;
    usedrive = substr(fparm,1,2);
    newdirect = directory(usedrive);
    if length(newdirect) = 3 then
      fparmuse = newdirect||substr(fparm,3);
    else
      fparmuse = newdirect'\'substr(fparm,3);
    call directory curdirect;
    end;
  when substr(fparm,1,1) = '\' then
    fparmuse = substr(curdirect,1,2)||fparm;
  otherwise
    do;
    if length(curdirect) = 3 then
      fparmuse = curdirect||fparm;
    else
      fparmuse = curdirect'\'fparm;
    end
  end;
parse var fparmuse x1 '\' dsn '\' member;
if pass = 1 then
  membero = member;
dsnreal = dsn;
fparmdir = x1'\'dsnreal;
lastdot = lastpos('.',dsn);
lowqual = substr(dsn,lastdot+1);
lowqual = translate(lowqual);
if mapping = 'FILESYS' then
  do;
  doctype = '/ASIS';
  parse upper var membero fname '.' fext;
  if fext <> '' then
    do;
    useext = fext;
    doctype = '/DOCTYPE' translate(fext);
    end;
  else
    useext = '?';
  end;
else
  do;
  doctype = '/ASIS';
  useext = '?';
  if numtype > 0 then
    do;
    do ii = 1 to numtype;
      if lowqual = type.ii then
        do;
        doctype = '/DOCTYPE' ext.ii;
        useext = ext.ii;
        end;
      end;
    end;
  end;
dsn2 = translate(dsn);
parse upper var member fname '.' fext;
member2 = fname;
usedsn2 = "'"highqm"."dsn2"'";
if member <> '' then
  usedsn = "'"highqm"."dsn2"("member2")'";
else
  usedsn = "'"highqm"."dsn2"'";
if useext = 'LST' | useext = 'OBJ' | useext = 'EXE' |,
  useext = 'ADT' | useext = 'PPR' | useext = 'OUT' |,
  protsave = 'NO' then
  gettemp = 'NOTD';
else
  gettemp = 'TD';
if ronly <> 'RO' then
  do;
  call message 05 usedsn;
  call message 06;
  call traceit 2 'Before IGYFINFO';
  stackfile = tempout;
  if mvscomm = 'YES' then
    call iwzmvws.cmd 'IGYFINFO' usedsn gettemp tempmult temphlqo '>'stackfile;
  else
    call iwzmtso.cmd '!!??'stackfile'??+IGYFINFO' usedsn gettemp tempmult temphlqo;
  read_stem.0 = 0;
  xx = linein(stackfile,1,0);
  do forever;
    if lines(stackfile) = 0 then
      leave;
    read_stem.0 = read_stem.0 + 1;
    nn = read_stem.0;
    read_stem.nn = linein(stackfile);
    end;
  xx = stream(stackfile,'C','CLOSE');
  '@erase' stackfile;
  call traceit 2 'After IGYFINFO';
  if read_stem.0 < 1 then
    do;
    call message 07 fparm;
    call errexit;
    end;
  if mvscomm = 'YES' then
    xx=read_stem.1
  else
    xx = substr(read_stem.1,3);
  parse upper var xx rcode recfm lrecl dsorg seqnum alias badhex memexist tempdsn rest;
  if rcode <> 'OK' then
    do;
    call message 07 fparm;
    call errexit;
    end;
  if dsorg = 'PS' & member <> '' then
    do;
    call message 08;
    call errexit;
    end;
  if dsorg = 'PO' & member = '' then
    do;
    call message 09;
    call errexit;
    end;
  if substr(recfm,1,1) <> 'F' & substr(recfm,1,1) <> 'V' then
    do;
    call message 10 recfm;
    call errexit;
    end;
  if dsorg <> 'PS' & dsorg <> 'PO' then
    do;
    call message 11 dsorg;
    call errexit;
    end;
  if lrecl = '**' | lrecl = 0 then
    do;
    call message 12 lrecl;
    call errexit;
    end;
  if substr(recfm,1,1) = 'V' then
    do;
    if lrecl <= 4 then
      do;
      call message 13 lrecl;
      call errexit;
      end;
    textlim = lrecl - 4;
    end;
  else
    textlim = lrecl;
  if useext = 'LST' | useext = 'OBJ' | useext = 'EXE' |,
    useext = 'ADT' | useext = 'PPR' | useext = 'OUT' |,
    badhex <> 'NO' then
    readonly = 'ON';
  else
    readonly = 'OFF';
/*if numtype > 0 then
    do;
    do ii = 1 to numtype;
      if substr(type.ii,1,1) = '/' then
        do;
        if substr(type.ii,2) = '*' | substr(type.ii,2) = useext then
          do;
          if ext.ii = 'NOSEQ' then
            seqnum = 'NO';
          end;
        end;
      end;
    end; */
  iwzmmsg = 'MACRO iwzmMSG.LX' usedsn recfm lrecl dsorg seqnum alias badhex memexist useext tempdsn '!';
  if readonly = 'OFF' & member <> '' then
    do;
    if protsave = 'NO' then
      call message 14;
    end;
  if badhex <> 'NO' then
    do;
    fparm = badhex;
    pass = 2;
    signal restart;
    end;
  end;
lpex:
if ronly = 'RO' then
  do;
  editmac = 'SET READONLY ON!SET NOSAVE ON!';
  iwzmmsg = 'MSG File is read/only!';
  emsgmac = '';
  end;
else
  do;
  editmac = 'MACRO iwzmEDT.LX' recfm textlim readonly seqnum'!';
  /*bp - add macro for handling error feedback */
  if emsgmac <> '' then /*bp*/
    emsgmac = emsgmac'!'; /*bp*/
  end;
call message 15;
if opsys = 'OS/2' then
    call iwzmlxp.cmd fparm '/NOLOGO /CM MULT !'iwzmmsg||editmac||emsgmac doctype lpexmore; /*bp*/
else
    '@iwzmlxp' fparm '/NOLOGO /CM MULT !'iwzmmsg||editmac||emsgmac doctype lpexmore; /*bp*/
call traceit 1 'Normal exit';
exit 0;
/* */
errexit:
'@pause';
call traceit 1 'Error exit';
exit 16;
/* */
/* */
message:
parse arg iwz_message_num,
          iwz_message_arg1 '\\',
          iwz_message_arg2 '\\',
          iwz_message_arg3 '\\',
          iwz_message_arg4 '\\',
          iwz_message_arg5 '\\',
          iwz_message_arg6 '\\',
          iwz_message_arg7 '\\',
          iwz_message_arg8;
select;
  when language = 'ENG' then
    call message_eng;
  when language = 'JPN' then
    call message_jpn;
  otherwise
    call message_eng;
  end;
return;
/* */
message_eng:
select;
 
when iwz_message_num = 1 then do;
call sayit 'Cannot find drive for temporary data sets';
end;
 
when iwz_message_num = 2 then do;
call sayit 'Missing high level qualifier in data set name';
end;
 
when iwz_message_num = 3 then do;
call sayit 'Cannot find a text drive for high level qualifier' iwz_message_arg1;
end;
 
when iwz_message_num = 4 then do;
call sayit 'Cannot determine MVS high level qualifier for' iwz_message_arg1;
call sayit 'You may have specified a file on a non-MVS drive.';
end;
 
when iwz_message_num = 5 then do;
call sayit 'Accessing MVS data set' iwz_message_arg1;
end;
 
when iwz_message_num = 6 then do;
call sayit 'Accessing MVS to get data set/member information';
end;
 
when iwz_message_num = 7 then do;
call sayit 'Cannot determine data set information for' iwz_message_arg1;
end;
 
when iwz_message_num = 8 then do;
call sayit 'Member not allowed for a non-PDS';
end;
 
when iwz_message_num = 9 then do;
call sayit 'Member missing for a PDS';
end;
 
when iwz_message_num = 10 then do;
call sayit 'Unsupported RECFM' iwz_message_arg1;
end;
 
when iwz_message_num = 11 then do;
call sayit 'Unsupported DSORG' iwz_message_arg1;
end;
 
when iwz_message_num = 12 then do;
call sayit 'Unsupported LRECL' iwz_message_arg1;
end;
 
when iwz_message_num = 13 then do;
call sayit 'Invalid LRECL for variable records' iwz_message_arg1;
end;
 
when iwz_message_num = 14 then do;
call sayit;
call sayit 'The MVSINFO.DAT file specifies that editor saves will';
call sayit 'not use the protected save mechanism (protsave no).';
call sayit;
end;
 
when iwz_message_num = 15 then do;
call sayit 'Please wait for editor to initialize';
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
/* */
message_jpn:
call sayit 'Japanese message';
select;
 
when iwz_message_num = 1 then do;
call sayit 'Cannot find drive for temporary data sets';
end;
 
when iwz_message_num = 2 then do;
call sayit 'Missing high level qualifier in data set name';
end;
 
when iwz_message_num = 3 then do;
call sayit 'Cannot find a text drive for high level qualifier' iwz_message_arg1;
end;
 
when iwz_message_num = 4 then do;
call sayit 'Cannot determine MVS high level qualifier for' iwz_message_arg1;
call sayit 'You may have specified a file on a non-MVS drive.';
end;
 
when iwz_message_num = 5 then do;
call sayit 'Accessing MVS data set' iwz_message_arg1;
end;
 
when iwz_message_num = 6 then do;
call sayit 'Accessing MVS to get data set/member information';
end;
 
when iwz_message_num = 7 then do;
call sayit 'Cannot determine data set information for' fparm;
end;
 
when iwz_message_num = 8 then do;
call sayit 'Member not allowed for a non-PDS';
end;
 
when iwz_message_num = 9 then do;
call sayit 'Member missing for a PDS';
end;
 
when iwz_message_num = 10 then do;
call sayit 'Unsupported RECFM' iwz_message_arg1;
end;
 
when iwz_message_num = 11 then do;
call sayit 'Unsupported DSORG' iwz_message_arg1;
end;
 
when iwz_message_num = 12 then do;
call sayit 'Unsupported LRECL' iwz_message_arg1;
end;
 
when iwz_message_num = 13 then do;
call sayit 'Invalid LRECL for variable records' iwz_message_arg1;
end;
 
when iwz_message_num = 14 then do;
call sayit;
call sayit 'The MVSINFO.DAT file specifies that editor saves will';
call sayit 'not use the protected save mechanism (protsave no).';
call sayit;
end;
 
when iwz_message_num = 15 then do;
call sayit 'Please wait for editor to initialize';
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
Get_MVSINFO:
Procedure expose env cobolroot mvsinfo. whoami tempdir trace
 
rtn = 0
null = '0000'x
crlf = '0D0A'x
mvsinfo. = ''
mvsinfoQ = translate('iwzm_MVSINFO.DAT_YALE');
 
oldq = rxqueue('Set',mvsinfoQ)   /* switch to mvsinfo queue */
if queued() = 0 then do                   /* if Q is missing we'll */
  qname = rxqueue('Create',mvsinfoQ)      /* create it and put a bad */
  if qname = mvsinfoQ then push 'Sven'    /* timestamp on it, else */
  else x=rxqueue('Delete',qname)          /* it was in use (we hope) */
  end                                     /* so we'll assume we can */
parse pull mvsstuff; push mvsstuff        /* get/replace Q contents */
parse value mvsstuff with ts (null) . cobolroot (null) mvsstuff /* get */
                                        /* timestamp and cobolroot */
if ts <> 'Sven' then do;
  mvsinfo = cobolroot'\MACROS\MVSINFO.DAT'
  bad_mvsinfo = '    **' whoami '****'crlf'    **error*' mvsinfo,
                'is unavailable, missing or empty **'
 
  x=SysFileTree(mvsinfo,'ts','F')       /* get MVSINFO.DAT's timestamp */
  if ts.0 <> 1 then do
    say bad_mvsinfo
    return 12;
    end
  parse var ts.1 v0 v1 v2 .
  timestamp ='mvsinfo.dat.timestamp' v0 v1 v2
  end;
else
  timestamp = 'Yale'
if timestamp <> ts then do              /* timestamps match? */
  pull mvsstuff                         /* no, remove bad contents */
  rtn = "iwzmIR.CMD"()                /* ask for new stuff */
  if rtn = 0 then do
    parse pull mvsstuff; push mvsstuff    /* get/replace Q contents */
                                        /* remove timestamp and     */
                                        /* cobolroot                */
    parse value mvsstuff with . (null) . cobolroot ( null) mvsstuff
    end
  end
qname = rxqueue('Set',oldq)      /* restore normal queue */
 
do while (mvsstuff<>'') & (rtn=0)   /* mvsinfo. structure */
  parse value mvsstuff with key val (null) mvsstuff
  if mvsinfo.key = '' then do       /* e.g. mvsinfo.TYPE='' */
    mvsinfo.KEYS = mvsinfo.KEYS key /* no substitution for KEYS */
    mvsinfo.key.1 = val             /* e.g. mvsinfo.TYPE.1=val  */
    mvsinfo.key = 1                 /* e.g. mvsinfo.TYPE=1      */
    end
  else do
    x = mvsinfo.key + 1             /* e.g. mvsinfo.TYPE+1     */
    mvsinfo.key.x = val             /* e.g. mvsinfo.TYPE.2=val */
    mvsinfo.key = x                 /* e.g. mvsinfo.TYPE=2     */
    end
  end
 
return rtn
 
Set_MVSINFO_Vars:
 
 parse var mvsinfo.CLOSECMD.1 closecmd;
 parse var mvsinfo.CLOSEFILE.1 closefile;
 parse var mvsinfo.FILESYS.1 filesys accessmon testaccess;
 parse var mvsinfo.FSSTARTCMD.1 fsstartcmd;
 parse var mvsinfo.FSSTOPCMD.1 fsstopcmd;
 parse var mvsinfo.HEADER.1 header;
 parse var mvsinfo.JOBLOG.1 joblog;
 parse var mvsinfo.MAXCMD.1 maxcmd;
 parse var mvsinfo.LANGUAGE.1 language;
 parse var mvsinfo.MOUNTCMD.1 mountcmd;
 parse var mvsinfo.MVSCOMM.1 mvscomm;
 parse var mvsinfo.iwzmEDT.1 iwzmedt;
 parse var mvsinfo.NFS.1 nfs;
 parse var mvsinfo.NULLSTDIN.1 nullstdin;
 parse var mvsinfo.OUTSHOW.1 outshow;
 parse var mvsinfo.PROTSAVE.1 protsave tempmult;
 parse var mvsinfo.PWD.1 pwd pwdasis pwdt pwde;
 parse var mvsinfo.READTIMEOUT.1 readtimeout;
 parse var mvsinfo.REXECCMD.1 rexeccmd;
 parse var mvsinfo.SDU.1 sdu;
 parse var mvsinfo.SIGYCLST.1 sigyclst;
 parse var mvsinfo.SYSPROC.1 sysproc;
 parse var mvsinfo.SYSTEM.1 system;
 parse var mvsinfo.TEMPDRIVE.1 tempdrive;
 parse var mvsinfo.TEMPDATA.1 tempdata;
 parse var mvsinfo.TESTFILE.1 testfile;
 parse var mvsinfo.TRACE.1 trace tracekeep;
 parse var mvsinfo.TRACECMD.1 tracecmd;
 parse var mvsinfo.TRACEMOD.1 tracemod;
 parse var mvsinfo.UMOUNTCMD.1 umountcmd;
 parse var mvsinfo.USERID.1 userid;
 parse var mvsinfo.WORKSYS.1 worksys;
 parse var mvsinfo.WRITETIMEOUT.1 writetimeout;
 
 parse var mvsinfo.DRIVE numdrive;
 if numdrive = '' then
   numdrive = 0;
 do ii = 1 to numdrive;
   parse var mvsinfo.DRIVE.ii,
             drive.ii highqual.ii trans.ii mapping.ii sidefile.ii;
   end;
 
 parse var mvsinfo.TYPE numtype;
 if numtype = '' then
   numtype = 0;
 do ii = 1 to numtype;
   parse var mvsinfo.TYPE.ii type.ii ext.ii;
   end;
 
return
 
/* */
Traceit:
 parse arg iwz_trc_level iwz_trc_message;
 if iwz_trc_level > trace then
   return;
 if pwd <> '********' & pwd <> '++++++++' & pwd <> '========' then
   do;
   do forever;
     if pos(pwd,iwz_trc_message) = 0 then
       leave;
     parse var iwz_trc_message iwz_trc_message1 (pwd) iwz_trc_message2;
     iwz_trc_message = iwz_trc_message1||'********'||iwz_trc_message2
     end;
   end
 iwz_trc_message = date('O') time('L') whoami':' iwz_trc_message;
 xx = lineout(tempdir'\iwzmTRC.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
 if tracecmd <> '' then
   interpret tracecmd;
return;
 
/* */
sayit:
 parse arg iwz_sayit_arg;
 if trace > 2 then
   call traceit 3 '--->' iwz_sayit_arg;
 say iwz_sayit_arg;
return;
/*
:runit
@rexx %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
@rem */
