/* Reinvoking as "REXX %0 %1 %2 %3 %4 %5 %6 %7 %8 %9"  2>nul
@goto runit */
/*********************************************************************/
/* Licensed Material - Property of IBM                               */
/* 5639-B92 , 5639-D65 (C) Copyright IBM Corp., 1997, 1998           */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*********************************************************************/
trace off;
signal on novalue;
parse source opsys . whoami rest;
/* cobolroot is now set by iwzmIR.CMD */
if opsys = 'OS/2' then
  do;
  env = 'OS2ENVIRONMENT';
  callit = '@Call';
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
  call SysLoadFuncs;
  end;
else
  do;
  env = 'ENVIRONMENT';
  callit = '@Rexx';
  end;
tempdir = value('TMP',,env);
tempout = SysTempFileName(tempdir'\TM?????.OUT');
tempout2 = SysTempFileName(tempdir'\T2?????.OUT');
xx = Get_MVSINFO();
if xx <> 0 then
  exit 16;
call Set_MVSINFO_Vars;
if tracemod = '*' |,
  wordpos(translate(substr(whoami,lastpos('\',whoami)+1)),tracemod) > 0 then
  do;
  if trace > 3 then trace results;
  if trace > 4 then trace ?;
  end;
parse arg the_input_args;
call traceit 1 'Entry' '!'the_input_args'!';
parse var mvsinfo.USER1.1 user1;
parse var mvsinfo.USER2.1 user2;
parse var mvsinfo.USER3.1 user3;
parse var mvsinfo.USER4.1 user4;
parse upper arg request reqdata;
select;
  when request = 'CLOSECMD' then
    requestcmd = closecmd;
  when request = 'FSSTARTCMD' then
    requestcmd = fsstartcmd;
  when request = 'FSSTOPCMD' then
    requestcmd = fsstopcmd;
  when request = 'MOUNTCMD' then
    requestcmd = mountcmd;
  when request = 'REXECCMD' then
    requestcmd = rexeccmd;
  when request = 'UMOUNTCMD' then
    requestcmd = umountcmd;
  otherwise
    do;
    call message 01 request;
    call traceit 1 'Error exit';
    exit 16;
    end;
  end;
drivedata = reqdata;
iwzmtso = reqdata;
reqfound = 'no';
if request = 'MOUNTCMD' | request = 'UMOUNTCMD' then
  parse upper var drivedata drive highqual trans mapping sidefile;
if request = 'CLOSECMD' then
  parse upper var reqdata closetype closefile closetime rest;
if filesys = 'NFS' then
  do;
  timeout = '';
  if readtimeout <> '' & readtimeout > 0 then
    do;
    timeout = timeout',readtimeout('readtimeout')';
    timeout = timeout',attrtimeout('readtimeout')';
    end;
  if writetimeout <> '' & writetimeout > 0 then
    timeout = timeout',writetimeout('writetimeout')';
  end;
if request = 'MOUNTCMD' | request = 'UMOUNTCMD' then
  do;
  select;
    when mapping = 'LOCAL' then
      do;
      if filesys = 'NFS' then
        nfsmap = '';
      else
        sdumap = ''; /* SDU - this may have to change */
      end;
    when mapping = 'FILESYS' then
      do;
      if filesys = 'NFS' then
        do;
        if sidefile = '' then
          nfsmap = ',fileextmap';
        else
          nfsmap = ',fileextmap,sidefile('sidefile')';
        end;
      else
        do;
        /* TO BE DETERMINED */
        end;
      end;
    otherwise
      nfsmap = '';
    end;
  end;
pwdd = substr('********',1,length(pwd));
max_rc = 0;
requestcmdall = requestcmd;
do forever;
  if length(requestcmdall) = 0 then
    leave;
  parse var requestcmdall requestcmd '%%%%' requestcmdall;
  if length(requestcmd) > 0 then
    call execcmd;
  end;
if max_rc = 0 then
  call traceit 1 'Normal exit';
else
  call traceit 1 'Error exit';
exit max_rc;
/* */
execcmd:
thecmd = '';
thecmdd = '';
restcmd = requestcmd;
do forever;
  if length(restcmd) = 0 then
    leave;
  posrep = pos('&*',restcmd);
  if posrep = 0 then
    do;
    thecmd = thecmd||restcmd;
    thecmdd = thecmdd||restcmd;
    restcmd = '';
    end;
  else
    do;
    parse var restcmd rest1 '&*' symname '.' restcmd;
    select;
      when symbol(symname) = 'VAR' then
        do;
        symval = value(symname);
        if translate(symname) = 'PWD' then
          symvald = value('PWDD');
        else
          symvald = symval;
        end;
      when symbol(symname) = 'LIT' then
        do;
        call message 02 symname;
        symval = '';
        symvald = '';
        end;
      otherwise
        do;
        call message 03 symname;
        symval = '';
        symvald = '';
        end;
      end;
    thecmd = thecmd||rest1||symval;
    thecmdd = thecmdd||rest1||symvald;
    end;
  end;
thecmd = strip(thecmd,'B');
thecmdd = strip(thecmdd,'B');
if request = 'FSSTARTCMD' | request = 'FSSTOPCMD' |,
  request = 'MOUNTCMD' | request = 'UMOUNTCMD' then
    call sayit thecmdd;
if length(thecmd) > 0 then
  do;
  if substr(thecmd,1,1) <> '@' then
    thecmd = '@'thecmd;
  thecmd = translate(thecmd,'{}','<>');
  call iwzmsnd.cmd thecmd;
  request_rc = result;
  end;
else
  request_rc = 0;
if request_rc > max_rc then
  max_rc = request_rc;
return;
/* */
message:
parse arg iwz_message_num,
          iwz_message_arg1 '\\',
          iwz_message_arg2 '\\',
          iwz_message_arg3 '\\',
          iwz_message_arg4 '\\',
          iwz_message_arg5 '\\',
          iwz_message_arg6 '\\',
          iwz_message_arg7 '\\',
          iwz_message_arg8;
select;
  when language = 'ENG' then
    call message_eng;
  when language = 'JPN' then
    call message_jpn;
  otherwise
    call message_eng;
  end;
return;
/* */
message_eng:
select;
 
when iwz_message_num = 1 then do;
call sayit 'Invalid request' iwz_message_arg1;
end;
 
when iwz_message_num = 2 then do;
call sayit 'Symbol not assigned' iwz_message_arg1 ', null value assumed';
end;
 
when iwz_message_num = 3 then do;
call sayit 'Invalid symbol' iwz_message_arg1 ', null value assumed';
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
/* */
message_jpn:
call sayit 'Japanese message';
select;
 
when iwz_message_num = 1 then do;
call sayit 'Invalid request' iwz_message_arg1;
end;
 
when iwz_message_num = 2 then do;
call sayit 'Symbol not assigned' iwz_message_arg1 ', null value assumed';
end;
 
when iwz_message_num = 3 then do;
call sayit 'Invalid symbol' iwz_message_arg1 ', null value assumed';
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
Get_MVSINFO:
Procedure expose env cobolroot mvsinfo. whoami tempdir trace
 
rtn = 0
null = '0000'x
crlf = '0D0A'x
mvsinfo. = ''
mvsinfoQ = translate('iwzm_MVSINFO.DAT_YALE');
 
oldq = rxqueue('Set',mvsinfoQ)   /* switch to mvsinfo queue */
if queued() = 0 then do                   /* if Q is missing we'll */
  qname = rxqueue('Create',mvsinfoQ)      /* create it and put a bad */
  if qname = mvsinfoQ then push 'Sven'    /* timestamp on it, else */
  else x=rxqueue('Delete',qname)          /* it was in use (we hope) */
  end                                     /* so we'll assume we can */
parse pull mvsstuff; push mvsstuff        /* get/replace Q contents */
parse value mvsstuff with ts (null) . cobolroot (null) mvsstuff /* get */
                                        /* timestamp and cobolroot */
if ts <> 'Sven' then do;
  mvsinfo = cobolroot'\MACROS\MVSINFO.DAT'
  bad_mvsinfo = '    **' whoami '****'crlf'    **error*' mvsinfo,
                'is unavailable, missing or empty **'
 
  x=SysFileTree(mvsinfo,'ts','F')       /* get MVSINFO.DAT's timestamp */
  if ts.0 <> 1 then do
    say bad_mvsinfo
    return 12;
    end
  parse var ts.1 v0 v1 v2 .
  timestamp ='mvsinfo.dat.timestamp' v0 v1 v2
  end;
else
  timestamp = 'Yale'
if timestamp <> ts then do              /* timestamps match? */
  pull mvsstuff                         /* no, remove bad contents */
  rtn = "iwzmIR.CMD"()                /* ask for new stuff */
  if rtn = 0 then do
    parse pull mvsstuff; push mvsstuff    /* get/replace Q contents */
                                        /* remove timestamp and     */
                                        /* cobolroot                */
    parse value mvsstuff with . (null) . cobolroot ( null) mvsstuff
    end
  end
qname = rxqueue('Set',oldq)      /* restore normal queue */
 
do while (mvsstuff<>'') & (rtn=0)   /* mvsinfo. structure */
  parse value mvsstuff with key val (null) mvsstuff
  if mvsinfo.key = '' then do       /* e.g. mvsinfo.TYPE='' */
    mvsinfo.KEYS = mvsinfo.KEYS key /* no substitution for KEYS */
    mvsinfo.key.1 = val             /* e.g. mvsinfo.TYPE.1=val  */
    mvsinfo.key = 1                 /* e.g. mvsinfo.TYPE=1      */
    end
  else do
    x = mvsinfo.key + 1             /* e.g. mvsinfo.TYPE+1     */
    mvsinfo.key.x = val             /* e.g. mvsinfo.TYPE.2=val */
    mvsinfo.key = x                 /* e.g. mvsinfo.TYPE=2     */
    end
  end
 
return rtn
 
Set_MVSINFO_Vars:
 
 parse var mvsinfo.CLOSECMD.1 closecmd;
 parse var mvsinfo.CLOSEFILE.1 closefile;
 parse var mvsinfo.FILESYS.1 filesys accessmon testaccess;
 parse var mvsinfo.FSSTARTCMD.1 fsstartcmd;
 parse var mvsinfo.FSSTOPCMD.1 fsstopcmd;
 parse var mvsinfo.HEADER.1 header;
 parse var mvsinfo.JOBLOG.1 joblog;
 parse var mvsinfo.MAXCMD.1 maxcmd;
 parse var mvsinfo.LANGUAGE.1 language;
 parse var mvsinfo.MOUNTCMD.1 mountcmd;
 parse var mvsinfo.MVSCOMM.1 mvscomm;
 parse var mvsinfo.iwzmEDT.1 iwzmedt;
 parse var mvsinfo.NFS.1 nfs;
 parse var mvsinfo.NULLSTDIN.1 nullstdin;
 parse var mvsinfo.OUTSHOW.1 outshow;
 parse var mvsinfo.PROTSAVE.1 protsave tempmult;
 parse var mvsinfo.PWD.1 pwd pwdasis pwdt pwde;
 parse var mvsinfo.READTIMEOUT.1 readtimeout;
 parse var mvsinfo.REXECCMD.1 rexeccmd;
 parse var mvsinfo.SDU.1 sdu;
 parse var mvsinfo.SIGYCLST.1 sigyclst;
 parse var mvsinfo.SYSPROC.1 sysproc;
 parse var mvsinfo.SYSTEM.1 system;
 parse var mvsinfo.TEMPDRIVE.1 tempdrive;
 parse var mvsinfo.TEMPDATA.1 tempdata;
 parse var mvsinfo.TESTFILE.1 testfile;
 parse var mvsinfo.TRACE.1 trace tracekeep;
 parse var mvsinfo.TRACECMD.1 tracecmd;
 parse var mvsinfo.TRACEMOD.1 tracemod;
 parse var mvsinfo.UMOUNTCMD.1 umountcmd;
 parse var mvsinfo.USERID.1 userid;
 parse var mvsinfo.WORKSYS.1 worksys;
 parse var mvsinfo.WRITETIMEOUT.1 writetimeout;
 
 parse var mvsinfo.DRIVE numdrive;
 if numdrive = '' then
   numdrive = 0;
 do ii = 1 to numdrive;
   parse var mvsinfo.DRIVE.ii,
             drive.ii highqual.ii trans.ii mapping.ii sidefile.ii;
   end;
 
 parse var mvsinfo.TYPE numtype;
 if numtype = '' then
   numtype = 0;
 do ii = 1 to numtype;
   parse var mvsinfo.TYPE.ii type.ii ext.ii;
   end;
 
return
 
/* */
Traceit:
 parse arg iwz_trc_level iwz_trc_message;
 if iwz_trc_level > trace then
   return;
 if pwd <> '********' & pwd <> '++++++++' & pwd <> '========' then
   do;
   do forever;
     if pos(pwd,iwz_trc_message) = 0 then
       leave;
     parse var iwz_trc_message iwz_trc_message1 (pwd) iwz_trc_message2;
     iwz_trc_message = iwz_trc_message1||'********'||iwz_trc_message2
     end;
   end
 iwz_trc_message = date('O') time('L') whoami':' iwz_trc_message;
 xx = lineout(tempdir'\iwzmTRC.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
 if tracecmd <> '' then
   interpret tracecmd;
return;
 
/* */
sayit:
 parse arg iwz_sayit_arg;
 if trace > 2 then
   call traceit 3 '--->' iwz_sayit_arg;
 say iwz_sayit_arg;
return;
/*
:runit
@rexx %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
@rem */
