/* REXX */
 
 /**********************************************************************
  Licensed Material - Property of IBM
  5639-B92 , 5639-D65 (C) Copyright IBM Corp., 1997
  (C) Copyright IBM Corp. 1997.  All rights reserved
  US Government Users Restricted Rights - Use, duplication or
  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 **********************************************************************/
 
signal on novalue
Parse source opsys . whoami .
if opsys = 'OS/2' then do
  env='OS2ENVIRONMENT'
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
  call SysLoadFuncs
  end
else do
  env='ENVIRONMENT'
  end
tempdir = value('TMP',,env);
 
mvsinfo. = ''
mvsinfoQ = translate('iwzm_MVSINFO.DAT_YALE');
rtn = 0                       /* our return code */
null = '0000'x
crlf = '0D0A'x
rt = 'iwzmrt';
func = 'RVAR';
if opsys = 'OS/2' then
  do;
  select;
    when 'iwzm' = 'iwzm' then
      envvar = 'ICOBDIR';
    when 'iwzm' = 'ibmm' then
      envvar = 'IPLIDIR';
    otherwise
      do;
      envvar = 'ICOBDIR';
      call oops 0 'Unexpected product prefix iwzm, COBOL asssumed';
      end;
    end;
  end;
else
  do;
  select;
    when 'iwzm' = 'iwzm' then
      envvar = 'COBOLMAIN';
    when 'iwzm' = 'ibmm' then
      envvar = 'IBMPLI';
    otherwise
      do;
      envvar = 'COBOLMAIN';
      call oops 0 'Unexpected product prefix iwzm, COBOL asssumed';
      end;
    end;
  end;
rc = RxFuncAdd(func,rt,func);
cobolroot = RVAR(envvar);
rc = RxFuncDrop(func);
if substr(cobolroot,2,2) <> ':\' then
  do;
  say 'Cannot determine product root directory';
  x = rxqueue('Delete',mvsinfoQ)
  return 18;
  end;
 
mvsinfo = cobolroot'\MACROS\MVSINFO.DAT'  /* path+name */
bad_mvsinfo = '    **' whoami '****'crlf'    **error*' mvsinfo,
              'is unavailable, missing or empty **'
bad_key =  '    **' whoami '**'crlf,
           '   **warning* unknown keyword:'
 
mixedcase_keys =,    /* values for these keys will not be upshifted */
  'CLOSECMD'    ,
  'FSSTARTCMD'  ,
  'FSSTOPCMD'   ,
  'MOUNTCMD'    ,
  'PWD'         ,
  'REXECCMD'    ,
  'TRACECMD'    ,
  'UMOUNTCMD'   ,
  'USER1'       ,
  'USER2'       ,
  'USER3'       ,
  'USER4'       ,
  'WIZARD'
 
uppercase_keys =,    /* values for these keys will be upshifted */
  'CLOSEFILE'   ,
  'DRIVE'       ,
  'FILESYS'     ,
  'HEADER'      ,
  'JOBLOG'      ,
  'MAXCMD'      ,
  'MVSCOMM'     ,
  'iwzmEDT'     ,
  'NFS'         ,
  'NULLSTDIN'   ,
  'OUTSHOW'     ,
  'PROTSAVE'    ,
  'READTIMEOUT' ,
  'SDU'         ,
  'SIGYCLST'    ,
  'SYSPROC'     ,
  'SYSTEM'      ,
  'TEMPDRIVE'   ,
  'TEMPDATA'    ,
  'TESTFILE'    ,
  'TRACE'       ,
  'TRACEMOD'    ,
  'TYPE'        ,
  'USERID'      ,
  'WORKSYS'     ,
  'WRITETIMEOUT'
 
/* determine language for messages */
 
lang = value('LANG',,env);
lang = translate(lang);
select;
  when lang = 'EN_US' then
    language = 'ENG';
  when lang = 'JA_JP' then
    language = 'JPN';
  otherwise
    do;
    call oops 0 'US English assumed for messages';
    language = 'ENG';
    end;
  end;
 
if lines(mvsinfo) > 0 then do               /* looks like it's there */
  x=SysFileTree(mvsinfo,'ts','F')           /* get timestamp */
  if ts.0 <> 1 then rtn=18       /* oops */
  parse var ts.1 v0 v1 v2 .
  stuff='mvsinfo.dat.timestamp' v0 v1 v2||null      /* set timestamp */
  call addstuff 'COBOLROOT' cobolroot;
  call addstuff 'LANGUAGE' language;
  end
else
  call oops 28 badmvsinfo
 
do while (lines(mvsinfo)>0)&(rtn<5)               /* read the file */
  x=linein(mvsinfo)
  if substr(x,1,1) <> '*' then do       /* it's not a comment line */
    parse var x key val
    if key <> '' then do                     /* and it's not blank */
      key=translate(key)                            /* upshift key */
      val=strip(val,'B')
      if (wordpos(key,uppercase_keys)>0) then val=translate(val)
      else if (wordpos(key,mixedcase_keys)=0) then do
        say bad_key key
        if mvsinfo.key = '' then          /* e.g. mvsinfo.TYPE='' */
          mvsinfo.KEYS = mvsinfo.KEYS key /* no substitution for KEYS */
        end
      if mvsinfo.key = '' then do       /* e.g. mvsinfo.TYPE='' */
        mvsinfo.key.1 = val             /* e.g. mvsinfo.TYPE.1=val  */
        mvsinfo.key = 1                 /* e.g. mvsinfo.TYPE=1      */
        end
      else do
        x = mvsinfo.key + 1             /* e.g. mvsinfo.TYPE+1     */
        mvsinfo.key.x = val             /* e.g. mvsinfo.TYPE.2=val */
        mvsinfo.key = x                 /* e.g. mvsinfo.TYPE=2     */
        end
      end
    end
  end
x=stream(mvsinfo,'C','CLOSE')
 
keywords= mixedcase_keys uppercase_keys mvsinfo.KEYS
do while words(keywords)>0 & rtn<5
  parse var keywords keyw keywords
  call checkem keyw                 /* validate what we got */
  signal OFF SYNTAX
  end
if rtn=0 then do
  oldq = rxqueue('Set',mvsinfoQ)   /* switch to mvsinfo queue */
  push stuff
  qname = rxqueue('Set',oldq)
  end
else x = rxqueue('Delete',mvsinfoQ)
if tracex > 2 then
  do;
  xx = SysFileDelete(tempdir'\iwzmTRX.TRC');
  trace = tracex;
  tracemod = tracemodx;
  tracecmd = tracecmdx;
  pwd = pwdx;
  stuffx = stuff;
  do while stuffx <> '';
    parse var stuffx valuex (null) stuffx;
    call traceit 3 valuex;
    end;
  end;
 
return rtn
 
 
addstuff:        /* ---------- addstuff ------------ */
  parse arg morestuff
  stuff = stuff||morestuff||null
  return
 
 
oops:            /* ---------- oops ---------------- */
parse arg xrc string
if xrc>=rtn then do
  say '****' whoami':'
  say '****   mvsinfo.dat,' string '****'
  rtn=xrc
  end
return
 
/* */
Traceit:
 parse arg iwz_trc_level iwz_trc_message;
 if iwz_trc_level > trace then
   return;
 if pwd <> '********' & pwd <> '++++++++' & pwd <> '========' then
   do;
   do forever;
     if pos(pwd,iwz_trc_message) = 0 then
       leave;
     parse var iwz_trc_message iwz_trc_message1 (pwd) iwz_trc_message2;
     iwz_trc_message = iwz_trc_message1||'********'||iwz_trc_message2
     end;
   end
 iwz_trc_message = date('O') time('L') whoami':' iwz_trc_message;
 xx = lineout(tempdir'\iwzmTRC.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
 xx = lineout(tempdir'\iwzmTRX.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRX.TRC','C','CLOSE');
 if tracecmd <> '' then
   interpret tracecmd;
return;
 
checkem:        /* ---------- checkem -------------- */
 
parse arg keyw .
parse var mvsinfo.keyw.1 val
signal ON SYNTAX NAME iwz_otherwise
signal value 'IWZ_'keyw
 
iwz_DRIVE:                                            /* DRIVE */
  if mvsinfo.DRIVE = '' then do
    call oops 0 "no DRIVE defined"
    return
    end
  do i = 1 to mvsinfo.DRIVE
    parse var mvsinfo.DRIVE.i a2 a3 a4 a5 a999
    if a2='' | a3='' then do
      say 'DRIVE letter and/or high level qualifier missing'
      return 4
      end
    if length(a3) > 17 then do
      say 'High level qualifier too long'
      return 4
      end
    if a4<>'TEXT' & a4<>'BINARY' & a4 <>'' then do
      say 'invalid text/binary specification for DRIVE' a2
      return 4
      end
    if a4='BINARY' then a4='binary'
    if a4='TEXT' | a4='' then a4='text,crlf'
    if a5<>'LOCAL' & a5<>'FILESYS' & a5 <>'' then do
      say 'Invalid name mapping specification for DRIVE' a2
      return 4
      end
    if a5='' then a5='LOCAL'
    call addstuff keyw a2 a3 a4 a5 a999
    end /* do */
return
 
iwz_FILESYS:                                          /* FILESYS */
  if mvsinfo.FILESYS = '' then do
    call oops 4 "FILESYS not specified"
    return
    end
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  parse var val filesysx .
  if filesysx = '' then do
    call oops 4 "FILESYS file system not specified"
    return
    end
  if filesysx<>"NFS" & filesysx<>"SDU" then do
    call oops 4 'FILESYS, invalid file system'
    return
    end
  if opsys <> 'OS/2' & filesysx='SDU' then do
    call oops 4 'FILESYS SDU only supported on OS/2'
    return
    end
  call addstuff keyw val
return
 
iwz_HEADER:                                           /* HEADER */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if val='' then val = 'YES'
  call addstuff keyw val
return
 
iwz_MAXCMD:                                           /* MAXCMD */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if val='' then val = 9999
  if val<72 then call oops 4 "MAXCMD less than 72 not supported"
  if word(mvsinfo.FILESYS.1,1)='SDU' & val>90 then val=90
  call addstuff keyw val
return
 
iwz_MVSCOMM:                                          /* MVSCOMM */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if word(mvsinfo.FILESYS.1,1)='SDU' then val='NO'
  call addstuff keyw val
return
 
iwz_NFS:                                              /* NFS */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if val<>'' & substr(val,1,1)<>',' then val=','||val
  if mvsinfo.NFS<>'' then call addstuff keyw val
return
 
iwz_PROTSAVE:                                         /* PROTSAVE */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  parse var val a2 a3 .
  if a2 = '' then a2 = 'YES'
  if a3 = '' then a3 = 1
  call addstuff keyw a2 a3
return
 
iwz_PWD:                                              /* PWD */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if val = '' then
    val = '======== 1';
  if word(val,1) = '********' & word(val,3) = '' then
    call oops 4 "PWD encrypted password missing"
  else
    do;
    tn = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    tt = tn;
    tt = tt||tt;
    parse var val a2 a3 a4 .;
    a2u = translate(a2);
    if a3 = '' then
      a3 = 2;
    tt = substr(tt,a3,36);
    a2 = translate(a2u,tn,tt);
    pwdx = a2;
    call addstuff keyw a2 a2u a3 a4;
    end;
return
 
iwz_READTIMEOUT:                                      /* READTIMEOUT */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  deftim=10
  if mvsinfo.READTIMEOUT = '' | val='' then do
    call oops 0 'defaulting READTIMEOUT to' deftim
    val = deftim
    end
  call addstuff keyw val
return
 
iwz_SDU:                                              /* SDU */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if val<>'' & substr(val,1,1)<>',' then  val=','||val
  if mvsinfo.SDU<>'' then call addstuff keyw val
return
 
iwz_SIGYCLST:                                         /* SIGYCLST */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if mvsinfo.SIGYCLST = '' then
    call oops 4 'SIGYCLST not specified'
  else
    call addstuff keyw val
return
 
iwz_SYSPROC:                                          /* SYSPROC */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if mvsinfo.SYSPROC = '' then
    call oops 4 'SYSPROC not specified'
  else
    call addstuff keyw val
return
 
iwz_SYSTEM:                                           /* SYSTEM */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if mvsinfo.SYSTEM = '' then
    call oops 4  'SYSTEM not specified'
  else
    call addstuff keyw val
return
 
iwz_TRACE:                                            /* TRACE */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if val = '' then val = 0;
  parse var val tracex tracekeepx .;
  call addstuff keyw val
return;
 
iwz_TRACECMD:                                         /* TRACECMD */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if val = '*' then
    val = "signal off novalue;if iwz_trc_message = 'IWZ_TRC_MESSAGE' then iwz_trc_message = message;do forever;call iwzmtrc.cmd tracemod'\'whoami iwz_trc_message;if result = '' then leave;interpret result;end;signal on novalue";
  tracecmdx = val;
  call addstuff keyw val
return;
 
iwz_TRACEMOD:                                         /* TRACEMOD */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  tracemodx = val;
  call addstuff keyw val
return;
 
iwz_TYPE:                                             /* TYPE */
  do i=1 to mvsinfo.TYPE
    parse var mvsinfo.TYPE.i val
    if words(val) < 2 then
      call oops 4 'TYPE and/or extension missing'
    else if words(val) > 2 then
      call oops 4 'TYPE too many arguments (should be two)'
    else
      call addstuff keyw val
    end
return
 
iwz_USERID:                                           /* USERID */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if mvsinfo.USERID = '' then
    call oops 4  'USERID not specified'
  else
    call addstuff keyw val
return
 
iwz_WRITETIMEOUT:                                     /* WRITETIMEOUT */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  deftim=10
  if mvsinfo.WRITETIMEOUT = '' then do
    call oops 0 'defaulting WRITETIMEOUT to' deftim
    val=deftim
    end
  call addstuff keyw val
return
 
iwz_WORKSYS:                                          /* WORKSYS */
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if mvsinfo.WORKSYS = '' then
    call oops 4 'WORKSYS not specified'
  else
    call addstuff keyw val
return
 
iwz_otherwise:                                        /* otherwise */
  Signal OFF SYNTAX
  if mvsinfo.keyw > 1 then
    call oops 0 keyw "specified more than once, using first occurrence"
  if mvsinfo.keyw<>'' then call addstuff keyw val
return
/*** end ***               ----- checkem -----                      */
 
