/* REXX */
trace off;
signal on novalue;
parse upper arg tracemod '\' whoami .;
parse arg . '\' . tracemsg;
if /* tracemod = 'TRACEMOD' | */ tracemod = '*' |,
  wordpos(translate(substr(whoami,lastpos('\',whoami)+1)),tracemod) > 0 then
  nop;
else
  return '';
parse source opsys rest;
if opsys = 'OS/2' then
  do;
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
  call SysLoadFuncs;
  end;
if length(tracemsg) > 2048 then
  tracemsg = substr(tracemsg,1,2048);
tracemsg = translate(tracemsg,'_____','?"'||'0a0d1a'x);
if pos('.LX',whoami) > 0 then
  macro = 'yes';
else
  macro = 'no';
if macro = 'yes' then
  do;
  qname = '*';
  'macro iwzmtrc.lx "'qname tracemsg'"';
  end;
else
  do;
  qname = RxQueue('Create');
  lpexcmds = 'macro iwzmtrc.lx "'qname tracemsg'"';
  if opsys = 'OS/2' then
    address cmd '@start /c /min /i iwzmlxp.cmd "M:\Remote ECD Trace" /NOLOGO /CM' lpexcmds;
  else
    address cmd '@start /min /i @iwzmlxp "M:\Remote ECD Trace" /NOLOGO /CM' lpexcmds;
  oldq = RxQueue('Set',qname);
  reply = linein('QUEUE:');
  xx = RxQueue('Set',oldq);
  xx = RxQueue('Delete',qname);
  end;
return reply;
