/* Reinvoking as "REXX %0 %1 %2 %3 %4 %5 %6 %7 %8 %9"  2>nul
@goto runit */
/*********************************************************************/
/* Licensed Material - Property of IBM                               */
/* 5639-B92 , 5639-D65 (C) Copyright IBM Corp., 1997, 1998           */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*********************************************************************/
trace off;
signal on novalue;
parse source opsys . whoami rest;
/* cobolroot is now set by iwzmIR.CMD */
if opsys = 'OS/2' then
  do;
  env = 'OS2ENVIRONMENT';
  callit = '@Call';
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
  call SysLoadFuncs;
  end;
else
  do;
  env = 'ENVIRONMENT';
  callit = '@Rexx';
  end;
tempdir = value('TMP',,env);
tempout = SysTempFileName(tempdir'\TM?????.OUT');
tempout2 = SysTempFileName(tempdir'\T2?????.OUT');
xx = Get_MVSINFO();
if xx <> 0 then
  exit 16;
call Set_MVSINFO_Vars;
if tracemod = '*' |,
  wordpos(translate(substr(whoami,lastpos('\',whoami)+1)),tracemod) > 0 then
  do;
  if trace > 3 then trace results;
  if trace > 4 then trace ?;
  end;
parse arg the_input_args;
call traceit 1 'Entry' '!'the_input_args'!';
 
/*- REXX --------------------------------------------------------
 *
 *  Name:  iwzmVSR
 *
 *  Description:
 *
 *    Workstation based EXEC that initiates the MVS based server
 *    process via IGYFINIT.
 *
 *  Function:
 *    - Gets this workstation's IP address.
 *    - Invokes IGYFINIT on the MVS host via RSH.
 *    - Receives IGYFSERV's IP address, Port and token.
 *    - Builds external data queue.
 *    - Pushes IGYFSERV's IP address, Port and token on the queue
 *      for use by IGYVWS.
 *
 *  Operation:
 *
 *    - Parameters:
 *      1. Line command parameters are used, in their entirety,
 *         for invoking RSH.
 *
 *         Example:  iwzmVSR phxn2 -lis914/mypw7
 *
 *       Note: If no parameters are passed iwzmVSR will get the
 *             required info from MVSINFO.DAT.
 *
 *  Return Codes:
 *    0 - The IGYFSERV server was started successfully on MVS.
 *    8 - IGYFSERV start failed.
 *   12 - The external data queue already existed.  IGYFSERV start
 *        was not attempted.
 *
 *  Security:
 *    - Uses the normal userid/password security put in place by RSH.
 *
 *  Installation:
 *    - Should be executed during the "Connect MVS Drives" process.
 *
 *  Changes:
 *    JCH 970326 Added exit if IWZRECDQ queue exists.
 *    JCH 970326 Closed mvsinfo in Read_MVSInfo_Dat.
 *    JCH 970326 Prefixed iwzmSND command with 'REXX' - NT only.
 *    JCH 970325 Added basic Start/Stop logging.
 *    JCH 970325 Delete OUTTRAP only if no errors are found.
 *    JCH 970325 Replaced PARSE LOWER with translate
 *
 *  What it doesn't do yet:
 *    - Does not handle (expired) password change.
 *    - The MVSINFO.DAT routines require the keywords in
 *      MVSINFO.DAT to be in lower case.
 *
 *----------------------------------------------------------------*/
 
 
/*------------------------------------------------------------------
 * Initialization
 *------------------------------------------------------------------*/
 
IWZQName = translate('iwzmRECD_HSC');
tm=1
trc=1
OK=1
CR='0D'x
LF='0A'x
B4='B4'x
numPush=5
msgnum=0
ExitError = 8
ExitQFound = 12
 
/*------------------------------------------------------------------
 * Log Start Attempt
 *------------------------------------------------------------------*/
Call traceit 3 'Starting';
 
/*------------------------------------------------------------------
 * Create external data queue
 *------------------------------------------------------------------*/
QName = RXQueue('Create',IWZQName)
if QName<>IWZQName then
  do
    x = RXQueue('Delete',QName)
    Call sayit "Data queue '"IWZQName"' already exists"
    Say "Data queue '"IWZQName"' already exists"
    exit ExitQFound
  end
 
/*------------------------------------------------------------------
 * Parse passed arguments
 *------------------------------------------------------------------*/
parse arg RSHParms
 
if RSHParms='-?' | RSHParms = '?' | RSHParms = '/?' then
  do
    Call sayit "Use the 'iwzmVSR' to start IGYFSERV on an MVS host."
    Call sayit " "
    Call sayit "Usage: iwzmVSR <REXEC/RSH parameters>"
    Exit ExitError
  end
 
/*------------------------------------------------------------------
 * If no RSH parms are passed, build parm string
 *------------------------------------------------------------------*/
if RSHParms='' then
  if opsys='OS/2' then RSHParms = "REXEC" system "-k -l"userid" -p"pwd
  else RSHParms = "RSH" system "-l"userid"/"pwd
else
  if opsys='OS/2' then RSHParms = "REXEC" RSHParms
  else RSHParms = "RSH" RSHParms
 
/*------------------------------------------------------------------
 * Register the Rexx TCP/IP functions if not already registered
 *------------------------------------------------------------------*/
if RxFuncQuery("SockLoadFuncs") then
  do
    rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
    if rc<>0 then
      do
        Call sayit "RxFuncAdd() Failed, RC="rc
        Exit ExitError
      end
     SockLoadFuncs()    /* SockLoadFuncs always gives a null return */
  end
 
/*---------------------------------------------------------------
 * Get this workstations IP host ID
 *---------------------------------------------------------------*/
wsip  = SockGetHostId()
Call sayit "Workstation IP="wsip
if wsip = -1 then
  do
    Call sayit "Error during SockGetHostId:" errno
    Exit ExitError
  end
 
iwzmtso = "ex '"sigyclst"(IGYFINIT)' '"wsip"'"
 
 
if tm | trc then x=time('r')
 
call iwzmsnd.cmd "@"RshParms iwzmtso  "}"tempout
 
if tm | trc then Call sayit "Total time:" time('r')
 
filechars = charin(tempout,1,chars(tempout))
x=lineout(tempout)
filechars = translate(filechars,LF,B4)
 
/*---------------------------------------------------------------
 * Echo RSH output excluding first 2 lines
 *---------------------------------------------------------------*/
l2pos=1
do 2
  l2=pos(CR,filechars,l2pos)
  l2pos=l2+1
end
if l2=0 then l2=1
if trc then Call sayit substr(filechars,l2)
 
call ChkCmd
if OK then 'erase' tempout
 
if OK then
  do
    OldQName = RXQueue('Set',IWZQName)
 
    do numPush
      Push  ':IP:' ipaddr port token 'AT' date('s') time()
    end
  end
else
  do
    Call sayit 'IGYFINIT initiation failed'
    x = RXQueue('Delete',IWZQName)
  end
 
slmsg = date('s') time('l')
if OK then
  do
    slmsg = slmsg "Start successful"
  end
else
  do
    slmsg = slmsg "Start failed"
  end
 
Call sayit slmsg;
 
if OK then Call traceit 1 'Normal exit';
else Call traceit 1 'Error exit';
if OK then exit 0
else Exit ExitError
 
/*---------------------------------------------------------------
 * Handle message returned from IGYFINIT
 *---------------------------------------------------------------*/
ChkCmd:
 
  np=pos(":IP:",filechars)
  if np<>0 then
    do
      ep = pos(CR,filechars,np)
      if ep=0 then ep=length(filechars)
      else ep=ep-1
      PMsg = substr(filechars,np,ep-np+1)
      parse var PMsg msgid msgrc rest
      if msgrc=0 then
        do
          parse var rest ipaddr port token .
        end
      else
        do
          Call sayit "IGYFINIT failed:" msgrc rest
          OK=0
        end
    end
  else
    do
      ok=0
      np=pos(":ERR:",filechars)
      if np<>0 then
        do
          ep = pos(CR,filechars,np)
          if ep=0 then ep=length(filechars)
          else ep=ep-1
          error_msg = substr(filechars,np,ep-np+1)
        end
      else
        do
          error_msg=''
        end
      Call sayit "IGYFINIT failed:" error_msg
    end
 
return
 
/*------------------------------------------------------------------
 * Get_Keyword_Value procedure
 *
 * Description:  This routines takes a passed keyword and looks
 *   for it and it's associated parameters in the MVSINFO.DAT.
 *
 * Return:  Returns the keyword and it's associated values or
 *   "NOT FOUND" if the keyword is not present in MVSINFO.DAT.
 *
 * Example:
 *   call Get_Keyword_Value "pwd"  ===>   result: 'pwd abcdef'
 *
 *------------------------------------------------------------------*/
Get_Keyword_Value:
  Parse upper arg keyword .
 
  /* Convert the keyword to lower case */
/*keyword=translate(keyword,xrange('a','z'),xrange('A','Z')) */
 
  LF='0A'x
  CR='0D'x
  tkw = keyword || ' '
  kwline="NOT FOUND"
 
  lfc = length(filechars)
 
  cp=1
  do forever
    np = pos(keyword,filecharsu,cp)
    if np<>0 then
      do
        cmdline=1
        /* See if line is a comment line */
        if np>1 then
          do c = np-1 to 1 by -1
            if substr(filechars,c,1)<>' ' then
              do
                if substr(filechars,c,1)=LF then leave
                if substr(filechars,c,1)=CR then leave
                cmdline=0
                leave
              end
          end
 
        if cmdline then
          do
            ep = pos(CR,filechars,np)
            if ep=0 then ep=lfc
            else ep=ep-1
            str = substr(filechars,np,ep-np+1)
            kwline=str
            leave
          end
        if np+1 > lfc then leave
        else cp=np+1
        iterate
      end
    else  /* keyword not found */
      do
        kwline="NOT FOUND"
        leave
      end
  end
 
 
return kwline
 
Read_MVSInfo_Dat:
  parse source opsys rest;
  rt = 'iwzmrt';
  if opsys = 'OS/2' then
    do;
    env = 'OS2ENVIRONMENT';
    envvar = 'ICOBDIR';
    xx = value(envvar,,env);
    if xx = '' then
      envvar = 'IPLIDIR';
    end;
  else
    do;
    env = 'ENVIRONMENT';
    envvar = 'COBOLMAIN';
    xx = value(envvar,,env);
    if xx = '' then
      envvar = 'IBMPLI';
    end;
  rc = RxFuncDrop(rt);
  rc = RxFuncAdd(rt,rt,rt);
  cobolroot = iwzmrt(envvar);
  rc = RxFuncDrop(rt);
  if substr(cobolroot,2,2) <> ':\' then
    do;
    say 'Cannot determine product root directory';
    return 18;
    end;
 
  mvsinfo = cobolroot'\MACROS\MVSINFO.DAT';
 
  filechars = charin(mvsinfo,1,chars(mvsinfo))
  if filechars='' then
    do
      Call sayit "Unable to read" filein
      return ExitError
    end
 
  x=stream(mvsinfo,'C','CLOSE')
  filecharsu = translate(filechars)
return 0
Get_MVSINFO:
Procedure expose env cobolroot mvsinfo. whoami tempdir trace
 
rtn = 0
null = '0000'x
crlf = '0D0A'x
mvsinfo. = ''
mvsinfoQ = translate('iwzm_MVSINFO.DAT_YALE');
 
oldq = rxqueue('Set',mvsinfoQ)   /* switch to mvsinfo queue */
if queued() = 0 then do                   /* if Q is missing we'll */
  qname = rxqueue('Create',mvsinfoQ)      /* create it and put a bad */
  if qname = mvsinfoQ then push 'Sven'    /* timestamp on it, else */
  else x=rxqueue('Delete',qname)          /* it was in use (we hope) */
  end                                     /* so we'll assume we can */
parse pull mvsstuff; push mvsstuff        /* get/replace Q contents */
parse value mvsstuff with ts (null) . cobolroot (null) mvsstuff /* get */
                                        /* timestamp and cobolroot */
if ts <> 'Sven' then do;
  mvsinfo = cobolroot'\MACROS\MVSINFO.DAT'
  bad_mvsinfo = '    **' whoami '****'crlf'    **error*' mvsinfo,
                'is unavailable, missing or empty **'
 
  x=SysFileTree(mvsinfo,'ts','F')       /* get MVSINFO.DAT's timestamp */
  if ts.0 <> 1 then do
    say bad_mvsinfo
    return 12;
    end
  parse var ts.1 v0 v1 v2 .
  timestamp ='mvsinfo.dat.timestamp' v0 v1 v2
  end;
else
  timestamp = 'Yale'
if timestamp <> ts then do              /* timestamps match? */
  pull mvsstuff                         /* no, remove bad contents */
  rtn = "iwzmIR.CMD"()                /* ask for new stuff */
  if rtn = 0 then do
    parse pull mvsstuff; push mvsstuff    /* get/replace Q contents */
                                        /* remove timestamp and     */
                                        /* cobolroot                */
    parse value mvsstuff with . (null) . cobolroot ( null) mvsstuff
    end
  end
qname = rxqueue('Set',oldq)      /* restore normal queue */
 
do while (mvsstuff<>'') & (rtn=0)   /* mvsinfo. structure */
  parse value mvsstuff with key val (null) mvsstuff
  if mvsinfo.key = '' then do       /* e.g. mvsinfo.TYPE='' */
    mvsinfo.KEYS = mvsinfo.KEYS key /* no substitution for KEYS */
    mvsinfo.key.1 = val             /* e.g. mvsinfo.TYPE.1=val  */
    mvsinfo.key = 1                 /* e.g. mvsinfo.TYPE=1      */
    end
  else do
    x = mvsinfo.key + 1             /* e.g. mvsinfo.TYPE+1     */
    mvsinfo.key.x = val             /* e.g. mvsinfo.TYPE.2=val */
    mvsinfo.key = x                 /* e.g. mvsinfo.TYPE=2     */
    end
  end
 
return rtn
 
Set_MVSINFO_Vars:
 
 parse var mvsinfo.CLOSECMD.1 closecmd;
 parse var mvsinfo.CLOSEFILE.1 closefile;
 parse var mvsinfo.FILESYS.1 filesys accessmon testaccess;
 parse var mvsinfo.FSSTARTCMD.1 fsstartcmd;
 parse var mvsinfo.FSSTOPCMD.1 fsstopcmd;
 parse var mvsinfo.HEADER.1 header;
 parse var mvsinfo.JOBLOG.1 joblog;
 parse var mvsinfo.MAXCMD.1 maxcmd;
 parse var mvsinfo.LANGUAGE.1 language;
 parse var mvsinfo.MOUNTCMD.1 mountcmd;
 parse var mvsinfo.MVSCOMM.1 mvscomm;
 parse var mvsinfo.iwzmEDT.1 iwzmedt;
 parse var mvsinfo.NFS.1 nfs;
 parse var mvsinfo.NULLSTDIN.1 nullstdin;
 parse var mvsinfo.OUTSHOW.1 outshow;
 parse var mvsinfo.PROTSAVE.1 protsave tempmult;
 parse var mvsinfo.PWD.1 pwd pwdasis pwdt pwde;
 parse var mvsinfo.READTIMEOUT.1 readtimeout;
 parse var mvsinfo.REXECCMD.1 rexeccmd;
 parse var mvsinfo.SDU.1 sdu;
 parse var mvsinfo.SIGYCLST.1 sigyclst;
 parse var mvsinfo.SYSPROC.1 sysproc;
 parse var mvsinfo.SYSTEM.1 system;
 parse var mvsinfo.TEMPDRIVE.1 tempdrive;
 parse var mvsinfo.TEMPDATA.1 tempdata;
 parse var mvsinfo.TESTFILE.1 testfile;
 parse var mvsinfo.TRACE.1 trace tracekeep;
 parse var mvsinfo.TRACECMD.1 tracecmd;
 parse var mvsinfo.TRACEMOD.1 tracemod;
 parse var mvsinfo.UMOUNTCMD.1 umountcmd;
 parse var mvsinfo.USERID.1 userid;
 parse var mvsinfo.WORKSYS.1 worksys;
 parse var mvsinfo.WRITETIMEOUT.1 writetimeout;
 
 parse var mvsinfo.DRIVE numdrive;
 if numdrive = '' then
   numdrive = 0;
 do ii = 1 to numdrive;
   parse var mvsinfo.DRIVE.ii,
             drive.ii highqual.ii trans.ii mapping.ii sidefile.ii;
   end;
 
 parse var mvsinfo.TYPE numtype;
 if numtype = '' then
   numtype = 0;
 do ii = 1 to numtype;
   parse var mvsinfo.TYPE.ii type.ii ext.ii;
   end;
 
return
 
/* */
Traceit:
 parse arg iwz_trc_level iwz_trc_message;
 if iwz_trc_level > trace then
   return;
 if pwd <> '********' & pwd <> '++++++++' & pwd <> '========' then
   do;
   do forever;
     if pos(pwd,iwz_trc_message) = 0 then
       leave;
     parse var iwz_trc_message iwz_trc_message1 (pwd) iwz_trc_message2;
     iwz_trc_message = iwz_trc_message1||'********'||iwz_trc_message2
     end;
   end
 iwz_trc_message = date('O') time('L') whoami':' iwz_trc_message;
 xx = lineout(tempdir'\iwzmTRC.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
 if tracecmd <> '' then
   interpret tracecmd;
return;
 
/* */
sayit:
 parse arg iwz_sayit_arg;
 if trace > 2 then
   call traceit 3 '--->' iwz_sayit_arg;
 say iwz_sayit_arg;
return;
/*
:runit
@rexx %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
@rem */
