/* Reinvoking as "REXX %0 %1 %2 %3 %4 %5 %6 %7 %8 %9"  2>nul
@goto runit */
/*********************************************************************/
/* Licensed Material - Property of IBM                               */
/* 5639-B92 , 5639-D65 (C) Copyright IBM Corp., 1997, 1998           */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*********************************************************************/
trace off;
signal on novalue;
parse source opsys . whoami rest;
/* cobolroot is now set by iwzmIR.CMD */
if opsys = 'OS/2' then
  do;
  env = 'OS2ENVIRONMENT';
  callit = '@Call';
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
  call SysLoadFuncs;
  end;
else
  do;
  env = 'ENVIRONMENT';
  callit = '@Rexx';
  end;
tempdir = value('TMP',,env);
tempout = SysTempFileName(tempdir'\TM?????.OUT');
tempout2 = SysTempFileName(tempdir'\T2?????.OUT');
xx = Get_MVSINFO();
if xx <> 0 then
  exit 16;
call Set_MVSINFO_Vars;
if tracemod = '*' |,
  wordpos(translate(substr(whoami,lastpos('\',whoami)+1)),tracemod) > 0 then
  do;
  if trace > 3 then trace results;
  if trace > 4 then trace ?;
  end;
parse arg the_input_args;
call traceit 1 'Entry' '!'the_input_args'!';
/*- REXX --------------------------------------------------------
 
Licensed Material - Property of IBM
IBM VisualAge for COBOL :  5639-B92
(C) Copyright IBM Corp. 1995, 1997.  All rights reserved
US Government Users Restricted Rights - Use, duplication or disclosure
restricted by GSA ADP Schedule Contract with IBM Corp.
 
 *
 *  Name:  iwzmVWS
 *
 *  Description:
 *
 *    Workstation based EXEC that sends TSO commands to the
 *    MVS based server IGYFSERV.
 *
 *  Function:
 *    - Get connection information from Rexx queue.
 *    - Establish socket connection to IGYFSERV.
 *    - Send TSO command.
 *    - Receive output.
 *    - Send output to STDOUT.
 *    - Retry the above process if no queue is found or
 *      if the socket connection is refused.
 *
 *  Operation:
 *
 *    - Parameters:
 *      1. TSO command to be sent to IGYFSERV.
 *
 *  Return codes:
 *    0 - Command was sent to host, executed and output was
 *        received.
 *    8 - An error occured attempting to execute TSO command.
 *
 *
 *  Security:
 *    - IGYFSERV verifies the client's IP address and token.
 *      This ensures that the request is coming from the same
 *      IP host (this workstation) that originally started the
 *      server.
 *
 *  Installation:
 *    - Use this in place of REXEC and RSH.
 *
 *  Changes:
 *    JCH 970325 Added :ERR: to no command found message.
 *    JCH 970325 Changed call to iwzmVSR to work from OS/2.
 *    JCH 970325 Added send of token to IGYFSERV for validation.
 *
 *  What it doesn't do yet:
 *    - Check the validity of stuff pulled from data queue.
 *
 *----------------------------------------------------------------*/
 
/*------------------------------------------------------------------
 * Initialization
 *------------------------------------------------------------------*/
 
EOT='00'x    /* End of transmission indicator */
TRC=0
tm=0
MaxRC=0
IWZQName = translate('iwzmRECD_HSC');
MaxRetries = 1
ReqRestart = 5000
ExitError = 8
CloseSock = 0
msgnum=0
outfile=''
 
 
PARSE ARG SendMsg                     /* okay see what we got */
SendMsg = translate(SendMsg,'>','}');
parse value Sendmsg with Sendmsg '>' outfile .
if outfile<>'' then xx=sysfiledelete(outfile)
if SendMsg='' | SendMsg = '?' then
  do
    call sayit ":ERR: No TSO command was passed."
    call sayit "Usage: iwzmVWS <tso command>"
    call traceit 1 'Error exit';
    exit ExitError
  end
 
if tm then x=time('r')
 
/*------------------------------------------------------------------
 * Execute Main logic and perform error recovery
 *------------------------------------------------------------------*/
do tries  = 1 to MaxRetries+1
  call Main_Line
 
  rc=result
  if rc=0 then leave
  if rc=ExitError then leave
  if rc=ReqRestart then
    do
      /* if this is a shutdown then don't do recovery */
      if translate(SendMsg)=":SHUTDOWN:" then
        do
          MaxRC=ExitError
          leave
        end
 
        /*----------------------------------------------------------
         * Try to cleanup and restart everthing
         *----------------------------------------------------------*/
        call Restart
        if result<>0 then iterate
    end
end
 
if MaxRC = 0 then
  call traceit 1 'Normal exit';
else
  call traceit 1 'Error exit';
Exit MaxRC
 
 
/*------------------------------------------------------------------
 * Perform Queue extract, TCP/IP Connection, send command
 * and receive output.
 *------------------------------------------------------------------*/
Main_Line:
   MaxRC=0
   CloseSock=0
 
  /*----------------------------------------------------------------
   * Get IGYFSERV IP address, port and ID token from queue
   *----------------------------------------------------------------*/
  OldQName = RXQueue('Set',IWZQName)
  if queued() < 1 then
    do
      Call traceit 3 "Queue" IWZQName "contains no data"
      MaxRc = ReqRestart
    end
 
  if MaxRC=0 then
    do
      parse pull ServInfo
      push ServInfo
      /* say "ServInfo="ServInfo */   /* remove */
      parse var ServInfo . SrvrID Port Token .
    end
 
  x = RXQueue('Set',OldQName)
 
  /*----------------------------------------------------------------
   * Register the Rexx TCP/IP functions if not already registered
   *----------------------------------------------------------------*/
  if RxFuncQuery("SockLoadFuncs") then
    do
      rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
      if rc<>0 then
        do
          Call traceit 3 "RxFuncAdd() Failed, RC="rc
          call traceit 1 'Error exit';
          exit 8
        end
 
      SockLoadFuncs()  /* SockLoadFuncs always gives a null return */
    end
 
  if tm then Call traceit 3 'After SockLoadFuncs:' time('r')
  /*---------------------------------------------------------------
   * open socket
   *---------------------------------------------------------------*/
  if MaxRC=0 then
    do
      socket  = SockSocket("AF_INET","SOCK_STREAM",0)
      if socket = -1 then
        do
          Call traceit 3 "Error during SockSocket:" errno
          MaxRC=ExitError
        end
      else
        SockClose=1
    end
 
  if tm then Call traceit 3 'After SockSocket:'    time('r')
  /*---------------------------------------------------------------
   * catch breaks
   *---------------------------------------------------------------*/
  signal on halt
 
  /*---------------------------------------------------------------
   * connect socket
   *---------------------------------------------------------------*/
  if MaxRC=0 then
    do
      call Set_Connect_Parms
 
      rc = SockConnect(socket,"server.!")
      if rc = -1 then
        do
          Call traceit 3 "Error during SockConnect:" errno
          if errno = 'ECONNREFUSED' then
            MaxRC=ReqRestart                 /* restart the server */
          else
            MaxRC=ExitError                 /* Errors with no retry*/
        end
    end
 
  if tm then Call traceit 3 'After SockConnect:'   time('r')
 
  /*---------------------------------------------------------------
   * Send the TSO command to server
   *---------------------------------------------------------------*/
  if MaxRC=0 then
    do
      TokenMsg = Token SendMsg
      rc = SockSend(socket,TokenMsg)
      if rc = -1 then
        do
          Call traceit 3 "Error during SockSend:" errno
          MaxRC=ReqRestart
        end
     end
 
  if tm then Call traceit 3 'After SockSend:'     time('r')
 
  /*----------------------------------------------------------------
   * Get back the results of the TSO command from host
   *----------------------------------------------------------------*/
  if MaxRC=0 then
    do
      out=''
      do forever
        rc = SockRecv(socket,"Rstr",10000)
        if rc<0 then
          do
            Call traceit 3 "Error during SockRecv:" rc errno
            MaxRC=ReqRestart
            leave
          end
        else
          do
            if trc then Call traceit 3 "Recv:" Rstr
            call Build_Msg
            if eotf <> 0 then leave
          end
      end
 
      /* Check for a command that could not be executed */
      if substr(out,1,5)=':ERR:' then MaxRC=ExitError
 
      if tm then Call traceit 3 'After SockRecv:'      time('r')
      if MaxRC <> ReqRestart then call say_results
    end
 
  /*---------------------------------------------------------------
   * close socket (and catch signals)
   *---------------------------------------------------------------*/
  halt:
 
  if CloseSock then
    do
      rc = SockSoClose(socket)
      if rc = -1 then
        do
          Call traceit 3 "Error during SockSoClose:" errno
          MaxRC=ExitError
        end
    end
 
  if tm then Call traceit 3 'After SockClose:'     time('r')
 
Return MaxRc
 
/*------------------------------------------------------------------
 * Build the output message variable
 *------------------------------------------------------------------*/
Build_Msg:
 
  eotf=0
  p= pos(eot,Rstr)
  if p <> 0 then
    do
      eotf=1
      if p>1 then
        do
          out = out || substr(Rstr,1,p-1)
        end
    end
  else
    do
      out = out || Rstr
    end
return
 
/*------------------------------------------------------------------
 * Dump the messages
 *------------------------------------------------------------------*/
Say_Results:
  call sayit out
return
 
Sayit:
  parse arg saymsg
  call traceit 3 '--->' saymsg;
  xx=lineout(outfile, saymsg)
  if outfile<>'' then xx=lineout(outfile)
  return 0
 
/*------------------------------------------------------------------
 * Restart the host server
 *------------------------------------------------------------------*/
Restart:
  x = RXQueue('Delete',IWZQName)
  callit 'iwzmscm.cmd' callit 'iwzmVSR 2}nul }nul'
  if rc<>0 then return ExitError
return 0
 
/*------------------------------------------------------------------
 * Restart the host server
 *------------------------------------------------------------------*/
Set_Connect_Parms:
  server.!family = "AF_INET"
  server.!port   = Port
  server.!addr   = SrvrID
return
 
Get_MVSINFO:
Procedure expose env cobolroot mvsinfo. whoami tempdir trace
 
rtn = 0
null = '0000'x
crlf = '0D0A'x
mvsinfo. = ''
mvsinfoQ = translate('iwzm_MVSINFO.DAT_YALE');
 
oldq = rxqueue('Set',mvsinfoQ)   /* switch to mvsinfo queue */
if queued() = 0 then do                   /* if Q is missing we'll */
  qname = rxqueue('Create',mvsinfoQ)      /* create it and put a bad */
  if qname = mvsinfoQ then push 'Sven'    /* timestamp on it, else */
  else x=rxqueue('Delete',qname)          /* it was in use (we hope) */
  end                                     /* so we'll assume we can */
parse pull mvsstuff; push mvsstuff        /* get/replace Q contents */
parse value mvsstuff with ts (null) . cobolroot (null) mvsstuff /* get */
                                        /* timestamp and cobolroot */
if ts <> 'Sven' then do;
  mvsinfo = cobolroot'\MACROS\MVSINFO.DAT'
  bad_mvsinfo = '    **' whoami '****'crlf'    **error*' mvsinfo,
                'is unavailable, missing or empty **'
 
  x=SysFileTree(mvsinfo,'ts','F')       /* get MVSINFO.DAT's timestamp */
  if ts.0 <> 1 then do
    say bad_mvsinfo
    return 12;
    end
  parse var ts.1 v0 v1 v2 .
  timestamp ='mvsinfo.dat.timestamp' v0 v1 v2
  end;
else
  timestamp = 'Yale'
if timestamp <> ts then do              /* timestamps match? */
  pull mvsstuff                         /* no, remove bad contents */
  rtn = "iwzmIR.CMD"()                /* ask for new stuff */
  if rtn = 0 then do
    parse pull mvsstuff; push mvsstuff    /* get/replace Q contents */
                                        /* remove timestamp and     */
                                        /* cobolroot                */
    parse value mvsstuff with . (null) . cobolroot ( null) mvsstuff
    end
  end
qname = rxqueue('Set',oldq)      /* restore normal queue */
 
do while (mvsstuff<>'') & (rtn=0)   /* mvsinfo. structure */
  parse value mvsstuff with key val (null) mvsstuff
  if mvsinfo.key = '' then do       /* e.g. mvsinfo.TYPE='' */
    mvsinfo.KEYS = mvsinfo.KEYS key /* no substitution for KEYS */
    mvsinfo.key.1 = val             /* e.g. mvsinfo.TYPE.1=val  */
    mvsinfo.key = 1                 /* e.g. mvsinfo.TYPE=1      */
    end
  else do
    x = mvsinfo.key + 1             /* e.g. mvsinfo.TYPE+1     */
    mvsinfo.key.x = val             /* e.g. mvsinfo.TYPE.2=val */
    mvsinfo.key = x                 /* e.g. mvsinfo.TYPE=2     */
    end
  end
 
return rtn
 
Set_MVSINFO_Vars:
 
 parse var mvsinfo.CLOSECMD.1 closecmd;
 parse var mvsinfo.CLOSEFILE.1 closefile;
 parse var mvsinfo.FILESYS.1 filesys accessmon testaccess;
 parse var mvsinfo.FSSTARTCMD.1 fsstartcmd;
 parse var mvsinfo.FSSTOPCMD.1 fsstopcmd;
 parse var mvsinfo.HEADER.1 header;
 parse var mvsinfo.JOBLOG.1 joblog;
 parse var mvsinfo.MAXCMD.1 maxcmd;
 parse var mvsinfo.LANGUAGE.1 language;
 parse var mvsinfo.MOUNTCMD.1 mountcmd;
 parse var mvsinfo.MVSCOMM.1 mvscomm;
 parse var mvsinfo.iwzmEDT.1 iwzmedt;
 parse var mvsinfo.NFS.1 nfs;
 parse var mvsinfo.NULLSTDIN.1 nullstdin;
 parse var mvsinfo.OUTSHOW.1 outshow;
 parse var mvsinfo.PROTSAVE.1 protsave tempmult;
 parse var mvsinfo.PWD.1 pwd pwdasis pwdt pwde;
 parse var mvsinfo.READTIMEOUT.1 readtimeout;
 parse var mvsinfo.REXECCMD.1 rexeccmd;
 parse var mvsinfo.SDU.1 sdu;
 parse var mvsinfo.SIGYCLST.1 sigyclst;
 parse var mvsinfo.SYSPROC.1 sysproc;
 parse var mvsinfo.SYSTEM.1 system;
 parse var mvsinfo.TEMPDRIVE.1 tempdrive;
 parse var mvsinfo.TEMPDATA.1 tempdata;
 parse var mvsinfo.TESTFILE.1 testfile;
 parse var mvsinfo.TRACE.1 trace tracekeep;
 parse var mvsinfo.TRACECMD.1 tracecmd;
 parse var mvsinfo.TRACEMOD.1 tracemod;
 parse var mvsinfo.UMOUNTCMD.1 umountcmd;
 parse var mvsinfo.USERID.1 userid;
 parse var mvsinfo.WORKSYS.1 worksys;
 parse var mvsinfo.WRITETIMEOUT.1 writetimeout;
 
 parse var mvsinfo.DRIVE numdrive;
 if numdrive = '' then
   numdrive = 0;
 do ii = 1 to numdrive;
   parse var mvsinfo.DRIVE.ii,
             drive.ii highqual.ii trans.ii mapping.ii sidefile.ii;
   end;
 
 parse var mvsinfo.TYPE numtype;
 if numtype = '' then
   numtype = 0;
 do ii = 1 to numtype;
   parse var mvsinfo.TYPE.ii type.ii ext.ii;
   end;
 
return
 
/* */
Traceit:
 parse arg iwz_trc_level iwz_trc_message;
 if iwz_trc_level > trace then
   return;
 if pwd <> '********' & pwd <> '++++++++' & pwd <> '========' then
   do;
   do forever;
     if pos(pwd,iwz_trc_message) = 0 then
       leave;
     parse var iwz_trc_message iwz_trc_message1 (pwd) iwz_trc_message2;
     iwz_trc_message = iwz_trc_message1||'********'||iwz_trc_message2
     end;
   end
 iwz_trc_message = date('O') time('L') whoami':' iwz_trc_message;
 xx = lineout(tempdir'\iwzmTRC.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
 if tracecmd <> '' then
   interpret tracecmd;
return;
 
/* */
sayit:
 parse arg iwz_sayit_arg;
 if trace > 2 then
   call traceit 3 '--->' iwz_sayit_arg;
 say iwz_sayit_arg;
return;
/*
:runit
@rexx %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
@rem */
