/* REXX */
/*************************************************************/
/*                                                           */
/*    Licensed Materials - Property of IBM                   */
/*                                                           */
/*    5639-B92 (C) Copyright IBM Corp. 1995                  */
/*    All rights reserved                                    */
/*                                                           */
/*    US Government Users Restricted Rights - Use,           */
/*    duplication, or disclosure restricted by GSA ADP       */
/*    Schedule Contract with IBM Corp.                       */
/*                                                           */
/*************************************************************/
 
/*************************************************************/
/* Name: iwzmWBN.CMD                                         */
/*                                                           */
/* Function: Perform a project level "Build normal" action   */
/*           for WorkFrame projects based on the COBOL       */
/*           MVS Master Project.  The supplied version of    */
/*           file issue a message informing the user that    */
/*           they need to manually perform the needed        */
/*           actions to perform the "Build normal".  The     */
/*           user can modify this REXX procedure to perform  */
/*           the required actions.                           */
/*                                                           */
/* Last Update: 11/21/96                                     */
/*************************************************************/
signal on novalue;
parse source opsys rest;
parse upper arg project_name; /* get the project name   */
call sayit 'A "Build normal" action has been requested for the WorkFrame';
call sayit 'project named' project_name'.';
call sayit;
call sayit 'The tasks required to perform the "Build normal" action for';
call sayit 'MVS parts is not supported.  You must perform these tasks';
call sayit 'manually.';
exit 0;
/* */
sayit:
parse arg sayit_arg;
if opsys = 'OS/2' then
  say sayit_arg;
else
  do;
  xx = lineout(,sayit_arg);
  xx = lineout();
  end;
return;
