#*******************************************************************************
# FILE NAME: iwzbmigr.mak                                  V2R2                *
#                                                                              *
# DESCRIPTION:                                                                 *
#   Make file to create OS/2 dynamic library for migrated part                 *
#       $(CVBOLDNAME)                                                          *
#                                                                              *
# COPYRIGHT:                                                                   *
#   IBM(R) VisualAge(TM) for COBOL                                             *
#   (C) Copyright International Business Machines Corporation 1998             *
#   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
#   US Government Users Restricted Rights - Use, duplication, or disclosure    *
#   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
#                                                                              *
# ---------------------------------------------------------------------------- *
# Notes:                                                                       *
#   The environment variables CVBDEBUG, OLDCOMPFLAGS, OLDLINKFLAGS can be used *
#   to set options                                                             *
#   The environment variables OLDCBJDEPENDS, OLDDLLDEPENDS can be used to set  *
#   additional dependencies                                                    *
#   The environment variable OLDDLLLIBS can be used to add .obj or .lib files  *
#   to link                                                                    *
#*******************************************************************************
OLDCOMPFLAGS=-qNOADATA -qENTRYINT(OPTLINK) $(OLDCOMPFLAGS)
!ifdef CVBDEBUG
OLDCOMPFLAGS=$(OLDCOMPFLAGS) -qTEST
!endif

OLDLINKFLAGS=/free /nologo /pmtype:pm /dll $(OLDLINKFLAGS)
!ifdef CVBDEBUG
OLDLINKFLAGS=$(OLDLINKFLAGS) /de
!endif

.SUFFIXES:

$(CVBOLDNAME).dll: $(CVBOLDNAME).obj $(CVBNAME).lib \
                   $(OLDDLLDEPENDS)
  @echo ... creating $(CVBOLDNAME).dll ...
          @copy $(CVBOLDNAME).def iwzbtemp.def > nul
          @echo showMsgFromText >> iwzbtemp.def
          @echo showMsgFromMsgFile >> iwzbtemp.def
          iwzolnk1 $(OLDLINKFLAGS) $(CVBOLDNAME).obj \
             iwzbcprt.lib iwzbcobs.lib iwzbapix.lib iwzblang.obj \
             iwzbrtr1.lib iwzbvdee.obj iwzbtemp.def $(OLDDLLLIBS)
          @del iwzbtemp.def
          implib /nol $(CVBOLDNAME).lib $(CVBOLDNAME).def

$(CVBOLDNAME).obj: $(CVBOLDNAME).cbl $(OLDOBJDEPENDS)
  @echo ... creating $(CVBOLDNAME).obj ...
          @set SYSLIB=$(SYSLIB);$(INCLUDE)
      -7  igyccob2 $(OLDCOMPFLAGS) $(CVBOLDNAME).cbl

cleanold:
   @if exist $(CVBOLDNAME).obj del $(CVBOLDNAME).obj
   @if exist $(CVBOLDNAME).lst del $(CVBOLDNAME).lst
   @if exist $(CVBOLDNAME).lib del $(CVBOLDNAME).lib
   @if exist $(CVBOLDNAME).dll del $(CVBOLDNAME).dll

