      ******************************************************************
      *                                                                *
      * MODULE NAME        TIMEZONE.CBL                                *
      *                                                                *
      * DESCRIPTIVE NAME   Server code for TimeZone - CICS             *
      *                    Sample shipped with VisualAge COBOL for OS/2*
      *                                                                *
      * Statement:         63H9790                                     *
      *                    (C) Copyright IBM Corporation 1994,1998     *
      *                                                                *
      * Status:            Version 2 Release 0                         *
      *                                                                *
      * Components:        TIMEZONE.CBL                                *
      *                                                                *
      * NOTES :-                                                       *
      *                                                                *
      *   This sample is an example of the form an ECI application; it *
      *   is not a template and should be used only as an example for  *
      *   for your applications. It does not demonstrate all the       *
      *   techniques required for a  large application.                *
      ******************************************************************

       IDENTIFICATION DIVISION.
       PROGRAM-ID. TIMEZONE.

       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       77 RAWTIME            PIC S9(15) COMP-3.
       01  DATE-TEMP         PIC X(8).
       01  TIME-TEMP         PIC X(8).
       LINKAGE SECTION.
       01  DFHCOMMAREA.
           07  DATE-OUT      PIC X(8).
           07  TIME-OUT      PIC X(8).

       PROCEDURE DIVISION.
      ***************************************************************
      *    Main section                                             *
      ***************************************************************
           EXEC CICS ASKTIME ABSTIME(RAWTIME)
           END-EXEC.

           EXEC CICS FORMATTIME ABSTIME(RAWTIME)
                                MMDDYY(DATE-OUT)
                                DATESEP('-')
                                TIME(TIME-OUT)
                                TIMESEP(':')
           END-EXEC.

           MOVE DATE-OUT TO DATE-TEMP.
           MOVE TIME-OUT TO TIME-TEMP.
           EXEC CICS RETURN END-EXEC.

           GOBACK.

