       CBL PGMNAME(MIXED) CALLINT(SYSTEM)
      ******************************************************************
      *                                                                *
      * MODULE NAME        FAAEXP15.CBL                                *
      *                                                                *
      * DESCRIPTIVE NAME   User exit - 15. Task Attach / Detach Exit   *
      *                    sample for Remote DL/I running on           *
      *                    CICS OS/2.                                  *
      *                                                                *
      * Statement:         Licensed Materials - Property of IBM        *
      *                                                                *
      *                    5622-793                                    *
      *                    (c) Copyright IBM Corp. 1997.               *
      *                                                                *
      *                    See Copyright Instructions.                 *
      *                                                                *
      *                    All rights reserved.                        *
      *                                                                *
      *                    U.S. Government Users Restricted Rights -   *
      *                    use, duplication or disclosure restricted   *
      *                    by GSA ADP Schedule Contract with IBM Corp. *
      *                                                                *
      *  NOTES :-                                                      *
      *    DEPENDENCIES = None                                         *
      *                   None                                         *
      *    RESTRICTIONS = none                                         *
      *    MODULE TYPE  = Copybook                                     *
      *    PROCESSOR    = PS/2 and PC                                  *
      *                                                                *
      ******************************************************************
      *                                                                *
      *  FUNCTION                                                      *
      *    The Remote DL/I calls in this program ensure that at the    *
      *    end of a transaction:                                       *
      *      - If a PSB is still scheduled, it is terminated.          *
      *      - If a remote DL/I connection exists, the connection      *
      *        is ended.                                               *
      *                                                                *
      ******************************************************************
      *
        IDENTIFICATION DIVISION.
        PROGRAM-ID. 'FAAEXP15'.
      *
        ENVIRONMENT DIVISION.
        CONFIGURATION SECTION.
        SOURCE-COMPUTER. IBM-PC.
        OBJECT-COMPUTER. IBM-PC.
      *
        DATA DIVISION.
      *
        WORKING-STORAGE SECTION.
      *
       77  DLI-RC                 PIC S9(8) binary.
      *
        LINKAGE SECTION.
      *
           COPY FAAEXW15.
      *
        PROCEDURE DIVISION USING EXIT-15.
      *
        A1-BEGIN SECTION.
      *
           if exit-15-task-attach
              continue
           else
      *       We get here for task detach.
      *       Only do the remote DL/I calls for transactions that
      *       may use remote DL/I (omit CICS supplied transactions).
              if exit-15-transid(1:1) not = "C"
      *            Terminate any outstanding scheduled PSBs
                   >>CALLINT OPTLINK
                   CALL "DLITermPSB" returning DLI-rc
                   >>CALLINT

      *            Disconnect if there is a connection
                   if DLI-rc not = 120
                     >>CALLINT OPTLINK
                     CALL "DLIDisconnect" returning DLI-rc
                     >>CALLINT
                   end-if

              end-if
           end-if

           MOVE 0 TO RETURN-CODE

           GOBACK.
