      cbl  pgmname(mixed)
      ******************************************************************
      * ODBC3EG.CBL                                                    *
      *----------------------------------------------------------------*
      * Sample program using ODBC3, ODBC3D and ODBC3P COPY books       *
      ******************************************************************
       IDENTIFICATION DIVISION.
       PROGRAM-ID. "ODBC3EG".
       DATA DIVISION.

       WORKING-STORAGE SECTION.
      *  copy ODBC API constant definitions
           COPY "odbc3.cpy" SUPPRESS.

      *  copy additional definitions used by ODBC30PROC procedure
           COPY "odbc3d.cpy".

      *  arguments used for SQLConnect
       01  ServerName                    PIC X(10) VALUE Z"Oracle7".
       01  ServerNameLength       COMP-5 PIC S9(4) VALUE 10.
       01  UserId                        PIC X(10) VALUE Z"TEST123".
       01  UserIdLength           COMP-5 PIC S9(4) VALUE 10.
       01  Authentification              PIC X(10) VALUE Z"TEST123".
       01  AuthentificationLength COMP-5 PIC S9(4) VALUE 10.

       PROCEDURE DIVISION.
       Do-ODBC SECTION.
        Start-ODBC.
           DISPLAY "Sample ODBC 3.0 program starts"

      *  allocate henv & hdbc
           PERFORM ODBC-Initialization

      *  connect to data source
           CALL "SQLConnect" USING BY VALUE     Hdbc
                                   BY REFERENCE ServerName
                                   BY VALUE     ServerNameLength
                                   BY REFERENCE UserId
                                   BY VALUE     UserIdLength
                                   BY REFERENCE Authentification
                                   BY VALUE     AuthentificationLength
                             RETURNING SQL-RC

           IF SQL-RC NOT = SQL-SUCCESS
             MOVE "SQLConnect" to SQL-stmt
             MOVE SQL-HANDLE-DBC to DiagHandleType
             SET DiagHandle to Hdbc
             PERFORM SQLDiag-Function
           END-IF

      *  set licensing informationm
           PERFORM SQL-SetLicInfo-Function

      *  allocate hstmt
           PERFORM Allocate-Statement-Handle

      *****************************************
      *  add application specific logic here  *
      *****************************************

      *  clean-up environment
           PERFORM ODBC-Clean-Up.

      *  End of sample program execution
           DISPLAY "Sample COBOL ODBC program ended"
           GOBACK.

      *  copy predefined COBOL ODBC calls which are performed
           COPY "odbc3p.cpy".
      *******************************************************
      * End of ODBC3EG.CBL:  Sample program for ODBC 3.0 *
      *******************************************************
