       Identification Division.
       Program-ID. dczy2kr.
       Author. TH

      ******************************************************************
      *                                                                *
      *    Licensed Material - Property of IBM                         *
      *                                                                *
      *    5622-793 (C) Copyright IBM Corp., 1997                      *
      *    All rights reserved                                         *
      *                                                                *
      *    US Government Users Restricted Rights - Use,                *
      *    duplication or disclosure restricted by GSA ADP             *
      *    Schedule Contract with IBM Corp.                            *
      *                                                                *
      *    2/27/97 - OS/2 version                                      *
      *    8/25/97 - Updated for 9/97 NT Release                       *
      *      1/27/98 - <MLE> tag with multiple (offset:length)         *
      *                multiple result entries with one offset         *
      *      2/10/98 - fix handling of <NAME> within <RESULT> block    *
      *                and skip <INCLUDE> ... </INCLUDE> block         *
      *                                                                *
      ******************************************************************
      *                                                                *
      *  This program takes the Y2000 analysis tool output, which is   *
      *  intended to be handled primarily by another tool, and         *
      *  generates reports which can be used by analysts as well       *
      *  as by other tools.                                            *
      *                                                                *
      *  This program uses the following seven files:                  *
      *                                                                *
      *    1) Input: generated with tagged entries from the            *
      *       Year 2000 tool. This file is primarily intended for      *
      *       processing by tools                                      *
      *                                                                *
      *    2) Input: seed file                                         *
      *       Input seed file for the Year 2000 tool.                  *
      *                                                                *
      *    3) Output/Input: work file                                  *
      *                                                                *
      *    4) Output: Main report appropriate for review               *
      *       by analysts (vs tools). Based on the output file 2)      *
      *       above with added report headings added and the report    *
      *       entries are ordered by the data names and the            *
      *       data name declaration positions.                         *
      *       Report entries for this file may be optionally loaded    *
      *       into into a relational database for use with the tables  *
      *       created from the entries from 4) and 6) below.           *
      *                                                                *
      *    5) Output: File ID report showing the map of file-ID's      *
      *       included in files in 3) above to actual file names.      *
      *       This file is intended to be used with the file 3) above. *
      *       Report entries for this file may be optionally loaded    *
      *       into into a relational database for use with the table   *
      *       created from the entries from 3) above.                  *
      *                                                                *
      *    6) Output: Seed File report                                 *
      *       This report is a copy of the input file 5) with the      *
      *       following modifications:                                 *
      *       a) The seed line number is added in the report.          *
      *       b) Seeds not referenced in the report are excluded.      *
      *                                                                *
      *    7) Output: Cross Reference report                           *
      *       This report includes cross reference for items           *
      *       reported in the main report.                             *
      *                                                                *
      *  The following files will be created                           *
      *  for the reports described above.                              *
      *                                                                *
      *     1) DCZWORK for the temporary work file                     *
      *                                                                *
      *     2) Main report file (.XRT):                                *
      *        The reports described above as "Main report",           *
      *        "File ID report" and "Seed File report" are             *
      *        concatenated and produced on a single physical file.    *
      *        The file name is based on the name of the .XRL file     *
      *        with the last four characters replaced with ".XRT".     *
      *        For example, it the .xrl file name is "mypgm.XRL",      *
      *        the file name for this report would be "mypgm.XRT".     *
      *        If the file name of the .xrl file is shorter than       *
      *        five characters long, the report file name would be     *
      *        programname.XRT in the current directory, where         *
      *        "programname" is the name of the program being          *
      *        analyzed.                                               *
      *                                                                *
      *        This file contains the four reports described           *
      *        above.                                                  *
      *          i.e. Main report, File ID report, and Seed file       *
      *               report in that order.                            *
      *                                                                *
      *     3) Cross reference report file (.XRF):                     *
      *        The report described as "Cross Reference report" above  *
      *        is produced on a separate file.                         *
      *        The file name is based on the name of the .XRL file     *
      *        with the last four characters replaced with ".XRF".     *
      *        For example, it the .xrl file name is "mypgm.XRF",      *
      *        the file name for this report would be "mypgm.XRF".     *
      *        If the file name of the .XRL file is shorter than       *
      *        five characters long, the report file name would be     *
      *        programname.XRF in the current directory, where         *
      *        "programname" is the name of the program being          *
      *        analyzed.                                               *
      *                                                                *
      *  DCZWORK will be allocated on the current directory unless     *
      *  the environment variable DCZWORK is set. If DCZWORK is        *
      *  set, the work file is allocated using the value of the        *
      *  DCZWORK environment variable.                                 *
      *----------------------------------------------------------------*
      *  Invocation                                                    *
      *                                                                *
      *    This program is invoked from the Year 2000 tool             *
      *    automatically if you specify  "DCZMKPU /r  ...".            *
      *                                                                *
      *    You can also invoke this program independently as follows:  *
      *                                                                *
      *      dczy2kr   aaa bbb                                         *
      *                                                                *
      *    where aaa and bbb are the names of the  .xrl  and  the .xsd *
      *    with directory/path as appropriate.                         *
      *                                                                *
      *----------------------------------------------------------------*
      *                                                                *
      * The following are the current capacity limits for this         *
      * program:                                                       *
      *                                                                *
      *   Maximum size of a single input report line:  800             *
      *   Maximum number of source files:             9999             *
      *   Maximum size of a single seed input line:    800             *
      *   Maximum number of lines for seed file:       800             *
      *                                                                *
      * The above can be adjusted by changing the declarations for     *
      * (and in some cases references to):                             *
      *                                                                *
      *   Rpt-In-Record, File-ID-Table-Entry, Seed-In-Record and       *
      *   Seed-Line-Char, and Seed-Line-Referenced respectively        *
      *                                                                *
      *----------------------------------------------------------------*

      *================================================================*
       Environment Division.
      *================================================================*

       Configuration Section.
       Input-Output Section.

       File-Control.

      *-File 1 (input)-------------------------------------------------*
      *    Rpt-In: .xrl file                                           *
      *----------------------------------------------------------------*
           Select Rpt-In
             Assign Using Rpt-In-Name
             Organization is LINE SEQUENTIAL
             File Status Is Rpt-In-FS.

      *-File 2 (input - Seed input)------------------------------------*
      *    Rpt-Seed: .xsd file                                         *
      *----------------------------------------------------------------*
           Select Seed-In
             Assign Using Seed-In-Name
             Organization is LINE SEQUENTIAL
             File Status is Seed-In-FS.

      *-File 3 (output/input - report work file)-----------------------*
      *    Rpt-Work: unordered analysys report work file               *
      *----------------------------------------------------------------*
           Select Rpt-Work
             Assign to DCZWORK
             Organization is LINE SEQUENTIAL
             File Status is Rpt-Work-FS.

      *-File 4 (output - main report)----------------------------------*
      *    Rpt-Main: Ordered and formatted main report                 *
      *----------------------------------------------------------------*
           Select Rpt-Main
             Assign Using Main-Report-File-Name
             Organization is LINE SEQUENTIAL
             File Status is Rpt-Main-FS.


      *-File 5 (output - fileID report)--------------------------------*
      *    Rpt-FileID: ordered and formatted File ID/File Name report  *
      *----------------------------------------------------------------*
           Select Optional Rpt-FileID
             Assign Using Main-Report-File-Name
             Organization is LINE SEQUENTIAL
             File Status is Rpt-FileID-FS.


      *-File 6 (output - Seed report)----------------------------------*
      *    Rpt-Seed: referenced seed lines with line numbers           *
      *----------------------------------------------------------------*
           Select Optional Rpt-Seed-File
             Assign Using Main-Report-File-Name
             Organization is LINE SEQUENTIAL
             File Status is Rpt-Seed-FS.

      *-File 7 (output - cross reference report)-----------------------*
      *    Xref-File: referenced seed lines with line numbers          *
      *----------------------------------------------------------------*
           Select Xref-File
             Assign Using Xref-Report-File-Name
             Organization is LINE SEQUENTIAL
             File Status is Rpt-Xref-FS.

      *-Sort file 1----------------------------------------------------*
      *    Sort-Rpt: used to sort Rpt-Work and create                  *
      *               Rpt-Main file                                    *
      *----------------------------------------------------------------*
           Select Sort-Rpt Assign to Sorti1.

       I-O-Control.

      *================================================================*
       Data Division.
      *================================================================*

      *================================================================*
       File Section.
      *================================================================*

      *------------------------------------------------------------*
      *    Input report file for this program                      *
      *------------------------------------------------------------*
       FD  Rpt-In
             Record is varying in size from 1 to 800 characters
             depending on In-Rec-Length.

       01  Rpt-In-Record       Pic X(800).

      *------------------------------------------------------------*
      *    Input seed file for this analysis                       *
      *------------------------------------------------------------*
       FD  Seed-In
             Record is varying in size from 1 to 800 characters
             depending on Seed-Rec-Length.

       01  Seed-In-Record       Pic X(800).

      *------------------------------------------------------------*
      *    Report workfile (unordered)                             *
      *------------------------------------------------------------*
       FD  Rpt-Work.

       01  Rpt-Work-Xref-Record Pic X(130).

       01  Rpt-Work-Record      Pic X(300).

      *------------------------------------------------------------*
      *    Main report output file (ordered and with headings)     *
      *------------------------------------------------------------*
       FD  Rpt-Main.

       01  Rpt-Main-Record             Pic X(78).

      *    ...this record is used to write > 78 character records
      *       Note: trailing spaces are stripped for Line Sequential
       01  Rpt-Main-Big-Record         Pic X(300).

      *------------------------------------------------------------*
      *    File ID/File-Name table file (ordered by fileID)        *
      *------------------------------------------------------------*
       FD  Rpt-FileID.

       01  Rpt-FileID-Header-Record     Pic X(78).

       01  Rpt-FileID-Record.
           02 File-ID-in-File           Pic 9999.
           02 filler                    Pic X(5).
           02 File-Name-in-File.
              03 File-Name-Char-in-File Pic X
                              Occurs 1 to 256 Times
                                Depending on Name-Length.

      *------------------------------------------------------------*
      *    Seed report output file                                 *
      *------------------------------------------------------------*
       FD  Rpt-Seed-File.

       01  Rpt-Seed-Header-Record  Pic X(78).

       01  Rpt-Seed-Record.
           02 filler-seed-no       Pic X(5).
           02 Seed-Record-Char     Pic X
               Occurs 1 to 800 Times
                                Depending on Seed-Rec-Length.

      *------------------------------------------------------------*
      *    Xref report output file                                 *
      *------------------------------------------------------------*
       FD  Xref-File.

       01  Xref-Record              Pic X(78).

       01  Xref-Big-Record          Pic X(300).

      *------------------------------------------------------------*
      *    Used to sort report the work file to write to the main  *
      *    report file and the Xref reprt file                     *
      *------------------------------------------------------------*
       SD  Sort-Rpt.

      *    ...report entry record...
       01  Rpt-Entry-S1.

      *       ...kind or xref record #.................(key 5)
           02 Xref-Rec-No-S1.
              03 Rpt-Kind-S1              Pic X(3).
              03 filler                   Pic X.

      *       ...data-name.............................(Key 1)
           02 Rpt-Name-S1                 Pic X(31).
           02 filler                      Pic X.

      *       ...qualified or not, or Xref record......(Key 3)
           02 Rpt-Qual-S1                 Pic X.
              88  Record-is-for-Xref      Value 'X'.
              88  Record-is-for-DN        Values 'Y', 'N'.
           02 filler                      Pic X.

      *       ...Definition position...................(Key 2)
           02 Rep-Def-Pos-S1.
      *          ...Def line from <DEF-POS>...
              03 Def-Line-S1              Pic ZZZZZ9.
              03 filler                   Pic X.
      *          ...Def file ID from <FILE>...
              03 Def-File-S1              Pic ZZZ9.
           02 filler                      Pic X.

      *       ...Year-Reason or Non-Year-Reason indicator
           02 Year-Reason-or-Not-S1 Pic X.
           02 filler                Pic X.

      *       ...Following depends on if it is a DN or Xref record
           02 DN-Xref-Dependent-Part.

              03 DN-Only-Report-Grp.
      *            ...cause from <REASON> entry........(Key 4)
                 04 Rpt-Cause-S1.
                    05 filler             Pic X.
      *             ...Xref File ID if Xref work record
                    05 Xref-File-ID-S1    Pic X(3).
                    05 filler             Pic X(4).
                 04 filler                Pic X.

      *             ...inference source...
                 04 Inference-Source-S1   Pic X(239).

      *             ...seed line number...
                 04 Rpt-Seed-Line-S1 Redefines Inference-Source-S1
                                          Pic 9(4).

              03 Xref-Only-Report-Grp Redefines DN-Only-Report-Grp.

                 04 filler                Pic X.
                 04 Xref-File-ID-Grp-S2.
                    05 Xref-File-ID-S2    Pic XXX.
                    05 filler             Pic XX.
                 04 filler                Pic X(72).



      *================================================================*
       Working-Storage Section.
      *================================================================*
       COPY dczy2kmc.

      *--------------------------------------------------------------*
      *   Switches and data values used to trigger call to an exit   *
      *--------------------------------------------------------------*

      *    ...switch to indicate if the exit is to be called or not...
       01  Y2K-Exit-Flag                 Pic X
                                         Value 'N'.
           88 Y2K-Exit-On                Value 'Y'.
           88 Y2K-Exit-Off               Value 'N'.

      *    ...name of the exit program...
       01  Y2K-Exit-Program              Pic X(8)
                                         Value 'Y2KEXIT'.

      *--------------------------------------------------------------*
      *   Y2K-Exit initialization status & call function values      *
      *--------------------------------------------------------------*

      *    ...initialization status...
       01  Y2K-Exit-Program-Init         Pic X
                                         Value '0'.
            88 Y2K-Exit-Initialized      Value '1'.


      *    ...Y2K-Exit function codes...
       01  Y2k-Exit-Func                 Pic 9(4)
                                         Value 9999.

           88 Y2K-Exit-Func-Init         Value 0.
           88 Y2K-Exit-Func-Pgm-Name     Value 1.
           88 Y2K-Exit-Func-DataItem-Def Value 2.
           88 Y2K-Exit-Func-DataItem-Rsn Value 3.
           88 Y2K-Exit-Func-Source       Value 4.
           88 Y2K-Exit-Func-Term         Value 9000.
           88 Y2K-Exit-Func-Term-Error   Value 9001.

      *------------------------------------*
      *   File Status                      *
      *------------------------------------*
       01  Rpt-In-FS          Pic XX.
           88 Rpt-In-EOF      Value '10'.

       01  Seed-In-FS         Pic XX.
           88 Seed-In-EOF     Value '10'.

       01  Rpt-Work-FS        Pic XX.
           88 Rpt-Work-EOF    Value '10'.

       01  Rpt-Main-FS        Pic XX.

       01  Rpt-FileID-FS      Pic XX.

       01  Rpt-Seed-FS        Pic XX.

       01  Rpt-Xref-FS        Pic XX.

      *----------------------------------------------------------------*
      *  Output Record Setup Areas: Rpt-Work and Rpt-Main              *
      *    Records are 78 or 300 characters long                       *
      *----------------------------------------------------------------*

      *    ...Header Separator line...
       01  Rpt-Separator Pic X(78)
                      Value ALL '-'.

      *    ...Header Record 1 (title)...
       01  Rpt-Hdr1.
           02 Rpt-Hdr1-1 Pic X(31)
                      Value 'Year 2000 Analysis Report for: '.
           02 Rpt-Pgm-name   Pic X(30).

      *                          123456789A123456789B123456789D1234567
      *    ...Column description(1)...
       01  Rpt-Hdr2.
           02 filler   Pic X(36)
                      Value     'Year-usage                          '.
           02 filler   Pic X(25)
                      Value     'Name-qualification       '.
           02 filler   Pic X(17)
                      Value     'Seed-line-No or  '.

      *    ...Column description (2)...
       01  Rpt-Hdr3.
           02 filler   Pic X(36)
                      Value     '| Y: Year  AY: Always-Year          '.
           02 filler   Pic X(25)
                      Value     '| Definition  Year or    '.
           02 filler   Pic X(17)
                      Value     'Inferred-from    '.

      *    ...Column header to column connection line...
       01  Rpt-Hdr4.
           02 filler   Pic X(36)
                      Value     '| YNY: Year-and-Non-Year            '.
           02 filler   Pic X(25)
                      Value     '| |---------> Non-Year   '.
           02 filler   Pic X(17)
                      Value     '| expression     '.

      *    ...Column header to column connection line...
       01  Rpt-Hdr5.
           02 filler   Pic X(36)
                      Value     '| NY: Non-Year ANY: Always-Non-Year '.
           02 filler   Pic X(25)
                      Value     '| Line   File |          '.
           02 filler   Pic X(17)
                      Value     '|                '.

      *    ...Column header to column connection line...
       01  Rpt-Hdr6.
           02 filler   Pic X(36)
                      Value     '|   Data-Name                       '.
           02 filler   Pic X(25)
                      Value     '| -No    -ID  | Reason   '.
           02 filler   Pic X(17)
                      Value     '|                '.


      *    ...Column header to column connection line...
       01  Rpt-Hdr7.
           02 filler   Pic X(36)
                      Value     '|-> |-----------------------------> '.
           02 filler   Pic X(25)
                      Value     '| |----> |--> | |------> '.
           02 filler   Pic X(17)
                      Value     '|--------------->'.


      *---------------------------------------------------------*
      *    File name header records                             *
      *---------------------------------------------------------*
       01  Source-File-Name-Header.
              03 filler        Pic X(22)
                               Value ' Source program file: '.
           02 Source-File-Name-in-Header.
               04 filler       Pic X
                      Occurs 1 to 256 Times
                        Depending on Source-File-Name-Length.

       01  Seed-File-Name-Header.
           02 filler           Pic X(22)
                               Value ' Seed File: '.
           02 Seed-File-Name-in-Header.
               04 filler       Pic X
                      Occurs 1 to 256 Times
                        Depending On Seed-In-Name-Length.


       01  Xrl-File-Name-Header.
           02 filler           Pic X(22)
                               Value ' Xrl file: '.
           02 Xrl-File-Name-in-Header.
              03 filler        Pic X
                      Occurs 1 to 256 Times
                        Depending On Rpt-In-Name-Length.

      *.........................................................*
      *    Time stamp header record                             *
      *.........................................................*
       01  Time-Stamp-Header.
           02 filler            Pic X(29)
                                Value ' Report process started at: '.
           02 Current-Month     Pic X(4).
           02 Current-Day       Pic 99.
           02 filler            Pic XX
                                Value    ', '.
           02 Current-Year.
              03 Current-Cent   Pic 99.
              03 Current-Yr     Pic 99.
           02 filler            Pic X(8)
                                Value    '  Time: '.
           02 Current-Time.
              03 Current-Hour   Pic 99.
              03 filler         Pic X
                                Value   ':'.
              03 Current-Minute Pic 99.
              03 filler         Pic X
                                Value   ':'.
              03 Current-Second Pic 99.
              03 filler         Pic X
                                Value   ':'.
              03 Current-CentiS Pic 99.
           02 filler          Pic X(16)
                              value    spaces.

      *    ...used with current-date...
       01  Current-YYYYMMDD.
           02 Current-YYYY    Pic 9999.
           02 Current-MM      Pic 99.
           02 Current-DD      Pic 99.

      *    ...used with Accept from Time...
       01  Current-HHMMSSCC.
           02 Current-HH      Pic 99.
           02 Current-MI      Pic 99.
           02 Current-SS      Pic 99.
           02 Current-CC      Pic 99.

      *    ...Month conversion table...
       01  Names-of-Months    Pic X(48)
             Value 'Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec '.

       01  Current-Month-Table Redefines Names-of-Months.
           02 Which-Month
                Occurs 12 times
                              Pic x(4).

      *---------------------------------------------------------*
      *    Main report entry record:                            *
      *     It is 300 characters long. The trailing spaces will *
      *     removed as part of Line Sequential file output      *
      *     processing.                                         *
      *---------------------------------------------------------*
       01  Rpt-Entry-Table.

           02  Rpt-Entry-No   Pic   999 Value 0.

           02  Rpt-Entry     OCCURS 100 Times.
      *       ...kind info from <REASON> entry...
             03 Rpt-Kind        Pic X(3)
                                Value spaces.
               88 Kind-Y        Value 'Y'.
               88 Kind-NY       Value 'NY'.
               88 Kind-YNY      Value 'YNY'.
               88 Kind-AY       Value 'AY'.
               88 Kind-ANY      Value 'ANY'.
               88 Kind-Unknown  Value '***'.
               88 Kind-spaces   Value spaces.
             03 filler          Pic X
                                Value space.

      *       ...unqualified data-name from <NAME> entry...
             03 Rpt-Name        Pic X(31).
             03 filler          Pic X
                                Value space.

      *       ...if nameis qualified or not, or Xref info record...
             03 Rpt-Qual        Pic X.
               88 Qual-Y        Value 'Y'.
               88 Qual-N        Value 'N'.
               88 Qual-X        Value 'X'.
             03 filler          Pic X
                                Value space.

      *       ...Definition position...
             03 Rpt-Def-Pos.
      *          ...Def line from <DEF-POS>...
                04 Def-Line     Pic ZZZZZ9.
                04 filler       Pic X
                                Value space.

      *          ...Def file ID from <FILE>...
                04 Def-File     Pic ZZZ9.
             03 filler          Pic X
                                Value space.

      *       ...indicate YEAR-REASON or NON-YEAR-REASON...
             03 Year-Reason-or-Not Pic X.
                88 Year-Reason-Y Value 'Y'.
                88 Year-Reason-N Value 'N'.
             03 filler          Pic X
                                Value space.

      *       ...Reason type...
             03 Rpt-Cause       Pic X(8).
             03 filler          Pic X
                                Value space.

      *       ...inference source...
             03 Inference-Source Pic X(239).

      *       ...seed line number...
             03 Rpt-Seed Redefines Inference-Source
                                Pic 9(4).
      *---------------------------------------------------------*
      *    End of base report entry set-up area                 *
      *    Used to modify 'MLE' reason with (offset:size)       *
      *---------------------------------------------------------*
           02 Offset-Size-Info   OCCURS 100 Times.
              03 Offset          Pic 9(10).
              03 filler redefines Offset.
                 04 filler       Pic 9(9).
                 04 Short-Offset Pic 9.
              03 Size-Value    Pic 9(10).
              03 filler redefines Size-Value.
                 04 filler       Pic 9(9).
                 04 Short-Size   Pic 9.
      *---------------------------------------------------------*
      *    End of Rpt-Entry-Table                               *
      *---------------------------------------------------------*

      *---------------------------------------------------------*
      *    Switch for processing multiple result entries for    *
      *    a name. Yes for MLE or for the same Offset           *                                     *
      *---------------------------------------------------------*
       01  Process-Result-Sw            Pic 9.
           88 Process-Result-Entry      Value 0.
           88 Dont-Process-Result-Entry Value 1.

      *---------------------------------------------------------*
      *    Cross Reference Info Work Record (as written to      *
      *    Rpt-Work file). It is 78 characters long.            *
      *---------------------------------------------------------*
       01  Xref-Work-Record.

      *    ...portion used only for sorting
           02 Xref-for-Sort-Only-Grp.
      *       ...Kind + sp. used as XREF record # for XREF.(SORT Key 5)
              03 XREF-Rec-No          Pic 9(4).


              03 Xref-Name-ID-X.
      *            ...unqualified data-name................(SORT Key 1)
                04 Xref-Name-X        Pic X(31).
                04 filler             Pic X.

      *            ...name qualified or not or Xref info...(SORT Key 3)
                04 Xref-Qual-X        Pic X     Value 'X'.
                04 filler             Pic X.

      *          ...Definition position....................(SORT Key 2)
                04 Xref-Def-Pos-X.
                  05 filler           Pic X.
                  05 Xref-Def-Line-X  Pic X(6).
                  05 filler           Pic X.
                  05 Xref-Def-File-ID-X Pic XXX.

                04 filler             Pic X.

              03 Xref-Reason-or-Not   Pic X.
              03 filler               Pic X.

      *    ...portin used in Xref report
           02 Xref-Only-Grp.
              03 filler               Pic X     Value space.
      *          ...Xref File ID...........................(SORT Key 4)
              03 Xref-File-ID         Pic XXX   Value spaces.
              03 Xref-File-ID-Del     Pic XX    Value ': '.

      *          ...Xref line #'s...
              03 Xref-Line-Numbers    Pic X(72) Value spaces.
      *---------------------------------------------------------*
      *    End of Xref work record set-up area                  *
      *---------------------------------------------------------*

      *----------------------------------------------------------------*
      *  End of record setup areas for Rpt-Work & Rpt-Main             *
      *----------------------------------------------------------------*

      *----------------------------------------------------------------*
      *  FileID report record set-up areas                             *
      *----------------------------------------------------------------*

      *    ...Header record 1 (Report tiltle)...
       01  File-ID-Hdr1.
           02 filler          Pic X(19)
                              Value 'File ID Table for: '.
           02 File-ID-Hdr1-2  Pic X(30).

      *    ...Report column description...
       01  File-Id-Hdr2       Pic X(18)
                              Value 'File-ID  File-Name'.

      *    ...Column header to column connection line...
       01  File-ID-Hdr3       Pic X(10)
                              Value '|-->     |'.

      *    ...main FileID report record...
       01  File-ID-Entry.
           02 File-ID           Pic 9999.
           02 filler            Pic X(5)
                                Value spaces.
           02 File-Name-Length  Pic 9(3) Value 0.
           02 File-Name         Pic X(256).
      *...End of record setup areas for Rpt-FileID file...


      *-------------------------------------------------*
      *  End of setup areas for Rpt-FileID file         *
      *-------------------------------------------------*

      *----------------------------------------------------------------*
      *   FileID table for FileID/File Name mapping                    *
      *----------------------------------------------------------------*
       01  File-Id-Table.
           02 File-ID-Table-Entry
                Occurs 0 to 1000 Times
                  Depending on Number-of-Files
                  Indexed by FileID-IX.
      *         ...will handle upto 1000 source files...
              03 File-ID-in-Table.
                 04 File-ID-No      Pic ZZZ9.
              03 File-Name-Size     Pic 9(3).
              03 File-Name-in-Table Pic X(256).

      *...Use for subscripting File-ID-Table or CauseID-Table...
       01  IX                       Pic 9(4).

      *...Number of source files reported in the input
       01  Number-of-Files          Pic 9(4) Value 0.

      *----------------------------------------------------------------*
      *   Rpt-Seed file record set-up areas                            *
      *----------------------------------------------------------------*
       01  Rpt-Seed-Title-Record.
           02 filler               Pic X(28) Value
              'Seed Input File Report for: '.
           02 Seed-Title-Pgm       Pic X(30).

       01  Rpt-Seed-Column-Header-1 Pic X(78) Value
           'Seed-line-number      '.

       01  Rpt-Seed-Column-Header-2 Pic X(78) Value
           '|    Seed-specification  '.

       01  Rpt-Seed-Column-Header-3 Pic X(78) Value
           '|--> |                       '.

       01  Rpt-Seed-Record-Ws.
           02 Seed-Line-No          Pic X(4).
           02 filler                Pic X
                                    Value space.
           02 Seed-Line.
              03 Seed-Line-Char     Pic X
                   Occurs 1 to 800 times
                     Depending on Seed-Rec-Length.


      *--------------------------------------------------------------*
      *    Xref report record set-up areas                           *
      *--------------------------------------------------------------*

      *    ...Xref report header file (used with base report headers)
       01  Xref-Rpt-Hdr1.
           02 filler                Pic X(47)
                Value 'Year 2000 Analysis Cross Reference Report for: '.
           02 Xref-Rpt-Pgm-name     Pic X(31).

      *    ...Xref report layout info header 1...
       01  Xref-Rpt-Layout-Hdr1.
           02 filler                Pic X(32)
                Value 'Data name                       '.
           02 filler                Pic X(22)
                Value '(Def Line-No/File-ID) '.
           02 filler                Pic X(24)
      *         Value 'Total No of references '.
                Value '                       '.

      *    ...Xref report layout info header 2...
       01  Xref-Rpt-Layout-Hdr2.
           02 filler                Pic X(33)
                Value ' FileID: Referencing line numbers'.
           02 filler                Pic X(45)
                Value spaces.

      *    ...Xref report Layout info header 2A...
       01  Xref-Rpt-Layout-Hdr2A.
           02  filler               Pic X(45)
                 Value '          r: referenced '.
           02  filler               Pic X(33)
                 Value spaces.

      *    ...Xref report Layout info header 2A...
       01  Xref-Rpt-Layout-Hdr2B.
           02  filler               Pic X(45)
                 Value '          m: modified '.
           02  filler               Pic X(33)
                 Value spaces.

      *    ...Xref report Layout info header 2A...
       01  Xref-Rpt-Layout-Hdr2C.
           02  filler               Pic X(45)
                 Value '          e: external '.
           02  filler               Pic X(33)
                 Value spaces.

      *    ...Xref report record for DN, (Def-Line/FileID) & Ref Count..
       01  Xref-DN-Record.
           02 Xref-DN               Pic X(31).
           02 filler                Pic X    Value space.
           02 Xref-Def.
              03 filler             Pic X    Value '('.
              03 Xref-Def-Line      Pic X(6).
              03 filler             Pic X    Value '/'.
              03 Xref-Def-File-ID   Pic XXX.
              03 filler             Pic XX   Value ') '.
      *       03 Xref-Ref-Count     Pic 9(6) Value 0.
              03 Xref-Ref-Count     Pic X(6) Value spaces.

      *    ...Xref report record for Ref-File-ID: Ref lines
       01  Xref-Ref-Record.
           02 filler              Pic X    Value space.
           02 Xref-Ref-File-ID-Grp.
              03 Xref-Ref-File-ID   Pic XXX.
              03 filler             Pic XX   Value ': '.
           02 Xref-Refs             Pic X(72).

       01  Xref-Refs-Pos            Pic 99   Value 1.
      *--------------------------------------------------------------*
      *    End of Xref report record set-up areas                    *
      *--------------------------------------------------------------*


      *.....................................................*
      *   Current tag found and being processed             *
      *.....................................................*
       01  Current-Tag        Pic X(28).

      *    ...top level tag values...
      *         Note: end-tags (i.e. </...>) may not be present
           88 HeaderTag                 Value '<HEADER>'.
            88 HeaderProgramTag       Value '<PROGRAM>'.
             88 AnalizedAtTag       Value '<ANALIZED AT>'.
            88 InputSeedFileTag       Value '<INPUT-SEED-FILE>'.
             88 SavedATTag          Value '<SAVED AT>'.
            88 OutputOptionTag        Value '<OUTPUT-OPTIONS>'.
            88 OutputOptionEndTag     Value '</OUTPUT-OPTIONS>'.
           88 HeaderEndTag              Value '</HEADER>'.

           88 ProgramTag                Value '<PROGRAM>'.

            88 ProgramInfoTag         Value '<PROGRAM-INFO>'.
            88 ProgramInfoEndTag      Value '<PROGRAM-INFO>'.

            88 DDNameTag              Value '<DDNAME>'.
            88 DDNameEndTag           Value '</DDNAME>'.

            88 NameTag                 Value '<NAME>'.
            88 ExternalNameTag         Value '<EXTERNAL-NAME>'.
             88 SizeTag             Value '<SIZE>'.
             88 DimensionsTag       Value '<DIMENSIONS>'.

             88 ResultTag           Value '<RESULT>'.
              88 YearTag          Value '<USED-AS-YEAR>'.
              88 NYearTag         Value '<USED-AS-NON-YEAR>'.
              88 YearNYearTag     Value '<USED-AS-YEAR-AND-NON-YEAR>'.
              88 AYearTag         Value '<ALWAYS-YEAR>'.
              88 ANonYearTag      Value '<ALWAYS-NON-YEAR>'.

               88 IndexTag      Value '<INDEX>'.
               88 LengthTag     Value '<LENGTH>'.
               88 YearReasonTag Value '<YEAR-REASON>'.
               88 NonYearReasonTag Value '<NON-YEAR-REASON>'.
      *           ...'reason' tag values within <YEAR-REASON> entry...
                88 BuiltInC              Value '<BUILTIN-YEAR>'.
                88 CallC       Value '<CALL>'.
                88 CicsFileNmC Value '<CICS-FILE-NAME>'.
                88 CicsFileVarC
                               Value '<CICS-FILE-VARIABLE>'.
                88 DatabaseC   Value '<DATABASE>'.
                88 DDNameC     Value '<DDNAME>'.
                88 IncludeC    Value '<INCLUDE>'.
                88 InferenceC  Value '<INFERENCE>'.
                88 MLEC        Value '<MLE>'.
                88 NameC       Value '<NAME>'.
                88 PatternC    Value '<PATTERN>'.

               88 YearReasonEndTag
                                 Value '</YEAR-REASON>'.
               88 NonYearReasonEndTag
                                 Value '</NON-YEAR-REASON>'.
              88 YearEndTag        Value '</USED-AS-YEAR>'.
              88 NYearEndTag       Value '</USED-AS-NON-YEAR>'.
              88 YearNYearEndTag   Value '</USED-AS-YEAR-AND-NON-YEAR>'.
              88 AYearEndTag       Value '</ALWAYS-YEAR>'.
              88 ANYearEndTag      Value '</ALWAYS-NON-YEAR>'.
             88 ResultEndTag         Value '</RESULT>'.

             88 FileTag              Value '<FILE>'.
              88 Def-PosTag        Value '<DEF-POS>'.
              88 Def-PosEndTag     Value '</DEF-POS>'.
              88 PosTag            Value '<POS>'.
              88 PosEndTag         Value '</POS>'.
             88 FileEndTag           Value '</FILE>'.

            88 NameEndTag              Value '</NAME>'.
            88 ExternalNameEndTag      Value '</EXTERNAL-NAME>'.

            88 IncludeTag              Value '<INCLUDE>'.
            88 IncludeEndTag           Value '</INCLUDE>'.

            88 AnnotateTag             Value '<ANNOTATE>'.
            88 AnnotateEndTag          Value '</ANNOTATE>'.

           88 ProgramEndTag              Value '</PROGRAM>'.

      *............................................*
      *    Tag processing state switches           *
      *............................................*
       01  Level1-Tag-Block          Pic 9 Value 0.
           88  Header-Block                Value 1.
           88  Program-Block               Value 2.
           88  Level1-Tag-Block-Off        Value 0.

      *    ...tag blocks within <PROGRAM>-</PROGRAM> block
       01  Level2-Tag-Block          Pic 9 Value 0.
           88  Program-Info-Block          Value 1.
           88  DDname-Block                Value 2.
           88  Name-Block                  Value 3.
           88  Field-Name-Block            Value 4.
           88  Include-Block               Value 5.

           88  Level2-Tag-Block-Off        Value 0.
           88  Include-Block-Off           Value 0.
           88  DDName-Block-Off            value 0.

      *    ...tag blocks within <NAME>-</NAME> block for a field
       01  Level3-Tag-Block          Pic 9 Value 0.
           88  Result-Block                Value 1.
           88  File-Block                  Value 2.
           88  Level3-Tag-Block-Off        Value 0.

      *................................................*
      *       indicator set by Get-Next-Token routine  *
      *       if '<' is found before next token...     *
      *................................................*
       01  Tag-Beg            Pic 9     value 0.
           88 Tag-Beg-Found             Value 1.
           88 Tag-Beg-Not-Found         Value 0.

      *...Current kind...
       01  Current-Kind       Pic X(3).

      *...Current cause (shown in .XRT report)...
       01  Current-Cause      Pic X(8).
           88 Built-In        Value 'BuiltIn'.
           88 CallCause       Value 'Call'.
           88 CicsFileNm      Value 'CICSFNm'.
           88 CicsFileVar     Value 'CICSFVar'.
           88 DataBase        Value 'DataBase'.
           88 DDName          Value 'DDName'.
           88 Include         Value 'Include'.
           88 Inference       Value 'Inferred'.
           88 MLE             Value 'MLE( : )'.
           88 NameCause       Value 'Name'.
           88 Pattern         Value 'Pattern'.

           88 Cause-Unknown   Value '********'.

      *...Current Ref count...
       01  Current-Ref-Count  Pic 999999.


      *...Tag constants used to scan input file
       01  OpenTag            Pic X     Value '<'.
       01  CloseTag           Pic X     Value '>'.

      *...<PROGRAM> tag status
       01  Program-Tag-Status Pic X       Value '0'.
           88 Program-Tag-Not-In-Progress Value '0'.
           88 Program-Tag-In-Progress     Value '1'.

      *...<NAME> tag status
       01  Name-Tag-Status    Pic X       Value '0'.
           88 Name-Tag-Not-In-Progress    Value '0'.
           88 Name-Tag-In-Progress        Value '1'.

      *...<RESULT> tag status
       01  Result-Tag-Status  Pic X       Value '0'.
           88 Result-Tag-Not-In-Progress  Value '0'.
           88 Result-Tag-In-Progress      Value '1'.

      *...Current file I/O operation
       01  File-IO-Req        Pic X(5)  Value spaces.
           88 OpenFile        Value 'Open'.
           88 CloseFile       Value 'Close'.
           88 ReadFile        Value 'Read'.
           88 WriteFile       Value 'Write'.
           88 SortFile        Value 'Sort'.

      *----------------------------------------------------*
      *   Input file names for .XRL and XSD files          *
      *----------------------------------------------------*
       01  Rpt-In-Name            Pic X(256)
                                  Value spaces.
        01  Rpt-In-Name-Length     Pic 999 Value 1.

       01  Seed-In-Name           Pic X(256)
                                  Value spaces.
        01  Seed-In-Name-Length    Pic 999 Value 1.

      *----------------------------------------------------*
      *   Source file name                                 *
      *----------------------------------------------------*
       01  Source-File-Name       Pic X(256)
                                  Value spaces.
        01  Source-File-Name-Length Pic 999 Value 1.

      *----------------------------------------------------*
      *   System file names for the report output files    *
      *----------------------------------------------------*
       01  Main-Report-File-name  Pic X(256)
                                  Value spaces.
        01  Main-Report-File-Name-Length Pic 999 Value 1.

       01  Xref-Report-File-name  Pic X(256)
                                  Value spaces.
        01  Xref-Report-File-Name-Length Pic 999 Value 1.

      *-----------------------------------------------------------*
      *   Current analysis entry item information                 *
      *   Some are used (possibly) for multiple report entries    *
      *-----------------------------------------------------------*

      *------------------------*
      *   Program name Info    *
      *------------------------*
      *    ...current program name
       01  Current-Program-Name  Pic X(256) value spaces.

      *    ...current program name length
       01  Program-Name-Length   Pic 999    Value 0.

      *--------------------------------------------*
      *   Current Data-Name (variable name) Info   *
      *--------------------------------------------*
      *    ...current (unqualified) data name
       01  Current-Name          Pic X(31)  value spaces.

       01  Name-Length           Pic 999.

      *    ... numbers of <name> tags without </name> yet
       01  No-of-NameTags-Pending Pic 99 Value 0.

      *    ...number of names in the current name structure
       01  No-of-Names-with-Qual  Pic 99 Value 0.

      *    ...Names in the current name structure
      *    ...the top level structure first and the field last
       01  Name-with-Qualifiers.
           02 Data-Name
                   Occurs 1 to 49 Times
                     Depending on No-of-Names-with-Qual
                                      Pic X(31).

       01  Current-Name-Qual     Pic X.
           88 Qualified          Value 'Y'.
           88 Not-Qualified      Value 'N'.

      *----------------------------------------------*
      *   Declaration postion for the current item   *
      *----------------------------------------------*
       01  Current-Def-Pos.
           02 Current-Def-Line   Pic 9(6).
           02 filler             Pic X      value space.
           02 Current-Def-FileID Pic 9999.

      *----------------------------*
      *   Current File Name Info   *
      *----------------------------*
       01  Current-File-Name     Pic X(256) value spaces.
       01  Current-FileID        Pic 9999.

      *---------------------------*
      *   Current "reason" Info   *
      *---------------------------*
       01  Current-Cause-String  Pic X(256) value spaces.
       01  Current-CauseID       Pic 9999.

      *--------------------------------*
      *   Seed line reference Info     *
      *--------------------------------*
       01  Current-Seed-Line     Pic XXXX.

      *    ...Current-Seed-Line set from the last 4 character
      *       positions of Line-No which is padded with spaces
      *       to the left...

      *...In memory table for Seed line numbers referenced in report...
       01  Referenced-Seed-Line-Table.
           02 Seed-Line-Referenced       Pic X
                Occurs 8000 Times.

       01  Max-Seed-Line                 Pic 9(4)
                                         Value zero.

      *    ...Seed file record number just read...
       01  Seed-In-Rec-No                Pic 9(4)
                                         Value zero.

      *-----------------------------------*
      *   Current referencing File-ID     *
      *    It is used in Sort Output Proc *
      *-----------------------------------*
       01  Current-Xref-File-ID   Pic 999
                                  Value 0.

      *----------------------*
      *   Line number Info   *
      *----------------------*
      *...stating line number set by Get-Starting-Line-Number
      *   aligned on right padded with spaces (if any) to the left...
       01  Line-No                      Pic X(6).
           88 Line-No-NA          Value '   n/a'.
           88 Line-No-not-there   Value '******'.
           88 Line-No-Space       Value spaces.

      *    ...same as Line-No but is numeric....
       01  Line-No-9s                   Pic 9(6).


      *    ...number of digits in Line-No...
       01  Line-No-Size           Pic 999  Value 0.


      *    ...Line-No concatenated with Ref type info
       01  Line-No-W-Ref-Type-Info      Pic X(9) Value spaces.
       01  Line-No-W-Ref-Type-Info-Size Pic 99.


      *    ...indicator for if valid Line-No is found.
      *       It is set by Get-Start-Line-Number routine...
       01  Line-No-Found-Status         Pic 9
                                 Value 0.
           88 Line-No-Not-Found  Value 0.
           88 Line-No-Found      Value 1.

       01  Seed-Rec-Length              Pic 999.

      *.................................................*
      *  Processing status for In-Rec                   *
      *.................................................*
       01  In-Rec-Status.

      *    ...Record length for the input record...
           02 In-Rec-Length      Pic 9(4).

      *    ...Starting char position in record buffer to be analyzed...
           02 In-Rec-Pos         Pic 9(4).

      *    ...Number of char positions left in the buffer to be analyzed
           02 In-Rec-Left        Pic S9(4).

      *    ...Ending char position in record buffer analyzed...
           02 In-Rec-Last-Processed-Pos  Pic 9(4).
      *    ...Current input record being processed...

           02 Rpt-In-Record-No   Pic 9(9) value 0.

      *    ...status on whether a "previous" input record exists.
      *       It is used by Get-Rpt-In-Record routine...
           02 In-Rec-Read-Status Pic X value 'N'.
              88 In-Rec-Read           value 'Y'.


      *    ...first <FILE> tag in <PROGRAM-INFO> tag block
       01  File-Tag-in-PROGRAM-INFO         Pic 9  value 0.
           88 First-File-in-Program-Info           Value 0.
           88 Not-First-File-in-Program-Info       value 1.


      *...Tag found switch...
       01  Tag-Found-Sw          Pic 9.
           88 tag-found          Value 1.
           88 tag-not-found      Value 0.

      *...Number of chars from current-pos before the searched char
       01 Count-Before-Found     Pic 9(4).

      *...Indication to prematually terminate the processing
       01 Quit-SW                Pic 9 Value 0.
          88 Quit-this                 Value 1.

      *    ...uptp 100 chars of previous Rpt-In record used for
      *       error messages...
       01  Prev-In-Rec                   Pic X(200).
       01  Prev-In-Rec-Length            Pic 9999.

      *------------------------*
      *   Current token Info   *
      *------------------------*
      *...Area to store a token. This is set by Get-Next-Token,
      *   which is used for all tag entries except for
      *   <COMMENT>, </COMMENT> and <ANNOTATE>...
       01  Token.
           02 Token-Char
                Occurs 1 to 256 Times
                  Depending on Token-Length
                                  Pic X.

      *    ...Length of the current token...
       01  Token-Length           Pic 999.

       01  Previous-Token.
           02 Previous-Token-Char
                Occurs 1 to 256 Times
                  Depending on Previous-Token-Length
                                  Pic X.
      *    ...Length of the previous token...
       01  Previous-Token-Length  Pic 999.

      *    ...Status from Get-Next-Token...
       01  Token-Beg-Found-Status Pic 9  Value 0.
           88 Token-Beg-Found            Value 1.
           88 Token-Beg-Not-Found        Value 0.

       01  Token-Found-Status     Pic 9  Value 0.
           88 Token-Found                Value 1.
           88 Token-Not-Found            Value 0.

      *---------------*
      *   Misc Info   *
      *---------------*
      *    ...Sort Return status...
       01  Sort-Return-Status     Pic 9    Value 0.
           88 Sort-At-End                  Value 1.
           88 Sort-Not-At-End              Value 0.


       01  Last-DN-ID-for-Xref.
           02 Last-DN-for-Xref       Pic X(31).
           02 filler                 Pic X.
           02 Last-Qual-for-Xref     Pic X.
           02 filler                 Pic X.
           02 Last-Def-ID            Pic X(11).
           02 filler                 Pic X.


      *    ...Inference-Source Position and length
       01  Inference-Source-Pos   Pic 999  Value 0.
       01  Inference-Source-Size  Pic 999  Value 0.

      *    ...Reference type informat position and length within Token
       01  Ref-Type-Info-Pos      Pic 99.
       01  Ref-Type-Info-Size     Pic 99.

      *    ...Temporary use in various places...
       01  Temp                   Pic 9(5).
       01  I                      Pic 9(5).
       01  Temp2                  Pic 9(5).

      *================================================================*
       Linkage Section.
      *================================================================*

      *...Arguments received
       01 Arguments.
      *   ...length of Arguments-String...
          02 Arguments-length     Comp-5 Pic 9(4).
      *   ....xrl and .xsd file names separated with a space...
          02 Arguments-string      Pic X(513).

      *================================================================*
       Procedure Division Using Arguments.
      *================================================================*

       Declaratives.
      *==============================================================*
      *   Declaratives to handle file I/O exceptions                 *
      *==============================================================*

      *---------------------------------------------------------*
      *     Declarative for Rpt-In file                         *
      *---------------------------------------------------------*
       Rpt-In-Error Section.
           Use After Error Procedure on Rpt-In.
       Rpt-In-Error-1.
           If Not Rpt-In-EOF
             Then
               Display MSG-INPUT-REPORT-ERROR
               Display MSG-FAILED-OPERATION File-IO-Req '.'
               Display MSG-FILE-STATUS Rpt-In-Fs '.'
               Display MSG-EXECUTION-TERMINATED
               Perform Y2K-Exit-Term-Error-D
               Stop Run
      *    ...should change to GOBACK once the restriction is removed..
             Else
                Next Sentence
           End-If.

      *---------------------------------------------------------*
      *     Declarative for Seed-In file                        *
      *---------------------------------------------------------*
       SeedIn-Error Section.
           Use After Error Procedure on Seed-In.
       SeedIn-Error-1.
           If Not Seed-In-EOF
             Then
               Display MSG-INPUT-SEED-ERROR
               Display MSG-FAILED-OPERATION File-IO-Req '.'
               Display MSG-FILE-STATUS Seed-In-FS '.'
               Display MSG-EXECUTION-TERMINATED
               Perform Y2K-Exit-Term-Error-D
               Stop Run
      *    ...should change to GOBACK once the restriction is removed..
             Else
               Next Sentence
           End-If.

      *---------------------------------------------------------*
      *     Declarative for Rpt-Work  file                      *
      *---------------------------------------------------------*
       Rpt-Work-Error Section.
           Use After Error Procedure on Rpt-Work.
       Rpt-Work-Error-1.
           Display MSG-REPORT-WORK-ERROR
           Display MSG-FAILED-OPERATION File-IO-Req '.'
           Display MSG-FILE-STATUS Rpt-Work-FS '.'
           Display MSG-EXECUTION-TERMINATED
           Perform Y2K-Exit-Term-Error-D
           Stop Run.
      *    ...should change to GOBACK once the restriction is removed..

      *---------------------------------------------------------*
      *     Declarative for Rpt-Main  file                      *
      *---------------------------------------------------------*
       Rpt-Main-Error Section.
           Use After Error Procedure on Rpt-Main.
       Rpt-Main-Error-1.
           Display MSG-REPORT-MAIN-ERROR
           Display MSG-FAILED-OPERATION File-IO-Req '.'
           Display MSG-FILE-STATUS Rpt-Main-FS '.'
           Display MSG-EXECUTION-TERMINATED
           Perform Y2K-Exit-Term-Error-D
           Stop Run.
      *    ...should change to GOBACK once the restriction is removed..

      *---------------------------------------------------------*
      *     Declarative for Rpt-FileID file                     *
      *---------------------------------------------------------*
       Rpt-FileID-Error Section.
           Use After Error Procedure on Rpt-FileID.
       Rpt-FileID-Error-1.
           Display MSG-REPORT-FILE-ERROR
           Display MSG-FAILED-OPERATION File-IO-Req '.'
           Display MSG-FILE-STATUS Rpt-FileID-FS '.'
           Display MSG-EXECUTION-TERMINATED
           Perform Y2K-Exit-Term-Error-D
           Stop Run.
      *    ...should change to GOBACK once the restriction is removed..

      *---------------------------------------------------------*
      *     Declarative for Rpt-Seed file                       *
      *---------------------------------------------------------*
       Rpt-Seed-Error Section.
           Use After Error Procedure on Rpt-Seed-File.
       Rpt-Seed-Error-1.
               Display MSG-REPORT-SEED-FILE-ERROR
               Display MSG-FAILED-OPERATION File-IO-Req '.'
               Display MSG-FILE-STATUS Rpt-Seed-FS '.'
               Display MSG-EXECUTION-TERMINATED
               Perform Y2K-Exit-Term-Error-D
               Stop Run.
      *    ...should change to GOBACK once the restriction is removed..

      *---------------------------------------------------------*
      *     Declarative for Rpt-Xref file                       *
      *---------------------------------------------------------*
       Rpt-Seed-Error Section.
           Use After Error Procedure on Xref-File.
       Rpt-Seed-Error-1.
               Display MSG-REPORT-XREF-FILE-ERROR
               Display MSG-FAILED-OPERATION File-IO-Req '.'
               Display MSG-FILE-STATUS Rpt-Xref-FS '.'
               Display MSG-EXECUTION-TERMINATED
               Perform Y2K-Exit-Term-Error-D
               Stop Run.
      *    ...should change to GOBACK once the restriction is removed..

      *------------------------------------------------------*
      *    Notify Y2K-Exit we are terminating with an error  *
      *       This routine is performed from declaratives.   *
      *------------------------------------------------------*
       Y2K-Exit-Term-Error-D.
           If Y2K-Exit-On and Y2K-Exit-Initialized
             Set Y2K-Exit-Func-Term-Error to true
             Call Y2K-Exit-Program
               Using Y2K-Exit-Func
           End-If.

       End Declaratives.
      *==============================================================*
      *   End of File I/O Error Declaratives                         *
      *==============================================================*

      *==============================================================*
      *   Main processing section starts                             *
      *==============================================================*
       Main-processing Section.
       Start-it.
           Display MSG-REPORT-STARTED

           Move all '0' to Referenced-Seed-Line-Table.
      *..............................................................*
      *    Get current time and set-up time stamp header record      *
      *..............................................................*
       Get-Current-Time.

      *    ...get YYYYMMDD...
           move function current-date(1:8) to Current-YYYYMMDD

             Move Current-YYYY to Current-Year
             Move Which-Month (Current-MM) to Current-Month
             Move Current-DD to Current-Day.

      *    ...get HHMMSSCC...
           Accept Current-HHMMSSCC from Time
             Move Current-HH to Current-Hour
             Move Current-MI to Current-Minute
             Move Current-SS to Current-Second
             Move Current-CC to Current-CentiS

      *...............................................................*
      *    Get and initialize the input file names passed as arg's    *
      *...............................................................*
           Move 0 to Rpt-In-Name-Length, Seed-In-Name-Length
           Move spaces to Rpt-In-Name, Seed-In-Name

           Inspect Arguments-String ( 1: Arguments-Length )
                                 Tallying Rpt-In-Name-Length
                                 For Characters
                                 Before space

           Move Arguments-String ( 1: Rpt-In-Name-Length )
                  to
                Rpt-In-Name
                Xrl-File-Name-in-Header

           Compute Seed-In-Name-Length =
             Arguments-Length - Rpt-In-Name-Length - 1
           Move Arguments-String
                  ( Rpt-In-Name-Length + 2: Seed-In-Name-Length )
             to Seed-In-Name, Seed-File-Name-in-Header.

      *...............................................................*
      *    Done with argument processing and time stamp header init   *
      *    Now ready to do real work                                  *
      *...............................................................*

      *..Open input and work files...                 .
       Open-Some-Files.
           Set OpenFile to true
           Open Input Rpt-In
           Open Output Rpt-Work.

      *    ...Y2K-Exit initialization code...
           If Y2K-Exit-On

             Set Y2K-Exit-Func-Init to true
             Call Y2K-Exit-Program
               Using Y2K-Exit-Func

             If Return-code not = 0
               Then
                 Perform Y2K-Exit-Error
               Else
                 Set Y2K-Exit-Initialized to true
             End-If
           End-If
      *      ...Y2K-Exit initialization code end...

           Perform Get-Rpt-In-Record.

      *---------------------------------------------------------------*
      *   Main processing loop starts                                 *
      *     Process each tag entry (skip over, gether info,           *
      *     and write out Rpt-Work  records) until EOF                *
      *     is reached on Rpt-In file.                                *
      *---------------------------------------------------------------*
       Create-Rpt-Work-from-Input.

      *    ...Go through input till EOF and handle each tag entry.....
           Perform with test before until Rpt-In-EOF or Quit-this

      *      ...Get next tag entry...
             Perform Get-Next-Tag-Entry

      *---------------------------------------------------------------*
      *      Evaluate and process various tag structures and entries  *
      *---------------------------------------------------------------*
             Evaluate True

      *...............................................................*
      *        Process <Header> tag block                             *
      *...............................................................*
               When HeaderTag

                 Set Header-Block to true
                 Move 0 to Rpt-Entry-No

      *          ...get the program name
                 Perform Get-Next-Tag-Entry
                 If ProgramTag
                   Then
                     Perform Get-Next-Token
                     If Token-Not-Found
                       Then
                         Display MSG-PROGRAM-TOKEN-ERROR
                         Perform Quit-It
                       Else
                         Move Token to
                                Rpt-Pgm-name, Current-Program-name,
                                File-ID-Hdr1-2, Seed-Title-Pgm,
                                Xref-Rpt-Pgm-Name
                     End-If
                   Else
                     Display MSG-HEADER-TAG-ERROR
                     Perform Quit-It
                  End-If

      *..............................................................*
      *        Process </HEADER> tag                                 *
      *..............................................................*
               When HeaderEndTag

                 If Header-Block
                   Then
                     Set Level1-Tag-Block-Off to true
                   Else
                     Display MSG-END-HEADER-TAG-ERROR
                     Perform Quit-It
                 End-If

      *..............................................................*
      *        Process <PROGRAM> tag (outside header tag block).     *
      *..............................................................*
               When ProgramTag and Not Header-Block

                 Set Program-Block to true

      *..............................................................*
      *        Process <PROGRAM-INFO> tag                            *
      *..............................................................*
               When ProgramInfoTag

                 Set Program-Info-Block to true

      *..............................................................*
      *        Process <INCLUDE> tag                                 *
      *..............................................................*
               When IncludeTag and     Program-Block
                               and not Name-Block
                               and not Field-Name-Block

                 Set Include-Block to true

      *..............................................................*
      *        Process </INCLUDE> tag                                *
      *..............................................................*
               When IncludeEndTag and Include-Block

                 Set Include-Block-Off to true

      *..............................................................*
      *        Process <DDNAME>                                      *
      *..............................................................*
               When DDNameTag and     Program-Block
                              and not Name-Block
                              and not Field-Name-Block

                 Set DDName-Block to true

      *..............................................................*
      *        Process </DDNAME> tag                                 *
      *..............................................................*
               When DDNameEndTag and DDName-Block

                 Set DDName-Block-Off to true

      *..............................................................*
      *        Process <File> tag within <PROGRAM-INFO> tag block    *
      *..............................................................*
               When FileTag and Program-Info-Block
                            and First-File-in-Program-Info

                 Set Not-First-File-in-Program-Info to true

                 Perform Get-Next-Token

                 If Token-Not-Found
                   Then
                     Display MSG-FILE-TOKEN-ERROR
                     Perform Quit-It
                   Else
                     Move Token-Length to Source-File-Name-Length
                     Move Token to Source-File-Name-in-Header
                  End-IF

      *..............................................................*
      *        Process </PROGRAM-INFO> tag                           *
      *..............................................................*
               When ProgramInfoEndTag and Program-Info-Block

                 Set Level2-Tag-Block-Off to true

      *..............................................................*
      *        Process <NAME> tag within <PROGRAM> tag block         *
      *        (currently handling <EXTERNAL-NAME> as <NAME> also)   *
      *..............................................................*
               When         (NameTag or ExternalNameTag)
                    and     Program-Block
                    and not Include-Block
                    and not DDName-Block
                    and not Result-Block

                 Set Name-Block to true

      *          ....................................................*
      *          . Go through <NAME> tags until one with <SIZE> tag  *
      *          . (i.e. field level <NAME>) is found                *
      *          ....................................................*
                 Perform with test after until SizeTag
                                         or No-Of-Names-with-Qual > 49
                                         or No-of-Names-with-Qual = 0

                   Add 1 to No-of-Names-with-Qual
                   Add 1 to No-of-NameTags-Pending

                   Perform Get-Next-Token

                   If Token-Not-Found
                     Then
                       Display MSG-NAME-TOKEN-ERROR
                       Perform Quit-It
                     Else
                       Move Token to Data-Name (No-of-Names-with-Qual),
                                     Current-Name
                                     Xref-DN
                       Move Token-Length to Name-Length
                   End-IF


                   Perform Get-Next-Tag-Entry

                   If Tag-Not-Found
                     Display MSG-NAME-TAG-ERROR
                     Perform Quit-It
                   End-If

                   If DimensionsTag
                     Perform Get-Next-Tag-Entry
                     If Tag-Not-Found
                       Display MSG-DIMENSIONS-TAG-ERROR
                       Perform Quit-It
                     End-If
                   End-If

                   If not (NameTag or ExternalNameTag or SizeTag)
                     Then
      *                ...This shouldn't happen. But just in case :-)
      *                ...it was <NAME> for <...reason> in non-<NAME>
      *                   block. Its not a <NAME> we are looking for
                       Move 0 to No-of-NameTags-Pending
                       Move 0 to No-of-Names-with-Qual
      *                ...note: this would cause it it to get out of
      *                   the big get-next-tag-entry loop.
                       Set Level2-Tag-Block-Off to true
                   End-If

                 End-Perform

                 If No-of-Names-with-Qual > 49
                   Display MSG-NAME-QUAL-MAX-ERROR
                   Perform Quit-It
                 End-If

                 If No-of-Names-with-Qual > 0
      *            ....................................................*
      *            . Unless it was a bogus <NAME> tag for non-name     *
      *            . (in which case No-of-Names-with-Qual = 0),        *
      *            . at this point we just found <NAME> tag for field  *
      *            ....................................................*


                   Set Field-Name-Block to true

      *            ...indicate if the field is within a structure or not
                   If No-of-Names-with-Qual = 1
                     Then
                       Set Not-Qualified to true
                     Else
                       Set Qualified to true
                   End-If

                 End-If
      *          ...Do some house keeping for the report record Info
      *          Move spaces to Rpt-Ref-No-Grp
      *          Move 0 to Current-Ref-Count, Rpt-Ref-No

      *..............................................................*
      *        Process <RESULT> tag within field level <NAME> tag    *
      *..............................................................*
               When ResultTag and Field-Name-Block

                 Set Result-Block to true

                 Move 0 to Rpt-Entry-No
                 Set Process-Result-Entry to true

      *--------------------------------------------------------------*
      *        Process <USED-AS-YEAR>, <USED-AS-NON-YEAR>,           *
      *                <USED-AS-YEAR-AND-NON-YEAR>, <ALWAYS-YEAR>,   *
      *                and <ALWAYS-NON-YEAR> tags,                   *
      *                and set the Rpt-Kind report entry             *
      *..............................................................*
      *            ...Set the Year Usage column information

               When YearTag and Field-Name-Block
                 Add 1 to Rpt-Entry-No
                 If Rpt-Entry-No > 100,
                   Perform Quit-It
                 End-If
                 Set Kind-Y (Rpt-Entry-No) to true
                 Set Process-Result-Entry to true

               When NYearTag and Field-Name-Block
                 Add 1 to Rpt-Entry-No
                 If Rpt-Entry-No > 100,
                   Perform Quit-It
                 End-If
                 Set Kind-NY (Rpt-Entry-No) to true
                 Set Process-Result-Entry to true

               When YearNYearTag and Field-Name-Block
                 Add 1 to Rpt-Entry-No
                 If Rpt-Entry-No > 100,
                   Perform Quit-It
                 End-If
                 Set Kind-YNY (Rpt-Entry-No) to true
                 Set Process-Result-Entry to true

               When AYearTag and Field-Name-Block
                 Add 1 to Rpt-Entry-No
                 If Rpt-Entry-No > 100,
                   Perform Quit-It
                 End-If
                 Set Kind-AY (Rpt-Entry-No) to true
                 Set Process-Result-Entry to true

               When ANonYearTag and Field-Name-Block
                 Add 1 to Rpt-Entry-No
                 If Rpt-Entry-No > 100,
                   Perform Quit-It
                 End-If
                 Set Kind-ANY (Rpt-Entry-No) to true
                 Set Process-Result-Entry to true

      *..............................................................*
      *       Process <OFFSET> and <LENGTH> tags to be used with     *
      *         <MLE> reason. Expected to be 1 digit values for MLE. *
      *..............................................................*
               When IndexTag and
                    (Rpt-Entry-No not = 0) and
                    Field-Name-Block

                  Perform Get-Next-Token
                  If Token-Length > 10
                    Move 10 to Token-Length
                  End-If
                  Move 0 to Offset (Rpt-Entry-No)
                  Move Token to
                       Offset (Rpt-Entry-No)
                          (10 - Token-Length + 1:Token-Length)

                  If (Rpt-Entry-No > 1)            and
                     (Offset (Rpt-Entry-No) not =
                     Offset (Rpt-Entry-No - 1))    and
                     not MLE
                    Then
                      Subtract 1 from Rpt-Entry-No
                      Set Dont-Process-Result-Entry to true
                    End-If

               When LengthTag and
                    (Rpt-Entry-No not = 0) and
                    Process-Result-Entry and
                    Field-Name-Block

                  Perform Get-Next-Token
                  Move 0 to Size-Value (Rpt-Entry-No)
                  Move Token to
                       Size-Value (Rpt-Entry-No)
                          (10 - Token-Length + 1:Token-Length)

      *..............................................................*
      *        Process </RESULT> tag within field level <NAME> tag   *
      *..............................................................*
               When ResultEndTag and Field-Name-Block and Result-Block
                   Set Level3-Tag-Block-Off to true

      *..............................................................*
      *        Process <(NON-)YEAR-REASON> tag within <RESULT> block *
      *..............................................................*
               When Field-Name-Block                      and
                    (YearReasonTag or NonYearReasonTag)   and
                    Process-Result-Entry

      *          ...set YEAR-REASON or NON-YEAR-REASON indicator..
                 If YearReasonTag
                   Then
                     Set Year-Reason-Y (Rpt-Entry-No) to true
                   Else
                     Set Year-Reason-N (Rpt-Entry-No) to true
                 End-If

      *          ...get and set REASON...
                 Perform Get-Next-Tag-Entry

                 Evaluate True
                   When BuiltInC
                     Set Built-In to true
                   When CallC
                     Set CallCause to true
                   When CICSFileNMC
                     Set CICSFileNM to true
                   When CICSFileVarC
                     Set CICSFileVar to true
                   When DataBaseC
                     Set DataBase to true
                   When DDNameC
                     Set DDName to true
                   When InferenceC
                     Set Inference to true
                   When IncludeC
                     Set Include to true
                   When MLEC
                     Set MLE to true
                   When NameC
                     Set NameCause to true
                   When PatternC
                     Set Pattern to true
                   When other
                     Display MSG-UNKNOWN-REASON-ERROR Current-Tag
                     Set Cause-Unknown to true
                     Perform Quit-It
                 End-Evaluate

                 Move Current-Cause to Rpt-Cause (Rpt-Entry-No)

      *          *....................................................*
      *          .  Get the Seed line number for all reasons except   .
      *          .  for Inference reason. For Inference, get the      .
      *          .  expression used for the inference.                .
      *          *....................................................*

                 Move spaces to Inference-Source (Rpt-Entry-No)
                 Move 1 to Inference-Source-Pos

                 If InferenceC
                   Then
      *              *................................................*
      *              .  Get the inference source information          .
      *              *................................................*
                     Perform Get-Next-Token

                     Perform test before until
                                 Token-Not-Found or
                                 Rpt-In-EOF

      *                ...check if we have enough space left for the
      *                ...token in Inference-Source area............
                       If Inference-Source-Pos + Token-Length >
                            Length of Inference-Source - 8
                         Then
                           Move ' ..etc..'
                             to
                                Inference-Source (Rpt-Entry-No)
                                     (Inference-Source-Pos:)
                         Else
                           Move Token
                                  to
                                Inference-Source (Rpt-Entry-No)
                                     (Inference-Source-Pos:)
                           Compute Inference-Source-Pos =
                                Inference-Source-Pos + Token-Length + 1
                       End-If

                       Perform Get-Next-Token
                     End-Perform

                   Else
      *              *................................................*
      *              .  Get the seed line number                      .
      *              *................................................*
                     Perform test before
                       Until Rpt-In-Record ( In-Rec-Pos: 2 ) = '</'
                        or Rpt-In-EOF

                       Perform Get-Next-Token
                       If Rpt-In-Record ( In-Rec-Pos: 2 ) = '</'
      *                ...if In-Rec-Pos -> '</...>, the token just
      *                   before </...> is in Token...

      *                   get the line number...
                         Perform Get-Start-Line-Number

                         Move Line-No ( 3: 4 )
                                to
                              Current-Seed-Line
                              Rpt-Seed (Rpt-Entry-No)
      *                  ...note Line-No may be 'n/a'...

                          If Line-No-Found
                           Then
      *                      ...indicate this seed line referenced...
                             Move '1' to
                                  Seed-Line-Referenced (Line-No-9s)

      *                     ...see if it is the highest seed line# yet
                            If Line-No-9s > Max-Seed-Line
                             Move Line-No-9s to Max-Seed-Line
                            End-If
                          End-If
                        End-If
                     End-Perform

                  End-If
      *           *..................................................*
      *           .  Done with Seed Line # or Inference source Info  .
      *           *..................................................*

      *..............................................................*
      *        Process <FILE> tag entry within Field-Name-Block      *
      *..............................................................*
               When FileTag and Field-Name-Block

                 Set File-Block to true

      *          ...initialize for Xref info processing
                 Move 1 to Xref-Refs-Pos
                 Move 1 to Xref-Rec-No

      *          ...initialize the last char position in File-Name to 0
                 Move 0 to File-Name-Length

      *          ...get file name tokens until EOF or next tag
      *             as Token-Not-Found...
                 Perform test after until Rpt-In-EOF or Token-Not-Found

                   Perform Get-Next-Token

                   If Not Rpt-In-EOF and Not Token-Not-Found
      *              ...if not the 1st token, insert a space ...
                     If File-Name-Length Not = 0
                       Move space
                         to File-Name (File-Name-Length + 1: 1)
                       Compute File-Name-Length = File-Name-Length + 1
                     End-If

      *              ... move the next (or first) token to File-Name...
                     Move Token
                       to File-Name (File-Name-Length + 1: Token-Length)
                     Compute File-Name-Length
                           = File-Name-Length + Token-Length
                    End-If

                  End-Perform

      *           ...check to see if 0<name<256...
                  If File-Name-Length = 0
                    Then
                      Display MSG-MISSING-FILE-NAME-ERROR
                      Perform Quit-It
                    Else
                     If File-Name-Length > 256
                       Display MSG-FILE-NAME-TRUNCATED
                       Move 256 to File-Name-Length
                     End-If
                 End-If

      *          ...find or create an entry for the file name
                 Perform Process-FileID-Table

      *          ...the file ID is set in Current-FileID at this point..
                 Move Current-FileID to Def-File (Rpt-Entry-No)
                                        Xref-File-ID
                                        Current-Xref-File-Id

      *..............................................................*
      *        Process <DEF-POS> tag entry within File-Block         *
      *..............................................................*
               When Def-PosTag and File-Block

                 Perform Get-Next-Token
                  If Token-Not-Found
                   Then
                     Display MSG-MISSING-LINE-COL-ERROR
                     Perform Quit-It
                   Else
      *              ...get the stating line number...
                     Perform Get-Start-Line-Number

      *              ...store starting line number in Current-Def-Line
                     Move Line-No to Current-Def-Line

      *              ...put FileID in Current-Def-FileID
                     Move Current-FileID to Current-Def-FileID
                                            Xref-File-ID
                 End-If

      *          *...................................................*
      *          * Write out the main analysis report records to     *
      *          * the work file                                     *
      *          *...................................................*
      *          ...prepare and write report entry records for the
      *             name (one for each result entry)...

                 Perform Test After Varying I From 1 By 1
                                    Until I = Rpt-Entry-No

                   Move Current-Name to Rpt-Name (I)
                   Move Current-Name-Qual to Rpt-Qual (I)
                   Move Current-Def-Pos to Rpt-Def-Pos (I)
                   If Rpt-Cause (I) (1:3) = 'MLE'
                     Move Short-Offset(I) to Rpt-Cause (I) (5:1)
                     Move Short-Size(I) to Rpt-Cause (I) (7:1)
                   End-If
      *            ...Write the record to Rpt-Work ...
                   Set WriteFile to true
      *
                   Write Rpt-Work-Record from Rpt-Entry (I)
                 End-Perform
      *          *...................................................*
      *          * Processing for main analysis report for this      *
      *          * data-name complete. Xref report work records      *
      *          * for this data-name are generated during <POS>     *
      *          * tag entry processing.                             *
      *          *...................................................*


      *              ...Tell Y2K-Exit about a data item definition...
      *              If Y2K-Exit-On
      *
      *                Set Y2K-Exit-Func-DataItem-Def to true
      *                Call Y2K-Exit-Program
      *                   Using Y2K-Exit-Func
      *                        Current-Program-Name
      *                        File-Name-in-Table (Current-Def-FileID)
      *                        File-Name-Size     (Current-Def-FileID)
      *                        Current-Name
      *                        Current-Name-Qual
      *                        Qualified-Name-Struct
      *                        Current-Def-Line
      *
      *                 If Return-code not = 0
      *                  Perform Y2K-Exit-Error
      *                End-If
      *               End-If
      *             ...Y2K-Exit code end...

      *..............................................................*
      *        Process <POS> tag within a FILE-BLOCK                 *
      *..............................................................*
               When PosTag and File-Block

      *          ...prepare report entry record...
                 Move spaces to Xref-for-Sort-Only-Grp
                 Move Current-FileID to Xref-File-ID
                 Move ': ' to Xref-File-ID-Del
                 Move Current-Name to Xref-Name-X
                 Move 'X' to Xref-Qual-X
                 Move Current-Def-Pos to Xref-Def-Pos-X
                 Move 1 to Xref-Rec-No

                 Perform Get-Next-Token

                 If Token-Not-Found
                   Display MSG-MISSING-POS-TOKEN
                   Perform Quit-It
                 End-If

      *          ...at least one reference found. process all Ref's...
                 Perform with test After Until Token-Not-Found

      *            ...get and move starting line number
                   Perform Get-Start-Line-Number
                   Move
                     Line-No-9s (7 - Line-No-Size: Line-No-Size)
                      to
                     Line-No-W-Ref-Type-Info

      *            ...get and move reference type information
                   Perform Get-Ref-Type-Info
                   If Ref-Type-Info-Size > 0
                     Move
                       Token (Ref-Type-Info-Pos: Ref-type-Info-Size)
                         to
                       Line-No-W-Ref-Type-Info (Line-No-Size + 1: )
                   End-If

      *            ...calculate the size of the Ref entry
                   Compute
                     Line-No-W-Ref-Type-Info-Size
                       =
                     Line-No-Size + Ref-Type-Info-Size

      *            ...Does it fit in the current ref record?
                   If Length of Xref-Line-Numbers - Xref-Refs-Pos + 1
                      > Line-No-W-Ref-Type-Info-Size

      *              ...yes, it does. Lets move the info in...
                     Then
                       Move
                         Line-No-W-Ref-Type-Info
                          (1: Line-No-W-Ref-Type-Info-Size)
                           to
                         Xref-Line-Numbers ( Xref-Refs-Pos: )
                       Compute
                         Xref-Refs-Pos
                           =
                         Xref-Refs-Pos + Line-No-W-Ref-Type-Info-Size
                           + 1

      *              ...no, it does not fit. Write the current record
                     Else

                       Move Current-Xref-File-ID to Xref-File-Id
                       Set WriteFile to true
                       Write Rpt-Work-Xref-Record from
                             Xref-Work-Record

                       Move 1 to Xref-Refs-Pos
                       Move Spaces to Xref-Line-Numbers
                       Add 1 to Xref-Rec-No
                   End-If

      *            ...go get the next reference entry within <POS> tag
                   Perform Get-Next-Token

                 End-Perform

      *..............................................................*
      *        Process </POS> tag entry within Field-Name-Block      *
      *..............................................................*
      *        When PosEndTag and Field-Name-Block

      *..............................................................*
      *        Process </FILE> tag entry within Field-Name-Block     *
      *..............................................................*
               When FileEndTag and Field-Name-Block

                 Set Level3-Tag-Block-Off to true

      *          ...if any Xref information not written, write it now..
                 If Xref-Refs-Pos > 1
                   Then

                     Move Current-Xref-File-ID to Xref-File-Id

                     Set WriteFile to true
                     Write Rpt-Work-Xref-Record from
                           Xref-Work-Record

                     Move 1 to Xref-Refs-Pos
                     Move Spaces to Xref-Line-Numbers
                     Move 1 to Xref-Rec-No
                   Else
                     Exit
                 End-If

      *..............................................................*
      *        Process </NAME> tag within a NAME-BLOCK               *
      *        (currently handling </EXTERNAL-NAME> as </NAME> also) *
      *..............................................................*
               When (NameEndTag or ExternalNameEndTag) and
                    (Name-Block or Field-Name-Block)

                   Subtract 1 from No-of-NameTags-Pending
                                   No-of-Names-with-Qual

                   If No-of-NameTags-Pending = 0
                     Then
                       Set Level2-Tag-Block-Off to true
                     Else
                       Set Name-Block to true
                   End-If

      *..............................................................*
      *        For any other tag/conditions just skip them over      *
      *..............................................................*
               When Other

                       Exit

             End-Evaluate

           End-Perform

      *    ...Close Rpt-Work file and Rpt-In file (.XSd)...
           Set CloseFile to true
           Close Rpt-Work
           Close Rpt-In
           Display MSG-WORK-FILE-CREATED.

      *--------------------------------------------------------------*
      *   End of main processing loop: Rpt-Work file completed       *
      *--------------------------------------------------------------*

      *--------------------------------------------------------------*
      * Now that we know the program name, decide the                *
      * names for the .XRT and .XRF output files                     *
      *--------------------------------------------------------------*
       Set-Output-Report-File-Names.
           If Rpt-In-Name-Length > 4
             Then
      *        ...replace the last 4 characters of the .XRL file
      *        with '.XRT' and '.XRF'...

               Move Rpt-In-Name-Length
                      to
                    Main-Report-File-Name-Length
                    Xref-Report-File-Name-Length

               Move Rpt-In-Name (1:Rpt-In-Name-Length - 4)
                      to
                    Main-Report-File-Name

               Move '.XRT'
                      to
                    Main-Report-File-Name (Rpt-In-Name-Length - 3:4)

               Move Rpt-In-Name (1:Rpt-In-Name-Length - 4)
                      to
                    Xref-Report-File-Name

               Move '.XRF'
                      to
                    Xref-Report-File-Name (Rpt-In-Name-Length - 3:4)

             Else
      *        ... use program name followed by '.XRT' & '.XRF'

               Compute Main-Report-File-Name-Length
                       Xref-Report-File-Name-Length
                         =
                       Program-Name-Length + 4

               Move Current-Program-Name
                      to
                    Main-Report-File-Name

               Move '.XRT'
                      to
                    Main-Report-File-Name (Program-Name-Length + 1:4)

               Move Current-Program-Name
                      to
                    Xref-Report-File-Name

               Move '.XRF'
                      to
                    Xref-Report-File-Name (Program-Name-Length + 1:4)
           End-If.

      *--------------------------------------------------------------*
      *    Open main report output files                             *
      *      File-ID and Seed-File report files are concatenated     *
      *      to the Main report fil.                                 *
      *--------------------------------------------------------------*
       Open-Reort-Output-Files.

           Set OpenFile to True
           Open output Rpt-Main
           Open Output Xref-File.

      *--------------------------------------------------------------*
      *   Create Rpt-Main file from Rpt-Work  File                   *
      *--------------------------------------------------------------*
      *--------------------------------------------------------------*
      * Create-Report-File1 section sorts records from Rpt-Work      *
      * file based on the data item name and the data item           *
      * definition position (line# and file ID) and writes to        *
      * Rpt-Main  file. Rpt-Main  file also gets                     *
      * report header records.                                       *
      *--------------------------------------------------------------*
       Create-Main-and-Xref-Report Section.

      *..............................................................*
      *   Write header records for the main report                   *
      *..............................................................*
       Write-Main-Report-Headers.
           Set WriteFile to true

      *    ...write report title
           Write Rpt-Main-Record From Rpt-Separator
           Write Rpt-Main-Record From Rpt-Hdr1
           Write Rpt-Main-Record From Time-Stamp-Header

      *    ...write cbl, xsd and xrl file names in the report header
           Write Rpt-Main-Record     From Rpt-Separator
           Write Rpt-Main-Big-Record From Source-File-Name-Header
           Write Rpt-Main-Big-Record From Seed-File-Name-Header
           Write Rpt-Main-Big-Record From Xrl-File-Name-Header

      *    ...write column description headers
           Write Rpt-Main-Record     From Rpt-Separator
           Write Rpt-Main-Record     From Rpt-Hdr2
           Write Rpt-Main-Record     From Rpt-Hdr3
           Write Rpt-Main-Record     From Rpt-Hdr4
           Write Rpt-Main-Record     From Rpt-Hdr5
           Write Rpt-Main-Record     From Rpt-Hdr6
           Write Rpt-Main-Record     From Rpt-Hdr7.

      *..............................................................*
      *   Write header records for the Xref report                   *
      *..............................................................*
       Write-Xref-Report-Headers.
           Set WriteFile to true

      *    ...write report title
           Write Xref-Record         From Rpt-Separator
           Write Xref-Record         From Xref-Rpt-Hdr1
           Write Xref-Record         From Time-Stamp-Header

      *    ...write cbl, xsd and xrl file names in the report header
           Write Xref-Big-Record     From Rpt-Separator
           Write Xref-Big-Record     From Source-File-Name-Header
           Write Xref-Big-Record     From Seed-File-Name-Header
           Write Xref-Big-Record     From Xrl-File-Name-Header

      *    ...write column description headers
           Write Xref-Record         From Rpt-Separator
           Write Xref-Record         From Xref-Rpt-Layout-Hdr1
           Write Xref-Record         From Xref-Rpt-Layout-Hdr2
           Write Xref-Record         From Xref-Rpt-Layout-Hdr2A
           Write Xref-Record         From Xref-Rpt-Layout-Hdr2B
           Write Xref-Record         From Xref-Rpt-Layout-Hdr2C
           Write Xref-Record         From Rpt-Separator.

      *--------------------------------------------------------------*
      *    Sort Rep-Out-Work and write to Rpt-Main and Xref-File     *
      *--------------------------------------------------------------*
       Sort-the-Report.

           Move spaces to Last-DN-ID-for-Xref
           Set SortFile to true
           Sort Sort-Rpt
                on ascending key Rpt-Name-S1
                on ascending key Rep-Def-Pos-S1
                on ascending key Rpt-Qual-S1
                on ascending key Xref-File-ID-S1
                on ascending key Xref-Rec-No-S1
                  with duplicates in order
             using Rpt-Work
             output procedure is Write-to-Report-Output-Files.

      *--------------------------------------------------------------*
      *    Finish up the main report and Xref files                  *
      *--------------------------------------------------------------*
       Finish-up-Report-Files.
      *    ...write a separator line at the end of the file...
           Set WriteFile to true
           Write Rpt-Main-Record from Rpt-Separator
           Write Xref-Record from Rpt-Separator

      *    ...close Rpt-Main  file...
           Set CloseFile to true
           Close Rpt-Main
           Close Xref-File

           Display MSG-REPORTS-CREATED.
      *--------------------------------------------------------------*
      *   End of Create-Main-and Xref-Report Section                 *
      *--------------------------------------------------------------*

      *--------------------------------------------------------------*
      *    Create-Rpt-FileID creates the Rpt-FileID file             *
      *    using the File-ID-Table created earlier.                  *
      *    This FileID report is appended to the Main report if      *
      *    both RptOut and FileID environment variables are set to   *
      *    the same value.                                           *
      *--------------------------------------------------------------*
       Create-Rpt-FileID Section.
       Create-FileID-Report.

      *    Open Extend Rpt-FileID
           Set OpenFile to true
           Open Extend Rpt-FileID.

      *---------------------------------------------------------*
      *   Write Rpt-FileID header records                       *
      *---------------------------------------------------------*
       Write-Rpt-FileID-Headers.
           Set WriteFile to true
           Move spaces to Rpt-FileID-Header-Record
           Write Rpt-FileID-Header-Record
           Write Rpt-FileID-Header-Record from Rpt-Separator
           Write Rpt-FileID-Header-Record from File-ID-Hdr1

      *    ...write column description headers
           Write Rpt-FileID-Header-Record from Rpt-Separator
           Write Rpt-FileID-Header-Record from File-ID-Hdr2
           Write Rpt-FileID-Header-Record from File-ID-Hdr3.

      *---------------------------------------------------------*
      *   Writw records from the File-ID-Table                  *
      *---------------------------------------------------------*
       Write-File-ID-Report-Records.
           Move 1 to IX
           Perform test before until IX > Number-of-Files
             Move spaces to Rpt-FileID-Record
             Move File-ID-in-Table (IX) to File-ID-in-File
             Move File-Name-Size (IX) to Name-Length
             Move File-Name-in-Table (IX) ( 1: Name-Length )
               to File-Name-in-File ( 1: Name-Length )
             Set WriteFile to true
             Write Rpt-FileID-Record
             Add 1 to IX
           End-Perform.

      *    ...write a separator record....
             Set WriteFile to true
             Write Rpt-FileID-Header-Record from Rpt-Separator

      *    ...close Rpt-FileID file (opened output).
           Set CloseFile to true
           Close Rpt-FileID.

           Display MSG-FILE-ID-FILE-CREATED.

      *--------------------------------------------------------------*
      *    Create Seed file report                                   *
      *--------------------------------------------------------------*
       Create-Seed-File-Report.
           Set OpenFile to true
           Open Input Seed-In
           Open Extend Rpt-Seed-File

      *-----------------------------------------------------------*
      *    Write header records for Rpt-Seed file                 *
      *-----------------------------------------------------------*
           Set WriteFile to true
           Move spaces to Rpt-Seed-Header-Record
           Write Rpt-Seed-Header-Record
           Write Rpt-Seed-Header-Record from Rpt-Separator
           Write Rpt-Seed-Header-Record from Rpt-Seed-Title-Record
           Write Rpt-Seed-Header-Record from Rpt-Separator
           Write Rpt-Seed-Header-Record from Rpt-Seed-Column-Header-1
           Write Rpt-Seed-Header-Record from Rpt-Seed-Column-Header-2
           Write Rpt-Seed-Header-Record from Rpt-Seed-Column-Header-3

           Set ReadFile to true
           Read Seed-In

      *-----------------------------------------------------------*
      *    Loop to read seed file record and write a report entry *
      *    if the seed was referenced in the main report.         *
      *-----------------------------------------------------------*
           Perform Test Before Until Seed-In-EOF
                                  or Max-Seed-Line < Seed-In-Rec-No

             Add 1 to Seed-In-Rec-No

      *      ...if this seed was referenced, write a Rpt-Seed entry...
             If Seed-Line-Referenced (Seed-In-Rec-No) = 1
               Move Seed-In-Rec-No to Seed-Line-No
               Move Seed-In-Record to Seed-Line

               Set WriteFile to true
               Write Rpt-Seed-Record from Rpt-Seed-Record-Ws
             End-If

             Set ReadFile to true
             Read Seed-In

           End-Perform

      *-----------------------------------------------------------*
      *    Finish up the Seed report file                         *
      *-----------------------------------------------------------*
      *    ...write end of report separator...
           Set WriteFile to true
           Write Rpt-Seed-Header-Record from Rpt-Separator
           Display MSG-RPT-SEED-FILE-CREATED

      *    ...close seed input and seed report files...
           Set CloseFile to true
           Close Seed-In, Rpt-Seed-File.
      *--------------------------------------------------------------*
      *    End of Rpt-Seed generation                                *
      *--------------------------------------------------------------*

      *--------------------------------------------------------------*
      *    The report generation completed                           *
      *--------------------------------------------------------------*
       We-are-done.
           Display MSG-REPORT-GEN-END.

      *    ...Y2K-Exit termination code...
           If Y2K-Exit-On

             Set Y2K-Exit-Func-Term to true
             Call Y2K-Exit-Program
               Using Y2K-Exit-Func

             If Return-code not = 0
               Perform Y2K-Exit-Error
             End-If
           End-If
      *      ...Y2K-Exit termination code end...

           Goback.
      *==============================================================*
      *   End of main processing section.                            *
      *==============================================================*

      *==============================================================*
      *   Beginning of sections with performed procedures            *
      *==============================================================*
       All-Performed-Functions Section.

      *--------------------------------------------------------------*
      * Sort Output Procedure
      *--------------------------------------------------------------*
      *   Write-to-Analysis-File is used as the output               *
      *   procedure for the sort with Rpt-Work  used as the          *
      *   input file.                                                *
      *   Main report records for Rpt-Main and Xref-File are         *
      *   written from this SORT OUTPUT PROCEDURE.                   *
      *--------------------------------------------------------------*
       Write-to-Report-Output-Files.
      *    ...Sort-Output-Procedure.
           Move 0 to Current-Xref-File-ID

           Perform with test after until Sort-At-End

             Return Sort-Rpt
               At End
                 Set Sort-At-End to true

               Not At END

      *          ...decide if it is a main analysis (i.e. DN)
                 If Record-is-for-DN
                   Then
      *              ...it is an analysis record for DN.
      *                 Write the record to the main report file...
                     Set WriteFile to true
                     Write Rpt-Main-Big-Record from Rpt-Entry-S1

                   Else
      *              ...no, it is a Xref record...
                     Move space to Rpt-Qual-S1
                     Move Rpt-Entry-S1 to Xref-Work-Record
                     Move Xref-Only-Grp to Xref-Ref-Record

      *              ...check if same as the last DN for Xref...
                     If Xref-Name-ID-X Not = Last-DN-ID-for-Xref
                       Move Xref-Name-X to Xref-DN
                       Move Xref-Def-Line-X to Xref-Def-Line
                       Move Xref-Def-File-ID-X to Xref-Def-File-ID
                       Set WriteFile to true
                       Write Xref-Record from Xref-DN-Record
                     End-If

                     If (Xref-Ref-File-ID = Current-Xref-File-ID)
                           and
                        (Xref-Name-ID-X = Last-DN-ID-for-Xref)
                       Then
                         Move spaces to Xref-Ref-File-ID-Grp
                        Else
                         Move Xref-File-ID to
                              Current-Xref-File-ID
                              Xref-Ref-File-ID
                     End-If
      *              ...write Xref analysis record...
                     Set WriteFile to true
                     Write Xref-Record from Xref-Ref-Record

                     Move Xref-Name-ID-X to Last-DN-ID-for-Xref
                   End-If

             End-Return

           End-Perform.

      *-------------------------------------------------*
      *   Read input record                             *
      *-------------------------------------------------*
       Get-Rpt-In-Record.
           If In-Rec-Read
             Move Rpt-In-Record ( 1: In-Rec-Length ) to Prev-In-Rec
             Move In-Rec-Length to Prev-In-Rec-Length
           End-If

      *    ...skip over 0 length record(s) till non 0 length recor
      *       read or EOF reached...
           Perform test after until Rpt-In-EOF
                                    or
                              In-Rec-Length not = 0
      *      ...get next record & set In-Rec-Pos to 1...
             Set ReadFile to true
             Read Rpt-In
      *
      *          display 'in-rec-length = ' in-rec-length
      *          display 'rpt-in-fs = ' rpt-in-fs

      *
             If Not Rpt-In-EOF
               Set In-Rec-Read to true
               Move 1 to In-Rec-Pos
               Move In-Rec-Length to In-Rec-Left
               Add 1 to Rpt-In-Record-No
             End-If

           End-Perform.

      *--------------------------------------------------------------*
      *   Get-Next-Tag-Entry routine                                 *
      *--------------------------------------------------------------*
      *     This routine gets next tag entry (i.e. <...>) and put    *
      *     it into Current-Tag. The Input is scanned in             *
      *     Rpt-In-Record starting at In-Rec-Pos. In-Rec-Pos will be *
      *     set to the character next to '>' (or 1st character of    *
      *     the next record in Rpt-In-Record) at the end of this     *
      *     processing.                                              *
      *     This routine will get additional input records           *
      *     until next tag is found or until EOF is reached          *
      *     on Rpt-In file. If EOF is reached without getting        *
      *     another tag, Tag-Not-Found and Rpt-In-EOF are set        *
      *     to True.                                                 *
      *--------------------------------------------------------------*
       Get-Next-Tag-Entry.

      *    ---------------------------------------------------------
      *       Get to next "<". Read addtional records if necessary
      *    ---------------------------------------------------------
           Set Tag-not-found to true
           Perform Test Before Until Tag-found or
                                     Rpt-In-EOF or
                                     Quit-this

      *      ...look for "<"...
             Move 0 to Count-before-found
             Inspect Rpt-In-Record ( In-Rec-Pos: In-Rec-Left )
               Tallying Count-before-found
               For Characters Before Initial OpenTag

             If Count-Before-Found < In-Rec-Left
               Then
                 Set tag-found to true
               Else
                 Set tag-not-found to true
             End-If

      *      ...if '<' not found in this record, get another...
             If tag-not-found and Not Rpt-In-EOF
               Then
      *          ...if '<' not found in this record, get another...
                 Perform Get-Rpt-In-Record
             End-IF
           End-Perform
      *    --------------------------------------------------------
      *       Either "<" was found or reached EOF w/o "<"*
      *    --------------------------------------------------------

      *    --------------------------------------------------------
      *       If '<' found, look for '>', which must be within
      *       the current record.
      *    --------------------------------------------------------
      *    ...Did we find '<'?...
           If tag-found
             Then
      *        ...set In-Rec-Pos to point to '<'...
               Compute In-Rec-Pos = In-Rec-Pos + Count-Before-Found
      *        ...Set In-Rec-Left (include '<' position)...
               Compute In-Rec-Left = In-Rec-Length - In-Rec-Pos + 1

      *        ...Anything left after '<'?...
               If In-Rec-Left > 1
                 Then
                   Move 0 to Count-before-found
                   Inspect
                     Rpt-In-Record ( In-Rec-Pos + 1: In-Rec-Left - 1)
                     Tallying Count-Before-Found
                     For Characters Before Initial CloseTag

                   If Count-Before-Found < In-Rec-Left
                     Then Set tag-found to true
                     Else set tag-not-found to true
                   End-If
                 Else
                   Set tag-not-found to true
               End-If

      *        ...Did we find '>'?...
               If tag-found
                 Then
      *          ...matching ">" found...
      *            ...set the position where ">" was found...
                   Compute In-Rec-Last-Processed-Pos =
                           In-Rec-Pos + Count-Before-Found + 1
      *            ...move '<...>' found to Current-Tag...
                   Move
                    Rpt-In-Record ( In-Rec-Pos: Count-Before-Found + 2 )
                     to
                    Current-Tag
      *            ...set In-Rec-Pos to the next char beyond ">"...
                   Compute In-Rec-Pos = In-Rec-Last-Processed-Pos + 1
                   Compute In-Rec-Left = In-Rec-Length - In-Rec-Pos + 1
      *            ...if nothing left to process, get a new record...
                   If In-Rec-Left not > 0,
                     Perform Get-Rpt-In-Record
                   End-If
                 Else
      *
      *            ...">" not found in this record. It is an error.
      *              Put out a message and skip to the next "<"....
                   Display MSG-TAG-DELIMITER-ERROR
                   Display MSG-SKIPPING-TAG
      *            ...Get next record to look for a new tag entry...
                   If tag-not-found and Not Rpt-In-EOF
                      Perform Get-Rpt-In-Record
                   End-If
               End-If
      *     Else
      *      ...or we must have reached EOF before finding next '<'.
      *         Rpt-In-EOF and tag-not-found are already set.
      *         Nothing more. Exit Get-Next-Tag-Entry...

           End-If.
      *--------------------------------------------------------------*
      *   End of Get-Next-Tag-Entry processing                       *
      *--------------------------------------------------------------*

      *--------------------------------------------------------------*
      *   Get-Next-Token Routine                                     *
      *--------------------------------------------------------------*
      *     This routine looks for the next token starting           *
      *     at In-Rec-Pos in Rpt-In-Record (delimited by             *
      *     one or more spaces or a line delimitor or a '<'.         *
      *     The token is put into Token. The length of Token         *
      *     is set in Token-Length.                                  *
      *     The In-Rec-Pos is adjusted to point to the character     *
      *     next to the last character for the token.                *
      *     If the token is at the end of the record,                *
      *     a new record is read and In-Rec-Pos is set to 1.         *
      *     If no token is found before next tag or reaching EOF,    *
      *     Token-Not-Found and/or Rpt-In-EOF are set to True.       *
      *--------------------------------------------------------------*
       Get-Next-Token.

      *    ...find the first non space character...

           Set Token-Beg-Not-Found to true
           Set Token-Not-Found to true
           Set Tag-Beg-Not-Found to true
           Set Tag-Not-Found to true

      *    ...loop until non-space character found...
           Perform With Test Before
             Until Token-Beg-Found or Rpt-In-EOF
                or In-Rec-Left = 0 or Tag-Beg-Found

             If Rpt-In-Record ( In-Rec-Pos: 1 ) Not = Space
               Then
                 If Rpt-In-Record ( In-Rec-Pos: 1 ) = '<'
                   Then
                     Set Tag-Beg-Found to true
                   Else
                     Set Token-Beg-Found to true
                 End-If
               Else
      *         ...In-Rec-Pos points to a space...
                Add 1 to In-Rec-Pos
                Subtract 1 from In-Rec-Left
                If In-Rec-Left not > 0 and Not Rpt-In-EOF
                  Perform Get-Rpt-In-Record
                End-If
              End-If

            End-Perform

      *     ...Check to see if a token was found...
            If Token-Beg-Found
              Then
      *         ...look for the end of the token...
                Move 0 to Count-Before-Found
                Inspect Rpt-In-Record (In-Rec-Pos: In-Rec-Left )
                  Tallying Count-Before-Found for characters
                  Before Initial Space

                Move 0 to Temp
                Inspect Rpt-In-Record (In-Rec-Pos: In-Rec-Left )
                  Tallying Temp for characters
                  Before Initial '<'

                If Temp < Count-Before-Found
                  Move Temp to Count-Before-Found
                End-If

                Move Count-Before-Found to Token-Length
                Move Rpt-In-Record ( In-Rec-Pos: Token-Length )
                  to Token
                Set Token-Found to true
              Else
                Set Token-Not-Found to true
            End-If

      *     ...set-up for next analysis...
            If Tag-Beg-Not-Found
              Add Count-Before-Found to In-Rec-Pos
      *       ...note: if Tag-Beg-Found, the next non-space
      *                char was '<'. Leave In-Rec-Pos alone...
            End-If

            Subtract 1 from In-Rec-Left
            If In-Rec-Left not > 0 and Not Rpt-In-EOF
              Perform Get-Rpt-In-Record
            End-If.

      *--------------------------------------------------------------*
      *   End-of-Next-Token routin                                   *
      *     Either the token is in Token or Token-Not-Found is set.  *
      *--------------------------------------------------------------*

      *--------------------------------------------------------------*
      *   Get-Start-Line-Number Routine                              *
      *--------------------------------------------------------------*
      *     Given a StartLine.Col.EndLine.Col token in Token from    *
      *     <DEF-POS>, <REASON> or <POS> entry, this routine         *
      *     returns the startingline number in Line-No               *
      *     right adjusted (padded with spaces on the left)          *
      *     if necessary.                                            *
      *--------------------------------------------------------------*
       Get-Start-Line-Number.
      *    ...Locate '.' as the line number terminator...
           Move 0 to Count-Before-Found
           Inspect Token
             Tallying Count-Before-Found for characters
             Before Initial '.'

           Move Count-Before-Found to Line-No-Size
           If Line-No-Size > 6 or
              Token ( 1: Line-No-Size ) Not Numeric

      *      ...if > 6 digits or not-numeric, it is not a line #...
             Then
               Set Line-No-Not-Found to true
      *        ...set Line-No to '   n/a'...
               Set Line-No-NA to true

             Else
               Set Line-No-Found to true
      *        ...move line number to Line-No right adjusted...
               Move spaces to Line-No
               Move zeroes to Line-No-9s
               Move Token ( 1: Line-No-Size )
                 to Line-No    ( 7 - Line-No-Size: Line-No-Size ),
                    Line-No-9s ( 7 - Line-No-Size: Line-No-Size )

           End-If.
      *--------------------------------------------------------------*
      *   End of Get-Start-Line-Number Routine                       *
      *--------------------------------------------------------------*

      *--------------------------------------------------------------*
      *   Get-Ref-Type-Info Routine                                  *
      *--------------------------------------------------------------*
      *     Given a StartLine.Col.EndLine.Col token in Token, this   *
      *     routine returns the character string indicating the      *
      *     reference type at the end of the reference token.        *
      *                                                              *
      *     It returns the position of reference type info string    *
      *     within Token in Ref-Type-Info-Pos and the size           *
      *     in Ref-Type-Info-Size.                                   *
      *--------------------------------------------------------------*
       Get-Ref-Type-Info.
           Move 1 to Ref-Type-Info-Pos

      *    ...look for the first alphanumeric char in Token
           Perform with test before Until
              Ref-Type-Info-Pos > Token-Length
             or
              Token ( Ref-Type-Info-Pos: 1) is alphabetic

             Add 1 to Ref-Type-Info-Pos
           End-Perform

      *    ...calculate the length of type info (should be 1, 2 or 3)
           Compute Ref-Type-Info-Size =
                   Token-Length - Ref-Type-Info-Pos + 1

      *    ...Verify the result is valid
           If Ref-Type-Info-Size > 3
             Display MSG-POSITION-ERROR
             Display MSG-POSITION-SIZE Ref-Type-Info-Size
             Display MSG-POSITION-POS Ref-Type-Info-Pos
             Perform Quit-It
           End-If.
      *--------------------------------------------------------------*
      *   End of Get-Ref-Type-Info Routine                           *
      *--------------------------------------------------------------*

      *--------------------------------------------------------------*
      *   Process-FileID-Table Routine:                              *
      *--------------------------------------------------------------*
      *     Given a file name this routine either find an entry      *
      *     in File-ID-Table or, if not found, creates a new entry   *
      *     for the file name. The File-ID associated with the       *
      *     file name is returned in Current-FileID.                 *
      *--------------------------------------------------------------*
       Process-FileID-Table.

           If Number-of-Files = 0

             Then
      *        ...Table is empty. Add new one in the table...
               Move 1 to File-ID-No (1), Number-of-Files
               Move File-ID-in-Table (1) to File-ID, Current-FileID
               Move File-Name-Length to File-Name-Size (1)
               Move File-Name (1: File-Name-Length)
                 to File-Name-in-Table (1)

      *       ...Tell Y2K-exit routine about a new source file...
              If Y2K-Exit-ON
                Perform Y2K-Exit-NewSource
              End-If
      *       ...End of call to Y2K-Exit...

             Else
      *        ...Table has entries...
               Set FileID-IX to 1

      *        ---------------------------------------------------
      *           Search matching file name in File-ID-Table
      *        ---------------------------------------------------
               Search File-ID-Table-Entry
                 At End
      *            ...Matching file name not found. Add new one...
      *               ...set file ID column in the new entry...
                   Add 1 to Number-of-Files
                   Move Number-of-Files
                     to File-ID-No (Number-of-Files)
      *                ...set Current-FileID...
                   Move File-ID-in-Table (Number-of-Files)
                     to Current-FileID
      *                 ...set the file name column in the new entry...
                   Move File-Name-Length
                     to File-Name-Size (Number-of-Files)
                   Move File-Name (1: File-Name-Length)
                     to File-Name-in-Table (Number-of-Files)

      *            ...Tell Y2K-exit routine about a new source file...
                   If Y2K-Exit-ON
                     Perform Y2K-Exit-NewSource
                   End-If
      *           ...End of call to Y2K-Exit...

                 When File-Name-in-Table (FileID-IX)
                        = File-Name ( 1: File-Name-Length )
                    and
                      File-Name-Size (FileID-IX)
                        = File-Name-Length

      *            ...Matching file name found. Get the file ID...
                   Set IX to FileID-IX
                   Move File-ID-in-Table (IX) to Current-FileID
               End-Search
      *        ---------------------------------------------------

             End-If.
      *--------------------------------------------------------------*
      *   End of Process-FileID-Table Routine                        *
      *--------------------------------------------------------------*

      *--------------------------------------------------------------*
      *   Invoke Y2K-Exit routine for a new sporce file              *
      *--------------------------------------------------------------*
       Y2K-Exit-NewSource.
           Set Y2K-Exit-Func-Source to true
           Call Y2K-Exit-Program
             Using
               Y2K-Exit-Func
               Current-Program-Name
               File-Name-in-Table (Number-of-Files)
               File-Name-Size (Number-of-Files)

           If Return-Code not = 0
             Perform Y2K-Exit-Error
           End-If.

      *--------------------------------------------------------------*
      *   Quit-It (internal error detected) Routine                  *
      *--------------------------------------------------------------*
      *     Currently setup to quit processing rater than continuing *
      *     at the next tag.                                         *
      *--------------------------------------------------------------*
       Quit-It.
           Display MSG-ERROR-DETECTED

      *    ...if still not finished with Rpt-In file, identify the line
      *       which caused the error...
           If not Rpt-In-EOF
      *      ...if In-Rec-Pos = 1, the error is in the previous line...
             If In-Rec-Pos = 1
               Then
                 Compute Temp2 = Rpt-In-Record-No - 1
                 Display MSG-ERROR-LINE-NO Temp2 '.'
                 Display MSG-INPUT-RECORD
                   Prev-In-Rec ( 1: Prev-In-Rec-Length )
               Else
                 Display MSG-ERROR-LINE-NO Rpt-In-Record-No '.'
                 Display MSG-INPUT-RECORD
                   Rpt-In-Record ( 1: In-Rec-Length)
             End-If
           End-If

      *    ...if more records to process, continue...
      *    If Rpt-In-EOF
      *      Then
               Display MSG-EXECUTION-TERMINATED
               Perform Y2K-Exit-Term-Error
               Goback
      *      Else
      *        Display 'Processing will be attempted at next tag.'
      *     End-If.
            Exit.

      *----------------------------------------------------------------*
      *   This routine handles cases when Y2K-Exit program returned    *
      *   non-zero Return-Code.                                        *
      *----------------------------------------------------------------*
       Y2K-Exit-Error.
           Display MSG-EXIT-FAILED
           Display MSG-EXIT-FUNCTION Y2K-Exit-Func
           Display MSG-EXIT-RETURN-CODE Return-Code
           Perform Y2K-Exit-Term-Error
           Goback.

      *----------------------------------------------------------------*
      *   Notify Y2K-Exit routine that we are terminating with         *
      *   an error.                                                    *
      *----------------------------------------------------------------*
       Y2K-Exit-Term-Error.
           If Y2K-Exit-On and
              Y2K-Exit-Initialized

             Set Y2K-Exit-Func-Term-Error to true
             Call Y2K-Exit-Program
               Using Y2K-Exit-Func

           End-If.

      *================================================================*
       End Program dczy2kr.
      *================================================================*
      *================================================================*
      *  End of dczy2kr program                                        *
      *================================================================*
