
/*
 * This file was generated by the SOM Compiler.
 * FileName: wpstutor.c.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emitc: 1.24
 */

/*
 *
 *
 *   Module Name: WPSTUTOR
 *
 *   Description: OS/2 Work Place Shell Sample Program
 *
 *                This class subclasses the WPDataFile class.  Most WPS
 *                instance and class methods are overridden to invoke
 *                'DisplayMethodInfo'.  This function uses a named pipe
 *                to communicate with the 'Show Method Description'
 *                (SHOWDESC.EXE) program, which displays the name and a
 *                description of the method that invoked
 *                'DisplayMethodInfo'.
 *
 *   Copyright (C) 1993 IBM Corporation
 *
 *       DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
 *       sample code created by IBM Corporation. This sample code is not
 *       part of any standard or IBM product and is provided to you solely
 *       for  the purpose of assisting you in the development of your
 *       applications.  The code is provided "AS IS", without
 *       warranty of any kind.  IBM shall not be liable for any damages
 *       arising out of your use of the sample code, even if they have been
 *       advised of the possibility of such damages.
 *
 */


#define WPSTutorial_Class_Source
#define M_WPSTutorial_Class_Source
#define MAX_TITLE_LENGTH   128
#include "wpstutor.ih"              /* Implementation header emitted from    */
                                    /*   WPSTUTOR.IDL                        */


#include "methodid.h"               /* Method IDs sent to SHOWDESC.EXE       */
#include <stdio.h>


/*********************** NON-METHOD FUNCTION PROTOTYPES ***********************
******************************************************************************/
MRESULT EXPENTRY WPSTutorWndProc( HWND hwnd, ULONG msg, MPARAM mp1,
                                  MPARAM mp2 );
ULONG   DisplayMethodThread(VOID);
VOID    DisplayMethodInfo(ULONG ulMethodID);


/********************************** DEFINES ***********************************
******************************************************************************/
#define DISPLAY_PROGRAM_NAME "ShowDesc.EXE\0"
                                 /* File name of the Show Method Description */
                                 /*   program                                */
#define NPIPE_COUNT   0x0002     /* Instance count for the pipe used to      */
                                 /*   communicate with Show Method Desc.     */


/***************** GLOBAL/STATIC (NON-INSTANCE) DATA SECTION ******************
*****                                                                     *****
*****    This data shouldn't be changed by instance methods or it will    *****
*****    effect all instances!  Any variables that are specific (unique   *****
*****    values) for each instance of this object should be declared as   *****
*****  instance data or dynamically allocated and stored as window data.  *****
*****                                                                     *****
*****      This global data should be declared as class instance data     *****
*****    if it will change after initialization.  In this case, it will   *****
*****                  be accessed through class methods.                 *****
*****                                                                     *****
******************************************************************************/

CHAR    szTutorialWindowClass[] = "WPSTUTORSAMPLE";
                                 /* Window class name for the                */
                                 /*   'Open tutorial' view                   */
HPIPE   hNPipe;                  /* Pipe used to communicate with            */
                                 /*   SHOWDESC.EXE                           */
PID     ShowMethDescPID;         /* PID for SHOWDESC.EXE process             */
BOOL    fProgramStarted = FALSE; /* Flag indicating if the SHOWDESC.EXE      */
                                 /*   program is up                          */
HMODULE hmod = NULLHANDLE;       /* Module handle for the class DLL          */


/*************************  INSTANCE METHODS SECTION  *************************
*****                                                                     *****
*****              Do not put any code in this section unless             *****
*****                   it is an object INSTANCE method                   *****
*****                                                                     *****
******************************************************************************/

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMInstance

/*
 *
 *  METHOD: DisplayTitleInfo                               ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    This method handles the processing of the "Open tutorial" menu item
 *    in the "Open" menu of the object's context menu.  The method creates a
 *    PM window in order to display the (backwards) title of the object in
 *    the window's title bar.
 *
 *  RETURN:
 *
 *    HWND - Handle to the window created
 *
 */

SOM_Scope HWND   SOMLINK wpstut_DisplayTitleInfo(WPSTutorial *somSelf)
{
   HAB         hab;                     /* PM anchor block handle            */
   PWINDOWDATA pWindowData;             /* Instance data reserved storage    */
   FRAMECDATA  flFrameCtlData;          /* Frame control data                */
   HWND        hwndFrame = NULLHANDLE;  /* Frame window handle               */
   HWND        hwndClient = NULLHANDLE; /* Client window handle              */

   /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
   WPSTutorialMethodDebug("WPSTutorial","wpstut_DisplayTitleInfo");

   /*
   **  Get the anchor block so we can register the window class.
   */
   hab = WinQueryAnchorBlock(HWND_DESKTOP);

   if (!WinRegisterClass(hab,
                         szTutorialWindowClass,
                         (PFNWP)WPSTutorWndProc ,
                         CS_SYNCPAINT,
                         sizeof(pWindowData)))
   {
      DebugBox("DisplayTitleInfo", "Failure in WinRegisterClass");
      return NULLHANDLE ;
   }

   /*
   **  Allocate some instance specific data in the Window words of the Frame
   **  window.  This will insure that our window procedure can use the
   **  object's methods because our window procedure isn't passed a
   **  *somSelf pointer.
   */
   pWindowData = (PWINDOWDATA) _wpAllocMem(somSelf, sizeof(*pWindowData), NULL);

   if (!pWindowData)
   {
      DebugBox("DisplayTitleInfo", "wpAllocMem failed to allocate pWindowData");
      return NULLHANDLE;
   }

   /*
   **  Initialize the instance data
   */
   memset((PVOID) pWindowData, 0, sizeof(*pWindowData));
   pWindowData->cb = sizeof(*pWindowData);
   pWindowData->somSelf = somSelf;

   /*
   **  Create a frame window as a child of the desktop to allow the user to
   **  manipulate the window.  Set the frame control data so the frame has a
   **  title bar, system menu, minimize and maximize buttons, and a sizing
   **  border.
   */
   flFrameCtlData.cb            = sizeof(flFrameCtlData);
   flFrameCtlData.flCreateFlags = FCF_TITLEBAR | FCF_SYSMENU | FCF_MINMAX |
                                  FCF_SIZEBORDER | FCF_SHELLPOSITION;
   flFrameCtlData.hmodResources = hmod;
   flFrameCtlData.idResources   = 0;

   hwndFrame = WinCreateWindow(
      HWND_DESKTOP,             /* Parent-window handle                      */
      WC_FRAME,                 /* Registered-class name (Frame)             */
      _wpQueryTitle(somSelf),   /* Window text                               */
      0,                        /* Window style                              */
      0, 0, 0, 0,               /* Window position (x, y, width, height)     */
      NULLHANDLE,               /* Owner-window handle                       */
      HWND_TOP,                 /* Sibling-window handle (on top of all)     */
      (USHORT) ID_FRAME,        /* Window identifier                         */
      (PVOID) &flFrameCtlData,  /* Class-specific control data               */
      NULL);                    /* Presentation parameters (none)            */

   if (!hwndFrame)
   {
      DebugBox("DisplayTitleInfo", "Failure in WinCreateWindow (Frame)");
      return NULLHANDLE;
   }

   /*
   **  Create a client window as a child of the frame for use by the object
   **  to display information and solicit user input.
   */
   hwndClient = WinCreateWindow(
         hwndFrame,             /* Parent-window handle (create object win)  */
         szTutorialWindowClass, /* Registered-class name (our class)         */
         NULL,                  /* Window text                               */
         0,                     /* Window style                              */
         0, 0, 0, 0,            /* Window position (x, y, width, height)     */
         hwndFrame,             /* Owner-window handle                       */
         HWND_TOP,              /* Sibling-window handle                     */
         (USHORT)FID_CLIENT,    /* Window identifier (client window)         */
         pWindowData,           /* Control data                              */
         NULL);                 /* Presentation parameters (none)            */

   if (!hwndClient)
   {
      WinDestroyWindow(hwndFrame);
      DebugBox("DisplayTitleInfo", "Failure in WinCreateWindow (Client)");
      return NULLHANDLE;
   }

   /*
   **  Set the icon to be associated with the window with the icon for
   **  the class.
   */
   WinSendMsg(hwndFrame, WM_SETICON, MPFROMP(_wpQueryIcon(somSelf)), NULL);

   /*
   **  Restore the window position. NOTE: If there is no stored location,
   **  the window position will be determined by the shell due to the
   **  FCF_SHELLPOSITION frame creation flag.
   */
   WinRestoreWindowPos(szTutorialWindowClass, _wpQueryTitle(somSelf),
                       hwndFrame);

   /*
   **  Make the window visible.
   */
   WinShowWindow(hwndFrame, TRUE);

   return hwndFrame;                                              /* success */
}


/************************ OVERRIDDEN INSTANCE METHODS *************************
******************************************************************************/

/*
 *
 *   METHOD: wpAddFileMenuPage                              ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *      This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpAddFileMenuPage(WPSTutorial *somSelf,
                HWND hwndNotebook)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpAddFileMenuPage");

    DisplayMethodInfo(IDS_WPADDFILEMENUPAGE);

    return (parent_wpAddFileMenuPage(somSelf,hwndNotebook));
}

/*
 *
 *   METHOD: wpAddFileTypePage                              ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *      This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpAddFileTypePage(WPSTutorial *somSelf,
                HWND hwndNotebook)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpAddFileTypePage");

    DisplayMethodInfo(IDS_WPADDFILETYPEPAGE);

    return (parent_wpAddFileTypePage(somSelf,hwndNotebook));
}

/*
 *
 *   METHOD: wpAddFile1Page                                 ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *      This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpAddFile1Page(WPSTutorial *somSelf,
                HWND hwndNotebook)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpAddFile1Page");

    DisplayMethodInfo(IDS_WPADDFILE1PAGE);

    return (parent_wpAddFile1Page(somSelf,hwndNotebook));
}

/*
 *
 *   METHOD: wpAddFile2Page                                 ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *      This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpAddFile2Page(WPSTutorial *somSelf,
                HWND hwndNotebook)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpAddFile2Page");

    DisplayMethodInfo(IDS_WPADDFILE2PAGE);

    return (parent_wpAddFile2Page(somSelf,hwndNotebook));
}

/*
 *
 *   METHOD: wpAddFile3Page                                 ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *      This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpAddFile3Page(WPSTutorial *somSelf,
                HWND hwndNotebook)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpAddFile3Page");

    DisplayMethodInfo(IDS_WPADDFILE3PAGE);

    return (parent_wpAddFile3Page(somSelf,hwndNotebook));
}

/*
 *
 *   METHOD: wpAddObjectGeneralPage                         ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *      This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpAddObjectGeneralPage(WPSTutorial *somSelf,
                HWND hwndNotebook)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpAddObjectGeneralPage");

    DisplayMethodInfo(IDS_WPADDOBJECTGENERALPAGE);

    return (parent_wpAddObjectGeneralPage(somSelf,hwndNotebook));
}

/*
 *
 *   METHOD: wpAddSettingsPages                             ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *      This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpAddSettingsPages(WPSTutorial *somSelf,
                HWND hwndNotebook)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpAddSettingsPages");

    DisplayMethodInfo(IDS_WPADDSETTINGSPAGES);

    return (parent_wpAddSettingsPages(somSelf,hwndNotebook));
}

/*
 *
 *   METHOD: wpAddToObjUseList                              ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *      This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpAddToObjUseList(WPSTutorial *somSelf,
                PUSEITEM pUseItem)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpAddToObjUseList");

    DisplayMethodInfo(IDS_WPADDTOOBJUSELIST);

    return (parent_wpAddToObjUseList(somSelf,pUseItem));
}

/*
 *
 *   METHOD: wpAllocMem                                     ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *      This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope PBYTE   SOMLINK wpstut_wpAllocMem(WPSTutorial *somSelf,
                ULONG cbBytes,
                PULONG prc)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpAllocMem");

    DisplayMethodInfo(IDS_WPALLOCMEM);

    return (parent_wpAllocMem(somSelf,cbBytes,prc));
}

/*
 *
 *   METHOD: wpClose                                        ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpClose(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpClose");

    DisplayMethodInfo(IDS_WPCLOSE);

    return (parent_wpClose(somSelf));
}

/*
 *
 *   METHOD: wpCopiedFromTemplate                           ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope void   SOMLINK wpstut_wpCopiedFromTemplate(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpCopiedFromTemplate");

    DisplayMethodInfo(IDS_WPCOPIEDFROMTEMPLATE);

    parent_wpCopiedFromTemplate(somSelf);
}

/*
 *
 *   METHOD: wpCopyObject                                   ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope WPObject *  SOMLINK wpstut_wpCopyObject(WPSTutorial *somSelf,
                WPFolder *Folder,
                BOOL fLock)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpCopyObject");

    DisplayMethodInfo(IDS_WPCOPYOBJECT);

    return (parent_wpCopyObject(somSelf,Folder,fLock));
}

/*
 *
 *   METHOD: wpCreateFromTemplate                           ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope WPObject *  SOMLINK wpstut_wpCreateFromTemplate(WPSTutorial *somSelf,
                WPFolder *folder,
                BOOL fLock)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpCreateFromTemplate");

    DisplayMethodInfo(IDS_WPCREATEFROMTEMPLATE);

    return (parent_wpCreateFromTemplate(somSelf,folder,fLock));
}

/*
 *
 *   METHOD: wpCreateShadowObject                           ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope WPObject *  SOMLINK wpstut_wpCreateShadowObject(WPSTutorial *somSelf,
                WPFolder *Folder,
                BOOL fLock)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpCreateShadowObject");

    DisplayMethodInfo(IDS_WPCREATESHADOWOBJECT);

    return (parent_wpCreateShadowObject(somSelf,Folder,fLock));
}

/*
 *
 *   METHOD: wpDelete                                       ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpDelete(WPSTutorial *somSelf,
                ULONG fConfirmations)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpDelete");

    DisplayMethodInfo(IDS_WPDELETE);

    return (parent_wpDelete(somSelf,fConfirmations));
}

/*
 *
 *   METHOD: wpDeleteFromObjUseList                         ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpDeleteFromObjUseList(WPSTutorial *somSelf,
                PUSEITEM pUseItem)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpDeleteFromObjUseList");

    DisplayMethodInfo(IDS_WPDELETEFROMOBJUSELIST);

    return (parent_wpDeleteFromObjUseList(somSelf,pUseItem));
}

/*
 *
 *   METHOD: wpDoesObjectMatch                              ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpDoesObjectMatch(WPSTutorial *somSelf,
                PVOID pvoidExtendedCriteria)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpDoesObjectMatch");

    DisplayMethodInfo(IDS_WPDOESOBJECTMATCH);

    return (parent_wpDoesObjectMatch(somSelf,pvoidExtendedCriteria));
}

/*
 *
 *   METHOD: wpDraggedOverObject                            ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope MRESULT   SOMLINK wpstut_wpDraggedOverObject(WPSTutorial *somSelf,
                WPObject *DraggedOverObject)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpDraggedOverObject");

    DisplayMethodInfo(IDS_WPDRAGGEDOVEROBJECT);

    return (parent_wpDraggedOverObject(somSelf,DraggedOverObject));
}

/*
 *
 *   METHOD: wpDragOver                                     ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope MRESULT   SOMLINK wpstut_wpDragOver(WPSTutorial *somSelf,
                HWND hwndCnr,
                PDRAGINFO pdrgInfo)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpDragOver");

    DisplayMethodInfo(IDS_WPDRAGOVER);

    return (parent_wpDragOver(somSelf,hwndCnr,pdrgInfo));
}

/*
 *
 *   METHOD: wpDrop                                         ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope MRESULT   SOMLINK wpstut_wpDrop(WPSTutorial *somSelf,
                HWND hwndCnr,
                PDRAGINFO pdrgInfo,
                PDRAGITEM pdrgItem)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpDrop");

    DisplayMethodInfo(IDS_WPDROP);

    return (parent_wpDrop(somSelf,hwndCnr,pdrgInfo,pdrgItem));
}

/*
 *
 *   METHOD: wpDroppedOnObject                              ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpDroppedOnObject(WPSTutorial *somSelf,
                WPObject *DroppedOnObject)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpDroppedOnObject");

    DisplayMethodInfo(IDS_WPDROPPEDONOBJECT);

    return (parent_wpDroppedOnObject(somSelf,DroppedOnObject));
}

/*
 *
 *   METHOD: wpEndConversation                              ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope MRESULT   SOMLINK wpstut_wpEndConversation(WPSTutorial *somSelf,
                ULONG ulItemID,
                ULONG flResult)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpEndConversation");

    DisplayMethodInfo(IDS_WPENDCONVERSATION);

    return (parent_wpEndConversation(somSelf,ulItemID,flResult));
}

/*
 *
 *   METHOD: wpFilterPopupMenu                              ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpFilterPopupMenu(WPSTutorial *somSelf,
                ULONG ulFlags,
                HWND hwndCnr,
                BOOL fMultiSelect)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpFilterPopupMenu");

    DisplayMethodInfo(IDS_WPFILTERPOPUPMENU);

    return (parent_wpFilterPopupMenu(somSelf,ulFlags,hwndCnr,fMultiSelect));
}

/*
 *
 *   METHOD: wpFindUseItem                                  ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope PUSEITEM   SOMLINK wpstut_wpFindUseItem(WPSTutorial *somSelf,
                ULONG type,
                PUSEITEM pCurrentItem)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpFindUseItem");

    DisplayMethodInfo(IDS_WPFINDUSEITEM);

    return (parent_wpFindUseItem(somSelf,type,pCurrentItem));
}

/*
 *
 *   METHOD: wpFormatDragItem                               ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpFormatDragItem(WPSTutorial *somSelf,
                PDRAGITEM pdrgItem)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpFormatDragItem");

    DisplayMethodInfo(IDS_WPFORMATDRAGITEM);

    return (parent_wpFormatDragItem(somSelf,pdrgItem));
}

/*
 *
 *   METHOD: wpFree                                         ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to disconnect and close the named pipe
 *     created to communicate with the 'Show Method Description'
 *     (SHOWDESC.EXE) program.  This method also kills that program.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpFree(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpFree");

    /*
    **  Disconnect and close the pipe used to communicate with the
    **  'Show Method Description' program.
    */
    DosDisConnectNPipe(hNPipe);
    DosClose(hNPipe);

    /*
    **  Kill the 'Show Method Description' process.
    */
    DosKillProcess(DKP_PROCESSTREE, ShowMethDescPID);

    return (parent_wpFree(somSelf));
}

/*
 *
 *   METHOD: wpFreeMem                                      ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpFreeMem(WPSTutorial *somSelf,
                PBYTE pByte)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpFreeMem");

    DisplayMethodInfo(IDS_WPFREEMEM);

    return (parent_wpFreeMem(somSelf,pByte));
}

/*
 *
 *   METHOD: wpHide                                         ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpHide(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpHide");

    DisplayMethodInfo(IDS_WPHIDE);

    return (parent_wpHide(somSelf));
}

/*
 *
 *   METHOD: wpInitData                                     ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope void   SOMLINK wpstut_wpInitData(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpInitData");

    DisplayMethodInfo(IDS_WPINITDATA);

    parent_wpInitData(somSelf);
}

/*
 *
 *   METHOD: wpInsertPopupMenuItems                         ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpInsertPopupMenuItems(WPSTutorial *somSelf,
                HWND hwndMenu,
                ULONG iPosition,
                HMODULE hmod,
                ULONG MenuID,
                ULONG SubMenuID)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpInsertPopupMenuItems");

    DisplayMethodInfo(IDS_WPINSERTPOPUPMENUITEMS);

    return (parent_wpInsertPopupMenuItems(somSelf,hwndMenu,iPosition,hmod,MenuID,SubMenuID));
}

/*
 *
 *   METHOD: wpInsertSettingsPage                           ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpInsertSettingsPage(WPSTutorial *somSelf,
                HWND hwndNotebook,
                PPAGEINFO ppageinfo)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpInsertSettingsPage");

    DisplayMethodInfo(IDS_WPINSERTSETTINGSPAGE);

    return (parent_wpInsertSettingsPage(somSelf,hwndNotebook,ppageinfo));
}

/*
 *
 *   METHOD: wpMenuItemSelected                             ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *     In addition, this method processes the input from the
 *     "Open tutorial" menu item added by this class.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpMenuItemSelected(WPSTutorial *somSelf,
                HWND hwndFrame,
                ULONG ulMenuId)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpMenuItemSelected");

    DisplayMethodInfo(IDS_WPMENUITEMSELECTED);

    /*
    **  Determine which menu item in the context menu was selected.
    */
    switch ( ulMenuId )
    {
       case IDM_OPENTUT:
       {
          /*
          **   The new 'Open tutorial' menu item was selected.
          **   We could call 'wpOpen' here, but if the object is already
          **   opened, the following API determines whether the object
          **   should be resurfaced or opened.  (If 'wpOpen' is called
          **   instead, multiple concurrent views won't work.)
          */
          _wpViewObject(somSelf, NULLHANDLE, OPEN_TUTORIAL, 0);
          break;
       }

       default :
       {
          /*
          **  The parent can handle all other menu item selections.
          */
          return parent_wpMenuItemSelected(somSelf, hwndFrame, ulMenuId);
       }
    }

    /*
    **  Indicate successful completion.
    */
    return TRUE;
}

/*
 *
 *  METHOD: wpModifyPopupMenu                              ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *     In addition, this method adds the "Open tutorial" item to the
 *     "Open" menu of the object's context menu,
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpModifyPopupMenu(WPSTutorial *somSelf,
                HWND hwndMenu,
                HWND hwndCnr,
                ULONG iPosition)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpModifyPopupMenu");

    DisplayMethodInfo(IDS_WPMODIFYPOPUPMENU);

    /*
    **  Insert the "Open tutorial" menu item at the top of the "Open"
    **  submenu.
    */
    _wpInsertPopupMenuItems(somSelf,
                            hwndMenu,
                            0,
                            hmod,
                            ID_OPENMENU,
                            WPMENUID_OPEN);

    /*
    **  Invoke default processing.
    */
    return (parent_wpModifyPopupMenu(somSelf, hwndMenu, hwndCnr, iPosition));
}

/*
 *
 *   METHOD: wpOpen                                         ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *     In addition, this method displays the current open view for the
 *     object.  If no view is open, a new open view is created.
 *
 */

SOM_Scope HWND   SOMLINK wpstut_wpOpen(WPSTutorial *somSelf,
                HWND hwndCnr,
                ULONG ulView,
                ULONG param)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpOpen");

    DisplayMethodInfo(IDS_WPOPEN);

    /*
    **  Determine which view is to be shown.
    */
    switch (ulView)
    {
       case OPEN_TUTORIAL:

          /*
          **  The user wants to see the "Open tutorial" view, so we'll try to
          **  give focus to an already open view.
          */
          if (!_wpSwitchTo(somSelf, ulView))
          {
             /*
             **  There is no open view, so a view needs to be created for
             **  this instance.
             */
             return _DisplayTitleInfo(somSelf);
          }
          break;

       default:
          return parent_wpOpen(somSelf, hwndCnr, ulView, param);
    }
}

/*
 *
 *   METHOD: wpQueryConfirmations                           ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpQueryConfirmations(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpQueryConfirmations");

    DisplayMethodInfo(IDS_WPQUERYCONFIRMATIONS);

    return (parent_wpQueryConfirmations(somSelf));
}

/*
 *
 *   METHOD: wpQueryDefaultView                             ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpQueryDefaultView(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpQueryDefaultView");

    DisplayMethodInfo(IDS_WPQUERYDEFAULTVIEW);

    return (parent_wpQueryDefaultView(somSelf));
}

/*
 *
 *   METHOD: wpQueryDetailsData                             ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpQueryDetailsData(WPSTutorial *somSelf,
                PVOID *ppDetailsData,
                PULONG pcp)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpQueryDetailsData");

    DisplayMethodInfo(IDS_WPQUERYDETAILSDATA);

    return (parent_wpQueryDetailsData(somSelf,ppDetailsData,pcp));
}

/*
 *
 *   METHOD: wpQueryHandle                                  ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope HOBJECT   SOMLINK wpstut_wpQueryHandle(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpQueryHandle");

    DisplayMethodInfo(IDS_WPQUERYHANDLE);

    return (parent_wpQueryHandle(somSelf));
}

/*
 *
 *   METHOD: wpQueryIcon                                    ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope HPOINTER   SOMLINK wpstut_wpQueryIcon(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpQueryIcon");

    DisplayMethodInfo(IDS_WPQUERYICON);

    return (parent_wpQueryIcon(somSelf));
}

/*
 *
 *   METHOD: wpQueryIconData                                ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpQueryIconData(WPSTutorial *somSelf,
                PICONINFO pIconInfo)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpQueryIconData");

    DisplayMethodInfo(IDS_WPQUERYICONDATA);

    return (parent_wpQueryIconData(somSelf,pIconInfo));
}

/*
 *
 *   METHOD: wpQueryRealName                                ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpQueryRealName(WPSTutorial *somSelf,
                PSZ pszFilename,
                PULONG pcb,
                BOOL fQualified)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpQueryRealName");

    DisplayMethodInfo(IDS_WPQUERYREALNAME);

    return (parent_wpQueryRealName(somSelf,pszFilename,pcb,fQualified));
}

/*
 *
 *   METHOD: wpQueryStyle                                   ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstut_wpQueryStyle(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpQueryStyle");

    DisplayMethodInfo(IDS_WPQUERYSTYLE);

    return (parent_wpQueryStyle(somSelf));
}

/*
 *
 *   METHOD: wpQueryTitle                                   ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope PSZ   SOMLINK wpstut_wpQueryTitle(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpQueryTitle");

    DisplayMethodInfo(IDS_WPQUERYTITLE);

    return (parent_wpQueryTitle(somSelf));
}

/*
 *
 *   METHOD: wpQueryType                                    ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope PSZ   SOMLINK wpstut_wpQueryType(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpQueryType");

    DisplayMethodInfo(IDS_WPQUERYTYPE);

    return (parent_wpQueryType(somSelf));
}

/*
 *
 *   METHOD: wpRegisterView                                 ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpRegisterView(WPSTutorial *somSelf,
                HWND hwndFrame,
                PSZ pszViewTitle)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpRegisterView");

    DisplayMethodInfo(IDS_WPREGISTERVIEW);

    return (parent_wpRegisterView(somSelf,hwndFrame,pszViewTitle));
}

/*
 *
 *   METHOD: wpRender                                       ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope MRESULT   SOMLINK wpstut_wpRender(WPSTutorial *somSelf,
                PDRAGTRANSFER pdxfer)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpRender");

    DisplayMethodInfo(IDS_WPRENDER);

    return (parent_wpRender(somSelf,pdxfer));
}

/*
 *
 *   METHOD: wpRenderComplete                               ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope MRESULT   SOMLINK wpstut_wpRenderComplete(WPSTutorial *somSelf,
                PDRAGTRANSFER pdxfer,
                ULONG ulResult)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpRenderComplete");

    DisplayMethodInfo(IDS_WPRENDERCOMPLETE);

    return (parent_wpRenderComplete(somSelf,pdxfer,ulResult));
}

/*
 *
 *   METHOD: wpRestore                                      ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpRestore(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpRestore");

    DisplayMethodInfo(IDS_WPRESTORE);

    return (parent_wpRestore(somSelf));
}

/*
 *
 *   METHOD: wpRestoreData                                  ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpRestoreData(WPSTutorial *somSelf,
                PSZ pszClass,
                ULONG ulKey,
                PBYTE pValue,
                PULONG pcbValue)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpRestoreData");

    DisplayMethodInfo(IDS_WPRESTOREDATA);

    return (parent_wpRestoreData(somSelf,pszClass,ulKey,pValue,pcbValue));
}

/*
 *
 *   METHOD: wpRestoreLong                                  ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpRestoreLong(WPSTutorial *somSelf,
                PSZ pszClass,
                ULONG ulKey,
                PULONG pulValue)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpRestoreLong");

    DisplayMethodInfo(IDS_WPRESTORELONG);

    return (parent_wpRestoreLong(somSelf,pszClass,ulKey,pulValue));
}

/*
 *
 *  METHOD: wpRestoreState                                 ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *     In addition, this method queries the title to "force" all views of
 *     the object's title to be backwards upon IPL.
 */

SOM_Scope BOOL   SOMLINK wpstut_wpRestoreState(WPSTutorial *somSelf,
                ULONG ulReserved)
{
    CHAR pszTitle[MAX_TITLE_LENGTH];

    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpRestoreState");

    DisplayMethodInfo(IDS_WPRESTORESTATE);

    /*
    **  Reset the title so it isn't the reverse of the reverse (i.e. normal).
    */
    sprintf(pszTitle,"%s",_wpQueryTitle(somSelf));
    _wpSetTitle(somSelf, pszTitle);

    return (parent_wpRestoreState(somSelf,ulReserved));
}

/*
 *
 *   METHOD: wpRestoreString                                ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpRestoreString(WPSTutorial *somSelf,
                PSZ pszClass,
                ULONG ulKey,
                PSZ pszValue,
                PULONG pcbValue)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpRestoreString");

    DisplayMethodInfo(IDS_WPRESTORESTRING);

    return (parent_wpRestoreString(somSelf,pszClass,ulKey,pszValue,pcbValue));
}

/*
 *
 *   METHOD: wpSaveData                                     ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSaveData(WPSTutorial *somSelf,
                PSZ pszClass,
                ULONG ulKey,
                PBYTE pValue,
                ULONG cbValue)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSaveData");

    DisplayMethodInfo(IDS_WPSAVEDATA);

    return (parent_wpSaveData(somSelf,pszClass,ulKey,pValue,cbValue));
}

/*
 *
 *   METHOD: wpSaveDeferred                                 ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSaveDeferred(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSaveDeferred");

    DisplayMethodInfo(IDS_WPSAVEDEFERRED);

    return (parent_wpSaveDeferred(somSelf));
}

/*
 *
 *   METHOD: wpSaveImmediate                                ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSaveImmediate(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSaveImmediate");

    DisplayMethodInfo(IDS_WPSAVEIMMEDIATE);

    return (parent_wpSaveImmediate(somSelf));
}

/*
 *
 *   METHOD: wpSaveLong                                     ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSaveLong(WPSTutorial *somSelf,
                PSZ pszClass,
                ULONG ulKey,
                ULONG ulValue)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSaveLong");

    DisplayMethodInfo(IDS_WPSAVELONG);

    return (parent_wpSaveLong(somSelf,pszClass,ulKey,ulValue));
}

/*
 *
 *   METHOD: wpSaveState                                    ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSaveState(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSaveState");

    DisplayMethodInfo(IDS_WPSAVESTATE);

    return (parent_wpSaveState(somSelf));
}

/*
 *
 *   METHOD: wpSaveString                                   ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSaveString(WPSTutorial *somSelf,
                PSZ pszClass,
                ULONG ulKey,
                PSZ pszValue)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSaveString");

    DisplayMethodInfo(IDS_WPSAVESTRING);

    return (parent_wpSaveString(somSelf,pszClass,ulKey,pszValue));
}

/*
 *
 *   METHOD: wpSetDefaultView                               ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSetDefaultView(WPSTutorial *somSelf,
                ULONG ulView)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSetDefaultView");

    DisplayMethodInfo(IDS_WPSETDEFAULTVIEW);

    return (parent_wpSetDefaultView(somSelf,ulView));
}

/*
 *
 *   METHOD: wpSetIcon                                      ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSetIcon(WPSTutorial *somSelf,
                HPOINTER hptrNewIcon)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSetIcon");

    DisplayMethodInfo(IDS_WPSETICON);

    return (parent_wpSetIcon(somSelf,hptrNewIcon));
}

/*
 *
 *   METHOD: wpSetIconData                                  ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSetIconData(WPSTutorial *somSelf,
                PICONINFO pIconInfo)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSetIconData");

    DisplayMethodInfo(IDS_WPSETICONDATA);

    return (parent_wpSetIconData(somSelf,pIconInfo));
}

/*
 *
 *   METHOD: wpSetRealName                                  ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSetRealName(WPSTutorial *somSelf,
                PSZ pszName)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSetRealName");

    DisplayMethodInfo(IDS_WPSETREALNAME);

    return (parent_wpSetRealName(somSelf,pszName));
}

/*
 *
 *   METHOD: wpSetStyle                                     ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSetStyle(WPSTutorial *somSelf,
                ULONG ulNewStyle)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSetStyle");

    DisplayMethodInfo(IDS_WPSETSTYLE);

    return (parent_wpSetStyle(somSelf,ulNewStyle));
}

/*
 *
 *   METHOD: wpSetTitle                                     ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *     In addition, this method reverses the title supplied by
 *     the user.
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSetTitle(WPSTutorial *somSelf,
                PSZ pszNewTitle)
{
    CHAR szBackwardsTitle[CCHMAXPATHCOMP] = "";
                                    /* Buffer for backwards title            */
    int  i;                         /* Counter                               */

    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSetTitle");

    DisplayMethodInfo(IDS_WPSETTITLE);

    /*
    **  Reverse the title set by the user.
    */
    szBackwardsTitle[CCHMAXPATHCOMP-1] = '\0';

    for (i=(CCHMAXPATHCOMP-2);
         i!=0 && (*pszNewTitle != '\0');
         i--)
    {
       szBackwardsTitle[i] = *pszNewTitle;
       pszNewTitle++;
    }

    /*
    **  Return the backwards title.
    */
    return (parent_wpSetTitle(somSelf, (PSZ)&szBackwardsTitle[i+1]));
}

/*
 *
 *   METHOD: wpSetType                                      ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSetType(WPSTutorial *somSelf,
                PSZ pszTypes,
                PFEA2LIST pfeal)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSetType");

    DisplayMethodInfo(IDS_WPSETTYPE);

    return (parent_wpSetType(somSelf,pszTypes,pfeal));
}

/*
 *
 *  METHOD: wpSetup                                        ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSetup(WPSTutorial *somSelf,
                PSZ pszSetupString)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSetup");

    DisplayMethodInfo(IDS_WPSETUP);

    return (parent_wpSetup(somSelf,pszSetupString));
}

/*
 *
 *   METHOD: wpSwitchTo                                     ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpSwitchTo(WPSTutorial *somSelf,
                ULONG View)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpSwitchTo");

    DisplayMethodInfo(IDS_WPSWITCHTO);

    return (parent_wpSwitchTo(somSelf,View));
}

/*
 *
 *   METHOD: wpUnlockObject                                 ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstut_wpUnlockObject(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpUnlockObject");

    DisplayMethodInfo(IDS_WPUNLOCKOBJECT);

    return (parent_wpUnlockObject(somSelf));
}

/*
 *
 *   METHOD: wpUnInitData                                   ( ) PRIVATE
 *                                                          (X) PUBLIC
 *   DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope void   SOMLINK wpstut_wpUnInitData(WPSTutorial *somSelf)
{
    /* WPSTutorialData *somThis = WPSTutorialGetData(somSelf); */
    WPSTutorialMethodDebug("WPSTutorial","wpstut_wpUnInitData");

    DisplayMethodInfo(IDS_WPUNINITDATA);

    parent_wpUnInitData(somSelf);
}

/**************************  CLASS METHODS SECTION  ***************************
*****                                                                     *****
*****              Do not put any code in this section unless             *****
*****                     it is an object CLASS method                    *****
*****                                                                     *****
******************************************************************************/

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta


/*
 *
 *  METHOD: clsQueryModuleHandle
 *
 *  DESCRIPTION:
 *
 *    This method obtains and returns the module handle for the object class.
 *
 *  RETURN:
 *
 *    0        - Unsuccessful execution
 *    Non-zero - Module handle
 *
 */

SOM_Scope HMODULE SOMLINK wpstutM_clsQueryModuleHandle(M_WPSTutorial *somSelf)
{
    zString zsPathName;                /* Class DLL name                     */
    APIRET  rc;                        /* DosQueryModuleHandle return code   */

    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_clsQueryModuleHandle");

    /*
    **  We only need to initialize the module handle if it hasn't
    **  already been initialized!
    */
    if ( !hmod )
    {
       /*
       **  First, we need to locate the file that holds our class.
       */
       zsPathName = _somLocateClassFile( SOMClassMgrObject,
                                         SOM_IdFromString("WPSTutorial"),
                                         WPSTutorial_MajorVersion,
                                         WPSTutorial_MinorVersion);

       /*
       **  Now we can determine the module handle based on the name of the
       **  class.
       */
       rc = DosQueryModuleHandle(zsPathName, &hmod);

       if (rc)
       {
          /*
          **  The DLL handle could not be found.
          */
          DebugBox("wpstutM_clsQueryModuleHandle",
                   "Failed to load DLL resources");

          hmod = NULLHANDLE;
       }
    }

    return(hmod);
}


/*
 *
 *  METHOD: wpclsCreateDefaultTemplates
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstutM_wpclsCreateDefaultTemplates(M_WPSTutorial *somSelf,
                WPObject *Folder)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsCreateDefaultTemplates");

    DisplayMethodInfo(IDS_WPCLSCREATEDEFAULTTEMPLATES);

    return (parent_wpclsCreateDefaultTemplates(somSelf,Folder));
}

/*
 *
 *  METHOD: wpclsFindObjectEnd
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstutM_wpclsFindObjectEnd(M_WPSTutorial *somSelf,
                HFIND hFind)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsFindObjectEnd");

    DisplayMethodInfo(IDS_WPCLSFINDOBJECTEND);

    return (parent_wpclsFindObjectEnd(somSelf,hFind));
}

/*
 *
 *  METHOD: wpclsFindObjectFirst
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstutM_wpclsFindObjectFirst(M_WPSTutorial *somSelf,
                PCLASS pClassList,
                PHFIND phFind,
                PSZ pszTitle,
                WPFolder *Folder,
                BOOL fSubfolders,
                PVOID pExtendedCriteria,
                POBJECT pBuffer,
                PULONG pCount)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsFindObjectFirst");

    DisplayMethodInfo(IDS_WPCLSFINDOBJECTFIRST);

    return (parent_wpclsFindObjectFirst(somSelf,pClassList,phFind,pszTitle,Folder,fSubfolders,pExtendedCriteria,pBuffer,pCount));
}

/*
 *
 *  METHOD: wpclsFindObjectNext
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstutM_wpclsFindObjectNext(M_WPSTutorial *somSelf,
                HFIND hFind,
                POBJECT pBuffer,
                PULONG pCount)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsFindObjectNext");

    DisplayMethodInfo(IDS_WPCLSFINDOBJECTNEXT);

    return (parent_wpclsFindObjectNext(somSelf,hFind,pBuffer,pCount));
}

/*
 *
 *  METHOD: wpclsInitData
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *     In addition, this method initializes the DLL module handle.
 */

SOM_Scope void   SOMLINK wpstutM_wpclsInitData(M_WPSTutorial *somSelf)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsInitData");

    /*
    **  Call the parent method first.
    */
    parent_wpclsInitData(somSelf);

    /*
    **  We need to initialize the module handle for our DLL so that we can
    **  invoke 'DisplayMethodInfo'.
    */
    _clsQueryModuleHandle(somSelf);

    DisplayMethodInfo(IDS_WPCLSINITDATA);
}

/*
 *
 *  METHOD: wpclsMakeAwake
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope WPObject *  SOMLINK wpstutM_wpclsMakeAwake(M_WPSTutorial *somSelf,
                PSZ pszTitle,
                ULONG ulStyle,
                HPOINTER hptrIcon,
                POBJDATA pObjData,
                WPFolder *Folder,
                ULONG ulUser)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsMakeAwake");

    DisplayMethodInfo(IDS_WPCLSMAKEAWAKE);

    return (parent_wpclsMakeAwake(somSelf,pszTitle,ulStyle,hptrIcon,pObjData,Folder,ulUser));
}

/*
 *
 *  METHOD: wpclsNew
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope WPObject *  SOMLINK wpstutM_wpclsNew(M_WPSTutorial *somSelf,
                PSZ pszTitle,
                PSZ pszSetupEnv,
                WPFolder *Folder,
                BOOL fLock)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsNew");

    DisplayMethodInfo(IDS_WPCLSNEW);

    return (parent_wpclsNew(somSelf,pszTitle,pszSetupEnv,Folder,fLock));
}

/*
 *
 *  METHOD: wpclsQueryDefaultView
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *     In addition, this method is overridden to make the default open
 *     view of the instances of this class to the "Open tutorial" view.
 */

SOM_Scope ULONG   SOMLINK wpstutM_wpclsQueryDefaultView(M_WPSTutorial *somSelf)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsQueryDefaultView");

    DisplayMethodInfo(IDS_WPCLSQUERYDEFAULTVIEW);

    /*
    **  Specify that the default open view for the instances of this class
    **  to be the "Open tutorial" view.
    */
    return OPEN_TUTORIAL;
}

/*
 *
 *  METHOD: wpclsQueryDetails
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope PCLASSDETAILS   SOMLINK wpstutM_wpclsQueryDetails(M_WPSTutorial *somSelf)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsQueryDetails");

    DisplayMethodInfo(IDS_WPCLSQUERYDETAILS);

    return (parent_wpclsQueryDetails(somSelf));
}

/*
 *
 *  METHOD: wpclsQueryDetailsInfo
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstutM_wpclsQueryDetailsInfo(M_WPSTutorial *somSelf,
                PCLASSFIELDINFO *ppClassFieldInfo,
                PULONG pSize)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsQueryDetailsInfo");

    DisplayMethodInfo(IDS_WPCLSQUERYDETAILSINFO);

    return (parent_wpclsQueryDetailsInfo(somSelf,ppClassFieldInfo,pSize));
}

/*
 *
 *  METHOD: wpclsQueryFolder
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope WPObject *  SOMLINK wpstutM_wpclsQueryFolder(M_WPSTutorial *somSelf,
                PSZ pszLocation,
                BOOL fLock)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsQueryFolder");

    DisplayMethodInfo(IDS_WPCLSQUERYFOLDER);

    return (parent_wpclsQueryFolder(somSelf,pszLocation,fLock));
}

/*
 *
 *  METHOD: wpclsQueryIcon
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope HPOINTER   SOMLINK wpstutM_wpclsQueryIcon(M_WPSTutorial *somSelf)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsQueryIcon");

    DisplayMethodInfo(IDS_WPCLSQUERYICON);

    return (parent_wpclsQueryIcon(somSelf));
}

/*
 *
 *  METHOD: wpclsQueryIconData                             ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *     In addition, the method is overridden to define the icon
 *     for the class.
 */

SOM_Scope ULONG   SOMLINK wpstutM_wpclsQueryIconData(M_WPSTutorial *somSelf,
                PICONINFO pIconInfo)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsQueryIconData");

    DisplayMethodInfo(IDS_WPCLSQUERYICONDATA);

    /*
    **  Build the default icon for this class.
    */
    if (pIconInfo)
    {
       /*
       **  Fill in the icon information.  The icon resources is supplied
       **  in this DLL.
       */
       pIconInfo->fFormat = ICON_RESOURCE;
       pIconInfo->hmod = hmod;
       pIconInfo->resid = ID_ICON;
    }

    return (sizeof(ICONINFO));
}

/*
 *
 *  METHOD: wpclsQueryInstanceFilter
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope PSZ   SOMLINK wpstutM_wpclsQueryInstanceFilter(M_WPSTutorial *somSelf)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsQueryInstanceFilter");

    DisplayMethodInfo(IDS_WPCLSQUERYINSTANCEFILTER);

    return (parent_wpclsQueryInstanceFilter(somSelf));
}

/*
 *
 *  METHOD: wpclsQueryInstanceType
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope PSZ   SOMLINK wpstutM_wpclsQueryInstanceType(M_WPSTutorial *somSelf)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsQueryInstanceType");

    DisplayMethodInfo(IDS_WPCLSQUERYINSTANCETYPE);

    return (parent_wpclsQueryInstanceType(somSelf));
}

/*
 *
 *  METHOD: wpclsQueryObject
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope WPObject *  SOMLINK wpstutM_wpclsQueryObject(M_WPSTutorial *somSelf,
                HOBJECT hObject)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsQueryObject");

    DisplayMethodInfo(IDS_WPCLSQUERYOBJECT);

    return (parent_wpclsQueryObject(somSelf,hObject));
}

/*
 *
 *  METHOD: wpclsQuerySettingsPageSize
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope BOOL   SOMLINK wpstutM_wpclsQuerySettingsPageSize(M_WPSTutorial *somSelf,
                PSIZEL pSizl)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsQuerySettingsPageSize");

    DisplayMethodInfo(IDS_WPCLSQUERYSETTINGSPAGESIZE);

    return (parent_wpclsQuerySettingsPageSize(somSelf,pSizl));
}

/*
 *
 *  METHOD: wpclsQueryStyle
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope ULONG   SOMLINK wpstutM_wpclsQueryStyle(M_WPSTutorial *somSelf)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsQueryStyle");

    DisplayMethodInfo(IDS_WPCLSQUERYSTYLE);

    return (parent_wpclsQueryStyle(somSelf));
}

/*
 *
 *  METHOD: wpclsQueryTitle
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope PSZ   SOMLINK wpstutM_wpclsQueryTitle(M_WPSTutorial *somSelf)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsQueryTitle");

    DisplayMethodInfo(IDS_WPCLSQUERYTITLE);

    return (parent_wpclsQueryTitle(somSelf));
}

/*
 *
 *  METHOD: wpclsUnInitData
 *
 *  DESCRIPTION:
 *
 *     This method is overridden to invoke 'DisplayMethodInfo'.
 *
 */

SOM_Scope void   SOMLINK wpstutM_wpclsUnInitData(M_WPSTutorial *somSelf)
{
    /* M_WPSTutorialData *somThis = M_WPSTutorialGetData(somSelf); */
    M_WPSTutorialMethodDebug("M_WPSTutorial","wpstutM_wpclsUnInitData");

    DisplayMethodInfo(IDS_WPCLSUNINITDATA);

    parent_wpclsUnInitData(somSelf);
}


/**************************  ORDINARY CODE SECTION  ***************************
*****                                                                     *****
*****                  Any non-method code should go here.                *****
*****                                                                     *****
******************************************************************************/

#undef SOM_CurrentClass

/*
 *
 *  NAME: DisplayMethodInfo
 *
 *  DESCRIPTION:
 *
 *    This function communicates with the 'Show Method Description'
 *    (SHOWDESC.EXE) program using a named pipe.  This communication tells
 *    the other process to display the name and description of the specified
 *    method.
 *
 *    This function is invoked by most overridden methods.
 *
 *  RETURN:
 *
 *    NONE
 *
 */

VOID DisplayMethodInfo(ULONG ulMethodID)
{
   APIRET   rc = 0;              /* Return code for DosXXX API               */
   ULONG    ulAppType;           /* Application type                         */
   TID      tid;                 /* Thread ID for the created thread         */
   ULONG    ulBytesXferred;      /* Number of bytes transferred over the pipe*/

   /*
   **  If the thread used to start up the 'Show Method Description' program
   **  has not been started yet,  we'll create the thread.  We can also
   **  create the named pipe used to communicate with that program.
   */
   if ( !fProgramStarted )
   {
      /*
      **  First, we'll make sure that the 'Show Method Description'
      **  program is available for execution.  (If the program can't
      **  be executed, we'll get stuck waiting for the named pipe
      **  to "connect".)
      */
      rc = DosQueryAppType(DISPLAY_PROGRAM_NAME, &ulAppType);

      if ( rc )
      {
         WPSTutorialMethodDebug("DisplayMethodInfo",
                                "SHOWDESC.EXE not available");
      }
      else
      {
         /*
         **  The program is available for execution, so we'll create the
         **  named pipe used to communicate with the program.
         */
         rc = DosCreateNPipe(PIPE_NAME,
                             &hNPipe,
                             NP_ACCESS_DUPLEX,
                             NP_WAIT | NP_TYPE_BYTE | NP_READMODE_BYTE |
                               NPIPE_COUNT,
                             4096,
                             4096,
                             10000);

         if ( rc )
         {
            WPSTutorialMethodDebug("DisplayMethodInfo", "DosCreateNPipe failed");
         }
         else
         {
            /*
            **  The thread will be created only if the named pipe was
            **  successfully created.
            */
            rc = DosCreateThread(&tid,
                                 (PFNTHREAD)DisplayMethodThread,
                                 0U,
                                 CREATE_READY,
                                 STACKSIZE);
            if ( rc )
            {
               /*
               **  Do clean up if the thread could not be created.
               */
               WPSTutorialMethodDebug("DisplayMethodInfo",
                                      "Thread could not be created");
               DosClose(hNPipe);
               fProgramStarted = FALSE;
            }
            else
            {
               fProgramStarted = TRUE;

               /*
               **  Connect the named pipe so the SHOWDESC.EXE program can open
               **  the pipe.
               */
               rc = DosConnectNPipe(hNPipe);

               if ( rc )
               {
                  fProgramStarted = FALSE;
                  WPSTutorialMethodDebug("DisplayMethodInfo",
                                         "Pipe could not be connected");
               }
            }
         }
      }
   }

   /*
   **  If the thread was created successfully, or if we didn't have to create
   **  the thread this time, we'll go ahead and pass the "method ID" to the
   **  SHOWDESC.EXE program.
   */
   if ( !rc )
   {
      rc = DosWrite(hNPipe, &ulMethodID, sizeof(ulMethodID), &ulBytesXferred);

      if ( rc )
      {
         WPSTutorialMethodDebug("DisplayMethodInfo", "DosWrite failed");
      }
      else
      {
         if ( !ulBytesXferred )
         {
            WPSTutorialMethodDebug("DisplayMethodInfo",
                                   "Method ID was not written on pipe");
         }
      }
   }

   return;
}

/*
 *
 *  NAME: WPSTutorWndProc
 *
 *  DESCRIPTION:
 *
 *    This function is the window procedure that processes messages for the
 *    default open view for an object.
 *
 *  RETURN:
 *
 *    MRESULT - Based on the message being processed.
 *
 */

MRESULT EXPENTRY WPSTutorWndProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   PWINDOWDATA pWindowData;      /* Window Words instance data               */
   HWND        hwndFrame;        /* Parent window handle                     */
   CHAR        pszTitle[MAX_TITLE_LENGTH];

   /*
   **  Get the handle of the parent window.
   */
   hwndFrame = WinQueryWindow(hwnd, QW_PARENT);

   /*
   **  Process the message that caused the window procedure to be invoked.
   */
   switch( msg )
   {
      /*
      **  Create the window for the default open view.
      */
      case WM_CREATE:

        /*
        **  Get the "Window Words" instance data.
        */
        pWindowData = (PWINDOWDATA) mp1;

        if (pWindowData == NULL)
        {
           DebugBox("WPSTutorWndProc:WM_CREATE", "Couldn't get window words");
           return FALSE;
        }

        /*
        **  Initialize the instance data (class view/usage details and
        **  window specific data) for this instance.
        */
        pWindowData->UseItem.type    = USAGE_OPENVIEW;
        pWindowData->ViewItem.view   = OPEN_TUTORIAL;
        pWindowData->ViewItem.handle = hwndFrame;

        /*
        **  Set a pointer value into the memory of the reserved window words
        **  to hold the instance view information.
        */
        WinSetWindowPtr(hwnd, QWL_USER, pWindowData);

        /*
        **  Add a view to the object's in-use list so the wpSwitchTo works.
        **  This API tells the shell to store the view in the internal
        **  linked list for the object to enable wpSwitchTo and other
        **  methods to find the view.
        */
        _wpAddToObjUseList(pWindowData->somSelf, &pWindowData->UseItem);

        /*
        **  Register the new open view.
        */
        sprintf(pszTitle,"%s",_wpQueryTitle(pWindowData->somSelf));
        _wpRegisterView(pWindowData->somSelf, hwndFrame,pszTitle);

        /*
        **  Make this window the window in focus.
        */
        WinSetFocus(HWND_DESKTOP, hwndFrame);

        break;

      /*
      **  Process a control.
      */
      case WM_COMMAND:

        /*
        **  There are no control commands to process.
        */
        break;

      /*
      **  Repaint the window.
      */
      case WM_PAINT:
      {
         HPS    hps;       /* Presentation space handle                      */

         hps = WinBeginPaint(hwnd, (HPS)NULLHANDLE, NULL);
         GpiErase(hps);
         WinEndPaint(hps);

         break;
      }

      /*
      **  User closed the window.
      */
      case WM_CLOSE:
      {
         /*
         **  Get the instance data.
         */
         pWindowData = (PWINDOWDATA) WinQueryWindowPtr(hwnd, QWL_USER);

         if (pWindowData == NULL)
         {
            DebugBox("WPSTutorWndProc:WM_CLOSE", "Couldn't get window words");
            return FALSE;
         }

         /*
         **  Save the current size and position of the window.
         */
         WinStoreWindowPos(szTutorialWindowClass,
                           _wpQueryTitle(pWindowData->somSelf),
                           hwndFrame);

         /*
         **  Remove the item type from the object's in-use list.
         */
         _wpDeleteFromObjUseList(pWindowData->somSelf,
                                 &pWindowData->UseItem);

         /*
         **  Deallocate storage for the instance specific data.
         */
         _wpFreeMem(pWindowData->somSelf, (PBYTE)pWindowData);

         /*
         **  Post a message to ourselves to terminate the application.
         */
         WinPostMsg(hwnd, WM_QUIT, 0, 0);

         /*
         **  Destroy the parent window
         */
         WinDestroyWindow(hwndFrame);
         break;
      }

      default:
         /*
         **  Allow PM to handle all other messages.
         */
         return WinDefWindowProc( hwnd, msg, mp1, mp2 );
   }

   return FALSE;

}

/*
 *
 *  NAME: DisplayMethodThread
 *
 *  DESCRIPTION:
 *
 *    This function starts the 'Show Method Description' program and waits for
 *    that program to be closed.  (The program can be closed by the user or by
 *    processing of the 'wpFree' method.)
 *
 *  RETURN:
 *
 *     0L - Always
 */

ULONG DisplayMethodThread(VOID)
{
   APIRET       rc = 0;             /* Return code for DosXXX API            */
   CHAR         szLoadError[100];   /* Buffer for the name of the object     */
                                    /*   that contributes to DosExecPgm      */
                                    /*   failure                             */
   RESULTCODES  ReturnCodes;        /* Termination and result codes for      */
                                    /*   SHOWDESC.EXE process                */
   PID          RetProcessID;       /* ID for the process that ends          */
                                    /*   SHOWDESC.EXE                        */

   /*
   **  Start the 'Show Method Description' program.
   */
   rc = DosExecPgm(szLoadError,
                   sizeof(szLoadError),
                   EXEC_ASYNCRESULT,
                   NULL,
                   NULL,
                   &ReturnCodes,
                   DISPLAY_PROGRAM_NAME);

   if ( rc )
   {
      WPSTutorialMethodDebug("DisplayMethodThread", "DosExecPgm failed");
   }
   else
   {
      /*
      **  The program was started successfully, so we can set our global flag
      **  to indicate that.
      */
      fProgramStarted = TRUE;

      /*
      **  Store the process ID for 'Show Method Description' so that it can
      **  be killed by 'wpFree' if needed.
      */
      ShowMethDescPID = ReturnCodes.codeTerminate;

      /*
      **  Wait for 'Show Method Description' to be killed.
      */
      rc = DosWaitChild(DCWA_PROCESS, DCWW_WAIT, &ReturnCodes, &RetProcessID,
                        ShowMethDescPID);
   }

   /*
   **  Close the pipe used to communicate with 'Show Method Description'.
   */
   DosDisConnectNPipe(hNPipe);
   DosClose(hNPipe);

   /*
   **  Reset the global flag to indicate that the SHOWDESC.EXE program is
   **  not up.
   */
   fProgramStarted = FALSE;

   /*
   **  Exit the thread.
   */
   DosExit(EXIT_THREAD, 0L);
   return 0L;
}
