#ifndef _KCOLOR_
  #define _KCOLOR_
/**************************************************************************
* FILE NAME: kcolor.hpp                                                   *
*                                                                         *
* DESCRIPTION:                                                            *
*   Declaration of the class(es):                                         *
*     KwColor - A specialization of IColor that can be constructed from   *
*               a single unsigned long value.                             *
*                                                                         *
**************************************************************************/

class _Export KwColor : public IColor {

public:
  KwColor(unsigned long value);

}; // KwColor

inline KwColor::KwColor(unsigned long value)
  : IColor(value & 0xFF0000, value & 0xFF00, value & 0xFF)
{
}

#endif
