#ifndef _KPTHDR_
  #define _KPTHDR_
/*******************************************************************************
* FILE NAME: kpthdr.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*     KPointerHandler - Changes a window's pointer.                           *
*                                                                              *
*******************************************************************************/
#ifndef _IHANDLER_
  #include <ihandler.hpp>
#endif

// Forward declarations for other classes:
class IEvent;
class IResourceId;
class IPointerHandle;
class ISystemPointerHandle;


class _Export KPointerHandler : public IHandler {
public:
  KPointerHandler   ( IPointerHandle *hdl = 0 );
  virtual ~KPointerHandler   ( );
  Boolean dispatchHandlerEvent ( IEvent& event );
  KPointerHandler& setPointer(ISystemPointerHandle::Identifier id);
  KPointerHandler& setPointer(const IResourceId& hdl);
  IPointerHandle   pointer() const;

protected:
  virtual Boolean mouseMove         ( IEvent& event );
  virtual Boolean controlPointer    ( IEvent& event );

private:
   IPointerHandle      *handle;
}; // KPointerHandler

#endif // _KPTHDR_
