#define INCL_WF
#include <wkf.h>
#include "sctool.h"
#include "iwftoolsr.h"
#include <string.h>

void SetDefaultOptions(SOM_OPTIONS *pDeflOptions)
{
   memset(pDeflOptions,0,sizeof(*pDeflOptions));
   pDeflOptions->cb = sizeof(*pDeflOptions);
   pDeflOptions->ulCommBufSize =       200000UL;
   pDeflOptions->ulStringBufSize =     200000UL;
   strcpy((char *)pDeflOptions->szSignature,SOM_OPTIONS_SIGNATURE);
   pDeflOptions->bEmitCFiles =       TRUE;
   pDeflOptions->bEmitDefFile =      TRUE;
   return;
}

void OptionsSave( HWND  hwndPage1,
                  HWND  hwndPage2,
                  SOM_OPTIONS *pOptions)
{
   WinSendMsg(  WinWindowFromID( hwndPage1,ID_COMMENTBUF),\
                                 SPBM_QUERYVALUE,\
                                 MPFROMP(&pOptions->ulCommBufSize),\
                                 MPFROM2SHORT(0,0));
   WinSendMsg(   WinWindowFromID(   hwndPage1,ID_STRINGBUF),\
                                    SPBM_QUERYVALUE,\
                                    MPFROMP(&pOptions->ulStringBufSize),\
                                    MPFROM2SHORT(0,0));

   WinQueryWindowText( WinWindowFromID( hwndPage1,ID_DEFINE),\
                       DEFSYMMAXSIZE,\
                       (PCH)pOptions->szDefSymbol);
   WinQueryWindowText( WinWindowFromID( hwndPage1,ID_UNDEFINE),\
                       UNDEFSYMMAXSIZE,\
                       (PCH)pOptions->szUnDefSymbol);

   pOptions->bShowVersion =      WinQueryButtonCheckstate( hwndPage1, ID_VERSION);
   pOptions->bIgnoreComments =   WinQueryButtonCheckstate( hwndPage1, ID_COMMENT);
   pOptions->bPrivates =         WinQueryButtonCheckstate( hwndPage1, ID_PRIVATE);
   pOptions->bReleaseOrder =     WinQueryButtonCheckstate( hwndPage1, ID_RELEASEORDER);
   pOptions->bUpdateRepository = WinQueryButtonCheckstate( hwndPage1, ID_REPOSITORY);
   pOptions->bNoWarnings =       WinQueryButtonCheckstate( hwndPage1, ID_WARNINGS);

   pOptions->bEmitCFiles =       WinQueryButtonCheckstate( hwndPage2, ID_C);
   pOptions->bEmitCPPFiles =     WinQueryButtonCheckstate( hwndPage2, ID_CPP);
   pOptions->bEmitDefFile =      WinQueryButtonCheckstate( hwndPage2, ID_DEF);
   pOptions->bEmitIrFile =       WinQueryButtonCheckstate( hwndPage2, ID_IR);
   pOptions->bEmitPdlFile =      WinQueryButtonCheckstate( hwndPage2, ID_PRIVIDL);
   pOptions->bEmitDTSFile =      WinQueryButtonCheckstate( hwndPage2, ID_DTS);

   return;
}

void OptionsRefresh(HWND hwndPage1,HWND hwndPage2, SOM_OPTIONS *pOptions)
{
   WinSetWindowText( WinWindowFromID( hwndPage1,ID_DEFINE),\
                     (PCSZ)pOptions->szDefSymbol);
   WinSetWindowText( WinWindowFromID( hwndPage1,ID_UNDEFINE),\
                     (PCSZ)pOptions->szUnDefSymbol);
   WinSendMsg(       WinWindowFromID( hwndPage1,ID_COMMENTBUF),\
                     SPBM_SETCURRENTVALUE,
                     MPFROMLONG(pOptions->ulCommBufSize),\
                     MPVOID);
   WinSendMsg(       WinWindowFromID( hwndPage1,ID_STRINGBUF),\
                     SPBM_SETCURRENTVALUE,
                     MPFROMLONG(pOptions->ulStringBufSize),\
                     MPVOID);
   WinCheckButton(   hwndPage1,\
                     ID_VERSION,\
                     pOptions->bShowVersion);
   WinCheckButton(   hwndPage1,\
                     ID_COMMENT,\
                     pOptions->bIgnoreComments);
   WinCheckButton(   hwndPage1,\
                     ID_PRIVATE,\
                     pOptions->bPrivates);
   WinCheckButton(   hwndPage1,\
                     ID_RELEASEORDER,\
                     pOptions->bReleaseOrder);
   WinCheckButton(   hwndPage1,\
                     ID_REPOSITORY,\
                     pOptions->bUpdateRepository);
   WinCheckButton(   hwndPage1,\
                     ID_WARNINGS,\
                     pOptions->bNoWarnings);

   WinCheckButton(   hwndPage2,\
                     ID_C,\
                     pOptions->bEmitCFiles);
   WinCheckButton(   hwndPage2,\
                     ID_CPP,\
                     pOptions->bEmitCPPFiles);
   WinCheckButton(   hwndPage2,\
                     ID_DEF,\
                     pOptions->bEmitDefFile);
   WinCheckButton(   hwndPage2,\
                     ID_IR,\
                     pOptions->bEmitIrFile);
   WinCheckButton(   hwndPage2,\
                     ID_PRIVIDL,\
                     pOptions->bEmitPdlFile);
   WinCheckButton(   hwndPage2,\
                     ID_DTS,\
                     pOptions->bEmitDTSFile);
   return;
}

MRESULT EXPENTRY SomDlgProcPage1(HWND hwndDlg,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   SOM_DLGINFO *pDlgInfo;

   switch(msg)
   {
      case WM_INITDLG:
      {
         pDlgInfo = (SOM_DLGINFO*)PVOIDFROMMP(mp2);
         WinSetWindowPtr(hwndDlg,QWL_USER,pDlgInfo);
         return MRFROMLONG(FALSE);
      }

      default:
         return WinDefDlgProc(hwndDlg,msg,mp1,mp2);
   }
   return MRFROMLONG(FALSE);
}

MRESULT EXPENTRY SomDlgProcPage2(HWND hwndDlg,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   SOM_DLGINFO *pDlgInfo;

   switch(msg)
   {
      case WM_INITDLG:
      {
         pDlgInfo = (SOM_DLGINFO*)PVOIDFROMMP(mp2);
         WinSetWindowPtr(hwndDlg,QWL_USER,pDlgInfo);
         return MRFROMLONG(FALSE);
      }

      default:
         return WinDefDlgProc(hwndDlg,msg,mp1,mp2);
   }
   return MRFROMLONG(FALSE);
}

MRESULT EXPENTRY SomDlgProc(HWND hwndDlg,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   SOM_DLGINFO *pDlgInfo;

   switch(msg)
   {
      case WM_INITDLG:
      {
         ULONG ulPage1,ulPage2;
         HWND hwndPage1,hwndPage2;
         HWND hwndNotebook;

         pDlgInfo = (SOM_DLGINFO*)PVOIDFROMMP(mp2);
         WinSetWindowPtr(hwndDlg,QWL_USER,pDlgInfo);

         hwndNotebook = WinWindowFromID( hwndDlg,ID_SOMNOTEBOOK);
         ulPage1 = (ULONG)WinSendMsg( hwndNotebook, BKM_INSERTPAGE,\
                                  MPFROMLONG(0),\
                                  MPFROM2SHORT(BKA_MAJOR|BKA_AUTOPAGESIZE,BKA_LAST));

         ulPage2 = (ULONG)WinSendMsg( hwndNotebook, BKM_INSERTPAGE,\
                                   MPFROMLONG(0),\
                                   MPFROM2SHORT(BKA_MAJOR|BKA_AUTOPAGESIZE,BKA_LAST));

         hwndPage1 = WinLoadDlg(  hwndNotebook,
                                  hwndDlg,
                                  SomDlgProcPage1,
                                  pDlgInfo->hModHandle,
                                  ID_SOMDLGPAGE1,
                                  (PVOID)pDlgInfo);

         hwndPage2 = WinLoadDlg(  hwndNotebook,
                                  hwndDlg,
                                  SomDlgProcPage2,
                                  pDlgInfo->hModHandle,
                                  ID_SOMDLGPAGE2,
                                  (PVOID)pDlgInfo);

         WinSendMsg(   hwndNotebook, BKM_SETNOTEBOOKCOLORS,\
                       MPFROMLONG(SYSCLR_FIELDBACKGROUND),\
                       MPFROMSHORT(BKA_BACKGROUNDMAJORCOLORINDEX));
         WinSendMsg(   hwndNotebook, BKM_SETNOTEBOOKCOLORS,\
                       MPFROMLONG(SYSCLR_FIELDBACKGROUND),
                       MPFROMSHORT(BKA_BACKGROUNDPAGECOLORINDEX));
         WinSendMsg(   hwndNotebook, BKM_SETDIMENSIONS,\
                       MPFROM2SHORT(20,20),\
                       MPFROMSHORT(BKA_PAGEBUTTON));
         WinSendMsg(   hwndNotebook, BKM_SETDIMENSIONS,\
                       MPFROM2SHORT(150,30),\
                       MPFROMSHORT(BKA_MAJORTAB));

         WinSendMsg(   hwndNotebook, BKM_SETTABTEXT,\
                       MPFROMLONG(ulPage1),\
                       MPFROMP("Common Settings"));
         WinSendMsg(   hwndNotebook, BKM_SETPAGEWINDOWHWND,\
                       MPFROMLONG(ulPage1),\
                       MPFROMHWND(hwndPage1));

         WinSendMsg(   hwndNotebook, BKM_SETTABTEXT,\
                       MPFROMLONG(ulPage2),\
                       MPFROMP("Emitted files"));
         WinSendMsg(   hwndNotebook, BKM_SETPAGEWINDOWHWND,\
                       MPFROMLONG(ulPage2),\
                       MPFROMHWND(hwndPage2));

         WinSendMsg( WinWindowFromID( hwndPage1 , ID_DEFINE),\
                     EM_SETTEXTLIMIT,\
                     MPFROMSHORT(DEFSYMMAXSIZE-1),\
                     MPVOID);

         WinSendMsg( WinWindowFromID( hwndPage1, ID_UNDEFINE),\
                     EM_SETTEXTLIMIT,\
                     MPFROMSHORT(UNDEFSYMMAXSIZE-1),\
                     MPVOID);

         WinSendMsg( WinWindowFromID( hwndPage1, ID_COMMENTBUF),\
                     SPBM_SETLIMITS,\
                     MPFROMLONG(393215UL),
                     MPFROMLONG(32767UL));

         WinSendMsg( WinWindowFromID( hwndPage1, ID_STRINGBUF),\
                     SPBM_SETLIMITS,\
                     MPFROMLONG(393215UL),
                     MPFROMLONG(32767UL));

         OptionsRefresh(hwndPage1,hwndPage2,pDlgInfo->pOptions);

         return MRFROMLONG(FALSE);
      }

      case WM_SYSCOMMAND:
      {
         switch(COMMANDMSG(&msg)->cmd)
         {
            case SC_CLOSE:
            {
               WinPostMsg( hwndDlg,WM_COMMAND,\
                           MPFROMSHORT(ID_CANCEL),\
                           MPVOID);
            }
            break;
         }
      }
      break;

      case WM_COMMAND:
      {
         switch(COMMANDMSG(&msg)->cmd)
         {
            case ID_DEFAULT:
            {
               HWND hwndNotebook;
               HWND hwndPage1,hwndPage2;
               ULONG ulPage1,ulPage2;

               pDlgInfo = (SOM_DLGINFO*)WinQueryWindowPtr(hwndDlg,QWL_USER);

               hwndNotebook = WinWindowFromID( hwndDlg, ID_SOMNOTEBOOK);
               ulPage1    = (ULONG)WinSendMsg( hwndNotebook, BKM_QUERYPAGEID,\
                                              MPVOID,\
                                              MPFROM2SHORT( BKA_FIRST,BKA_MAJOR ));
               ulPage2    = (ULONG)WinSendMsg( hwndNotebook, BKM_QUERYPAGEID,\
                                               MPFROMLONG( ulPage1 ),\
                                               MPFROM2SHORT( BKA_NEXT,BKA_MAJOR));

               hwndPage1 = (HWND)WinSendMsg( hwndNotebook, BKM_QUERYPAGEWINDOWHWND,\
                                             MPFROMLONG( ulPage1 ),\
                                             MPVOID);

               hwndPage2 = (HWND)WinSendMsg( hwndNotebook, BKM_QUERYPAGEWINDOWHWND,\
                                             MPFROMLONG( ulPage2 ),\
                                             MPVOID);
               OptionsRefresh(hwndPage1,hwndPage2,pDlgInfo->pDeflOptions);
            }
            break;

            case ID_UNDO:
            {
               HWND hwndNotebook;
               HWND hwndPage1,hwndPage2;
               ULONG ulPage1,ulPage2;

               pDlgInfo = (SOM_DLGINFO*)WinQueryWindowPtr(hwndDlg,QWL_USER);

               hwndNotebook = WinWindowFromID( hwndDlg, ID_SOMNOTEBOOK);
               ulPage1    = (ULONG)WinSendMsg( hwndNotebook, BKM_QUERYPAGEID,\
                                              MPVOID,
                                              MPFROM2SHORT( BKA_FIRST,BKA_MAJOR ));
               ulPage2    = (ULONG)WinSendMsg( hwndNotebook, BKM_QUERYPAGEID,\
                                               MPFROMLONG( ulPage1 ),\
                                               MPFROM2SHORT( BKA_NEXT,BKA_MAJOR));

               hwndPage1 = (HWND)WinSendMsg( hwndNotebook, BKM_QUERYPAGEWINDOWHWND,\
                                             MPFROMLONG( ulPage1 ),\
                                             MPVOID);

               hwndPage2 = (HWND)WinSendMsg( hwndNotebook, BKM_QUERYPAGEWINDOWHWND,\
                                             MPFROMLONG( ulPage2 ),\
                                             MPVOID);
               OptionsRefresh(hwndPage1,hwndPage2,pDlgInfo->pOptions);
            }
            break;

            case ID_OK:
            {
               HWND hwndNotebook;
               HWND hwndPage1,hwndPage2;
               ULONG ulPage1,ulPage2;

               pDlgInfo = (SOM_DLGINFO*)WinQueryWindowPtr(hwndDlg,QWL_USER);

               hwndNotebook = WinWindowFromID( hwndDlg, ID_SOMNOTEBOOK);
               ulPage1    = (ULONG)WinSendMsg( hwndNotebook, BKM_QUERYPAGEID,\
                                              MPVOID,
                                              MPFROM2SHORT( BKA_FIRST,BKA_MAJOR ));
               ulPage2    = (ULONG)WinSendMsg( hwndNotebook, BKM_QUERYPAGEID,\
                                               MPFROMLONG( ulPage1 ),\
                                               MPFROM2SHORT( BKA_NEXT,BKA_MAJOR));

               hwndPage1 = (HWND)WinSendMsg( hwndNotebook, BKM_QUERYPAGEWINDOWHWND,\
                                             MPFROMLONG( ulPage1 ),\
                                             MPVOID);

               hwndPage2 = (HWND)WinSendMsg( hwndNotebook, BKM_QUERYPAGEWINDOWHWND,\
                                             MPFROMLONG( ulPage2 ),\
                                             MPVOID);

               OptionsSave(hwndPage1,hwndPage2,pDlgInfo->pOptions);

               WinDismissDlg(hwndDlg,WKF_NOERROR);
            }
            break;

            case ID_CANCEL:
            {
               WinDismissDlg(hwndDlg,WKF_CANCEL);
            }
            break;
         }
      }
      break;

      default:
         return WinDefDlgProc(hwndDlg,msg,mp1,mp2);
   }
   return MRFROMLONG(FALSE);
}
