/* NOSHIP */
#ifndef _IDDEINFO_
#define _IDDEINFO_
/*******************************************************************************
* FILE NAME: iddeinfo.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     Iddeinfo                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <istring.hpp>
#include <ireslock.hpp>

#pragma pack(4)

struct _DDESTRUCT;
class IDDEAckQueue;
class IDDEServerAcknowledgeEvent;

class IDDEFormat {
public:
  IDDEFormat ( unsigned long ddeFormat );
 ~IDDEFormat ( );
unsigned long
  ulClFormat;
IDDEFormat
 *pNextCl;
};  // IDDEFormat

class IDDEFormatSet {
public:
   IDDEFormatSet ( );
  ~IDDEFormatSet ( );
void
  add ( unsigned long ddeFormat );
IDDEFormat
 *pFirstCl;
private:
IPrivateResource
  priResCl;
};  // IDDEFormatSet


/*-------------------------------- Accessors -----------------------------------
|   freeMemory     - Frees the shared memory from used to send data between    |
|                    processes.                                                |
|   buildDDEStruct - Builds a DDESTRUCT.                                       |
|   atomFromString - Converts a string to its associated atom.  The atom will  |
|                    be added to the atom table if it does not already exist.  |
|   stringFromAtom - Converts an atom to its associated string.                |
------------------------------------------------------------------------------*/
unsigned long
  IDDEInfo__atomFromString ( const char* atomAsString,
                             Boolean*    atomAdded  );

IString
  IDDEInfo__stringFromAtom ( unsigned long atom );

void
  IDDEInfo__freeMemory ( _DDESTRUCT* ddeInformation );

_DDESTRUCT
 *IDDEInfo__buildDDEStruct ( const char*    itemName,
                             const char*    dataFormat,
                             unsigned short status,
                             const void *   transferData,
                             unsigned long  dataLength,
                             Boolean*       atomAdded );

class IDDEServerConversation : public IBase
{
public:
  IDDEServerConversation  ( unsigned long clientHwnd )
       : ulClClientHwnd(clientHwnd), pAckQCl(0)  { }
  ~IDDEServerConversation ( );
unsigned long const&
  conversationId ( ) const
        { return ulClClientHwnd; }
Boolean
  isAckOutstanding ( IString item,
                     IString format ) const;
void
  addEvent ( IDDEServerAcknowledgeEvent* pEvt );
IDDEServerAcknowledgeEvent*
  removeEvent ( );
unsigned long
  eventCount ( ) const;

private:
unsigned long
  ulClClientHwnd;
IDDEAckQueue
 *pAckQCl;
}; // IDDEServerConversation

class IDDEStatics : public IBase {
public:
  ~IDDEStatics();
static IPrivateResource
 &semaphor ( );
private:
static IPrivateResource
 *pPriResCl;
};  // IDDEStatics

#pragma pack()

inline unsigned long const& key (IDDEServerConversation* const& conversation)
       { return conversation->conversationId(); }

#endif // _IDDEINFO_
