/*******************************************************************************
* FILE NAME: ikeyhdr.c                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the template functions                *
*   declared in ikeyhdr.hpp.                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ikeyhdr.hpp>


template<class ATarget>
IKeyboardConnectionTo<ATarget>::IKeyboardConnectionTo( ATarget&           target,
                                                       KeyboardMemberFn   characterKeyMemberFn )
: fTarget(target),
  fConnectedCharacterKeyMember(characterKeyMemberFn),
  fConnectedVirtualKeyMember(0)
{
}

template<class ATarget>
IKeyboardConnectionTo<ATarget>::~IKeyboardConnectionTo()
{
}

template<class ATarget>
Boolean
IKeyboardConnectionTo<ATarget>::characterKeyPress( IKeyboardEvent& event )
{
    //----------------------------------------------------------------
    // DEFECT 26389 : check for valid key function, before calling
    //----------------------------------------------------------------
    if ( fConnectedCharacterKeyMember )
       return ( fTarget.*fConnectedCharacterKeyMember ) ( event );
    else
       return false;
}

template<class ATarget>
Boolean
IKeyboardConnectionTo<ATarget>::virtualKeyPress( IKeyboardEvent& event )
{
    if ( fConnectedVirtualKeyMember )
       return ( fTarget.*fConnectedVirtualKeyMember ) ( event );
    else
       return false;
}

template<class ATarget>
IKeyboardConnectionTo<ATarget>&
IKeyboardConnectionTo<ATarget>::setVirtualKeyMemberFn ( KeyboardMemberFn virtualKeyMemberFn )
{
    fConnectedVirtualKeyMember = virtualKeyMemberFn;
    return *this;
}

