/*******************************************************************************
* FILE NAME: ipainhdr.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in ipainhdr.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#define INCL_WINMESSAGEMGR
#define INCL_WINWINDOWMGR
extern "C" {
  #include <iwindefs.h>
}
#ifndef _IPAINHDR_
  #include <ipainhdr.hpp>
#endif
#ifndef _IPAINEVT_
  #include <ipainevt.hpp>
#endif
#include <itrace.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IPAINHDR_CPP_
  #include <ipagetun.h>
#endif


/**************************************************************/
/* Default constructor for page tuning.                       */
/**************************************************************/
IPaintHandler :: IPaintHandler ( )
{ ; }


/**************************************************************/
/* Empty destructor for page tuning.                          */
/**************************************************************/
IPaintHandler :: ~IPaintHandler ( )
{ ; }


/**************************************************************/
/* dispatchHandler Event - Dispatch command functions for this handler. */
/**************************************************************/
Boolean IPaintHandler :: dispatchHandlerEvent(IEvent & evt)
{
   IBoolean bRc = false;

#ifdef IC_PMWIN
   if (evt.eventId() == WM_PAINT) {
      IPaintEvent ptevt(evt);
      // if the rect is 0 sized then don't call paintWindow.
      if ( ptevt.rect() != IRectangle() )
      {
         bRc = paintWindow(ptevt);    // call derived class (if any) to paint
         if (bRc)
         {
            RECTL  rct = ptevt.rect().asRECTL();
#ifdef IC_WIN
#ifdef IC_TRACE_ALL
            ITRACE_ALL(IString("IPaintHandler::dispatch (true) hwnd=")+
                       IString(evt.handle().asUnsigned()).d2x() );
            ITRACE_ALL(IString("rect=(") +
                       IString(rct.left) + IString(",") +
                       IString(rct.top) + IString(",") +
                       IString(rct.right) + IString(",") +
                       IString(rct.bottom) + IString(")") );
#endif
//            IVALIDATERECT(evt.handle(), (const tagRECT*)&rct );
            IVALIDATERECT(evt.handle(), 0 );    // validate whole region
#else
            IVALIDATERECT(evt.handle(), &rct );
#endif
            evt.setResult(ptevt.result());  // copy result
         }
      } 
      else   // Ensure default painting occurs
      {        
#ifdef IC_WIN
#ifdef IC_TRACE_ALL
            ITRACE_ALL(IString("IPaintHandler::dispatch (false) hwnd=")+
                       IString(evt.handle().asUnsigned()).d2x() );
#endif
               PAINTSTRUCT ptst;
               BeginPaint( evt.handle(), &ptst );
               EndPaint( evt.handle(), &ptst );
#else
               WinEndPaint(WinBeginPaint(evt.handle(), 0, 0));
#endif
      }
   } /* endif */
#endif //IC_PMWIN

#ifdef IC_MOTIF
   if (evt.eventId() == xEvent(Expose)) 
   {
      IPaintEvent ptevt(evt);
      if (ptevt.presSpaceHandle())    // if we have a pres space
         bRc = paintWindow(ptevt);    // call derived class (if any) to paint
      // In Motif, we don't need to do anything else.
      if (bRc)
         evt.setResult(ptevt.result());  // copy result 
      // In IPaintEvent dtor, other data from ptevt is unconditionally copied into evt.
   } /* endif */
#endif //IC_MOTIF

   return bRc;
}
