//===============================================================
// vapp.h - the vapp base object - Windows version
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================
#ifndef VAPP_H
#define VAPP_H
#include <v/vos2.h>
#include <v/vbaseitm.h>	// our parent class
#include <v/vfont.h>	// our parent class
#include <v/vawinfo.h>
#include <v/vmenu.h>
#include <v/vtimer.h>
#include <v/vthislst.h>
#define MaxAppFonts FontIdsUsed

    const char szvFrameClass [] = "vFrameClass";	// To give it a name
    const char szvWindowClass [] = "vWindowClass";	// To give it a name
    static vThisList _timers;

    extern int AppMain(int, char**);
    class vWindow;
    class vCommandPane;
    typedef struct WindList
      {
	vWindow* window;
	vAppWinInfo* info;
	WindList* nextWinList;
      } WindList;
    typedef struct CmdPaneList
      {
	vCommandPane* commandPane;
	CmdPaneList* nextCPList;
      } CmdPaneList;
    // long  APIENTRY  wpFrameProc(HWND, ULONG, MPARAM, MPARAM);
	MRESULT  EXPENTRY  wpWindowProc(HWND, ULONG, MPARAM, MPARAM);
	class _appWorkTimer : public vTimer
	  {
	  public:		//---------------------------------------- public
	_appWorkTimer() {}
	~_appWorkTimer() {}
	virtual void TimerTick();
	  private:		//--------------------------------------- private
	  };
	class vApp : public vBaseItem
	  {
	// give friend access to some special things
	friend class vWindow; // Provide access for vWindow class
	friend class vMenuPane; // Menu Pane needs access
//	friend class vCommandPane;
	friend int main(int argc, char** argv);
	friend MRESULT EXPENTRY wpWindowProc(HWND, ULONG, MPARAM, MPARAM);
	friend class _appWorkTimer;
	friend class vTimer;

      public:		//---------------------------------------- public
	vApp(char* appName, int simSDI = 1, int frameHeight = 0, int frameWidth = 0);	// constructor
	virtual ~vApp();	// destructor

	// Methods to override
	virtual void AppCommand(vWindow* win, ItemVal id, ItemVal retval,
				CmdType ctype);
	virtual void CloseAppWin(vWindow* win);
	virtual void CloseHelpWin(vWindow* win);
	int IsHelpWin(vWindow *Win);
	virtual void Exit(void);
	virtual void KeyIn(vWindow* win, vKey key, unsigned int shift);
	virtual vWindow* NewAppWin(vWindow* win, char* name, int w, int h,
		vAppWinInfo* winInfo = 0);
	virtual  vWindow* NewHelpWin(vWindow* win, char* name, int h, int w);
	// Utlity methods
	vFont GetDefaultFont();
	void GetVVersion(int& major, int& minor)
	   { major = V_VersMajor; minor = V_VersMinor;}
	int DefaultHeight() { return _DefaultHeight; }
	int DefaultWidth() {return _DefaultWidth; }
	int IsRunning() {return _running;}  // see if app is running
	void SendWindowCommandAll(ItemVal id, int val, CmdType ctype);
	void SetValueAll(ItemVal id, int val, ItemSetType setType);
	void SetAppTitle(char* title);
	void SetStringAll(ItemVal id, char* str);
	int ShowList();
	vAppWinInfo *getAppWinInfo(vWindow* Win);
	void AppExit(int exitVal);
	int InExit() { return _inExit; }
	// Tasking
	void CheckEvents();
	int EnableWorkSlice(long slice);
	virtual void WorkSlice() {}	// No op by default
	// OS/2 stuff
	HAB AppHab() { return _hab; }
	HMQ AppHmq() { return _hmq; }
	ULONG AppCP() { return _codePage; }
	// Windows stuff
	HWND winHwnd() { return _Frame; }
	HWND winClientHwnd() { return _Client; }
	int simSDI() {return _simSDI;}
	HWND AppFrameMenu() {return hFrameMenu;}

      protected:	//--------------------------------------- protected
	WindList* _WindowList;		// List of "top level" windows
	CmdPaneList* _CmdPaneList;	// List of command panes
	int _running;			// if we are running
	// The following two are called from main.
	void initialize(int& argc, char** argv);
	int doEventLoop();
      private:		//--------------------------------------- private
	int _DefaultHeight;
	int _DefaultWidth;
	int _frameWidth, _frameHeight;
	int _inExit;		  	// If in exit procedure
	int _simSDI;			// if Simulate SDI interface
	_appWorkTimer* _workTimer;	// timer for work slice
	void registerWindow(vWindow* Win, vAppWinInfo* awinfo);
	void unregisterWindow(vWindow* Win);
	void DispatchWork(void);
	void registerCmdPane(vCommandPane* cmdPane);
	void unregisterCmdPane(vCommandPane* cmdPane);
//	void selectCmdPanes(vWindow* parent);
	HWND hFrameMenu, hFrameSubMenu;	// Default menu
	HWND  _Frame, _Client;		// Need these for frame
	HAB _hab;
	HMQ _hmq;
	ULONG _codePage;               // system codepage
	HWND hAccel;
	vWindow* _curThis;	// Needed to fake things out at the start
	HPOINTER _appicon, _winicon;
      };
    extern vApp *theApp;		// Pointer to single global instance
#endif
