//===============================================================
// vbrush.cxx: vBrush class for drawing - Windows
//
// Copyright (C) 1995,1996,1997,1998  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================
#include <v/vOS2.h>           // for OS/2 stuff
#include <v/vapp.h>
#include <v/vbrush.h>
//=======================>>> vBrush::vBrush <<<===========================
  vBrush::vBrush(unsigned int r, unsigned int g, unsigned int b,
              int style, int fillMode)
  {
      brushColor._r = r, brushColor._g = g; brushColor._b = b;
      brushColor._pixel = SETRGB(r,g,b);
      brushStyle = style;
      brushFillMode = fillMode;
  }
//=======================>>> vBrush::~vBrush <<<===========================
  vBrush::~vBrush()
  {
  }
//=====================>>> vBrush::vBrush <<<===========================
  vBrush::vBrush(const vBrush& p)
  {
    brushColor = p.brushColor;
    brushFillMode = p.brushFillMode;
    brushStyle = p.brushStyle;
  }
//=====================>>> vBrush::operator= <<<===========================
  vBrush& vBrush::operator =(const vBrush& p)
  {
    if (this == &p)     // assigning to self
      {
	return *this;
      }
    brushColor = p.brushColor;
    brushFillMode = p.brushFillMode;
    brushStyle = p.brushStyle;
    return *this;               // allow r to l multiple assignment
  }
//=====================>>> vBrush::SetStyle <<<===========================
  void vBrush::SetStyle(int style)
  {
    brushStyle = style;
  }
//=====================>>> vBrush::SetFillMode <<<===========================
  void vBrush::SetFillMode(int fm)
  {
    brushFillMode = fm;
  }
//=====================>>> vBrush::SetColor <<<===========================
  void vBrush::SetColor(vColor c)
  {
    brushColor = c;
  }
//=====================>>> vBrush::SetColor <<<===========================
  void vBrush::SetColor(unsigned int r, unsigned int g, unsigned int b)
  {
    brushColor.Set(r,g,b);
  }
//=====================>>> vBrush::GetHBRUSH <<<===========================
// returns pointer to AREABUNDLE set with vBrush attributes
  PAREABUNDLE vBrush::GetHBRUSH()
  {
	_abBrush.lColor = brushColor._pixel;
	_abBrush.usMixMode = FM_OVERPAINT;
	switch (brushStyle)
	  {
	    case vSolid:
		_abBrush.usSymbol = PATSYM_SOLID;
		break;
	    case vTransparent:
		_abBrush.usSymbol = PATSYM_NOSHADE;
		break;
	    case vHorizontalHatch:
		_abBrush.usSymbol = PATSYM_HORIZ;
		break;
	    case vVerticleHatch:
		_abBrush.usSymbol = PATSYM_VERT;
		break;
	    case vLeftDiagonalHatch:
		_abBrush.usSymbol = PATSYM_DIAG3;
		break;
	    case vRightDiagonalHatch:
		_abBrush.usSymbol = PATSYM_DIAG1;
		break;
	    case vCrossHatch:
		_abBrush.usSymbol = PATSYM_HATCH;
		break;
	    case vDiagonalCrossHatch:
		_abBrush.usSymbol = PATSYM_DIAGHATCH;
		break;
	    default:
		_abBrush.usSymbol = PATSYM_SOLID;
		break;
	  }
      return &_abBrush;                   // return pointer to areabundle
  }
