//===============================================================
// vlabelc.cxx  - label Cmd - Windows
//
// Copyright (C) 1995,1996,1997,1998  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================
#include <v/vos2.h>     // for OS/2 stuff
#include <v/vlabelc.h>  // our definitions
#include <v/vcmdprnt.h> // a command parent
#include <v/vutil.h>    // utility
#include <v/vicon.h>    // icons
//=====================>>> vLabelCmd::vLabelCmd <<<=======================
  vLabelCmd::vLabelCmd(vCmdParent* dp, CommandObject* dc):
	    vCmd(dp, dc)
  {
    initialize();
  }
//=====================>>> vLabelCmd::~vLabelCmd <<<=======================
  vLabelCmd::~vLabelCmd()
  {
    SysDebug(Destructor,"vLabelCmd::~vLabelCmd() destructor\n")
  }
//=====================>>> vLabelCmd::initialize <<<=======================
  void vLabelCmd::initialize(void)
  {
    // build a button command for use in a parent window
    CopyToLocal();                      // Make local copies of CmdObject
    SysDebug(Constructor,"vLabelCmd::vLabelCmd() constructor\n")

    if (dlgCmd->cmdType == C_Icon && _itemList != 0)    // icon
    {
      initIcon();
      return;
    }

    // set the Pres Params to the system default color
    _PPColor[0].PPtype = PP_BACKGROUNDCOLORINDEX;
    _PPColor[0].PPval.color = SYSCLR_DIALOGBACKGROUND;
    _PPColor[1].PPtype = PP_FOREGROUNDCOLORINDEX;
    _PPColor[1].PPval.color = SYSCLR_MENUTEXT;
    _PPColor[2].PPtype = 0;    // end of array marker

    if (dlgCmd->cmdType == C_ColorLabel && _itemList != 0)    // color
    {
      initColorLabel();
    }

    ULONG style = SS_TEXT | DT_BOTTOM;

    if (!(dlgCmd->attrs & CA_Hidden))   // Check for Hidden
      style |= WS_VISIBLE;

    if (dlgCmd->size > 0)               // may reset title!
    {
      _w = dlgCmd->size;
    }
    else if ((dlgCmd->attrs & CA_MainMsg) && (LabelWidth(_title) < 80))
    {
      _w = 88;
    }
    else
      _w = LabelWidth(_title) + 8;            // set my width


    if (_parentWin->paneType() == P_Status
        || dlgCmd->cmdType == C_Blank)
    {
      _h = LabelHeight()+3;  // was 9
    }
    else
    {
      _h = LabelHeight()+3;  // was 9
    }

    _parentWin->SetPosition(_x, _y, _w, _h, dlgCmd->cFrame,
      dlgCmd->cRightOf, dlgCmd->cBelow);

//    _y += 1;   // center better
//    _h -= 1;

    _CtrlOffset = _parentWin->AddDlgControl(_x, _y , _w, _h, _cmdId,
      style, WC_STATIC, _title, _parentWin->AssyPresParams(_PPColor), 0, NULL);
  }

//=====================>>> vButtonCmd::initColorButton <<<=======================
  void vLabelCmd::initColorLabel(void)
  {
    // wCmd is the widget of this button
    _origColor = 0;
    if (_itemList != 0)          // an RGB provided
    {
      _origColor = (vColor*)_itemList;   // point to the rgb
      _color = *_origColor;
    }
    // set the Pres Params to the specified color
    // we use the RGB version for the background
    _PPColor[0].PPtype = PP_BACKGROUNDCOLORINDEX;
    _PPColor[0].PPval.color = SYSCLR_DIALOGBACKGROUND;
    _PPColor[1].PPtype = PP_FOREGROUNDCOLOR;
    _PPColor[1].PPval.color = (LONG) _color.pixel();
    _PPColor[2].PPtype = 0;    // end of array marker
  }

//=====================>>> vLabelCmd::initIcon <<<=======================
  void vLabelCmd::initIcon(void)
  {
    // I don't know how to make an SS_BITMAP control at creation
    // time since there is nothing like a  BTNCDATA structure...
    // So, we start out making a static text control and add the
    // bitmap later in the WM_INITDLG code before its visible
    // (see DRAWITEM for details)
    ULONG style = SS_TEXT;

    if (!(dlgCmd->attrs & CA_Hidden))  // Check for Hidden
      style |= WS_VISIBLE;

    _ip = (vIcon *) _itemList;  // to access bitmap
    _h = LONG( ((_ip->height*2)/5) + 4 );
    _w = LONG( (_ip->width / 2) + 6 );

    _parentWin->SetPosition(_x, _y, _w, _h, dlgCmd->cFrame,
	     dlgCmd->cRightOf, dlgCmd->cBelow);

//    _y += 2;   // align it a bit better
//    _h -= 2;

    _CtrlOffset = _parentWin->AddDlgControl(_x, _y , _w, _h, _cmdId,
	   style, WC_STATIC, "", NULL, 0, NULL);
  }
//================>>> vLabelCmd::SetCmdVal <<<============================
  void vLabelCmd::SetCmdVal(ItemVal val, ItemSetType st)
  {
    SysDebug2(Misc,"vLabelCmd::SetCmdVal(val:%d ItemSetType:%d)\n",val,st)
    HWND myHwnd = GetMyHwnd(_cmdId);
    SysDebug2(OS2Dev,"       myHwnd(_cmdId=%u)=%x\n",_cmdId,myHwnd)

    switch (st)
    {
      case Sensitive:
	_Sensitive = val;               // set
	WinEnableWindow (myHwnd, val);
	break;

      case Hidden:
	if (val)
	{
	  WinShowWindow (myHwnd, FALSE);
	}
	else
	{
	  WinShowWindow (myHwnd, TRUE);
	}
	break;

      case ChangeColor:               // changed original vColor
      {
	_color = *_origColor;       // recopy color

	// set the Pres Params to the specified color
	// we use the RGB version of the PP_
	_PPColor[1].PPtype = PP_FOREGROUNDCOLOR;
	_PPColor[1].PPval.color = (LONG) _color.pixel();

	WinSetPresParam(myHwnd, _PPColor[1].PPtype, (ULONG) sizeof(RGB),
	  (PVOID) &_PPColor[1].PPval.color);

	break;
      }
      case Red:
	_color.SetR(val);
	break;

      case Green:
	_color.SetG(val);
	break;

      case Blue:
      {
	_color.SetB(val);
	_PPColor[1].PPtype = PP_FOREGROUNDCOLOR;
	_PPColor[1].PPval.color = (LONG) _color.pixel();
	WinSetPresParam(myHwnd, _PPColor[1].PPtype, (ULONG) sizeof(RGB),
	  (PVOID) &_PPColor[1].PPval.color);
	break;
      }
    }
  }

//================>>> vLabelCmd::SetCmdStr <<<============================
  void vLabelCmd::SetCmdStr(VCONST char* str)
  {
    char trunc[80];
    SysDebug1(Misc,"vLabelCmd::SetCmdStr(str:%s)\n",strncpy(trunc, str, 60) )
    WinSetDlgItemText(_parentWin->getParent(), _cmdId, str);

    _title = str;
  }

//================>>> vLabelCmd::MEASUREITEM <<<============================
  int vLabelCmd::MEASUREITEM(int id, OWNERITEM* oi)
  {
    return 1;
  }

//================>>> vLabelCmd::DRAWITEM <<<============================
  int vLabelCmd::DRAWITEM(int id, OWNERITEM* poi)
  {
    // This really has nothing to do with DRAWITEM, but its
    // an unused procedure that we can hijaak and use to load
    // the bitmap for C_Icons during the WM_INITDLG setup

    if (dlgCmd->cmdType == C_Icon)
    {
      // This is called during WM_INITDLG for static Icons
      // so we can load the bitmap

      // We force the bitmap to be rebuilt with each call
      // since SS_BITMAP appears to auto destroy the bitmap when the window
      // is destroyed

      // Note: For transparent icons we cannot us BM_SRCTRANSPARENT since
      // there is no canvas to bitblt into.  Instead, we pass the dialog
      // background color we need to the icon creation method, and it
      // substitutes the dialog background color for the icon background
      // to fake transparency.
      HBITMAP hImage;

      // get icon HBITMAP
      hImage = _ip->GetIconDLG(C_Icon, SYSCLR_DIALOGBACKGROUND);

      HWND hIcon = GetMyHwnd(id);
      WinSetWindowBits(hIcon, QWL_STYLE, SS_BITMAP, SS_BITMAP | 0x7f);
      MRESULT NewhImage = WinSendMsg(hIcon, SM_SETHANDLE, MPFROMP(hImage), NULL);

      SysDebug2(OS2Dev,"vLabelCmd::DRAWITEM hImage:%x NewhImage:%x\n", hImage, NewhImage)
      SysDebug2(OS2Dev,"vLabelCmd::DRAWITEM this:%x hIcon:%x \n", this, hIcon)

    }
    return (0);
  }

//===================>>> vLabelCmd::vCmdCallback <<<=======================
  void vLabelCmd::CmdCallback(UINT uMsg, MPARAM mp1, MPARAM mp2)
  {
    // No Op for a label
  }
