/*
	This program is provided on an "as is" basis, without warranty of any
	kind. The entire risk as to the quality and performance of the program
	is borne by you.

    Report bugs to: july@cblink.net
*/

#ifndef __v2i_h
#define __v2i_h

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long dword;

typedef struct
{
    word res;   /* reserved; must be zero */
    word type;  /* resource type; must be 1 */
    word count; /* number of entries in the directory */

} icondir;

typedef struct
{
    byte width;     /* width of the icon in pixels; acceptable values: 16,32,64 */
    byte height;    /* height of the icon in pels; acceptable values: 16,32,64 */
    byte colors;    /* number of colors in the icon; acceptable values: 2,8,16 */
    byte res;       /* reserved; must be zero */
    word planes;    /* number of color planes in the color bitmap */
    word bitcnt;    /* number of bits in the icon bitmap */
    dword bytes;    /* specifies the size of the resource in bytes */
    dword imageoff; /* the offset, in bytes, from the bof to the icon image */

} icondirentry;

typedef struct
{
    dword size;         /* number of bytes req'd by the structure (40) */
    long width;         /* width of the bitmap, in pixels (icondirentry.width) */
    long height;        /* width of the bitmap, in pixels (icondirentry.height * 2) */
    word planes;        /* this value must be set to 1 */
    word bitcnt;        /* number of bits per pixel; acceptable values: 1,4,8,16,24,32 (log2(icondirentry.colors)) */
    dword compress;     /* NOT USED (0) */ /* type of compression */
    dword sizeimage;    /* the size, in bytes, of the image */
    long xppm;          /* NOT USED (0) */ /* horizontal pixels per meter */
    long yppm;          /* NOT USED (0) */ /* vertical pixels per meter */
    dword clrused;      /* NOT USED (0) */ /* number of color indices in the color table that are actually used by the bitmap */
    dword clrimp;       /* NOT USED (0) */ /* umber of color indices that are considered important for displaying the bitmap */

} bitmapinfoheader;

typedef struct
{
    byte b, g, r, res;

} rgbquad;

typedef enum { ttcolor, ttul, ttur, ttll, ttlr } transptype;
typedef struct
{
	transptype ttype;
    int depth, width, height, transpc;
    int *colortable;	/* colortable[256] */
    int *pict;			/* pict[64][64] */

} iconrec;

extern iconrec *icn;

#define MAXICONS 	5
#define PICT(x,y) 	(icn->pict[(x)*64 + (y)])

int nearest( rgbquad q );
int read_char();

#endif
