/*  This file rebuilds your VisPro/C++ desktop.
 *  You would execute this file if your system
 *  INI files become damaged, or if you accidentally
 *  delete the VisPro/C++ WorkPlace Shell icon.
 *
 *  This program assumes you have already installed
 *  VisPro/C++ and have the product in the PATH
 *  variable of your CONFIG.SYS.
 */
call rxfuncadd 'sysloadfuncs','rexxutil','sysloadfuncs'
call sysloadfuncs
PRODCHECK=syssearchpath('PATH','VISPROCP.EXE')
PRODUCTDIR=left(PRODCHECK,length(PRODCHECK)-13)
PROJECTDIR=PRODUCTDIR'\projects'
SAMPLESDIR=PRODUCTDIR'\samples'
INFILE='VISPRO'
rc=stream(INFILE,'c','open')
if rc<>'READY:' then do
   say ''
   say '  Error opening the VISPRO control file.'
   say '  Run this program from the VisPro/C++'
   say '  installation disk 1.'
   say ''
   exit
end
if lines(INFILE)<1 then do
   say ''
   say '  Error opening the VISPRO control file.'
   say '  Run this program from the VisPro/C++'
   say '  installation disk 1.'
   say ''
   rc=stream(INFILE,'c','close')
   call sysfiledelete(VISPRO)
   call sysdropfuncs
   exit
end
say 'Recreating objects...'
do 9
   null=linein(INFILE)
end /* do */

INSTRING=linein(INFILE)

do while left(INSTRING,1)='('
   COMMAND='rc=syscreateobject'||INSTRING
   interpret COMMAND
   if rc<>1 then do
      say '  ERROR'
      say '  An error occured while processing the string'
      say ' 'COMMAND
      say '  Check to make sure the affected files/directories'
      say '  exist, then run this program again.'
      say '  Check the online REXX reference for more information'
      say '  on the SysCreateObject call.'
      rc=stream(INFILE,'c','close')
      call sysfiledelete(VISPRO)
      call sysdropfuncs
      exit
      end
   INSTRING=linein(INFILE)
end /* do */

rc=stream(INFILE,'c','close')
call sysdropfuncs
exit
say 'Objects successfully recreated.'
