
          ****************
          ** C Compiler **
          ****************

    Don't issue errors for invalid octal constants found in blocks
    of code that are commented out.
===========================================================

    Expressions of the form:
    
    	"string"( 1 );
	
    caused the compiler to crash.
===========================================================

          ********************
          ** Code Generator **
          ********************

    Taking the address of a "far" function in the 32-bit
    compiler when the "-bt=windows" switch was used would
    sometimes only generate a 16-bit offset fixup rather
    than a 32-bit offset.
===========================================================

    Functions which returned structures using __syscall
    would lose track of the amount of stuff on the stack.
===========================================================

    An instruction which had an indexed operand and result
    which were the same (ie [edx]), and for which there was
    an older register with the same value available,
    would replace the register with the older value, even if
    the older value was destroyed by the operation.

    ie.		mov eax, edx
    		sqrt [edx] -> [edx]	{ destroys eax }
	would become
		mov eax, edx
		sqrt [eax] -> [eax]	{ bad since eax destroyed }
===========================================================

    If we had a loop which was the destination of a multi-way
    branch (ie switch), instructions which were used to setup
    induction variables would be lost when writing out the
    object file, providing there were no paths to the loop other
    than through the multi-way branch. (You don't want to see the
    example :)
===========================================================

    Fixed a bug in the floating point scheduler which would
    cause an ICE #81 to occur when trying to deal with POW
    operations if -fpr and -fp5 were both thrown.
===========================================================

    The inline assembler did not properly encode the
    following instruction with the 32-bit compilers:

    		mov ss,sp

===========================================================

    The C++ compiler could cause the code generator to
    output information to the object file which would
    confuse wdisasm into displaying whole code segments
    as "DB <hex_byte>" rather than assembly instructions.
    It had no effect on the actual generated code.
===========================================================

    The inline assembler for the 32-bit compilers did not
    properly handle a conditional jump instruction to
    an external procedure.
===========================================================

    Loops which were driven by a comparison involving a
    bit-test (such as while( i & 3 ) ), could, if the
    compiler got over-zealous in applying induction variable
    analysis, have bad code generated for them.
===========================================================

    byte swapping code which led to an instruction like
    "movzx dx,dh" would be (mis)optimized into something which
    zeroed out the dx register. Note that the operands had to
    be a two-byte register and it's high half for this to occur.
===========================================================

    A pair of instructions which looked something like
    	"add A,X -> A" and "add A,Y -> B"
    would be changed into something which looked like
    	"add A,X+Y -> B" and "add A,X -> A"
    This was bad if B was redefined in between the two instructions
    and the placements of the new instructions were identical to the
    old ones.
===========================================================

    Constants near an expression involving a multiplication
    by 0 would be treated as 0.
===========================================================

    The QNX 32-bit hosted compilers could run out of stack
    space when compiling large routines since the code 
    which allocated more stack in the code generator for deeply 
    recursive routines was accidently disabled.
===========================================================

    Loops with a driving expression which could be determined to
    be TRUE at compile time would cause code generator to hang in
    certain situations.
===========================================================

          ***************
          ** C Library **
          ***************

    _grow_handles() for OS/2 1.x now handles case where
    the argument specifies fewer than the minimum number of
    handles allowed by the operating system.
===========================================================

    Small data model (-ms, -mm) Windows 16 bit executables
    now receive a valid pointer in the LpCmdLine variable
    passed to WinMain().
===========================================================

    POSIX level close() for OS/2 2.x and Windows NT now
    properly manages the multi-thread serialization primitives.
===========================================================

    OS/2 2.x startup code for DLLs now sets up the environment
    information for use from within the DLL.
===========================================================

    The fcvt() and ecvt() functions now properly append
    trailing zeros when requested.
===========================================================

    The POSIX level read() function when opened with O_TEXT
    did not handle embedded ctrl-z characters properly.
===========================================================

    The fdopen() function now properly handles the "a"
    attribute when in the face of calls to ftell().
===========================================================

    OS/2 spawn calls now handle P_NOWAITO and P_NOWAIT properly
    for use by subsequent calls to wait().
===========================================================

    _dos_findclose() stub function has been added to the DOS
    hosted library in order to minimize user program conditional
    compilation given that _dos_findclose() must be called
    under OS/2 and Windows NT.
===========================================================

    NT hosted fclose() function was not properly releasing
    the file handle.
===========================================================

    _harderr() function was not setting up DS prior to use
    in large data models.
===========================================================

    NT hosted heap manager was not making proper use of
    serialization primitives for multi-threading support.
===========================================================

    _harderr function didn't calculate the device header address
    correctly in 32-bit extended DOS environment.
===========================================================

    Memory allocation with FlashTek extender fixed so that it
    doesn't use the "lsl" instruction.
===========================================================

    Under OS/2 2.x longjmp() from a signal handler is allowed
    and now re-enables subsequent invocations of the signal.
===========================================================

    32bit _harderr() function was not working properly for
    PharLap version 5 or the PharLap TNT extender.
===========================================================

    Under OS/2 the isatty() function incorrectly indicated
    that pipes were ttys.
===========================================================

    The mktime() function did not handle negative hours
    properly.
===========================================================

    The localtime() function did not figure out DST
    (Daylight Savings Time) properly when configured for
    the southern hemisphere where the start point comes
    after the end point in a given calendar year.
===========================================================

    The signal() function did not properly ignore signals
    when SIG_INT specified for OS/2 and Windows NT.
===========================================================

    st_mode field in fstat struct was not being initialized on NT.
===========================================================

    The QNX version of kbhit did not return TRUE if an
    ungetc() had been done.
===========================================================

    Fixed malloc() for PharLap/QNX systems for cases where
    sbrk() is called between mallocs.
===========================================================

    Fixed scanf() and related functions to properly handle
    assignment suppression of floating point values.
===========================================================

    Fixed _heapshrink() for Rational Systems DOS/4GW.
===========================================================

    Industry convention says that puts() and fputs() return
    the number of characters written on success.  The ANSI
    spec says that they return a non-negative value on
    success.  The functions have been changed to conform
    with the industry convention since it is not incompatible
    with the ANSI specification.
===========================================================

    sopen() function was not properly setting errno to
    EEXIST under Windows NT.
===========================================================

    Under extended dos a call to malloc() slightly less than
    4GB of memory would not fail properly.
===========================================================

    The OS/2 spawn* functions did not work properly in
    a detached session.
===========================================================

    fixed _nheapshrink() and _nheapmin() for the case where
    a sbrk() or system specific piece of memory is added
    after the CLIB's memory (should not shrink in this case
    because it will cancel or corrupt the alternate memory)
===========================================================

    fixed integer exponent operator for (-1)^(-1)
===========================================================

    fixed localtime() function to properly assume that it
    is not daylight savings time when no rule has been
    specifed for the conversion to daylight savings time.
===========================================================

    spawn wasn't setting the .cb field in the parm passed
    to CreateProcess.  This didn't matter under NT, but wouldn't
    work on Chicago.
===========================================================

          ******************
          ** C++ Compiler **
          ******************

    fixed virtual thunk calculation for certain non-virtual
    multiple inheritance hierarchies (fairly rare case because
    the C++ compiler already tries to minimize the number of
    thunks it has to generate so the problem only occurs if
    you combine two hierarchies that have a lot of virtual fns)
    
    e.g.,   B1  B2  B3(f)	where sizeof(B1) != 0
	     \   \  /		  and sizeof(B2) != 0
	      \   D1(f)	call f() in B3 context
	       \  /
		D2

===========================================================

    static members should not influence whether a class
    needs a constructor since they are initialized
    separately (likewise for destructors and op=)

===========================================================

    fixed token pasting of two tokens that result in
    a long string
    e.g.,

	#define TXT( a ) L##a
	
	long char *p = TXT("xx");

===========================================================

    The C++ compiler did not properly parse command line
    macro definitions with values (e.g., -DFOO=5) if the
    -D+ option had been previously specified.
===========================================================

    Compiler complained about an invalid octal constant
    even though the source code was being skipped.
    e.g.,
	#if 0
	08
	#endif
===========================================================

    fix to correctly handle unsigned constants in
    preprocessor directives.
===========================================================

    fixed optimization of a default ctor when a class is
    embedded within another class at a non-zero offset
===========================================================

    fixed scanning of hex constants so that if there are
    a lot of digits, all of the digits will be absorbed
    and only one error message will be issued

    e.g.,
	#if 0 < 0x7fffffffffffffffff
	#endif
===========================================================

    #include'ing a file with no extension did not work
    properly.
===========================================================

    Added the -ft and -fx switches. Some of the C++ header
    files have names that do not fit in the the DOS 8.3
    naming restrictions. E.g. strstream.h. Some people
    include "strstream.h" while others include "strstrea.h".
    To allow both forms to work, if the compiler can not
    open a file and the name is longer than 8 characters,
    it will truncate the name to 8 and try opening this new
    name. This is the default behaviour. Checking for the
    truncated name can be disabled by using the -fx switch.
    The behaviour can be re-enabled by specifying -ft later
    on the command line.
===========================================================

    allow the following code:

    typedef int IFI( int );
    struct S {
	virtual IFI x;
	virtual IFI y;
    };
===========================================================

    Allow a cast to a reference to an undefined class type.
===========================================================

    Fixed explicit near modifiers when the default code
    model is far.
    e.g.,
    void near foo()
    {
    }
===========================================================

    Fixed destruction of class static members so that they
    are destructed in proper reverse source order along with
    file-scope variables.
===========================================================

    Allow constructor style initialization for a class
    without any explicit constructors declared if the
    initialization can be done with the compiler
    generated copy constructor.
    e.g.,
	struct S { int a, b; };
	void foo( S *p ) {
	    S v( *p );
	}
===========================================================

    fixed ctor optimization of single ctors nested in
    class members.
===========================================================

    Improved error message for mem-initializers for class
    members with a single argument constructor.
    e.g.,
	struct C {
	    C();
	    ~C();
	};
	
	struct D {
	    C c;
	    D(int a);
	    ~D();
	};
	
	D::D(int a) : c(a) {
	              ^^^^- error cannot construct C with an int
	}

===========================================================

    Changed the -d2~ switch so that it does not generate
    information for inline member functions in classes.
    This prevents the compiler from generating out
    of line instances of the functions, saving on object
    file size.
===========================================================

    Long double constants were being truncated to integers.
===========================================================

    Compiler won't print warnings 480 and 481 if both
    declarations are in library include files
    (i.e., #include <file.h>).
    
===========================================================

          *****************
          ** C++ Library **
          *****************

    ostream::operator <<( signed long ) function fixed to
    correctly format the value LONG_MIN in limits.h.
===========================================================

    C++ runtime support did not properly record special
    case of user throwing the value zero as an exception.
===========================================================

    The istream::get( streambuf &, char ) member function did
    not correctly set ios::eofbit upon reaching eof.
===========================================================

    The fstream (ifstream,ofstream,fstream) open() and attach()
    member functions now clear all ios::iostate bits on success.
===========================================================

          *************
          ** DOS4/GW **
          *************
                       +----------------------+
                       | Key to release notes |
                       |                      |
                       | E -- Enhancement     |
                       | B -- Bug (fix)       |
                       | D -- Documentation   |
                       +----------------------+


Release 1.97, 01Jun94 (changes since release 1.95)
---------------------

E ** IMPORTANT: the default settings for many virtual memory manager
     configuration options HAVE BEEN CHANGED to work better on a
     larger number of systems, as determined by feedback from our
     customers.

        Option          Old value               New value
        ------          ---------               ---------
        DELETESWAP      0                       1
        SWAPNAME        \dos4gvm.swp            .

     The DELETESWAP and SWAPNAME changes were made because most
     applications don't run over and over again, and the convenience
     of a temporary swap file outweighs the speed advantage of a
     permanent swap file.  Also, the new default setting works
     even if you spawn another DOS/4GW application that uses VMM.
     The default behavior is to create a randomly named swap file in
     the same directory as your application, and remove it on exit.

        Option          Old value               New value
        ------          ---------               ---------
        SWAPMIN         0                       0
        SWAPINC         0                       4096

     SWAPMIN and SWAPINC were changed to save disk space when there
     is sufficient physical memory to run the program.  The swap
     file will now start out at zero length, and it will grow as
     needed by 4 MB increments.  To specify a fixed-size swap
     file, set SWAPINC to 0.

     Please note that these changes WILL slow down program startup
     slightly, but the new defaults will work on more machines and
     conserve disk space.  A higher-performance virtual memory
     manager is available in DOS/4GW Professional.  We encourage
     you to measure performance of your program on a typical end
     user machine.

E ** SWAPNAME can now be set to just a directory name, in which
     case a unique file name will generated.

E ** To change the new DELETESWAP default, set DOS4GVM=NODELETESWAP.

E ** For interrupts which the user program has not hooked, DOS/4GW
     will now chain to the previous handler immediately,
     instead of first switching to the transfer stack.  This optimization
     reduces the round-trip time for a passdown interrupt by about
     15%, and it solves "transfer stack overflow" problems caused
     by interrupts coming in faster than the extender can handle
     them (e.g. PC-NFS on a slow machine at times of high network
     load).

E ** We have added error message 1002, "DOS/4GW may not be renamed or
     bound", as a preventive check against practices which can
     fool DOS/4GW's command-line parser and cause subtle bugs
     in program execution.

E ** Error message 1014 diagnoses the situation when a program issues
     the unsupported INT 21h/31h function (Terminate and Stay
     Resident).  (If you need TSR capability, DOS/4G is required.)

E ** Error message 2533 diagnoses the situation when there isn't
     enough disk space for VMM's swap file.

     2533: not enough disk space for SwapMin - <number> bytes needed

E ** DOS/4GW now supports these DPMI 1.0 functions, which are used in
     implementing floating-point emulators:

          INT 31h/E00h   Get Coprocessor Status
          INT 31h/E01h   Set Coprocessor Emulation

E ** The mouse callback code has been rewritten to use a DPMI
     real-mode callback instead of a passup interrupt.  This new
     behavior is more compatible with other DPMI hosts, and also
     more compatible with DESQview, which doesn't virtualize
     the entire real mode interrupt vector table when a graphical
     program is interrupted by a hardware interrupt.

E ** INT 21h/60h (Resolve To Canonical Path Name) is now supported,
     with pointer translation for DS:ESI and ES:EDI.

E ** Loading of linear executables has been sped up slightly
     by eliminating a few disk accesses.

E ** If a loaded program's initial ESP is within 0x100 bytes of the
     next page boundary, the next page is touched at load time to
     prevent page faults on the stack during hardware interrupts.

E ** The linear executable loader will now diagnose an attempt
     to load a program that has no stack.

B ** We have worked around a bug in the Windows NT DPMI host,
     involving the real-mode stack pointer on entry to a real-mode
     callback, which may improve passup interrupt handling under
     Windows NT.

B ** A debug exception caused by a hard-coded "INT 1" instruction
     will now be passed down to real mode, instead of causing
     DOS/4GW error 2001.

B ** INT 21/48h, which has never been supported by DOS/4G extenders
     for allocations larger than 64 KB, now returns the carry
     flag in that circumstance.

B ** A bug in INT 21/49h that could cause the application to
     terminate prematurely has been fixed.

B ** User-specified Ctrl-Break, Ctrl-C, and critical error handlers
     are now restored properly after shelling out to another application.

B ** Getting a critical error after installing and removing your
     own critical error handler is no longer a problem.

B ** On a failed INT 31/100h, 101h, or 102h, the DOS error code
     is now properly returned in AX.

B ** Under our VMM, INT 31/502h did not properly flush the cache
     after freeing pages.  If the pages were written to before the
     next flush, the data could have been lost.  This bug was a
     serious problem with the WATCOM 9.5B-level patches (and its
     initial 10.0 release); it could cause malloc() to fail
     prematurely, regardless of the amount of available memory.

B ** A problem resizing blocks larger than 64 KB with INT 31/503h
     (only a problem when VMM was not running) has been fixed.

B ** Attempting to lock all available memory (INT 31/600) under VMM
     will now (properly) fail.  It had been locking the memory, and
     leaving no pages to use for swapping.

B ** A bug in VMM's INT 31/601, where pages would not actually be
     unlocked, has been fixed.

B ** Accounting of memory under VMM has been improved.

B ** Mouse callback functions are now called on a 32-bit stack.

B ** A bug in loading programs when the base address is >16 MB
     (as when spawned by another very large DOS/4G application)
     has been fixed.

B ** A bug in loading, after being spawned by a program built
     with a more recent version of DOS/16M, has been corrected.

B ** Under a 32-bit DPMI host, such as OS/2 2.1, ALIAS16 objects
     are now properly loaded into a 16-bit segment.

B ** We are now performing even more cautious disambiguation
     between hardware interrupts and exceptions.  The new
     logic prevents problems on very rare hardware configurations
     where interference on the bus causes spurious INT 8 events.
     (This bug is like the previously reported, and commoner,
     problem with spurious INT 0Fh caused by flaky IDE controllers.
     However, in the rarer case, the undriven interrupt ID lines
     are all zeroes instead of ones.)

B ** We now distinguish between software interrupts and exceptions
     in the range 0-Fh.  For example, we will signal an interrupt
     instead of an exception when a protected mode INT 9 instruction
     is executed.

B ** A bug in handling interrupts with the direction flag set
     has been fixed.

B ** An obscure bug involving failure to resize a segment when
     installing handlers for more than 32 interrupts has been fixed.

B ** Attempts to free a descriptor when one or more of the
     segment registers still contain the selector for that
     descriptor will no longer cause a general protection fault.
     Previously, the code worked because the default GP fault
     handler covered up "POP segreg" instructions and zeroed
     the segment register; however, this behavior required
     that people who hooked exception 0Dh themselves also
     wrote code to cover up the bad POP instructions.

B ** The more aggressive null pointer checking introduced in
     version 1.95 (reads as well as writes) has been relaxed to
     work better with programs that manage extended memory and
     test the A20 line state by testing for pointer wraparound
     (for example, SMARTDRV).  Null pointer checking is now
     disabled during DOS calls.

B ** The swap file is now closed before shelling to DOS, so that
     the file size will be updated and a spawned copy of CHKDSK
     will no longer report lost clusters.

B ** A bug in failing to enforce the MINMEM parameter has been
     fixed.

B ** A bug in failing to update the DPMI Memory Information
     (INT 31h/500h) after locking memory has been fixed.

B ** Several obscure bugs in the virtual memory manager are fixed.
     These bugs occasionally showed up in calls to INT 31h/503h
     (Resize Memory Block), INT 31h/600h (Lock Linear Region) and
     INT 31h/800h (Physical Address Mapping).
===========================================================

          *************************
          ** FORTRAN 77 Compiler **
          *************************

    Fixed a problem with data initializing fields in a structure
    that contained a field that itself was another structure.
===========================================================

    Added the VOLATILE statement.

	VOLATILE VAR1, ... VARn

    A variable specified in a VOLATILE statement instructs the
    code generator that the variable may change asynchronously.
    Each time value of the variable is required, it will be
    fetched from memory and each time the variable is assigned
    a new value, it will immediately be stored in memory.
===========================================================

    Fixed a problem with INTEGER*2 constants.  The compiler assumed
    they were unsigned in certain unpredictable cirumstances when in
    fact they were signed.
===========================================================

          ************************
          ** FORTRAN 77 Library **
          ************************

    Printing INTEGER*1 or INTEGER*2 arrays would cause
    incorrect data to be displayed.
===========================================================

    Input of logical data now allows lower case "t" and "f"
    for TRUE and FALSE.
===========================================================

    Fixed a problem in NAMELIST input when reading complex
    arrays.
===========================================================

    The following READ statement would issue an error with input
    "2*0" and succeed with input "0 0".  Both forms of input are
    now accepted.

	READ( *, * ) I, X

    where I is integer and X is real.
===========================================================

    STOP and PAUSE did not work correctly in Windows and OS/2
    Presentation Manager applications.
===========================================================

    Fixed a problem with integer exponentiation.  The following
    would print 0 instead of -1.
    
    	I = -1
	PRINT *, I**I
===========================================================

          **********************
          ** Graphics Library **
          **********************

    Fixed problem with the calculation of y-values 
    in _getwindowcoord.
===========================================================

          ********************
          ** C Header Files **
          ********************

    IOMANIP.H was missing the #define that caused it to
    only be included once.
===========================================================

    stdlib.h should contain the atoh() function prototype
    under QNX systems only.
===========================================================

          ************
          ** Linker **
          ************

    When going into interactive mode, the QNX hosted version
    of the linker displayed the incorrect message on how
    to terminate the session.
===========================================================

    fixed a couple of bugs with option eliminate
===========================================================

    ignore BLKD32 and BLKE32 records, and make sure 'k' and
    'm' aren't parsed as numbers.
===========================================================

    When you have a phar lap application that starts with a
    16-bit segment that has a user-defined group, if you do
    not use option offset the linker will start at address
    0xffffffff rather than 0.
===========================================================

    Fixup pages were not being padded to a dword boundary in
    PE executables.  Resulting DLLs would not run under Chicago.
===========================================================

          ***********************
          ** Windows SDK Tools **
          ***********************

    Fixed a bug in NT.LIB that caused programs using functions from
    winspool.drv to fail at runtime because they could not find
    winspool.dll.
===========================================================

    Fixed a bug in wrc that would cause it to generate an error message
    when adding resources to an NT executable or DLL that contained an
    object of size zero.
===========================================================

          ************
          ** WVIDEO **
          ************

    The QNX hosted debugger will now process any symbolic
    information present on the /boot/sys/Slib16 and /boot/sys/Slib32
    executables. This will provide symbolic addresses for
    processes which die in the system shared library code
    and also all the "show calls" hueristics to trace out
    of the shared library to find out what user code originally
    entered the shared library.

    NOTE: Since a post mortem dump file does not contain
    data from the shared library of the system on which the
    dump occured, the PMD.TRP file causes the debugger to
    not process the symbolic information for the local
    /boot/sys/Slib?? if it determines that the local OS is
    a different version than that of the system on which
    the dump occured. This determination is the same as
    the one used to see if reading from the GDT selectors
    of the local system is OK, and can be overridden in the
    same manner, with the with the trap file parameters 'g'
    to force enablement or 'd' to disable.
===========================================================

    If the PMD.TRP (QNX) file can not open the executable with the
    name as specified in the post mortem dump file, it now
    will remove any node number from the name and try that.
===========================================================

    Fixed RSIHELP.EXP so that set DOS4G=NULLP can be used
    with DOS/4GW version 1.96 and above.
===========================================================

    Pressing F10, cursoring to the "Break!", "Watch!", "Trace!", 
    or "Go!" menu items and then pressing cursor up or
    down crashed the debugger.
===========================================================

          **************
          ** Profiler **
          **************

    Changed the character used in listing histograms from
    '\xdb' to '#' to print better.
===========================================================

    Increased the stack size in WSAMPOS2.EXE to avoid
    problems in an OS/2 PM window.
===========================================================
