/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1993  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.5 of 15-May-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de
 *	/pub/unix/languages/pfe-VERSION.tar.gz
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * support.h ---	declare types and prototypes for support.c
 * (duz 09Jul93)
 */

#ifndef __SUPPORT_H
#define __SUPPORT_H

#ifndef __SYSDEP_H
#include "config.h"
#endif

#ifndef __FORTH_H
#include "forth.h"
#endif

#ifndef FILE
#include <stdio.h>
#endif


/* miscellaneous =========================================================== */

void millisec (int ms);

code (rot);
code (invert);
code (fetch);
code (pocket);
code (update);
code (save_buffers);
code (close_all_files);
code (decimal);
code (key_question);

/* strings ================================================================= */

void to_lower (char *p, int n);
void to_upper (char *p, int n);
void store_asciiz (const char *src, int n, char *dst, int max);
char *expand_filename (const char *nm, const char *path,
		       const char *ext, char *fn);
char *search (char *p1, int u1, const char *p2, int u2);

/* floored divide and number i/o conversion ================================ */

udiv_t udiv (uCell num, uCell denom);
fdiv_t fdiv (Cell num, Cell denom);
uCell u_d_div (udCell *ud, uCell denom);
void u_d_mul (udCell *ud, uCell w, uCell c);

int dig2num (Byte c, uCell *n, uCell base);
char num2dig (uCell n);
void hold (char c);
const char *to_number (const char *p, uCell *n, udCell *d, uCell base);
int number_question (const char *p, uCell n, dCell *d);
Flag to_float (char *p, Cell n, double *f);

char *str_ud_dot_r (udCell ud, char *p, int w, int base);
char *str_d_dot_r (dCell d, char *p, int w, int base);
char *str_dot (Cell n, char *p, int base);

code (less_number_sign);
code (number_sign_s);
code (number_sign_greater);

code (s_to_d);			/* in core.c */
code (d_dot_r);			/* in double.c */
code (d_dot);			/* in double.c */
code (dot_r);			/* in core.c */
code (dot);			/* in core.c */

void d_dot_r (dCell d, int w);
void d_dot (dCell d);
void dot_r (Cell n, int w);
void dot (Cell n);

/* console i/o ============================================================= */

code (standard_io);

void outc (char c);		/* these work on C-strings */
void outs (const char *s);	/* but adjust the OUT variable */
int outf (const char *s, ...);
void type (const char *s, Cell n); /* this works with a Forth-string */

code (type);			/* in core.c */
code (space);			/* in core.c */
code (cr);			/* in core.c */
code (backspace);		/* in misc.c */
code (bell);			/* in misc.c */

void spaces (int n);
code (spaces);			/* in core.c */

void tab (int n);
void dot_line (Cell blk, Cell line);
int expect (char *p, Cell n);
int accept (char *p, int n);
int question_stop (void);
int question_cr (void);
code (start_question_cr);	/* in misc.c */

/* files =================================================================== */

void file_error (void);
int file_access (const char *fn);
File *create_file (const char *p, int n, int mode);
File *open_file (const char *p, int n, int mode);
int close_file (File *f);
fpos_t fsize (FILE *f);
int reposition_file (fpos_t pos, File *f);
int read_file (void *p, uCell *n, File *f);
int write_file (void *p, uCell n, File *f);
int read_line (char *p, uCell *u, File *f, Cell *ior);
fpos_t file_copy (const char *dst, const char *src, fpos_t limit);
int file_move (const char *src, const char *dst);
int lengthen_file (const char *fn, fpos_t n);
int resize (const char *fn, fpos_t size);
int resize_file (File *f, fpos_t size);
int systemf (const char *s, ...);

/* source input ============================================================ */

code (query);
int next_line (void);
int use_block_file (const char *name, int len);
void read_write (File *f, char *p, uCell n, Flag readflag);
char *buffer (uCell n, int *reload);
char *block (uCell n);
int refill (void);

void *save_input (void *p);
void *restore_input (void *p);
void source (char **p, int *n);
int parse (char del, char **p, uCell *l);
char *word (char del);

/* dictionary and words lists ============================================== */

Wordl *word_list (void);
void forget (char *above);

int wl_hash (const char *s, int l);
char **thread_with_latest (const Wordl *w);
char *latest (void);

char *search_wordlist (const char *nm, int l, const Wordl *w);
char *find (const char *nm, int l);
char *tick (Xt *xt);

Cell aligned (Cell n);
code (align);			/* in core.c */
code (aligned);

char *alloc_string (const char *s, int l);
char *alloc_parsed_string (char del);
char *alloc_word (char del);
void header (pCode cfa, char flags);

char **name_to_link (const char *p);
char *link_to_name (char **l);
Xt link_from (char **lnk);
char **to_link (Xt xt);
#define TO_BODY(C)	((Cell *)((Xt)(C) + 1))
#define BODY_FROM(P)	((Xt)((Cell *)(P) - 1))
char *to_name (Xt xt);
Xt name_from (const char *p);
Xt runtime (void);
void dot_name (const char *nfa);

int complete_dictionary (char *in, char *out);

code (only);
code (also);
code (definitions);
code (default_order);
code (reset_order);

uCell pfe_version_code (void);
void preload_dictionary (void);
long save_dictionary (Dict *d1, Dict *d2, const char *fn);
int reload_dictionary (const char *fn, Dict *dict);

/* inner and outer interpreter ============================================= */

void run_forth (Xt xt);
code (interpret);
void evaluate (char *p, int n);
void load (uCell blk);
void include_file (File *f);
void included (const char *fn, int n);

/* ABORT and exception handling ============================================ */

extern jmp_buf abort_dest;
extern jmp_buf quit_dest;
void do_abort (void);

int cAtch (Xt xt);		/* catch is a keyword in C++ */
void tHrow (int id, ...);	/* accepts -2 addr cnt */
void abortq (const char *fmt, ...); /* accepts printf()-like parameters */

code (question_comp);		/* in misc.c */
code (question_exec);
code (question_pairs);
code (store_csp);
code (question_csp);
code (question_loading);
code (question_stack);
void question_pairs (Cell n);
void question_file_open (File *f);

void initialize_system (void);

/* signal stuff ============================================================ */

void install_signal_handlers (void);
void swap_signals (void);
Xt forth_signal (int sig, Xt xt);
void load_signals (Wordl *wid);

#endif
