/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1993  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.5 of 15-May-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de
 *	/pub/unix/languages/pfe-VERSION.tar.gz
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * term.h ---	Declarations for terminal driver of pfe.
 *		It doesn't matter how you supply these functions,
 *		  --- just do it!
 *		For an example driver refer to term-ux.c.
 * (duz 09May93)
 */

#ifndef __TERM_H
#define __TERM_H

enum ekey_codes			/* The function keys known to pfe */
{
  EKEY_k1 = 0x100,		/* function keys F1 through F10 */
  EKEY_k2,
  EKEY_k3,
  EKEY_k4,
  EKEY_k5,
  EKEY_k6,
  EKEY_k7,
  EKEY_k8,
  EKEY_k9,
  EKEY_k0,

  /* "kl", "kr", "ku", "kd" */
  EKEY_kl,			/* arrow key left */
  EKEY_kr,			/* arrow key right */
  EKEY_ku,			/* arrow key up */
  EKEY_kd,			/* arrow key down */
  /* "kh", "kH", "kN", "kP" */
  EKEY_kh,			/* home key */
  EKEY_kH,			/* home down key */
  EKEY_kN,			/* next page key */
  EKEY_kP,			/* previous page key */
  /* "kb", "kD", "kM", "kI" */
  EKEY_kb,			/* backspace key */
  EKEY_kD,			/* delete character key */
  EKEY_kM,			/* exit insert mode key */
  EKEY_kI,			/* insert character key */
  /* "kA", "kE", "kL", "kC" */
  EKEY_kA,			/* insert line key */
  EKEY_kE,			/* clear to end of line key */
  EKEY_kL,			/* delete line key */
  EKEY_kC,			/* clear screen key */
				/* Enter key: defined by curses */
/*EKEY_enter,
*/
  /* count the keys: */
  EKEY_LAST,
  NO_OF_KEYS = EKEY_LAST - EKEY_k1
};

extern unsigned char *rawkey_string [NO_OF_KEYS];
				/* what all those keys really send */

/*
 * These variables are physically defined in the term.c and
 * initialized by term-xxx:prepare_terminal().
 * If window size can change, it would be nice if they were kept up to date.
 */
extern int rows, cols;		/* size of text screen */
extern int xmax, ymax;		/* size of graphics window in pixels */

/* Refer to term-ux.c for what these functions are expected to do: */

int set_interrupt_key (char ch);
void interactive_terminal (void);
void system_terminal (void);
void query_winsize (void);
int prepare_terminal (void);

int keypressed (void);
int getkey (void);

void cputc (int c);
void cputs (const char *s);
void gotoxy (int x, int y);
void wherexy (int *x, int *y);

void goleft (void);
void goright (void);
void goup (void);
void godown (void);

void home (void);
void clrscr (void);
void clreol (void);
void clrdown (void);
void bing (void);

void standout_on (void);
void standout_off (void);
void bright (void);
void reverse (void);
void blinking (void);
void normal (void);
void underline_on (void);
void underline_off (void);

/* These are not part of the driver, but system independent, in term.c */

int printable (int c);		/* like isprint() for ISO-characters */
void cputc_printable (int c);	/* like cputc() but certainly visible */
int change_case (int key);	/* exchange lower case with upper case char */
int getekey (void);		/* get a character like EKEY */
int ekeypressed (void);		/* check for extended key available */
int getwskey (void);		/* get a character, for block editor */
int getckey (void);		/* get a control character mapping it to A-Z */

extern void (*on_stop) (void);
extern void (*on_continue) (void);
extern void (*on_winchg) (void);

#endif
