/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.filter;

import com.ibm.eou.toolkit.filter.TextEditable;
import com.ibm.eou.toolkit.filter.TextEditableEvent;
import com.ibm.eou.toolkit.filter.TextEditableListener;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class BaseTextEditable
implements TextEditable,
Serializable {
    private static final String COPYRIGHT = "\n\n(c) Copyright IBM Corporation 1999, \n\n";
    protected transient Vector fListeners = new Vector(1, 1);
    private boolean fValid = true;

    public void addTextEditableListener(TextEditableListener textEditableListener) {
        if (!this.fListeners.contains(textEditableListener)) {
            this.fListeners.addElement(textEditableListener);
        }
    }

    public void dispose() {
        this.fListeners.removeAllElements();
        this.fListeners = null;
    }

    protected void fireCaretPositionChanged(TextEditableEvent textEditableEvent) {
        Enumeration enumeration = ((Vector)this.fListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).caretPositionChanged(textEditableEvent);
        }
    }

    protected void fireFocusGained(TextEditableEvent textEditableEvent) {
        Enumeration enumeration = ((Vector)this.fListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).focusGained(textEditableEvent);
        }
    }

    protected void fireFocusLost(TextEditableEvent textEditableEvent) {
        if (!textEditableEvent.isTemporary()) {
            this.fireTextValueCompleted(new TextEditableEvent(this, 3005));
        }
        Enumeration enumeration = ((Vector)this.fListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).focusLost(textEditableEvent);
        }
    }

    protected void fireKeyPressed(TextEditableEvent textEditableEvent) {
        if (textEditableEvent.getKeyCode() == 10) {
            this.fireTextValueCompleted(textEditableEvent);
        }
        Enumeration enumeration = ((Vector)this.fListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).keyPressed(textEditableEvent);
        }
    }

    protected void fireKeyReleased(TextEditableEvent textEditableEvent) {
        Enumeration enumeration = ((Vector)this.fListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).keyReleased(textEditableEvent);
        }
    }

    protected void fireKeyTyped(TextEditableEvent textEditableEvent) {
        Enumeration enumeration = ((Vector)this.fListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).keyTyped(textEditableEvent);
        }
    }

    protected void fireTextValueChanged(TextEditableEvent textEditableEvent) {
        Enumeration enumeration = ((Vector)this.fListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).textValueChanged(textEditableEvent);
        }
    }

    protected void fireTextValueCompleted(TextEditableEvent textEditableEvent) {
        Enumeration enumeration = ((Vector)this.fListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).textValueCompleted(textEditableEvent);
        }
    }

    public boolean getValid() {
        return this.fValid;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        this.fListeners = new Vector(1, 1);
    }

    public void removeTextEditableListener(TextEditableListener textEditableListener) {
        this.fListeners.removeElement(textEditableListener);
    }

    public void setValid(boolean bl) {
        this.fValid = bl;
    }

    public abstract void insert(String var1, int var2);

    public abstract int getSelectionEnd();

    public abstract void transferFocus();

    public abstract void replaceRange(String var1, int var2, int var3);

    public abstract int getCaretPosition();

    public abstract void select(int var1, int var2);

    public abstract void setText(String var1);

    public abstract void setSelectionEnd(int var1);

    public abstract String getText();

    public abstract void selectAll();

    public abstract void setText(String var1, boolean var2);

    public abstract void setCaretPosition(int var1);

    public abstract void setSelectionStart(int var1);

    public abstract void insert(String var1, int var2, boolean var3);

    public abstract void append(String var1, boolean var2);

    public abstract void replaceRange(String var1, int var2, int var3, boolean var4);

    public abstract void append(String var1);

    public abstract int getSelectionStart();
}

