/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.filter;

import com.ibm.eou.toolkit.filter.TextEditable;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;

public class TextEditableEvent
extends AWTEvent {
    private KeyEvent fKeyEvent = null;
    private boolean fTemporary = false;
    public static final int TEXT_EDITABLE_FIRST = 3000;
    public static final int TEXT_EDITABLE_LAST = 3007;
    public static final int KEY_PRESSED = 3000;
    public static final int KEY_RELEASED = 3001;
    public static final int KEY_TYPED = 3002;
    public static final int CARET_POSITION_CHANGED = 3003;
    public static final int TEXT_VALUE_CHANGED = 3004;
    public static final int TEXT_VALUE_COMPLETED = 3005;
    public static final int FOCUS_GAINED = 3006;
    public static final int FOCUS_LOST = 3007;

    public TextEditableEvent(TextEditable textEditable, int n) {
        super(textEditable, n);
    }

    public TextEditableEvent(TextEditable textEditable, int n, KeyEvent keyEvent) {
        super(textEditable, n);
        this.fKeyEvent = keyEvent;
    }

    public TextEditableEvent(TextEditable textEditable, int n, boolean bl) {
        super(textEditable, n);
        this.fTemporary = bl;
    }

    public void consume() {
        int n = this.getID();
        if (n == 3000 || n == 3001 || n == 3002) {
            this.consumed = true;
            if (this.fKeyEvent != null) {
                this.fKeyEvent.consume();
            }
        }
    }

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999, \n\n";
    }

    private void ensureKeyEvent() {
        if (this.fKeyEvent == null) {
            Component component = null;
            if (this.getSource() instanceof Component) {
                component = (Component)this.getSource();
            }
            this.fKeyEvent = new KeyEvent(component, this.getID(), System.currentTimeMillis(), 0, 0);
            if (this.consumed) {
                this.fKeyEvent.consume();
            }
        }
    }

    public char getKeyChar() {
        this.ensureKeyEvent();
        return this.fKeyEvent.getKeyChar();
    }

    public int getKeyCode() {
        this.ensureKeyEvent();
        return this.fKeyEvent.getKeyCode();
    }

    public int getModifiers() {
        this.ensureKeyEvent();
        return this.fKeyEvent.getModifiers();
    }

    public TextEditable getTextEditable() {
        return (TextEditable)this.getSource();
    }

    public boolean isConsumed() {
        return super.isConsumed();
    }

    public boolean isTemporary() {
        return this.fTemporary;
    }

    public void setKeyChar(char c) {
        this.ensureKeyEvent();
        this.fKeyEvent.setKeyChar(c);
    }

    public void setKeyCode(int n) {
        this.ensureKeyEvent();
        this.fKeyEvent.setModifiers(n);
    }

    public void setModifiers(int n) {
        this.ensureKeyEvent();
        this.fKeyEvent.setModifiers(n);
    }
}

