/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.graphics;

import com.ibm.eou.toolkit.util.TextUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Vector;

public class FontUtils {
    public static final int LEFT = -1;
    public static final int RIGHT = 1;
    public static final int CENTER = 0;
    public static final int TOP = -2;
    public static final int BOTTOM = 2;
    private static final int MAX_SWITCHES = 5;

    private FontUtils() {
    }

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999.\n\n";
    }

    public static String[] createWrappedStrings(String string, int n) {
        return FontUtils.createWrappedStrings(string, n, null);
    }

    public static String[] createWrappedStrings(String string, int n, FontMetrics fontMetrics, boolean bl) {
        return FontUtils.createWrappedStrings(string, n, fontMetrics, bl, null);
    }

    public static String[] createWrappedStrings(String string, int n, FontMetrics fontMetrics, boolean bl, Locale locale) {
        Vector<String> vector = new Vector<String>(Math.max(fontMetrics.getMaxAdvance() * string.length() / n, 10), 1);
        int n2 = 0;
        do {
            int n3 = n2;
            n2 = FontUtils.indexOfNextLine(string, n3, n, fontMetrics, bl, locale);
            vector.addElement(FontUtils.getSubstring(string, n3, n2, bl));
        } while (n2 != -1 && n2 < string.length());
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        vector.removeAllElements();
        return objectArray;
    }

    public static String[] createWrappedStrings(String string, int n, Locale locale) {
        Vector<String> vector = new Vector<String>(string.length() / n, 1);
        int n2 = 0;
        do {
            int n3 = n2;
            n2 = FontUtils.indexOfNextLine(string, n3, n, locale);
            vector.addElement(FontUtils.getSubstring(string, n3, n2, false));
        } while (n2 != -1 && n2 < string.length());
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        vector.removeAllElements();
        return objectArray;
    }

    public static Font getLargestFont(Font font, int n) {
        int n2 = Math.max(n, 0);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(font);
        Font font2 = font;
        int n3 = -1;
        int n4 = font.getSize();
        String string = font.getName();
        int n5 = font.getStyle();
        int n6 = -1;
        int n7 = fontMetrics.getHeight() - fontMetrics.getLeading();
        boolean bl = n7 < n2;
        int n8 = 0;
        while (n3 != n4 && n6 != n7 && n8 < 5) {
            n3 = n4;
            n6 = n7;
            n4 *= n2;
            font2 = new Font(string, n5, n4 /= n7);
            fontMetrics = toolkit.getFontMetrics(font2);
            if (bl == (n7 = fontMetrics.getHeight() - fontMetrics.getLeading()) < n2) continue;
            bl = !bl;
            ++n8;
        }
        if (n4 < 1) {
            n4 = 1;
            font2 = new Font(string, n5, n4);
        } else if (n7 > n2) {
            font2 = new Font(string, n5, n3);
        }
        return font2;
    }

    public static Font getLargestFont(Font font, int n, int n2, String string) {
        Font font2 = FontUtils.getLargestFont(font, n2);
        Font font3 = FontUtils.getLargestFont(font, n, string);
        return font2.getSize() < font3.getSize() ? font2 : font3;
    }

    public static Font getLargestFont(Font font, int n, String string) {
        int n2 = Math.max(n, 0);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(font);
        Font font2 = font;
        int n3 = -1;
        int n4 = font.getSize();
        String string2 = font.getName();
        int n5 = font.getStyle();
        int n6 = 0;
        int n7 = fontMetrics.stringWidth(string);
        boolean bl = n7 < n2;
        int n8 = 0;
        while (n3 != n4 && n6 != n7 && n8 < 5) {
            n3 = n4;
            n6 = n7;
            n4 *= n2;
            font2 = new Font(string2, n5, n4 /= n7);
            fontMetrics = toolkit.getFontMetrics(font2);
            if (bl == (n7 = fontMetrics.stringWidth(string)) < n2) continue;
            bl = !bl;
            ++n8;
        }
        if (n4 < 1) {
            n4 = 1;
            font2 = new Font(string2, n5, n4);
        } else if (n7 > n2) {
            font2 = new Font(string2, n5, n3);
        }
        return font2;
    }

    private static String getSubstring(String string, int n, int n2, boolean bl) {
        String string2;
        String string3 = string2 = n2 >= 0 ? string.substring(Math.max(0, n), n2) : string.substring(Math.max(0, n));
        if (bl) {
            int n3 = TextUtils.lastIndexOfNonWhitespace(string2);
            string2 = string2.substring(0, n3 + 1);
        }
        return string2;
    }

    public static Dimension getWrappedSize(String string, double d, FontMetrics fontMetrics, boolean bl) {
        return FontUtils.getWrappedSize(string, d, fontMetrics, bl, null);
    }

    public static Dimension getWrappedSize(String string, double d, FontMetrics fontMetrics, boolean bl, Locale locale) {
        int n;
        int n2;
        int n3 = (int)Math.sqrt((double)(fontMetrics.stringWidth(string) * fontMetrics.getHeight()) * d);
        String[] stringArray = null;
        boolean bl2 = false;
        do {
            int n4;
            if (bl2) {
                n4 = fontMetrics.stringWidth((String)stringArray[stringArray.length - 1]);
                n3 += Math.max(1, (n4 + stringArray.length - 2) / (stringArray.length - 1));
            }
            bl2 = true;
            stringArray = FontUtils.createWrappedStrings(string, n3, fontMetrics, bl, locale);
            n = 0;
            n4 = 0;
            while (n4 < stringArray.length) {
                n = Math.max(n, fontMetrics.stringWidth(stringArray[n4]));
                ++n4;
            }
        } while ((double)(n2 = stringArray.length * fontMetrics.getHeight() + fontMetrics.getLeading()) * d > (double)n);
        return new Dimension(n, n2);
    }

    public static Dimension getWrappedSize(String string, int n, FontMetrics fontMetrics, boolean bl) {
        return FontUtils.getWrappedSize(string, n, fontMetrics, bl, null);
    }

    public static Dimension getWrappedSize(String string, int n, FontMetrics fontMetrics, boolean bl, Locale locale) {
        String[] stringArray = FontUtils.createWrappedStrings(string, n, fontMetrics, bl, locale);
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            n2 = Math.max(n2, fontMetrics.stringWidth(stringArray[n3]));
            ++n3;
        }
        return new Dimension(n2, stringArray.length * fontMetrics.getHeight() + fontMetrics.getLeading());
    }

    public static int indexOfNextLine(String string, int n, int n2) {
        return FontUtils.indexOfNextLine(string, n, n2, null);
    }

    public static int indexOfNextLine(String string, int n, int n2, FontMetrics fontMetrics, boolean bl) {
        return FontUtils.indexOfNextLine(string, n, n2, fontMetrics, bl, null);
    }

    public static int indexOfNextLine(String string, int n, int n2, FontMetrics fontMetrics, boolean bl, Locale locale) {
        BreakIterator breakIterator = locale != null ? BreakIterator.getLineInstance(locale) : BreakIterator.getLineInstance();
        breakIterator.setText(string);
        int n3 = 0;
        int n4 = n > 0 ? breakIterator.following(n - 1) : breakIterator.first();
        int n5 = 0;
        while (n4 != -1 && n4 <= n) {
            n4 = breakIterator.next();
        }
        while (n4 != -1 && n5 <= n2) {
            n3 = n4;
            int n6 = Character.getType(string.charAt(n3 - 1));
            if (n6 == 13 || n6 == 14 || n6 == 15) break;
            n4 = breakIterator.next();
            if (n4 == -1) continue;
            n5 = fontMetrics.stringWidth(FontUtils.getSubstring(string, n, n4, bl));
        }
        return n4 != -1 && n4 > n ? n3 : string.length();
    }

    public static int indexOfNextLine(String string, int n, int n2, Locale locale) {
        BreakIterator breakIterator = locale != null ? BreakIterator.getCharacterInstance(locale) : BreakIterator.getCharacterInstance();
        breakIterator.setText(string);
        int n3 = n > 0 ? breakIterator.following(n - 1) : breakIterator.first();
        int n4 = 0;
        while (n4 < n2 && n3 != -1) {
            n3 = breakIterator.next();
            ++n4;
        }
        if (n3 == -1) {
            return string.length();
        }
        BreakIterator breakIterator2 = locale != null ? BreakIterator.getLineInstance(locale) : BreakIterator.getLineInstance();
        breakIterator2.setText(string);
        int n5 = n > 0 ? breakIterator2.following(n - 1) : breakIterator2.first();
        int n6 = breakIterator2.next();
        while (n6 != -1 && n6 <= n3) {
            n5 = n6;
            int n7 = Character.getType(string.charAt(n5 - 1));
            if (n7 == 13 || n7 == 14 || n7 == 15) break;
            n6 = breakIterator2.next();
        }
        return n5;
    }

    public static void renderWrapped(Graphics graphics, Rectangle rectangle, String string, int n, int n2) {
        FontUtils.renderWrapped(graphics, rectangle, string, n, n2, null);
    }

    public static void renderWrapped(Graphics graphics, Rectangle rectangle, String string, int n, int n2, Locale locale) {
        Graphics graphics2 = graphics.create();
        graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        String[] stringArray = FontUtils.createWrappedStrings(string, rectangle.width, fontMetrics, true, locale);
        int n4 = n2 != -2 ? stringArray.length * n3 + fontMetrics.getLeading() : 0;
        int n5 = rectangle.y + fontMetrics.getLeading() + fontMetrics.getAscent();
        if (n2 == 2) {
            n5 += rectangle.height - n4;
        } else if (n2 == 0) {
            n5 += rectangle.height / 2 - n4 / 2;
        }
        int n6 = 0;
        while (n6 < stringArray.length) {
            int n7;
            String string2 = stringArray[n6];
            int n8 = n7 = n != -1 ? fontMetrics.stringWidth(string2) : 0;
            int n9 = n == -1 ? rectangle.x : (n == 1 ? rectangle.x + rectangle.width - n7 : rectangle.x + rectangle.width / 2 - n7 / 2);
            graphics2.drawString(string2, n9, n5);
            n5 += n3;
            ++n6;
        }
    }
}

