/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.info;

import com.ibm.eou.toolkit.info.InfoEvent;
import com.ibm.eou.toolkit.info.InfoListener;
import com.ibm.eou.toolkit.info.InfoPopup;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class InfoTrigger
implements Runnable,
MouseMotionListener,
MouseListener,
Serializable {
    private static final int STATE_ISDEAD = 0;
    private static final int STATE_ISREADYTOWAIT = 1;
    private static final int STATE_ISWAITINGTOSHOW = 2;
    private static final int STATE_ISTRIGGERED = 3;
    private static final int STATE_ISSHOWING = 4;
    public static final long DEFAULT_DELAY = 500L;
    public static final int DEFAULT_GROUP = 0;
    public static final int MAX_PRIORITY = Integer.MAX_VALUE;
    private static Vector sTriggeredList = new Vector(1, 1);
    private static int sNextPriority = 0;
    private Component fTriggerComponent;
    private Rectangle fTriggerRectangle;
    private String fText;
    private long fTimeout = 500L;
    private int fGroup = 0;
    private int fPriority = ++sNextPriority;
    private transient Vector fListeners = new Vector(1, 1);
    private Thread fTimerThread = null;
    private transient Object fTimerThreadLock = new Object();
    private int fState = 0;
    private int fMouseX = 0;
    private int fMouseY = 0;
    private boolean fEnabled = true;

    public InfoTrigger(Component component, Rectangle rectangle, String string) {
        this.fTriggerComponent = component;
        this.fTriggerRectangle = rectangle;
        this.fText = string;
        this.fTriggerComponent.addMouseMotionListener(this);
        this.fTriggerComponent.addMouseListener(this);
    }

    public InfoTrigger(Component component, String string) {
        this(component, null, string);
    }

    public void addInfoListener(InfoListener infoListener) {
        this.fListeners.addElement(infoListener);
    }

    private static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 3.0\n(c) Copyright IBM Corp. 1999. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public void disableDefaultDisplay() {
        this.removeInfoListener(InfoPopup.getInstance());
    }

    public void enableDefaultDisplay() {
        this.addInfoListener(InfoPopup.getInstance());
    }

    public long getDelay() {
        return this.fTimeout;
    }

    public long getGroup() {
        return this.fGroup;
    }

    public int getPriority() {
        return this.fPriority;
    }

    public String getText() {
        return this.fText;
    }

    public Component getTriggerComponent() {
        return this.fTriggerComponent;
    }

    public Rectangle getTriggerRectangle() {
        return this.fTriggerRectangle;
    }

    private void hide(int n) {
        this.fState = n;
        InfoEvent infoEvent = new InfoEvent(this, this.fMouseX, this.fMouseY);
        Enumeration enumeration = ((Vector)this.fListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((InfoListener)enumeration.nextElement()).hideInfo(infoEvent);
        }
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public boolean isShowing() {
        boolean bl;
        Object object = this.fTimerThreadLock;
        synchronized (object) {
            bl = this.fState == 4;
        }
        return bl;
    }

    public boolean isTriggered() {
        boolean bl;
        Object object = this.fTimerThreadLock;
        synchronized (object) {
            bl = this.fState == 3 || this.fState == 4;
        }
        return bl;
    }

    public void kill() {
        Object object = this.fTimerThreadLock;
        synchronized (object) {
            if (this.fState != 0) {
                boolean bl = this.isTriggered();
                if (this.isShowing()) {
                    this.hide(0);
                } else {
                    this.fState = 0;
                }
                Vector vector = sTriggeredList;
                synchronized (vector) {
                    if (bl) {
                        sTriggeredList.removeElement(this);
                    }
                    InfoTrigger.manageDisplayFor(this.fGroup);
                }
            }
        }
    }

    private static void manageDisplayFor(int n) {
        InfoTrigger infoTrigger = null;
        Enumeration enumeration = sTriggeredList.elements();
        while (enumeration.hasMoreElements()) {
            InfoTrigger infoTrigger2 = (InfoTrigger)enumeration.nextElement();
            if (infoTrigger2.getGroup() != (long)n) continue;
            if (infoTrigger == null) {
                infoTrigger = infoTrigger2;
                continue;
            }
            if (infoTrigger2.getPriority() > infoTrigger.getPriority()) {
                if (infoTrigger.isShowing()) {
                    infoTrigger.hide(3);
                }
                infoTrigger = infoTrigger2;
                continue;
            }
            if (!infoTrigger2.isShowing()) continue;
            infoTrigger2.hide(3);
        }
        if (infoTrigger != null && !infoTrigger.isShowing()) {
            infoTrigger.show();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.kill();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.fTriggerComponent && (this.fTriggerRectangle == null || this.fTriggerRectangle.contains(mouseEvent.getX(), mouseEvent.getY()))) {
            this.fMouseX = mouseEvent.getX();
            this.fMouseY = mouseEvent.getY();
            this.startTimer();
        } else {
            this.kill();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void readObject(ObjectInputStream objectInputStream) {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        this.fListeners = new Vector(1, 1);
        this.fTimerThreadLock = new Object();
    }

    public void removeInfoListener(InfoListener infoListener) {
        this.fListeners.removeElement(infoListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long l = 0L;
        boolean bl = true;
        Object object = this.fTimerThreadLock;
        synchronized (object) {
            try {
                while (bl) {
                    switch (this.fState) {
                        case 0: {
                            bl = false;
                            break;
                        }
                        case 1: {
                            this.fState = 2;
                            l = this.getDelay();
                            break;
                        }
                        case 2: {
                            this.trigger();
                            l = 0L;
                            break;
                        }
                        case 3: 
                        case 4: {
                            l = 0L;
                            break;
                        }
                    }
                    if (!bl) continue;
                    try {
                        this.fTimerThreadLock.wait(l);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.fTimerThread = null;
                throw throwable;
            }
            Object var5_6 = null;
            this.fTimerThread = null;
            return;
        }
    }

    public void setDelay(long l) {
        this.fTimeout = l;
    }

    public void setEnabled(boolean bl) {
        this.fEnabled = bl;
        if (!bl) {
            this.kill();
        }
    }

    public void setGroup(int n) {
        this.fGroup = n;
    }

    public void setPriority(int n) {
        this.fPriority = n;
    }

    public void setText(String string) {
        this.fText = string;
        if (this.isShowing()) {
            InfoEvent infoEvent = new InfoEvent(this, this.fMouseX, this.fMouseY);
            Enumeration enumeration = ((Vector)this.fListeners.clone()).elements();
            while (enumeration.hasMoreElements()) {
                ((InfoListener)enumeration.nextElement()).changeInfo(infoEvent);
            }
        }
    }

    public void setTrigger(Component component, Rectangle rectangle) {
        this.fTriggerComponent.removeMouseMotionListener(this);
        this.fTriggerComponent.removeMouseListener(this);
        this.kill();
        this.fTriggerComponent = component;
        this.fTriggerRectangle = rectangle;
        this.fTriggerComponent.addMouseMotionListener(this);
        this.fTriggerComponent.addMouseListener(this);
    }

    private void show() {
        this.fState = 4;
        InfoEvent infoEvent = new InfoEvent(this, this.fMouseX, this.fMouseY);
        Enumeration enumeration = ((Vector)this.fListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((InfoListener)enumeration.nextElement()).showInfo(infoEvent);
        }
    }

    public void startTimer() {
        if (!this.fEnabled) {
            return;
        }
        Object object = this.fTimerThreadLock;
        synchronized (object) {
            if (this.fState != 4) {
                boolean bl = false;
                Vector vector = sTriggeredList;
                synchronized (vector) {
                    Enumeration enumeration = sTriggeredList.elements();
                    while (!bl && enumeration.hasMoreElements()) {
                        boolean bl2 = bl = ((InfoTrigger)enumeration.nextElement()).getGroup() == (long)this.fGroup;
                    }
                }
                if (bl) {
                    this.trigger();
                } else {
                    this.fState = 1;
                    if (this.fTimerThread == null) {
                        this.fTimerThread = new Thread(this);
                        this.fTimerThread.start();
                    } else {
                        this.fTimerThreadLock.notify();
                    }
                }
            }
        }
    }

    public void trigger() {
        if (!this.fEnabled) {
            return;
        }
        Object object = this.fTimerThreadLock;
        synchronized (object) {
            if (this.fState != 3 && this.fState != 4) {
                this.fState = 3;
                Vector vector = sTriggeredList;
                synchronized (vector) {
                    if (!sTriggeredList.contains(this)) {
                        sTriggeredList.addElement(this);
                    }
                    InfoTrigger.manageDisplayFor(this.fGroup);
                }
            }
        }
    }
}

