/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.extend.awt.support;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;

public class Utilities {
    private static String Copyright = "\r\n\r\nLicensed Materials - Property of IBM.\r\n(C) Copyright IBM Corporation 1997.\r\nAll Rights Reserved US Government Users Restricted Rights -\r\nUse, duplication or disclosure\r\nrestricted by GSA ADP Schedule Contract\r\nwith IBM Corp.\r\n\r\n";

    public static int lineHeight(FontMetrics fontMetrics, Object[] objectArray, ImageObserver imageObserver) {
        int n = fontMetrics.getHeight();
        if (objectArray != null) {
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] != null && objectArray[n2] instanceof Image) {
                    n = Math.max(n, ((Image)objectArray[n2]).getHeight(imageObserver) + 4);
                }
                ++n2;
            }
        }
        return n;
    }

    public static int itemHeight(FontMetrics fontMetrics, Image image, String string, ImageObserver imageObserver) {
        Object[] objectArray = new Object[]{image, string};
        return Utilities.lineHeight(fontMetrics, objectArray, imageObserver);
    }

    public static int lineWidth(FontMetrics fontMetrics, Image image, String string, ImageObserver imageObserver) {
        return Utilities.itemWidth(fontMetrics, image, imageObserver) + 8 + Utilities.itemWidth(fontMetrics, string, imageObserver);
    }

    public static int itemWidth(FontMetrics fontMetrics, Object object, ImageObserver imageObserver) {
        int n = 0;
        if (object != null) {
            n += object instanceof Image ? ((Image)object).getWidth(imageObserver) : fontMetrics.stringWidth(object.toString());
        }
        return n;
    }

    public static Object[] subArray(Object[] objectArray, int n, int n2) {
        Object[] objectArray2 = new Object[n2 - n];
        System.arraycopy(objectArray, n, objectArray2, 0, objectArray2.length);
        return objectArray2;
    }

    public static int baseLineFromBottom(FontMetrics fontMetrics, int n, int n2) {
        int n3 = (n2 - fontMetrics.getHeight()) / 2;
        return n - n3 - fontMetrics.getDescent() - fontMetrics.getLeading() / 2;
    }

    public static int baseLineFromTop(FontMetrics fontMetrics, int n, int n2) {
        int n3 = (n2 - fontMetrics.getHeight()) / 2;
        return n + n3 + fontMetrics.getAscent() - fontMetrics.getLeading() / 2;
    }

    public static String[] splitLine(String string) {
        String[] stringArray = null;
        int n = 1;
        int n2 = 0;
        while (string.indexOf(10, n2) > -1) {
            ++n;
            n2 = string.indexOf(10, n2) + 1;
        }
        stringArray = new String[n];
        n2 = 0;
        int n3 = 0;
        while (n3 < n - 1) {
            stringArray[n3] = string.substring(n2, string.indexOf(10, n2));
            n2 = string.indexOf(10, n2) + 1;
            ++n3;
        }
        stringArray[n - 1] = string.substring(n2);
        return stringArray;
    }

    public static Dimension lineSpan(FontMetrics fontMetrics, String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n = Math.max(n, fontMetrics.stringWidth(stringArray[n2]));
            ++n2;
        }
        return new Dimension(n, fontMetrics.getHeight() * stringArray.length);
    }

    public static void drawHorizontalDottedLine(Graphics graphics, int n, int n2, int n3) {
        int n4 = n3 - n + 1;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n5 < n4 - 3 ? 3 : n4 - n5;
            graphics.drawLine(n + n5, n2, n + n5 + n6, n2);
            n5 += 8;
        }
    }

    public static void drawVerticalDottedLine(Graphics graphics, int n, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n5 < n4 - 3 ? 3 : n4 - n5;
            graphics.drawLine(n, n2 + n5, n, n2 + n5 + n6);
            n5 += 8;
        }
    }
}

